/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.metrics;

import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.area.LayerBlend;
import com.neptunelabs.fsiserver.imagemanipulator.color.AlphaMode;
import com.neptunelabs.fsiserver.imagemanipulator.color.BlendMode;
import com.neptunelabs.fsiserver.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageMode;
import com.neptunelabs.fsiserver.imagereader.metrics.Histogram;
import java.nio.ByteOrder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class HistogramRenderer {
    private final FSILogger int;
    private final SwapPool \u00d800000;
    private final Histogram \u00f400000;
    private final boolean \u00d400000 = false;
    private final float \u00d300000 = 0.65f;
    private final int[] super = new int[]{0, 0xCC3D3D, 0x3DCC3D, 0xCCCC3D, 4031948, 6409277, 4050088, 0xFFFFFF};
    private final int \u00d600000 = 0xFFFFFF;
    private final int \u00d200000 = -16777216;
    private final int \u00f600000 = -3618616;
    private final int class = 0;

    public HistogramRenderer(FSILogger fSILogger, SwapPool swapPool, Histogram histogram) {
        this.int = fSILogger;
        this.\u00d800000 = swapPool;
        this.\u00f400000 = histogram;
    }

    public FSIImageLimited drawHistogram(HistogramChannel histogramChannel) {
        if (histogramChannel == HistogramChannel.\u00d200000) {
            return this.drawHueHistogram();
        }
        return this.drawColorizedHistogram(histogramChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSIImageLimited drawColorizedHistogram(HistogramChannel histogramChannel) {
        int n = 256;
        int n2 = 100;
        int n3 = 256;
        int n4 = 100;
        FSIImage fSIImage = new FSIImageLimited(this.int, this.\u00d800000, ByteOrder.LITTLE_ENDIAN, 256, 100, null, FSIImageMode.new);
        FSIImage fSIImage2 = ((FSIImage)fSIImage).createCompatibleImage();
        fSIImage2.addAlpha();
        FSIImage fSIImage3 = null;
        try {
            int n5;
            int n6;
            byte[] byArray = new byte[256];
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            byte[] byArray4 = new byte[256];
            byte[] byArray5 = new byte[256];
            for (n6 = 0; n6 < 256; ++n6) {
                if (histogramChannel == HistogramChannel.\u00f800000) {
                    byArray4[n6] = (byte)Math.round(Math.sqrt(this.\u00f400000.\u00d4o0000[n6] * 10000.0f));
                    continue;
                }
                if (histogramChannel == HistogramChannel.\u00f500000) {
                    byArray5[n6] = (byte)Math.round(Math.sqrt(this.\u00f400000.\u00f4O0000[n6] * 10000.0f));
                    continue;
                }
                byArray[n6] = (byte)Math.round(Math.sqrt(this.\u00f400000.nullsuper[n6] * 10000.0f));
                byArray2[n6] = (byte)Math.round(Math.sqrt(this.\u00f400000.\u00d5o0000[n6] * 10000.0f));
                byArray3[n6] = (byte)Math.round(Math.sqrt(this.\u00f400000.\u00d400000[n6] * 10000.0f));
            }
            for (n6 = 0; n6 < 100; ++n6) {
                for (n5 = 0; n5 < 256; ++n5) {
                    ((FSIImage)fSIImage).setSample(n5, n6, 0xFFFFFF);
                }
            }
            for (n6 = 0; n6 < 100; n6 += 25) {
                for (n5 = 0; n5 < 256; n5 += 2) {
                    ((FSIImage)fSIImage).setSample(n5, n6, -3618616);
                }
            }
            for (n6 = 0; n6 < 256; n6 += 2) {
                ((FSIImage)fSIImage).setSample(n6, 99, -3618616);
            }
            for (n6 = 0; n6 < 256; n6 += 64) {
                for (n5 = 0; n5 < 100; n5 += 2) {
                    ((FSIImage)fSIImage).setSample(n6, n5, -3618616);
                }
            }
            for (n6 = 0; n6 < 100; n6 += 2) {
                ((FSIImage)fSIImage).setSample(255, n6, -3618616);
            }
            fSIImage3 = ((FSIImage)fSIImage).createCopy();
            int n7 = 0;
            int n8 = 0;
            while (n7 < 256) {
                int n9 = byArray[n8] & 0xFF;
                int n10 = byArray2[n8] & 0xFF;
                int n11 = byArray3[n8] & 0xFF;
                int n12 = byArray5[n8] & 0xFF;
                int n13 = byArray4[n8] & 0xFF;
                for (int i = 0; i < 100; ++i) {
                    int n14 = 0;
                    if (histogramChannel == HistogramChannel.String) {
                        if (i < n9) {
                            n14 |= 1;
                        }
                        if (i < n10) {
                            n14 |= 2;
                        }
                        if (i < n11) {
                            n14 |= 4;
                        }
                    } else if (histogramChannel == HistogramChannel.\u00f800000) {
                        if (i < n13) {
                            n14 = 7;
                        }
                    } else if (histogramChannel == HistogramChannel.\u00f500000) {
                        if (i < n12) {
                            n14 = 7;
                        }
                    } else if (histogramChannel == HistogramChannel.\u00d600000 || histogramChannel == HistogramChannel.null) {
                        if (i < n9) {
                            n14 = 1;
                        }
                    } else if (histogramChannel == HistogramChannel.\u00f600000 || histogramChannel == HistogramChannel.o00000) {
                        if (i < n10) {
                            n14 = 2;
                        }
                    } else if ((histogramChannel == HistogramChannel.\u00d300000 || histogramChannel == HistogramChannel.\u00d800000) && i < n11) {
                        n14 = 4;
                    }
                    if (n14 <= 0) continue;
                    n6 = fSIImage3.getSample(n7, 99 - i);
                    n5 = HistogramRenderer.mixColor(n6, this.super[n14], 0.65f);
                    fSIImage2.setSample(n7, 99 - i, n5);
                }
                ++n7;
                ++n8;
            }
            LayerBlend layerBlend = new LayerBlend(this.int);
            fSIImage = layerBlend.transform(fSIImage, fSIImage2, 0, 0, BlendMode.\u00d5O0000, AlphaMode.String, 100.0f, false);
        }
        catch (ProcessingException processingException) {
            if (fSIImage != null) {
                ((FSIImage)fSIImage).dispose();
            }
        }
        finally {
            if (fSIImage3 != null) {
                fSIImage3.dispose();
            }
            fSIImage2.dispose();
        }
        return fSIImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSIImageLimited drawHueHistogram() {
        int n = 360;
        int n2 = 299;
        int n3 = 300;
        int n4 = 360;
        int n5 = 300;
        FSIImage fSIImage = new FSIImageLimited(this.int, this.\u00d800000, ByteOrder.LITTLE_ENDIAN, 360, 300, null, FSIImageMode.new);
        FSIImage fSIImage2 = ((FSIImage)fSIImage).createCompatibleImage();
        fSIImage2.addAlpha();
        FSIImage fSIImage3 = null;
        try {
            int n6;
            int n7;
            int[] nArray = new int[360];
            double d = 0.0;
            for (int i = 0; i < 360; ++i) {
                d = Math.max(d, (double)this.\u00f400000.\u00f8O0000[i]);
            }
            double d2 = 1.0 / d;
            double d3 = 89401.0;
            for (n7 = 0; n7 < 360; ++n7) {
                nArray[n7] = (int)Math.round(Math.sqrt((double)this.\u00f400000.\u00f8O0000[n7] * d2 * 89401.0));
            }
            for (n7 = 0; n7 < 300; ++n7) {
                for (n6 = 0; n6 < 360; ++n6) {
                    ((FSIImage)fSIImage).setSample(n6, n7, 0xFFFFFF);
                }
            }
            for (n7 = 0; n7 < 300; n7 += 75) {
                for (n6 = 0; n6 < 360; n6 += 2) {
                    ((FSIImage)fSIImage).setSample(n6, n7, -3618616);
                }
            }
            for (n7 = 0; n7 < 360; n7 += 2) {
                ((FSIImage)fSIImage).setSample(n7, 299, -3618616);
            }
            for (n7 = 0; n7 < 360; n7 += 45) {
                for (n6 = 0; n6 < 300; n6 += 2) {
                    ((FSIImage)fSIImage).setSample(n7, n6, -3618616);
                }
            }
            for (n7 = 0; n7 < 300; n7 += 2) {
                ((FSIImage)fSIImage).setSample(359, n7, -3618616);
            }
            fSIImage3 = ((FSIImage)fSIImage).createCopy();
            int n8 = 0;
            int n9 = 0;
            while (n8 < 360) {
                int n10 = nArray[n9];
                int n11 = BaseImageUtils.floatRgbToIntRgb(BaseImageUtils.hslToRgb((float)n9 / 360.0f, 1.0f, 0.5f));
                for (int i = 0; i < 300; ++i) {
                    int n12 = 0;
                    if (i < n10) {
                        n12 |= 1;
                    }
                    if (n12 <= 0) continue;
                    n7 = fSIImage3.getSample(n8, 299 - i);
                    n6 = HistogramRenderer.mixColor(n7, n11, 0.65f);
                    fSIImage2.setSample(n8, 299 - i, n6);
                }
                ++n8;
                ++n9;
            }
            LayerBlend layerBlend = new LayerBlend(this.int);
            fSIImage = layerBlend.transform(fSIImage, fSIImage2, 0, 0, BlendMode.\u00d5O0000, AlphaMode.String, 100.0f, false);
        }
        catch (ProcessingException processingException) {
            if (fSIImage != null) {
                ((FSIImage)fSIImage).dispose();
            }
        }
        finally {
            if (fSIImage3 != null) {
                fSIImage3.dispose();
            }
            fSIImage2.dispose();
        }
        return fSIImage;
    }

    private static int mixColor(int n, int n2, float f) {
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = n2 >> 16 & 0xFF;
        int n7 = n2 >> 8 & 0xFF;
        int n8 = n2 & 0xFF;
        int n9 = (int)((1.0f - f) * (float)n3 + f * (float)n6);
        int n10 = (int)((1.0f - f) * (float)n4 + f * (float)n7);
        int n11 = (int)((1.0f - f) * (float)n5 + f * (float)n8);
        return 0xFF000000 | n9 << 16 | n10 << 8 | n11;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum HistogramChannel {
        \u00d600000,
        \u00f600000,
        \u00d300000,
        null,
        o00000,
        \u00d800000,
        String,
        \u00d200000,
        \u00f500000,
        \u00f800000;

    }
}

