/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.converter;

import com.neptunelabs.fsiserver.framework.io.ByteArrayOutputStreamFast;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.YUVImage;

public class TJToBufferedImage {
    private static final int super = 255;
    private static final int \u00d300000 = 216;
    private static final int class = 218;
    private static final int \u00d400000 = 217;
    private static final int \u00d200000 = 224;

    public static boolean readStream(ImageInputStream imageInputStream, BufferedImage bufferedImage, boolean bl) throws IOException {
        JPEGByteData jPEGByteData = TJToBufferedImage.getJFIFFromStream(imageInputStream);
        return TJToBufferedImage.read(jPEGByteData, bufferedImage, bl);
    }

    private static JPEGByteData getJFIFFromStream(ImageInputStream imageInputStream) throws IOException {
        ByteArrayOutputStreamFast byteArrayOutputStreamFast = new ByteArrayOutputStreamFast();
        boolean bl = false;
        if (imageInputStream.read() == 255 && imageInputStream.read() == 216) {
            byteArrayOutputStreamFast.write(255);
            byteArrayOutputStreamFast.write(216);
            boolean bl2 = false;
            boolean bl3 = false;
            while (imageInputStream.read() == 255 && !bl3) {
                int n;
                int n2;
                byteArrayOutputStreamFast.write(255);
                int n3 = imageInputStream.read();
                byteArrayOutputStreamFast.write(n3);
                if (bl2) continue;
                if (n3 == 218) {
                    bl2 = true;
                    while (!bl3) {
                        n2 = imageInputStream.read();
                        byteArrayOutputStreamFast.write(n2);
                        if (n2 != 255) continue;
                        n = imageInputStream.read();
                        byteArrayOutputStreamFast.write(n);
                        if (n != 217) continue;
                        bl3 = true;
                    }
                    continue;
                }
                if (n3 == 217) break;
                if (n3 == 224) {
                    bl = true;
                }
                n2 = imageInputStream.read();
                byteArrayOutputStreamFast.write(n2);
                n = imageInputStream.read();
                byteArrayOutputStreamFast.write(n);
                int n4 = n2 << 8 | n;
                if (n4 <= 0) continue;
                for (int i = 0; i < n4 - 2; ++i) {
                    byteArrayOutputStreamFast.write(imageInputStream.read());
                }
            }
        }
        byteArrayOutputStreamFast.close();
        return new JPEGByteData(byteArrayOutputStreamFast.toByteArray(), bl);
    }

    public static boolean read(JPEGByteData jPEGByteData, BufferedImage bufferedImage, boolean bl) throws IOException {
        boolean bl2;
        BufferedImage bufferedImage2 = bufferedImage;
        try (TJDecompressor tJDecompressor = new TJDecompressor(jPEGByteData.\u00d200000);){
            Object object;
            int n = tJDecompressor.getWidth();
            int n2 = tJDecompressor.getHeight();
            if (bufferedImage == null) {
                object = new ComponentColorModel(ColorSpace.getInstance(1004), false, false, 1, 0);
                WritableRaster writableRaster = ((ColorModel)object).createCompatibleWritableRaster(n, n2);
                bufferedImage2 = new BufferedImage((ColorModel)object, writableRaster, false, null);
            }
            object = bufferedImage2.getRaster();
            if (bl) {
                int n3 = 4;
                YUVImage yUVImage = tJDecompressor.decompressToYUV(n, n3, n2, tJDecompressor.getSubsamp());
                byte[] byArray = yUVImage.getBuf();
                DataBuffer dataBuffer = ((Raster)object).getDataBuffer();
                int n4 = dataBuffer.getDataType();
                int n5 = yUVImage.getSubsamp();
                int n6 = TJ.getMCUWidth(n5) / 8;
                int n7 = TJ.getMCUHeight(n5) / 8;
                int n8 = TJToBufferedImage.PAD(n, n6);
                int n9 = TJToBufferedImage.PAD(n2, n7);
                int n10 = TJToBufferedImage.PAD(n8, n3);
                int n11 = 0;
                int n12 = byArray.length / 3;
                int n13 = n12 * 2;
                if (n4 == 0) {
                    int n14 = 0;
                    for (int i = 0; i < n9; ++i) {
                        for (int j = 0; j < n10; ++j) {
                            if (j < n) {
                                dataBuffer.setElem(0, n14++, byArray[n11]);
                                dataBuffer.setElem(0, n14++, byArray[n12]);
                                dataBuffer.setElem(0, n14++, byArray[n13]);
                            }
                            ++n11;
                            ++n12;
                            ++n13;
                        }
                    }
                }
                bl2 = true;
            } else {
                int n15 = tJDecompressor.getColorspace();
                int n16 = 0;
                if (n15 == 2) {
                    n16 = 6;
                } else if (n15 == 0 || n15 == 1) {
                    n16 = 0;
                } else if (n15 == 3 || n15 == 4) {
                    n16 = 11;
                }
                int n17 = TJ.getPixelSize(n16);
                int n18 = tJDecompressor.getWidth() * n17;
                int n19 = tJDecompressor.getScaledHeight(n, n2);
                byte[] byArray = new byte[n18 * n19];
                tJDecompressor.decompress(byArray, 0, 0, n, n18, n2, n16, 4096);
                DataBuffer dataBuffer = ((Raster)object).getDataBuffer();
                int n20 = dataBuffer.getDataType();
                if (n20 == 0) {
                    for (int i = 0; i < byArray.length; ++i) {
                        dataBuffer.setElem(0, i, byArray[i]);
                    }
                }
                bl2 = false;
            }
        }
        catch (TJException tJException) {
            throw new IOException(tJException);
        }
        return bl2;
    }

    private static int PAD(int n, int n2) {
        return n + n2 - 1 & ~(n2 - 1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class JPEGByteData {
        final boolean super;
        final byte[] \u00d200000;

        public JPEGByteData(byte[] byArray, boolean bl) {
            this.\u00d200000 = byArray;
            this.super = bl;
        }
    }
}

