/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.exif;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.exif.C;
import com.neptunelabs.fsiserver.imagereader.exif.D;
import com.neptunelabs.fsiserver.imagereader.exif.ExifIDFRawTag;
import com.neptunelabs.fsiserver.imagereader.exif.ExifTag;
import com.neptunelabs.fsiserver.imagereader.exif.ExifTagMapping;
import com.neptunelabs.fsiserver.imagereader.exif.ExifValueType;
import com.neptunelabs.fsiserver.imagereader.helper.Rational;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExifParser {
    private static final int[] \u00d600000 = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final byte[] \u00f600000 = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
    private static final byte[] \u00f500000 = new byte[]{85, 78, 73, 67, 79, 68, 69, 0};
    private boolean Object = false;
    private FSILogger void;
    private boolean float = false;
    private ByteArrayWalker o00000;
    private String \u00d200000 = null;
    private final LinkedList<C> \u00f400000 = new LinkedList();
    private final List<ExifTag> oO0000 = new ArrayList<ExifTag>();
    private final ExifTagMapping OO0000 = ExifTagMapping.getInstance();
    private final D \u00d500000 = D.o00000();
    private final DecimalFormat \u00d400000 = new DecimalFormat("#0.00", new DecimalFormatSymbols(Locale.US));

    private ExifParser(FSILogger fSILogger) {
        this.void = fSILogger;
    }

    public static ExifParser getInstance(FSILogger fSILogger) {
        return new ExifParser(fSILogger);
    }

    public void setName(String string) {
        this.\u00d200000 = string;
    }

    public void scanExif(byte[] byArray) {
        block7: {
            if (!this.float) {
                try {
                    ByteOrder byteOrder = this.parseHeader(byArray);
                    if (this.float || byteOrder == null) break block7;
                    this.o00000 = ByteArrayWalker.wrap(byArray, byteOrder);
                    this.o00000.position(4);
                    int n = this.o00000.getInt();
                    C c = new C(34665, n);
                    boolean bl = true;
                    while (!this.float && bl) {
                        if (n >= 8) {
                            this.scanIFD(c);
                        }
                        bl = !this.\u00f400000.isEmpty();
                        C c2 = this.\u00f400000.poll();
                        if (c2 != null) {
                            c = c2;
                            continue;
                        }
                        break;
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (this.void != null) {
                        this.void.logException(runtimeException, 3830, runtimeException.getClass().getName() + ": " + runtimeException.getLocalizedMessage(), this.\u00d200000);
                    }
                    this.float = true;
                }
            }
        }
        this.close();
    }

    public List<ExifTag> getExifTags() {
        return this.oO0000;
    }

    public List<Integer> getTagSortMap() {
        return this.\u00d500000.\u00d300000();
    }

    public Map<Pair<Integer, String>, String> getShortMap() {
        HashMap<Pair<Integer, String>, String> hashMap = new HashMap<Pair<Integer, String>, String>();
        for (ExifTag exifTag : this.oO0000) {
            hashMap.put(new Pair<Integer, String>(exifTag.getTag(), exifTag.getShortDescription()), exifTag.getValueAsText());
        }
        return hashMap;
    }

    public ExifTag getTag(int n) {
        ExifTag exifTag = null;
        if (this.oO0000 != null) {
            for (ExifTag exifTag2 : this.oO0000) {
                if (exifTag2.getTag() != n) continue;
                exifTag = exifTag2;
                break;
            }
        }
        return exifTag;
    }

    private void close() {
        if (this.o00000 != null) {
            this.o00000 = null;
        }
    }

    private void evaluateExifTag(ExifIDFRawTag exifIDFRawTag) throws IOException {
        if (this.o00000.remaining() <= 0) {
            return;
        }
        switch (exifIDFRawTag.\u00d200000) {
            case 34665: 
            case 34853: 
            case 40965: {
                this.\u00f400000.offer(new C(exifIDFRawTag.\u00d200000, this.getTagValueLong(exifIDFRawTag)[0]));
                break;
            }
            case 11: 
            case 270: 
            case 271: 
            case 272: 
            case 305: 
            case 306: 
            case 315: 
            case 33432: 
            case 34852: 
            case 36867: 
            case 36868: 
            case 37520: 
            case 37521: 
            case 37522: 
            case 42016: {
                this.readAndEvaluatePlainTextTag(34665, exifIDFRawTag);
                break;
            }
            case 256: 
            case 257: 
            case 259: 
            case 277: 
            case 18246: 
            case 18249: 
            case 40962: 
            case 40963: 
            case 41989: {
                this.readAndEvaluatePlainNumberTag(34665, exifIDFRawTag);
                break;
            }
            case 258: {
                this.readAndEvaluatePlainNumberListTag(34665, exifIDFRawTag);
                break;
            }
            case 37122: 
            case 37378: 
            case 37379: 
            case 37381: 
            case 37386: 
            case 41483: 
            case 41493: 
            case 41988: {
                this.readAndEvaluateRationalAsDouble(34665, exifIDFRawTag);
                break;
            }
            case 36864: 
            case 37510: 
            case 40960: 
            case 41730: {
                this.readAndEvaluateUndefinedTagAsString(34665, exifIDFRawTag);
                break;
            }
            case 318: 
            case 319: 
            case 529: 
            case 532: {
                this.readAndEvaluateRationalsListAsDoubleArray(34665, exifIDFRawTag);
                break;
            }
            case 284: {
                this.readAndEvaluatePlanarConfigurationTag(exifIDFRawTag);
                break;
            }
            case 262: {
                this.readAndEvaluatePhotometricInterpretationTag(exifIDFRawTag);
                break;
            }
            case 41728: {
                this.readAndEvaluateFileSourceTag(exifIDFRawTag);
                break;
            }
            case 41729: {
                this.readAndEvaluateSceneTypeTag(exifIDFRawTag);
                break;
            }
            case 282: 
            case 283: 
            case 41486: 
            case 41487: {
                this.readAndEvaluateResolutionTag(exifIDFRawTag);
                break;
            }
            case 274: {
                this.readAndEvaluateOrientationTag(exifIDFRawTag);
                break;
            }
            case 531: {
                this.readAndEvaluateYCbCrPositioningTag(exifIDFRawTag);
                break;
            }
            case 296: 
            case 41488: {
                this.readAndEvaluateResolutionUnitTag(exifIDFRawTag);
                break;
            }
            case 37380: {
                this.readAndEvaluateExposureBiasValueTag(exifIDFRawTag);
                break;
            }
            case 33434: 
            case 37377: {
                this.readAndEvaluateShutterSpeedValueTag(exifIDFRawTag);
                break;
            }
            case 34850: {
                this.readAndEvaluateExposureProgramTag(exifIDFRawTag);
                break;
            }
            case 37382: {
                this.readAndEvaluateSubjectDistanceTag(exifIDFRawTag);
                break;
            }
            case 33437: {
                this.readAndEvaluateFNumberTag(exifIDFRawTag);
                break;
            }
            case 34855: {
                this.readAndEvaluateISOSpeedRatingsTag(exifIDFRawTag);
                break;
            }
            case 37383: {
                this.readAndEvaluateMeteringModeTag(exifIDFRawTag);
                break;
            }
            case 37384: {
                this.readAndEvaluateLightSourceTag(exifIDFRawTag);
                break;
            }
            case 37385: {
                this.readAndEvaluateFlashTag(exifIDFRawTag);
                break;
            }
            case 40961: {
                this.readAndEvaluateColorSpaceTag(exifIDFRawTag);
                break;
            }
            case 41495: {
                this.readAndEvaluateSensingMethodTag(exifIDFRawTag);
                break;
            }
            case 41985: {
                this.readAndEvaluateCustomRenderedTag(exifIDFRawTag);
                break;
            }
            case 41986: {
                this.readAndEvaluateExposureModeTag(exifIDFRawTag);
                break;
            }
            case 41987: {
                this.readAndEvaluateWhiteBalanceTag(exifIDFRawTag);
                break;
            }
            case 41990: {
                this.readAndEvaluateScreenCaptureTypeTag(exifIDFRawTag);
                break;
            }
            case 41991: {
                this.readAndEvaluateGainControlTag(exifIDFRawTag);
                break;
            }
            case 41992: 
            case 41993: 
            case 41994: {
                this.readAndEvaluateNormalLowHighTag(exifIDFRawTag);
                break;
            }
            case 41996: {
                this.readAndEvaluateSubjectDistanceRangeTag(exifIDFRawTag);
                break;
            }
            case 37121: {
                this.readAndEvaluateComponentsConfigurationTag(exifIDFRawTag);
                break;
            }
            default: {
                this.void.log(3835, "Skipping tag: " + exifIDFRawTag.\u00d200000 + " (" + ExifTagMapping.getInstance().getShortName(34665, exifIDFRawTag.\u00d200000) + ") in " + this.\u00d200000);
            }
        }
    }

    private void evaluateInterOpTag(ExifIDFRawTag exifIDFRawTag) throws UnsupportedEncodingException, IOException {
        switch (exifIDFRawTag.\u00d200000) {
            case 1: 
            case 4096: {
                this.readAndEvaluatePlainTextTag(40965, exifIDFRawTag);
                break;
            }
            case 2: {
                this.readAndEvaluateUndefinedTagAsString(40965, exifIDFRawTag);
                break;
            }
            case 4097: 
            case 4098: {
                this.readAndEvaluatePlainNumberTag(40965, exifIDFRawTag);
                break;
            }
            default: {
                this.void.log(3835, "Skipping tag: " + exifIDFRawTag.\u00d200000 + " (" + ExifTagMapping.getInstance().getShortName(40965, exifIDFRawTag.\u00d200000) + ") in " + this.\u00d200000);
            }
        }
    }

    private void evaluateGPSTag(ExifIDFRawTag exifIDFRawTag) throws UnsupportedEncodingException, IOException {
        switch (exifIDFRawTag.\u00d200000) {
            case 8: 
            case 18: 
            case 29: {
                this.readAndEvaluatePlainTextTag(34853, exifIDFRawTag);
                break;
            }
            case 1: {
                this.readAndEvaluateGPSLatitudeRefTag(exifIDFRawTag);
                break;
            }
            case 3: {
                this.readAndEvaluateGPSLongitudeRefTag(exifIDFRawTag);
                break;
            }
            case 5: {
                this.readAndEvaluateGPSAltitudeRefTag(exifIDFRawTag);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                this.readAndEvaluateRationalsListAsDoubleArray(34853, exifIDFRawTag);
                break;
            }
            case 9: {
                this.readAndEvaluateGPSStatusTag(exifIDFRawTag);
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                this.readAndEvaluateRationalAsDouble(34853, exifIDFRawTag);
                break;
            }
            case 10: {
                this.readAndEvaluateGPSMeasureModeTag(exifIDFRawTag);
                break;
            }
            case 12: {
                this.readAndEvaluateGPSSpeedRefTag(exifIDFRawTag);
                break;
            }
            case 14: 
            case 16: {
                this.readAndEvaluateGPSTrackRefTag(exifIDFRawTag);
                break;
            }
            case 30: {
                this.readAndEvaluateGPSDifferentalTag(exifIDFRawTag);
                break;
            }
            default: {
                this.void.log(3835, "Skipping tag: " + exifIDFRawTag.\u00d200000 + " (" + ExifTagMapping.getInstance().getShortName(34853, exifIDFRawTag.\u00d200000) + ") in " + this.\u00d200000);
            }
        }
    }

    private void readAndEvaluatePlainTextTag(int n, ExifIDFRawTag exifIDFRawTag) {
        String string = this.readPlainTextTag(exifIDFRawTag);
        String string2 = this.OO0000.getShortName(n, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(n, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, null));
        } else {
            this.void.log(3835, "Unexpected content for String tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + ") in " + this.\u00d200000);
        }
    }

    private void readAndEvaluatePlainNumberTag(int n, ExifIDFRawTag exifIDFRawTag) {
        int n2 = -1;
        if (exifIDFRawTag.\u00d300000 == 3 || exifIDFRawTag.\u00d300000 == 8) {
            n2 = this.getTagValueShort(exifIDFRawTag)[0];
        } else if (exifIDFRawTag.\u00d300000 == 4 || exifIDFRawTag.\u00d300000 == 9) {
            n2 = this.getTagValueLong(exifIDFRawTag)[0];
        }
        String string = this.OO0000.getShortName(n, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(n, exifIDFRawTag.\u00d200000);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Number, n2, n2));
    }

    private void readAndEvaluatePlainNumberListTag(int n, ExifIDFRawTag exifIDFRawTag) {
        int[] nArray = null;
        if (exifIDFRawTag.\u00d300000 == 3 || exifIDFRawTag.\u00d300000 == 8) {
            nArray = this.getTagValueShort(exifIDFRawTag);
        } else if (exifIDFRawTag.\u00d300000 == 4 || exifIDFRawTag.\u00d300000 == 9) {
            nArray = this.getTagValueLong(exifIDFRawTag);
        }
        String string = this.OO0000.getShortName(n, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(n, exifIDFRawTag.\u00d200000);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.NumberList, nArray, nArray));
    }

    private void readAndEvaluateUndefinedTagAsString(int n, ExifIDFRawTag exifIDFRawTag) throws UnsupportedEncodingException {
        String string = this.OO0000.getShortName(n, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(n, exifIDFRawTag.\u00d200000);
        String string3 = this.readUndefinedTagAsString(exifIDFRawTag);
        if (string3 != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, string3, string3));
        }
    }

    private void readAndEvaluateRationalAsDouble(int n, ExifIDFRawTag exifIDFRawTag) {
        Rational rational = this.getTagValueRational(exifIDFRawTag);
        if (rational != null) {
            String string = this.OO0000.getShortName(n, exifIDFRawTag.\u00d200000);
            String string2 = this.OO0000.getLongName(n, exifIDFRawTag.\u00d200000);
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Rational, ExifParser.convertRationalToDouble(rational), rational));
        }
    }

    private void readAndEvaluateRationalsListAsDoubleArray(int n, ExifIDFRawTag exifIDFRawTag) {
        String string = this.OO0000.getShortName(n, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(n, exifIDFRawTag.\u00d200000);
        Rational[] rationalArray = this.getTagValueRationalList(exifIDFRawTag);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.RationalsList, ExifParser.convertRationalsListToDoubleArray(rationalArray), null));
    }

    private void readAndEvaluateNormalLowHighTag(ExifIDFRawTag exifIDFRawTag) {
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        String string = null;
        switch (n) {
            case 0: {
                string = "Normal";
                break;
            }
            case 1: {
                string = "Soft";
                break;
            }
            case 2: {
                string = "Hard";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
    }

    private void readAndEvaluatePlanarConfigurationTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 1: {
                string = "Chunky";
                break;
            }
            case 2: {
                string = "Planar";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateComponentsConfigurationTag(ExifIDFRawTag exifIDFRawTag) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = this.getTagValueBytes(exifIDFRawTag);
        for (int i = 0; i < 4; ++i) {
            byte by = byArray[i];
            if (by == 1) {
                stringBuilder.append("Y");
                continue;
            }
            if (by == 2) {
                stringBuilder.append("Cb");
                continue;
            }
            if (by == 3) {
                stringBuilder.append("Cr");
                continue;
            }
            if (by == 4) {
                stringBuilder.append("R");
                continue;
            }
            if (by == 5) {
                stringBuilder.append("G");
                continue;
            }
            if (by != 6) continue;
            stringBuilder.append("B");
        }
        String string = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (stringBuilder.length() > 0) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, stringBuilder.toString(), byArray));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string + "): " + byArray.length + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateSubjectDistanceRangeTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "unknown";
                break;
            }
            case 1: {
                string = "Macro";
                break;
            }
            case 2: {
                string = "Close view";
                break;
            }
            case 3: {
                string = "Distant view";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateGainControlTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "None";
                break;
            }
            case 1: {
                string = "Low gain up";
                break;
            }
            case 2: {
                string = "High gain up";
                break;
            }
            case 3: {
                string = "Low gain down";
                break;
            }
            case 4: {
                string = "High gain down";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateScreenCaptureTypeTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "Standard";
                break;
            }
            case 1: {
                string = "Landscape";
                break;
            }
            case 2: {
                string = "Portrait";
                break;
            }
            case 3: {
                string = "Night scene";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateWhiteBalanceTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "Auto white balance";
                break;
            }
            case 1: {
                string = "Manual white balance";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateExposureModeTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "Auto exposure";
                break;
            }
            case 1: {
                string = "Manual exposure";
                break;
            }
            case 2: {
                string = "Auto bracket";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateCustomRenderedTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "Normal process";
                break;
            }
            case 1: {
                string = "Custom process";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateSensingMethodTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 2: {
                string = "One-chip color area sensor";
                break;
            }
            case 3: {
                string = "Two-chip color area sensor";
                break;
            }
            case 4: {
                string = "Three-chip color area sensor";
                break;
            }
            case 5: {
                string = "Color sequential area sensor";
                break;
            }
            case 7: {
                string = "Trilinear sensor";
                break;
            }
            case 8: {
                string = "Color sequential linear sensor";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateColorSpaceTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 1: {
                string = "sRGB";
                break;
            }
            case 65535: {
                string = "Uncalibrated";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateFlashTag(ExifIDFRawTag exifIDFRawTag) throws IOException {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "Flash did not fire";
                break;
            }
            case 1: {
                string = "Flash fired";
                break;
            }
            case 5: {
                string = "Strobe return light not detected";
                break;
            }
            case 7: {
                string = "Strobe return light detected";
                break;
            }
            case 9: {
                string = "Flash fired, compulsory flash mode";
                break;
            }
            case 13: {
                string = "Flash fired, compulsory flash mode, return light not detected";
                break;
            }
            case 15: {
                string = "Flash fired, compulsory flash mode, return light detected";
                break;
            }
            case 16: {
                string = "Flash did not fire, compulsory flash mode";
                break;
            }
            case 24: {
                string = "Flash did not fire, auto mode";
                break;
            }
            case 25: {
                string = "Flash fired, auto mode";
                break;
            }
            case 29: {
                string = "Flash fired, auto mode, return light not detected";
                break;
            }
            case 31: {
                string = "Flash fired, auto mode, return light detected";
                break;
            }
            case 32: {
                string = "No flash function";
                break;
            }
            case 65: {
                string = "Flash fired, red-eye reduction mode";
                break;
            }
            case 69: {
                string = "Flash fired, red-eye reduction mode, return light not detected";
                break;
            }
            case 71: {
                string = "Flash fired, red-eye reduction mode, return light detected";
                break;
            }
            case 73: {
                string = "Flash fired, compulsory flash mode, red-eye reduction mode";
                break;
            }
            case 77: {
                string = "Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected";
                break;
            }
            case 79: {
                string = "Flash fired, compulsory flash mode, red-eye reduction mode, return light detected";
                break;
            }
            case 89: {
                string = "Flash fired, auto mode, red-eye reduction mode";
                break;
            }
            case 93: {
                string = "Flash fired, auto mode, return light not detected, red-eye reduction mode";
                break;
            }
            case 95: {
                string = "Flash fired, auto mode, return light detected, red-eye reduction mode";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateLightSourceTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "Unknown";
                break;
            }
            case 1: {
                string = "Daylight";
                break;
            }
            case 2: {
                string = "Fluorescent";
                break;
            }
            case 3: {
                string = "Tungsten";
                break;
            }
            case 4: {
                string = "Flash";
                break;
            }
            case 9: {
                string = "Fine weather";
                break;
            }
            case 10: {
                string = "Cloudy weather";
                break;
            }
            case 11: {
                string = "Shade";
                break;
            }
            case 12: {
                string = "Daylight fluorescent (D 5700 \u2013 7100K)";
                break;
            }
            case 13: {
                string = "Day white fluorescent (N 4600 \u2013 5400K)";
                break;
            }
            case 14: {
                string = "Cool white fluorescent (W 3900 \u2013 4500K)";
                break;
            }
            case 15: {
                string = "White fluorescent (WW 3200 \u2013 3700K)";
                break;
            }
            case 17: {
                string = "Standard light A";
                break;
            }
            case 18: {
                string = "Standard light B";
                break;
            }
            case 19: {
                string = "Standard light C";
                break;
            }
            case 20: {
                string = "D55";
                break;
            }
            case 21: {
                string = "D65";
                break;
            }
            case 22: {
                string = "D75";
                break;
            }
            case 23: {
                string = "D50";
                break;
            }
            case 24: {
                string = "ISO studio tungsten";
                break;
            }
            case 255: {
                string = "other light source";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateMeteringModeTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "Unknown";
                break;
            }
            case 1: {
                string = "Average";
                break;
            }
            case 2: {
                string = "Center Weighted Average";
                break;
            }
            case 3: {
                string = "Spot";
                break;
            }
            case 4: {
                string = "Multi Spot";
                break;
            }
            case 5: {
                string = "Pattern";
                break;
            }
            case 6: {
                string = "Partial";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateISOSpeedRatingsTag(ExifIDFRawTag exifIDFRawTag) {
        int[] nArray = this.getTagValueShort(exifIDFRawTag);
        String string = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.NumberList, nArray, null));
    }

    private void readAndEvaluateFNumberTag(ExifIDFRawTag exifIDFRawTag) {
        Rational rational = this.getTagValueRational(exifIDFRawTag);
        float f = ExifParser.convertRationalToFloat(rational);
        String string = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, "f/" + f, Float.valueOf(f)));
    }

    private void readAndEvaluateSubjectDistanceTag(ExifIDFRawTag exifIDFRawTag) {
        Rational rational = this.getTagValueRational(exifIDFRawTag);
        float f = ExifParser.convertRationalToFloat(rational);
        String string = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (rational.o00000 == 0L) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, "unknown distance", Float.valueOf(f)));
        } else if (rational.o00000 > Integer.MAX_VALUE) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, "infinity", Float.valueOf(f)));
        } else {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, Float.toString(f) + " m", Float.valueOf(f)));
        }
    }

    private void readAndEvaluateExposureProgramTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "Not defined";
                break;
            }
            case 1: {
                string = "Manual";
                break;
            }
            case 2: {
                string = "Normal program";
                break;
            }
            case 3: {
                string = "Aperture priority";
                break;
            }
            case 4: {
                string = "Shutter priority";
                break;
            }
            case 5: {
                string = "Creative program";
                break;
            }
            case 6: {
                string = "Action program";
                break;
            }
            case 7: {
                string = "Portrait mode";
                break;
            }
            case 8: {
                string = "Landscape mode";
                break;
            }
            default: {
                string = null;
            }
        }
        if (string != null) {
            String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
            String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + ": " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateShutterSpeedValueTag(ExifIDFRawTag exifIDFRawTag) {
        Rational rational = this.getTagValueRational(exifIDFRawTag);
        float f = ExifParser.convertRationalToFloat(rational);
        if (f >= 0.0f) {
            String string = f < 1.0f ? "1/" + Math.round(1.0f / f) + " sec" : f + " sec";
            String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
            String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, Float.valueOf(f)));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + " " + f + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateExposureBiasValueTag(ExifIDFRawTag exifIDFRawTag) {
        Rational rational = this.getTagValueRational(exifIDFRawTag);
        float f = ExifParser.convertRationalToFloat(rational);
        int n = (int)Math.floor(f);
        float f2 = f - (float)n;
        StringBuilder stringBuilder = new StringBuilder();
        if (f > 0.0f) {
            stringBuilder.append('+');
        }
        if ((double)f2 > 0.332 && (double)f2 < 0.335) {
            if (n != 0) {
                stringBuilder.append(n);
                stringBuilder.append(' ');
            }
            stringBuilder.append("1/3");
        } else if ((double)f2 > 0.665 && (double)f2 < 0.667) {
            if (n != 0) {
                stringBuilder.append(n);
                stringBuilder.append(' ');
            }
            stringBuilder.append("2/3");
        } else if (f2 == 0.0f) {
            stringBuilder.append("\u00b10");
        } else {
            stringBuilder.append(this.\u00d400000.format(f));
        }
        String string = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, stringBuilder.toString(), Float.valueOf(f)));
    }

    private void readAndEvaluateResolutionUnitTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 2: {
                string = "Inch";
                break;
            }
            case 3: {
                string = "Centimeter";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateYCbCrPositioningTag(ExifIDFRawTag exifIDFRawTag) {
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        String string = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (n == 1) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, "Centered", n));
        } else if (n == 2) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, "Co-sited", n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateOrientationTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 1: {
                string = "Top Left (Horizontal, normal)";
                break;
            }
            case 2: {
                string = "Top Right (Mirror horizontal)";
                break;
            }
            case 3: {
                string = "Bottom Right (Rotate 180)";
                break;
            }
            case 4: {
                string = "Bottom Left (Mirror vertical)";
                break;
            }
            case 5: {
                string = "Left Top (Mirror horizontal and rotate 270 CW)";
                break;
            }
            case 6: {
                string = "Right Top (Rotate 90 CW )";
                break;
            }
            case 7: {
                string = "Right Bottom (Mirror horizontal and rotate 90 CW)";
                break;
            }
            case 8: {
                string = "Left Bottom (Rotate 270 CW)";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Invalid value for tag: tagname:" + exifIDFRawTag.\u00d200000 + "(" + string2 + "): " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateResolutionTag(ExifIDFRawTag exifIDFRawTag) {
        String string = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string2 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        Rational rational = this.getTagValueRational(exifIDFRawTag);
        if (rational.new == 1L) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, String.valueOf(rational.o00000), rational));
        } else {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string, string2, ExifValueType.Text, rational.o00000 + "/" + rational.new, rational));
        }
    }

    private void readAndEvaluatePhotometricInterpretationTag(ExifIDFRawTag exifIDFRawTag) {
        String string;
        int n = this.getTagValueShort(exifIDFRawTag)[0];
        switch (n) {
            case 0: {
                string = "WhiteIsZero";
                break;
            }
            case 2: {
                string = "BlackIsZero";
                break;
            }
            case 3: {
                string = "RGB";
                break;
            }
            case 4: {
                string = "RGB Palette ";
                break;
            }
            case 5: {
                string = "Transparency Mask ";
                break;
            }
            case 6: {
                string = "CMYK";
                break;
            }
            case 7: {
                string = "YCbCr";
                break;
            }
            case 8: {
                string = "CIELab";
                break;
            }
            case 9: {
                string = "ICCLab";
                break;
            }
            case 10: {
                string = "ITULab";
                break;
            }
            case 32803: {
                string = "Color Filter Array ";
                break;
            }
            case 32844: {
                string = "Pixar LogL ";
                break;
            }
            case 32845: {
                string = "Pixar LogLuv ";
                break;
            }
            case 34892: {
                string = "Linear Raw";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        if (string != null) {
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, n));
        } else {
            this.void.log(3835, "Unknown value for Photometric Interpretation: " + n + " in " + this.\u00d200000);
        }
    }

    private void readAndEvaluateSceneTypeTag(ExifIDFRawTag exifIDFRawTag) {
        byte[] byArray = this.getTagValueBytes(exifIDFRawTag);
        String string = null;
        string = byArray[0] == 1 ? "Directly Photographed" : "Unknown";
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, byArray[0]));
    }

    private void readAndEvaluateFileSourceTag(ExifIDFRawTag exifIDFRawTag) {
        byte[] byArray = this.getTagValueBytes(exifIDFRawTag);
        String string = null;
        string = byArray[0] == 1 ? "Film Scanner" : (byArray[0] == 2 ? "Reflection Print Scanner" : (byArray[0] == 3 ? "Digital Camera" : "Unknown"));
        String string2 = this.OO0000.getShortName(34665, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34665, exifIDFRawTag.\u00d200000);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, byArray[0]));
    }

    private void readAndEvaluateGPSLatitudeRefTag(ExifIDFRawTag exifIDFRawTag) throws UnsupportedEncodingException {
        String string = null;
        String string2 = this.readPlainTextTag(exifIDFRawTag);
        if (string2 != null) {
            if (string2.equals("N")) {
                string = "North";
            } else if (string2.equals("S")) {
                string = "South";
            }
            String string3 = this.OO0000.getShortName(34853, exifIDFRawTag.\u00d200000);
            String string4 = this.OO0000.getLongName(34853, exifIDFRawTag.\u00d200000);
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string3, string4, ExifValueType.Text, string, string2));
        }
    }

    private void readAndEvaluateGPSLongitudeRefTag(ExifIDFRawTag exifIDFRawTag) throws UnsupportedEncodingException {
        String string = null;
        String string2 = this.readPlainTextTag(exifIDFRawTag);
        if (string2 != null) {
            if (string2.equals("E")) {
                string = "East";
            } else if (string2.equals("W")) {
                string = "West";
            }
            String string3 = this.OO0000.getShortName(34853, exifIDFRawTag.\u00d200000);
            String string4 = this.OO0000.getLongName(34853, exifIDFRawTag.\u00d200000);
            this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string3, string4, ExifValueType.Text, string, string2));
        }
    }

    private void readAndEvaluateGPSStatusTag(ExifIDFRawTag exifIDFRawTag) throws UnsupportedEncodingException {
        String string = null;
        String string2 = this.readPlainTextTag(exifIDFRawTag);
        if (string2 != null) {
            if (string2.equals("A")) {
                string = "Measurement Active";
            } else if (string2.equals("V")) {
                string = "Measurement Void";
            }
            if (string != null) {
                String string3 = this.OO0000.getShortName(34853, exifIDFRawTag.\u00d200000);
                String string4 = this.OO0000.getLongName(34853, exifIDFRawTag.\u00d200000);
                this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string3, string4, ExifValueType.Text, string, string2));
            } else {
                this.void.log(3835, "Unknown content for GPS Status: " + string2 + " in " + this.\u00d200000);
            }
        }
    }

    private void readAndEvaluateGPSAltitudeRefTag(ExifIDFRawTag exifIDFRawTag) {
        String string = null;
        byte[] byArray = this.getTagValueBytes(exifIDFRawTag);
        if (byArray[0] == 0) {
            string = "Above Sea Level";
        } else if (byArray[0] == 1) {
            string = "Below Sea Level";
        }
        String string2 = this.OO0000.getShortName(34853, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34853, exifIDFRawTag.\u00d200000);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, byArray[0]));
    }

    private void readAndEvaluateGPSDifferentalTag(ExifIDFRawTag exifIDFRawTag) {
        String string = null;
        byte[] byArray = this.getTagValueBytes(exifIDFRawTag);
        if (byArray[0] == 0) {
            string = "No Correction";
        } else if (byArray[0] == 1) {
            string = "Differential Correction";
        }
        String string2 = this.OO0000.getShortName(34853, exifIDFRawTag.\u00d200000);
        String string3 = this.OO0000.getLongName(34853, exifIDFRawTag.\u00d200000);
        this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string2, string3, ExifValueType.Text, string, byArray[0]));
    }

    private void readAndEvaluateGPSMeasureModeTag(ExifIDFRawTag exifIDFRawTag) throws UnsupportedEncodingException {
        String string = null;
        String string2 = this.readPlainTextTag(exifIDFRawTag);
        if (string2 != null) {
            if (string2.equals("2")) {
                string = "2-Dimensional Measurement";
            } else if (string2.equals("3")) {
                string = "3-Dimensional Measurement";
            }
            if (string != null) {
                String string3 = this.OO0000.getShortName(34853, exifIDFRawTag.\u00d200000);
                String string4 = this.OO0000.getLongName(34853, exifIDFRawTag.\u00d200000);
                this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string3, string4, ExifValueType.Text, string, string2));
            } else {
                this.void.log(3835, "Unknown content for GPS Measure Mode: " + string2 + " in " + this.\u00d200000);
            }
        }
    }

    private void readAndEvaluateGPSSpeedRefTag(ExifIDFRawTag exifIDFRawTag) throws UnsupportedEncodingException {
        String string = null;
        String string2 = this.readPlainTextTag(exifIDFRawTag);
        if (string2 != null) {
            if (string2.equals("K")) {
                string = "km/h";
            } else if (string2.equals("M")) {
                string = "mph";
            } else if (string2.equals("N")) {
                string = "knots";
            }
            if (string != null) {
                String string3 = this.OO0000.getShortName(34853, exifIDFRawTag.\u00d200000);
                String string4 = this.OO0000.getLongName(34853, exifIDFRawTag.\u00d200000);
                this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string3, string4, ExifValueType.Text, string, string2));
            } else {
                this.void.log(3835, "Unknown content for GPS Speed Ref: " + string2 + " in " + this.\u00d200000);
            }
        }
    }

    private void readAndEvaluateGPSTrackRefTag(ExifIDFRawTag exifIDFRawTag) throws UnsupportedEncodingException {
        String string = null;
        String string2 = this.readPlainTextTag(exifIDFRawTag);
        if (string2 != null) {
            if (string2.equals("M")) {
                string = "Magnetic North";
            } else if (string2.equals("T")) {
                string = "True North";
            }
            if (string != null) {
                String string3 = this.OO0000.getShortName(34853, exifIDFRawTag.\u00d200000);
                String string4 = this.OO0000.getLongName(34853, exifIDFRawTag.\u00d200000);
                this.oO0000.add(new ExifTag(exifIDFRawTag.\u00d200000, string3, string4, ExifValueType.Text, string, string2));
            } else {
                this.void.log(3835, "Unknown content for GPS Track Ref: " + string2 + " in " + this.\u00d200000);
            }
        }
    }

    private String readPlainTextTag(ExifIDFRawTag exifIDFRawTag) {
        byte[] byArray = this.getTagValueBytes(exifIDFRawTag);
        if (byArray != null) {
            String string = new String(byArray, FileOperations.\u00d500000);
            if (string.length() == 0) {
                return null;
            }
            return string.trim();
        }
        return null;
    }

    private String readUndefinedTagAsString(ExifIDFRawTag exifIDFRawTag) {
        String string = null;
        byte[] byArray = this.getTagValueBytes(exifIDFRawTag);
        byte[] byArray2 = Arrays.copyOf(byArray, 8);
        if (Arrays.equals(byArray2, \u00f600000) && byArray.length > 8) {
            byte[] byArray3 = Arrays.copyOfRange(byArray, 8, byArray.length - 1);
            string = new String(byArray3, FileOperations.o00000);
        } else if (Arrays.equals(byArray2, \u00f500000) && byArray.length > 8) {
            byte[] byArray4 = Arrays.copyOfRange(byArray, 8, byArray.length - 1);
            string = new String(byArray4, FileOperations.\u00d200000);
        } else if (exifIDFRawTag.\u00d200000 == 36864 || exifIDFRawTag.\u00d200000 == 40960 || exifIDFRawTag.\u00d200000 == 2) {
            string = new String(byArray, FileOperations.o00000);
            if (!this.Object && string.length() <= 4) {
                string = new StringBuffer(string).reverse().toString();
            }
        } else {
            String string2 = new String(byArray2, FileOperations.o00000);
            this.void.log(3835, "Unknown content for tag: " + exifIDFRawTag.\u00d200000 + "(length: " + byArray.length + "): " + string2 + " in " + this.\u00d200000);
        }
        return string;
    }

    private Rational getTagValueRational(ExifIDFRawTag exifIDFRawTag) throws BufferUnderflowException {
        this.o00000.position((int)exifIDFRawTag.String);
        return new Rational(this.o00000.getInt(), this.o00000.getInt());
    }

    private Rational[] getTagValueRationalList(ExifIDFRawTag exifIDFRawTag) throws BufferUnderflowException {
        Rational[] rationalArray = new Rational[exifIDFRawTag.o00000];
        this.o00000.position((int)exifIDFRawTag.String);
        for (int i = 0; i < exifIDFRawTag.o00000; ++i) {
            rationalArray[i] = new Rational(this.o00000.getInt(), this.o00000.getInt());
        }
        return rationalArray;
    }

    private int[] getTagValueLong(ExifIDFRawTag exifIDFRawTag) throws BufferUnderflowException {
        int[] nArray = new int[exifIDFRawTag.o00000];
        this.o00000.position((int)exifIDFRawTag.String);
        for (int i = 0; i < exifIDFRawTag.o00000; ++i) {
            nArray[i] = this.o00000.getInt();
        }
        return nArray;
    }

    private int[] getTagValueShort(ExifIDFRawTag exifIDFRawTag) throws BufferUnderflowException {
        int[] nArray = new int[exifIDFRawTag.o00000];
        try {
            this.o00000.position((int)exifIDFRawTag.String);
            for (int i = 0; i < exifIDFRawTag.o00000; ++i) {
                nArray[i] = this.o00000.getShort() & 0xFFFF;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.void != null) {
                this.void.logException(illegalArgumentException, 3830, "IAR1", illegalArgumentException.getLocalizedMessage());
            }
            this.float = true;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            if (this.void != null) {
                this.void.logException(bufferUnderflowException, 3830, "BUE2", bufferUnderflowException.getLocalizedMessage());
            }
            this.float = true;
        }
        return nArray;
    }

    private byte[] getTagValueBytes(ExifIDFRawTag exifIDFRawTag) throws BufferUnderflowException, IllegalArgumentException {
        byte[] byArray = new byte[exifIDFRawTag.o00000];
        this.o00000.position((int)exifIDFRawTag.String);
        if (this.o00000.remaining() >= exifIDFRawTag.o00000) {
            this.o00000.get(byArray);
        }
        return byArray;
    }

    private ByteOrder parseHeader(byte[] byArray) {
        ByteOrder byteOrder;
        if (byArray[0] == 73 && byArray[1] == 73) {
            this.Object = true;
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (byArray[0] == 77 && byArray[1] == 77) {
            this.Object = false;
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            this.float = true;
            byteOrder = null;
        }
        if (this.Object && byArray[2] != 42 && byArray[3] != 0) {
            this.float = true;
        } else if (!this.Object && byArray[2] != 0 && byArray[3] != 42) {
            this.float = true;
        }
        if (this.float && this.void != null) {
            this.void.log(3831, this.\u00d200000);
        }
        return byteOrder;
    }

    private void scanIFD(C c) {
        block18: {
            try {
                this.o00000.position(c.\u00d200000());
                int n = this.o00000.getShort();
                if (n > 0 && n <= 3000) {
                    int n2;
                    ExifIDFRawTag[] exifIDFRawTagArray = new ExifIDFRawTag[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        int n3;
                        int n4 = c.\u00d200000() + 2 + 12 * n2;
                        this.o00000.position(n4);
                        exifIDFRawTagArray[n2] = new ExifIDFRawTag();
                        exifIDFRawTagArray[n2].\u00d200000 = this.o00000.getShort() & 0xFFFF;
                        exifIDFRawTagArray[n2].\u00d300000 = this.o00000.getShort() & 0xFFFF;
                        exifIDFRawTagArray[n2].o00000 = this.o00000.getInt();
                        exifIDFRawTagArray[n2].String = this.o00000.getInt();
                        if (exifIDFRawTagArray[n2].\u00d300000 < 0 || exifIDFRawTagArray[n2].\u00d300000 > 12 || (n3 = exifIDFRawTagArray[n2].o00000 * \u00d600000[exifIDFRawTagArray[n2].\u00d300000]) > 4) continue;
                        exifIDFRawTagArray[n2].String = n4 + 8;
                    }
                    switch (c.o00000()) {
                        case 34665: {
                            for (n2 = 0; n2 < n; ++n2) {
                                if (exifIDFRawTagArray[n2].\u00d200000 <= 0) continue;
                                this.evaluateExifTag(exifIDFRawTagArray[n2]);
                            }
                            break block18;
                        }
                        case 34853: {
                            for (n2 = 0; n2 < n; ++n2) {
                                if (exifIDFRawTagArray[n2].\u00d200000 <= 0) continue;
                                this.evaluateGPSTag(exifIDFRawTagArray[n2]);
                            }
                            break block18;
                        }
                        case 40965: {
                            for (n2 = 0; n2 < n; ++n2) {
                                if (exifIDFRawTagArray[n2].\u00d200000 <= 0) continue;
                                this.evaluateInterOpTag(exifIDFRawTagArray[n2]);
                            }
                            break block18;
                        }
                    }
                    break block18;
                }
                if (n < 0 || n > 3000) {
                    if (this.void != null) {
                        this.void.log(3832, this.\u00d200000);
                    }
                    this.float = true;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if (this.void != null) {
                    this.void.logException(iOException, 3830, "IOE1", this.\u00d200000);
                }
                this.float = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (illegalArgumentException.getCause() != null) {
                    illegalArgumentException.getCause().printStackTrace();
                }
                if (this.void != null) {
                    this.void.logException(illegalArgumentException, 3830, "IAE2", this.\u00d200000);
                }
                this.float = true;
            }
        }
    }

    private static double[] convertRationalsListToDoubleArray(Rational[] rationalArray) {
        double[] dArray = new double[rationalArray.length];
        for (int i = 0; i < rationalArray.length; ++i) {
            dArray[i] = ExifParser.convertRationalToDouble(rationalArray[i]);
        }
        return dArray;
    }

    private static double convertRationalToDouble(Rational rational) {
        double d = (double)rational.o00000 / (double)rational.new;
        return d;
    }

    private static float convertRationalToFloat(Rational rational) {
        if (rational.new != 0L) {
            float f = (float)rational.o00000 / (float)rational.new;
            return f;
        }
        return 0.0f;
    }
}

