/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.reader;

import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.MemoryManager;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageMode;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.imagereader.reader.ConverterImageReaderAbstract;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class ConverterImageReaderPSD
extends ConverterImageReaderAbstract {
    private static int \u00f6o0000 = 1;

    public ConverterImageReaderPSD(FSILogger fSILogger, SwapPool swapPool, BufferedImageConverter bufferedImageConverter, ByteOrder byteOrder, boolean bl) {
        super(fSILogger, swapPool, bufferedImageConverter, byteOrder, bl, \u00f6o0000);
    }

    @Override
    public void destroy() {
        this.shutdown();
        if (this.\u00d400000) {
            while (!this.OO0000 && !this.Oo0000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readImage() throws IOException {
        boolean bl = false;
        this.\u00d400000 = true;
        File file = this.voidsuper.null.toFile();
        ImageReader imageReader = null;
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            imageReader = iterator.next();
            \u00f6o0000 |= imageReader.getOriginatingProvider().getVersion().hashCode();
            imageReader.setInput(imageInputStream);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
            this.\u00f4O0000 = this.transferImageDirect(bufferedImage);
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
        }
        return bl;
    }

    @Override
    public void setFile(FSIMetaData fSIMetaData) {
        long l;
        this.voidsuper = fSIMetaData;
        if (fSIMetaData.\u00d2O0000 > 0xFFFFFFFEL) {
            if (this.\u00d200000 != null) {
                this.\u00d200000.log(3806, fSIMetaData.o00000);
            }
            this.Oo0000 = true;
        }
        if (!(this.Oo0000 || (l = 4L * (long)fSIMetaData.getWidth() * (long)fSIMetaData.getHeight()) <= MemoryManager.getFreeHeapSpace() && l <= Integer.MAX_VALUE)) {
            this.Objectsuper = true;
        }
    }

    private FSIImage transferImageDirect(BufferedImage bufferedImage) {
        FSIImageMode fSIImageMode = bufferedImage.getColorModel().hasAlpha() ? FSIImageMode.new : FSIImageMode.o00000;
        FSIImageLimited fSIImageLimited = new FSIImageLimited(this.\u00d200000, this.super, this.\u00d2o0000, bufferedImage.getWidth(), bufferedImage.getHeight(), this.voidsuper.o00000, fSIImageMode);
        boolean bl = bufferedImage.isAlphaPremultiplied();
        if (!bl) {
            for (int i = 0; i < bufferedImage.getHeight(); ++i) {
                for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                    int n = bufferedImage.getRGB(j, i);
                    if (this.\u00d4o0000) {
                        this.voidsuper.oO0000.pushRGB(n);
                    }
                    ((FSIImage)fSIImageLimited).setSample(j, i, n);
                }
            }
        } else {
            for (int i = 0; i < bufferedImage.getHeight(); ++i) {
                for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                    int n;
                    int n2 = bufferedImage.getRGB(j, i);
                    int n3 = n2 >> 24 & 0xFF;
                    if (n3 != 0 && n3 != 255) {
                        float f = (float)n3 / 255.0f;
                        int n4 = (int)((float)(n2 >> 16 & 0xFF) / f);
                        int n5 = (int)((float)(n2 >> 8 & 0xFF) / f);
                        int n6 = (int)((float)(n2 & 0xFF) / f);
                        n = n3 << 24 | n4 << 16 | n5 << 8 | n6;
                    } else {
                        n = n2;
                    }
                    if (this.\u00d4o0000) {
                        this.voidsuper.oO0000.pushARGB(n);
                    }
                    ((FSIImage)fSIImageLimited).setSample(j, i, n);
                }
            }
        }
        return fSIImageLimited;
    }
}

