/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor;

import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.security.CityHash;
import com.neptunelabs.fsiserver.utils.URL;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public final class Parameters {
    private final Map<Parameter, String> \u00d300000;
    private Type \u00d200000 = null;
    private String \u00d500000 = null;
    private long String = 0L;
    private long o00000 = -1L;

    private static Map<String, String[]> parseServletRequest(HttpServletRequest httpServletRequest) {
        Map<String, String[]> map = httpServletRequest.getParameterMap();
        if (map.size() == 0 && httpServletRequest.getMethod().equalsIgnoreCase("POST") && httpServletRequest.getContentLength() > 0) {
            byte[] byArray;
            try {
                byArray = URL.getContent(httpServletRequest);
            }
            catch (IOException iOException) {
                byArray = null;
            }
            if (byArray != null) {
                Charset charset;
                String string = httpServletRequest.getCharacterEncoding();
                if (string == null) {
                    charset = StandardCharsets.US_ASCII;
                } else if (string.equalsIgnoreCase("UTF-8")) {
                    charset = StandardCharsets.UTF_8;
                } else if (string.equalsIgnoreCase("ISO-8859-1") || string.equalsIgnoreCase("ISO-8859-15")) {
                    charset = FileOperations.\u00d500000;
                } else {
                    try {
                        charset = Charset.forName(string);
                    }
                    catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                        charset = FileOperations.o00000;
                    }
                }
                map = URL.parseParameters(byArray, charset);
            }
        }
        return map;
    }

    public Parameters(HttpServletRequest httpServletRequest) {
        this(Parameters.parseServletRequest(httpServletRequest));
    }

    public Parameters(String string) {
        this(URL.parseParameters(string.getBytes(FileOperations.o00000), FileOperations.o00000));
    }

    private Parameters(Map<String, String[]> map) {
        String string;
        if (map.get("type") != null) {
            string = map.get("type")[0];
            if (string == null) {
                string = "IMAGE";
            }
            this.\u00d200000 = Type.valueOf(string.toUpperCase());
        } else {
            this.\u00d200000 = Type.\u00d800000;
        }
        this.\u00d300000 = new LinkedHashMap<Parameter, String>();
        Parameters.fillParameterMap(map, this.\u00d300000, General.values());
        if (this.\u00d200000 == Type.\u00f600000) {
            Parameters.fillParameterMap(map, this.\u00d300000, GeneralImage.values());
            Parameters.fillParameterMap(map, this.\u00d300000, FileImage.values());
        } else if (this.\u00d200000 == Type.\u00d300000) {
            Parameters.fillParameterMap(map, this.\u00d300000, GeneralImage.values());
            Parameters.fillParameterMap(map, this.\u00d300000, DirectoryImage.values());
            Parameters.fillParameterMap(map, this.\u00d300000, Sorting.values());
        } else if (this.\u00d200000 == Type.super) {
            Parameters.fillParameterMap(map, this.\u00d300000, _Oo.values());
            Parameters.fillParameterMap(map, this.\u00d300000, Sorting.values());
        } else if (this.\u00d200000 == Type.class) {
            Parameters.fillParameterMap(map, this.\u00d300000, List.values());
            Parameters.fillParameterMap(map, this.\u00d300000, Sorting.values());
        } else if (this.\u00d200000 == Type.int || this.\u00d200000 == Type.\u00d200000) {
            Parameters.fillParameterMap(map, this.\u00d300000, Search.values());
            Parameters.fillParameterMap(map, this.\u00d300000, List.values());
            Parameters.fillParameterMap(map, this.\u00d300000, Sorting.values());
        } else if (this.\u00d200000 == Type.\u00f400000) {
            Parameters.fillParameterMap(map, this.\u00d300000, AppInfo.values());
        }
        Parameters.fillParameterMap(map, this.\u00d300000, _o.values());
        if (this.\u00d300000.containsKey(_o.Oo0000)) {
            this.\u00d300000.put(General.\u00f4\u00d40000, this.\u00d300000.remove(_o.Oo0000));
        }
        if (this.\u00d300000.containsKey(_o.\u00d2o0000)) {
            this.\u00d300000.put(Sorting.\u00d4\u00d50000, this.\u00d300000.remove(_o.\u00d2o0000));
        }
        if (this.\u00d300000.containsKey(_o.\u00d3o0000)) {
            this.\u00d300000.put(General.\u00f6\u00d40000, this.\u00d300000.remove(_o.\u00d3o0000));
        }
        if ((string = this.\u00d300000.get(General.\u00f8\u00d40000)) != null) {
            this.\u00d500000 = URL.cleanUpSourceParameter(string);
            byte[] byArray = this.\u00d500000.getBytes(StandardCharsets.UTF_8);
            this.String = CityHash.cityHash64(byArray, 0, byArray.length);
        }
        this.hashCode64();
    }

    public Set<Map.Entry<Parameter, String>> entrySet() {
        return this.\u00d300000.entrySet();
    }

    public Type getType() {
        return this.\u00d200000;
    }

    public String getAssetURLPath() {
        return this.\u00d500000;
    }

    public long getAssetURLHash() {
        return this.String;
    }

    public boolean contains(Parameter parameter) {
        return this.\u00d300000.containsKey(parameter);
    }

    public String get(Parameter parameter) {
        return this.\u00d300000.get(parameter);
    }

    public String put(Parameter parameter, String string) {
        if (parameter == General.\u00f8\u00d40000) {
            this.\u00d500000 = string = URL.cleanUpSourceParameter(string);
        }
        return this.\u00d300000.put(parameter, string);
    }

    public long hashCode64() {
        if (this.o00000 == -1L) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)this.\u00d200000);
            for (Map.Entry<Parameter, String> entry : this.\u00d300000.entrySet()) {
                stringBuilder.append(entry.getKey().toString());
                stringBuilder.append(entry.getValue());
            }
            Object object = stringBuilder.toString().getBytes(FileOperations.\u00d200000);
            this.o00000 = CityHash.cityHash64((byte[])object, 0, ((Object)object).length);
        }
        return this.o00000;
    }

    private static void fillParameterMap(Map<String, String[]> map, Map<Parameter, String> map2, Parameter[] parameterArray) {
        if (map != null) {
            block0: for (String string : map.keySet()) {
                String string2 = string.toLowerCase();
                for (Parameter parameter : parameterArray) {
                    if (!parameter.toString().equals(string2)) continue;
                    String[] stringArray = map.get(string);
                    String string3 = stringArray[0];
                    if (string3 == null) continue block0;
                    map2.put(parameter, string3);
                    continue block0;
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Parameter, String> entry : this.\u00d300000.entrySet()) {
            stringBuilder.append(entry.getKey().toString()).append('=').append(entry.getValue()).append(';');
        }
        return stringBuilder.toString();
    }

    public static enum Search implements Parameter
    {
        \u00d4o0000,
        \u00d8o0000,
        \u00d6o0000;

    }

    public static enum AppInfo implements Parameter
    {
        \u00f4o0000,
        \u00f6o0000;

    }

    public static enum List implements Parameter
    {
        \u00f4\u00d50000,
        \u00f6\u00d50000,
        intString,
        O\u00d60000;

    }

    private static enum _Oo implements Parameter
    {

    }

    public static enum DirectoryImage implements Parameter
    {
        \u00d2\u00d60000,
        \u00d3\u00d60000,
        doString;

    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum FileImage implements Parameter
    {
        \u00d300000,
        \u00d600000,
        OO0000,
        \u00f6O0000,
        \u00d8O0000,
        \u00f8O0000,
        interface,
        \u00d3O0000,
        \u00f400000,
        super,
        Objectsuper,
        \u00f4O0000,
        \u00f800000,
        do,
        int,
        class,
        \u00d6O0000,
        \u00d400000,
        \u00d4O0000,
        \u00f600000,
        \u00d800000,
        \u00d200000;

    }

    public static enum GeneralImage implements Parameter
    {
        voidObject,
        \u00d3\u00d30000,
        classnew,
        \u00f6\u00d30000,
        \u00d8\u00d30000,
        \u00d4\u00d20000,
        ObjectObject,
        \u00d3\u00d20000,
        \u00d6\u00d30000,
        \u00d6\u00d20000,
        \u00d3\u00d40000,
        intnew,
        supernew,
        floatObject,
        \u00f4\u00d20000,
        \u00f8\u00d20000,
        \u00d2\u00d30000,
        \u00f6\u00d20000,
        \u00d4\u00d40000,
        \u00d6\u00d40000,
        interfacenew,
        \u00f4\u00d30000,
        \u00f8\u00d30000,
        \u00d4\u00d30000,
        \u00d8\u00d20000,
        O\u00d30000,
        \u00d2\u00d20000,
        O\u00d20000,
        \u00d2\u00d40000,
        donew;

    }

    public static enum Sorting implements Parameter
    {
        superString,
        \u00d8\u00d50000,
        \u00d6\u00d50000,
        classString,
        \u00d3\u00d50000,
        \u00d4\u00d50000;

    }

    private static enum _o implements Parameter
    {
        Oo0000,
        \u00d2o0000,
        \u00d3o0000;

    }

    public static enum General implements Parameter
    {
        publicObject,
        \u00f8\u00d40000,
        \u00f6\u00d40000,
        \u00f4\u00d40000,
        O\u00d50000;

    }

    public static interface Parameter {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Type {
        \u00f600000,
        \u00d300000,
        super,
        class,
        \u00f400000,
        \u00d600000,
        int,
        \u00d200000,
        \u00d800000;

    }
}

