/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.outputcompressors;

import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.framework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.gif.GIFEncoder;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressorResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;

public class GIFCompressor
extends OutputCompressor {
    public GIFCompressor(FSILogger fSILogger) {
        super(fSILogger);
        this.\u00d400000 = true;
    }

    @Override
    public OutputCompressorResponse compressImageData(int n, FSIImage fSIImage, Renderer renderer, Parameters parameters, String string) {
        FSIImage[] fSIImageArray = new FSIImage[]{fSIImage};
        return this.compressImageData(n, fSIImageArray, renderer, parameters, string);
    }

    @Override
    public OutputCompressorResponse compressImageData(int n, FSIImage[] fSIImageArray, Renderer renderer, Parameters parameters, String string) {
        OutputCompressorResponse outputCompressorResponse = new OutputCompressorResponse();
        StringBuilder stringBuilder = new StringBuilder("GIF");
        OutputParameters outputParameters = renderer.getOutputParameters();
        GIFEncoder gIFEncoder = new GIFEncoder(this.new);
        gIFEncoder.setCopyright(string);
        gIFEncoder.setSoftware(SoftwareVersion.getSoftware(false));
        gIFEncoder.setPalette(ImageEncoderUtils.PaletteMode.o00000);
        gIFEncoder.setMatteColor(this.getParameterBackgroundColor(parameters, outputParameters));
        gIFEncoder.setMaxColors(this.getParameterMaxColors(parameters, outputParameters));
        gIFEncoder.setDitherer(this.getParameterDithererMode(parameters, outputParameters));
        gIFEncoder.setQuantizer(this.getParameterQuantizerMode(parameters, outputParameters));
        gIFEncoder.setQuantizerSampleDepth(outputParameters.\u00d5O0000);
        if (fSIImageArray.length == 1) {
            gIFEncoder.setImage(fSIImageArray[0]);
        } else {
            gIFEncoder.setAnimationDelay(this.getParameterDelay(parameters, outputParameters));
            gIFEncoder.setAnimationFramePalette(outputParameters.\u00d3O0000);
            gIFEncoder.setAnimationLoop(this.getParameterLoop(parameters, outputParameters));
            for (FSIImage fSIImage : fSIImageArray) {
                gIFEncoder.addImage(fSIImage);
            }
        }
        try (FSIImage[] fSIImageArray2 = new ByteArrayOutputStreamFast(1024);){
            gIFEncoder.setOutputStream((OutputStream)fSIImageArray2);
            gIFEncoder.encode();
            gIFEncoder.dispose();
            OutputParameters.Encoding encoding = this.getEncodingFromRequestParameters(parameters);
            if (encoding == OutputParameters.Encoding.\u00d400000) {
                encoding = outputParameters.\u00d400000;
            }
            if (encoding == OutputParameters.Encoding.new) {
                outputCompressorResponse.setMimeType("text/plain");
                outputCompressorResponse.setImageData(Base64.getEncoder().encode(fSIImageArray2.toByteArray()));
                stringBuilder.append("b64");
            } else {
                outputCompressorResponse.setMimeType("image/gif");
                outputCompressorResponse.setImageData(fSIImageArray2.toByteArray());
            }
            outputCompressorResponse.setETagModifer(stringBuilder.toString());
        }
        catch (IOException iOException) {
            this.new.log(3040, iOException.getLocalizedMessage());
            outputCompressorResponse.setError(true);
        }
        return outputCompressorResponse;
    }
}

