/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagemanipulator.metrics.HistogramRenderer;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.metrics.Histogram;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class MetricsImageRenderer
extends RendererAbstract {
    private final ImageBuilder O\u00d40000;

    public MetricsImageRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        this.O\u00d40000 = requestProcessorSettings.getImageBuilder();
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new HashSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws IllegalArgumentException {
        RendererImageResponse rendererImageResponse;
        block8: {
            HttpSession httpSession = httpServletRequest.getSession(false);
            Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
            String string = parameters.getAssetURLPath();
            String string2 = parameters.get(Parameters.FileImage.\u00f6O0000);
            if (string == null) {
                return MetricsImageRenderer.generateMissingParameterResponse("source");
            }
            if (string2 == null) {
                return MetricsImageRenderer.generateMissingParameterResponse("channel");
            }
            rendererImageResponse = new RendererImageResponse();
            try {
                SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(string);
                PermissionSet permissionSet = this.\u00d300000.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
                if (permissionSet == null || !permissionSet.read.renderedImages.booleanValue() || !permissionSet.read.extendedMetadata.booleanValue()) {
                    return MetricsImageRenderer.generateNotAuthorizedResponse();
                }
                HistogramRenderer.HistogramChannel histogramChannel = HistogramRenderer.HistogramChannel.valueOf(string2.toUpperCase());
                MetaData metaData = this.O\u00d40000.getImageMetaData(sourceConnectorReader, string, 32, true, httpSession);
                if (metaData != null && metaData instanceof ImageMetaData) {
                    ImageMetaData imageMetaData = (ImageMetaData)metaData;
                    Histogram histogram = imageMetaData.getHistogram();
                    if (histogram != null) {
                        HistogramRenderer histogramRenderer = new HistogramRenderer(this.new, this.\u00d300000.getSwapPool(), histogram);
                        FSIImageLimited fSIImageLimited = histogramRenderer.drawHistogram(histogramChannel);
                        rendererImageResponse.setResponseImage(fSIImageLimited);
                        rendererImageResponse.setStatus(200);
                    }
                    break block8;
                }
                throw new IllegalArgumentException("Histogram requests not supported for non-image files.");
            }
            catch (IOException iOException) {
                this.new.log(3190, iOException.getClass().getName() + ": " + iOException.getLocalizedMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Invalid channel value.");
            }
        }
        return rendererImageResponse;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new TreeSet<String>();
    }

    @Override
    public void setOption(String string, String string2) {
    }

    @Override
    public String getOption(String string) {
        return null;
    }
}

