/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class EISChainWriter {
    private ByteOrder super = ByteOrder.LITTLE_ENDIAN;
    private Path \u00d200000 = null;

    public EISChainWriter(FSILogger fSILogger, Path path) {
        this.\u00d200000 = path;
    }

    public void addEntry(int n, String string) throws IOException {
        if (Files.exists(this.\u00d200000, new LinkOption[0])) {
            this.addEntryToExistingChainFile(this.\u00d200000, n, string);
        } else {
            this.createNewChainFileWithEntry(this.\u00d200000, string, n);
        }
    }

    public void removeEntry(String string) throws IOException {
        if (Files.exists(this.\u00d200000, new LinkOption[0])) {
            Map<String, Integer> map = EISChainReader.readAll(this.\u00d200000);
            map.remove(string);
            if (map.size() > 0) {
                this.createChainFileWithEntries(this.\u00d200000, map);
            } else {
                Files.delete(this.\u00d200000);
            }
        } else {
            throw new NoSuchFileException(this.\u00d200000.toAbsolutePath().toString());
        }
    }

    private void createChainFileWithEntries(Path path, Map<String, Integer> map) throws IOException {
        int n = EISEnvironment.\u00d600000.length + 1 + 2;
        for (Map.Entry<String, Integer> object2 : map.entrySet()) {
            n += 8 + object2.getKey().getBytes(FileOperations.\u00d200000).length;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.put(EISEnvironment.\u00d600000);
        if (this.super == ByteOrder.LITTLE_ENDIAN) {
            byteBuffer.put((byte)126);
        } else {
            byteBuffer.put((byte)-66);
        }
        byteBuffer.order(this.super);
        byteBuffer.putShort((short)1);
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            byteBuffer.putInt(entry.getValue());
            byte[] byArray = entry.getKey().getBytes(FileOperations.\u00d200000);
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
        }
        Path path2 = Files.createTempFile(path.getParent(), path.getFileName().toString(), ".tmp", new FileAttribute[0]);
        FileOperations.writeFile(path2, byteBuffer);
        FileOperations.move(path2, path);
    }

    private void createNewChainFileWithEntry(Path path, String string, int n) throws IOException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put(string, n);
        this.createChainFileWithEntries(path, hashMap);
    }

    private void addEntryToExistingChainFile(Path path, int n, String string) throws IOException {
        block13: {
            try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                EISChainReader.readAndEvaluateMagic(seekableByteChannel);
                this.super = EISChainReader.readAndHandleByteOrderEntry(seekableByteChannel);
                short s = EISChainReader.readVersion(seekableByteChannel, this.super);
                if (s == 1) {
                    seekableByteChannel.position(seekableByteChannel.size());
                    byte[] byArray = string.getBytes(FileOperations.\u00d200000);
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8 + byArray.length);
                    byteBuffer.order(this.super);
                    byteBuffer.putInt(n);
                    byteBuffer.putInt(byArray.length);
                    byteBuffer.put(byArray);
                    byteBuffer.flip();
                    seekableByteChannel.write(byteBuffer);
                    break block13;
                }
                throw new IOException("Unknown EIS Chain Version in file " + path);
            }
        }
    }
}

