/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.io;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MemoryManager {
    private static final MemoryManager o00000 = new MemoryManager();
    private static Boolean return = null;
    private final int \u00d300000 = 20;
    private final MemoryPoolMXBean \u00d400000 = this.findOldGenPool();
    private long \u00d500000 = 0L;
    private long new = 0L;

    private MemoryManager() {
    }

    public static MemoryManager getInstance() {
        return o00000;
    }

    public void adaptThreshold() {
        if (this.usesG1GC()) {
            long l = MemoryManager.getTotalHeapSpace() + this.getCommitedYoungGen();
            if (l != this.new) {
                this.new = l;
                this.\u00d500000 = l - (long)((float)(l * 20L) / 100.0f);
                this.\u00d400000.setUsageThreshold(MemoryManager.getTotalHeapSpace());
                this.\u00d400000.setUsageThreshold(this.\u00d500000);
            }
        } else {
            long l = this.\u00d400000.getUsage().getMax();
            this.\u00d500000 = l - (long)((float)(l * 20L) / 100.0f);
            this.\u00d400000.setUsageThreshold(this.\u00d500000);
        }
    }

    public boolean usesG1GC() {
        if (return == null) {
            List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMXBean : list) {
                if (!garbageCollectorMXBean.getName().contains("G1")) continue;
                return = true;
            }
            if (return == null) {
                return = false;
            }
        }
        return return;
    }

    private long getCommitedYoungGen() {
        long l = 0L;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.getName().contains("Eden") && !memoryPoolMXBean.getName().contains("Survivor")) continue;
            l += memoryPoolMXBean.getUsage().getCommitted();
        }
        return l;
    }

    public long getMaxYoungGen() {
        long l = 0L;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.getName().contains("Eden") && !memoryPoolMXBean.getName().contains("Survivor")) continue;
            l += memoryPoolMXBean.getUsage().getMax();
        }
        return l;
    }

    public long getCommitedOldGen() {
        long l = 0L;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (memoryPoolMXBean.getType() != MemoryType.HEAP || memoryPoolMXBean.getName().contains("Eden") || memoryPoolMXBean.getName().contains("Survivor")) continue;
            l += memoryPoolMXBean.getUsage().getCommitted();
        }
        return l;
    }

    public long getMaxOldGen() {
        long l = 0L;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (memoryPoolMXBean.getType() != MemoryType.HEAP || memoryPoolMXBean.getName().contains("Eden") || memoryPoolMXBean.getName().contains("Survivor")) continue;
            l += memoryPoolMXBean.getUsage().getMax();
        }
        return l;
    }

    public long getCurrentThreshold() {
        return this.\u00d500000;
    }

    public long getUsedOldGen() {
        return this.\u00d400000.getUsage().getUsed();
    }

    private static long getUsedHeapSpace() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    public static long getTotalHeapSpace() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
    }

    public static long getFreeHeapSpace() {
        return MemoryManager.getTotalHeapSpace() - MemoryManager.getUsedHeapSpace();
    }

    private MemoryPoolMXBean findOldGenPool() {
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.isUsageThresholdSupported()) continue;
            return memoryPoolMXBean;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    public void dumpMemory() {
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean object22 : list) {
            Object object;
            System.out.println("MemoryPool Name: %" + object22.getName());
            for (String string : object = object22.getMemoryPoolNames()) {
                System.out.println("Pool Name: %" + string);
            }
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        System.out.println("Current thread count: " + threadMXBean.getThreadCount());
        System.out.println("Peak thread count: " + threadMXBean.getPeakThreadCount());
        List<MemoryPoolMXBean> list2 = ManagementFactory.getMemoryPoolMXBeans();
        for (Object object : list2) {
            MemoryUsage memoryUsage = object.getPeakUsage();
            System.out.println("Peak %s memory used: " + object.getName() + ", " + memoryUsage.getUsed());
            System.out.println("Peak %s memory reserved: " + object.getName() + " " + memoryUsage.getCommitted());
        }
    }
}

