/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class ReaderAbstract
implements Closeable {
    final Path \u00d400000;
    SeekableByteChannel Object;
    ByteOrder o00000;
    private long \u00d200000 = -1L;

    ReaderAbstract(Path path, Set<StandardOpenOption> set) throws IOException {
        this.\u00d400000 = path;
        this.checkAccess(set);
        this.init(set);
    }

    ReaderAbstract(Path path, StandardOpenOption ... standardOpenOptionArray) throws IOException {
        this.\u00d400000 = path;
        HashSet<StandardOpenOption> hashSet = new HashSet<StandardOpenOption>(standardOpenOptionArray.length);
        Collections.addAll(hashSet, standardOpenOptionArray);
        this.checkAccess(hashSet);
        this.init(hashSet);
    }

    private void checkAccess(Set<StandardOpenOption> set) throws IOException {
        if (set.contains(StandardOpenOption.CREATE) || set.contains(StandardOpenOption.CREATE_NEW) || set.contains(StandardOpenOption.WRITE) || set.contains(StandardOpenOption.APPEND) || set.contains(StandardOpenOption.TRUNCATE_EXISTING)) {
            throw new IOException("Only read modes allowed");
        }
    }

    private void init(Set<StandardOpenOption> set) throws IOException {
        this.Object = Files.newByteChannel(this.\u00d400000, set, new FileAttribute[0]);
        this.o00000 = ByteOrder.nativeOrder();
    }

    public long length() throws IOException {
        if (this.\u00d200000 == -1L) {
            this.\u00d200000 = this.Object.size();
        }
        return this.\u00d200000;
    }

    public String toString() {
        return this.\u00d400000.toString();
    }

    public boolean isOpen() {
        return this.Object.isOpen();
    }

    @Override
    public abstract void close() throws IOException;

    public abstract int read(byte[] var1) throws IOException;

    public abstract int read(ByteBuffer var1) throws IOException;

    public abstract int read() throws IOException;

    public abstract byte readByte() throws IOException;

    public abstract int readUByte() throws IOException;

    public abstract short readShort() throws IOException;

    public abstract int readUShort() throws IOException;

    public abstract int readInt() throws IOException;

    public abstract long readUInt() throws IOException;

    public abstract long readLong() throws IOException;

    public abstract float readFloat() throws IOException;

    public abstract double readDouble() throws IOException;

    public abstract void seek(long var1) throws IOException, IllegalArgumentException;

    public abstract long position() throws IOException;

    public abstract void skip(long var1) throws IOException;

    public void setByteOrder(ByteOrder byteOrder) {
        this.o00000 = byteOrder;
    }

    public ByteOrder getByteOrder() {
        return this.o00000;
    }
}

