/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.io;

import com.neptunelabs.fsiserver.framework.io.ReaderAbstract;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;

public class ReaderChannel
extends ReaderAbstract {
    public ReaderChannel(Path path, Set<StandardOpenOption> set) throws IOException {
        super(path, set);
    }

    public ReaderChannel(Path path, StandardOpenOption ... standardOpenOptionArray) throws IOException {
        super(path, standardOpenOptionArray);
    }

    @Override
    public String toString() {
        return this.\u00d400000.toString();
    }

    @Override
    public void close() throws IOException {
        this.Object.close();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.Object.read(ByteBuffer.wrap(byArray));
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.Object.read(byteBuffer);
    }

    @Override
    public int read() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        this.Object.read(byteBuffer);
        byteBuffer.flip();
        return byteBuffer.get() & 0xFF;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    @Override
    public int readUByte() throws IOException {
        return this.read();
    }

    @Override
    public short readShort() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2);
        byteBuffer.order(this.o00000);
        this.Object.read(byteBuffer);
        byteBuffer.flip();
        return byteBuffer.getShort();
    }

    @Override
    public int readUShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readInt() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(this.o00000);
        this.Object.read(byteBuffer);
        byteBuffer.flip();
        return byteBuffer.getInt();
    }

    @Override
    public long readUInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(this.o00000);
        this.Object.read(byteBuffer);
        byteBuffer.flip();
        return byteBuffer.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(this.o00000);
        this.Object.read(byteBuffer);
        byteBuffer.flip();
        return byteBuffer.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(this.o00000);
        this.Object.read(byteBuffer);
        byteBuffer.flip();
        return byteBuffer.getDouble();
    }

    @Override
    public void seek(long l) throws IOException, IllegalArgumentException {
        this.Object.position(l);
    }

    @Override
    public void skip(long l) throws IOException {
        this.seek(this.Object.position() + l);
    }

    @Override
    public long position() throws IOException {
        return this.Object.position();
    }
}

