/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.area;

import com.neptunelabs.fsiserver.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.fsiserver.imagereader.converter.FastMath;

public class ConvolutionKernel2D {
    int \u00d300000;
    int o00000;
    float[] \u00d200000;

    public ConvolutionKernel2D(int n, int n2, float[] fArray) throws ImageManipulatorException {
        int n3 = n * n2;
        if (n / 2 * 2 == n || n2 / 2 * 2 == n2) {
            throw new ImageManipulatorException("Kernel size even");
        }
        if (fArray == null) {
            throw new ImageManipulatorException("Kernel matrix null");
        }
        if (n3 != fArray.length) {
            throw new ImageManipulatorException("Kernel must have odd width and height");
        }
        this.\u00d300000 = n;
        this.o00000 = n2;
        this.\u00d200000 = fArray;
    }

    public static ConvolutionKernel2D getGaussianKernel(int n, double d) {
        int n2;
        int n3 = n * 2 + 1;
        float[] fArray = new float[n3 * n3];
        double d2 = 2.0 * d * d;
        double d3 = Math.sqrt(Math.PI * 2 * d);
        float f = n * n;
        float f2 = 0.0f;
        int n4 = 0;
        for (n2 = -n; n2 <= n; ++n2) {
            for (int i = -n; i <= n; ++i) {
                float f3 = n2 * n2 + i * i;
                fArray[n4] = f3 > f ? 0.0f : (float)(FastMath.exp((double)(-f3) / d2) / d3);
                f2 += fArray[n4];
                ++n4;
            }
        }
        n2 = 0;
        while (n2 < fArray.length) {
            int n5 = n2++;
            fArray[n5] = fArray[n5] / f2;
        }
        return new ConvolutionKernel2D(n3, n3, fArray);
    }
}

