/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.utils;

import com.neptunelabs.fsiserver.imagereader.converter.FastMath;

public final class BaseImageUtils {
    protected BaseImageUtils() {
    }

    public static float clamp(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    private static double clamp(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d > 1.0) {
            return 1.0;
        }
        return d;
    }

    public static int clampFT255(double d) {
        if (d < 0.0) {
            return 0;
        }
        if (d > 255.0) {
            return 255;
        }
        return (int)(d + 0.5);
    }

    public static int clampFT(float f, int n, int n2) {
        if (f < (float)n) {
            return 0;
        }
        if (f > (float)n2) {
            return 255;
        }
        return (int)(f + 0.5f);
    }

    public static int clampFT255(float f) {
        if (f < 0.0f) {
            return 0;
        }
        if (f > 255.0f) {
            return 255;
        }
        return (int)(f + 0.5f);
    }

    public static int clampFT(int n, int n2, int n3) {
        if (n < n2) {
            return 0;
        }
        if (n > n3) {
            return 255;
        }
        return n;
    }

    public static float[] rgbToHsl(float f, float f2, float f3) {
        float f4 = Math.min(Math.min(f, f2), f3);
        float f5 = Math.max(Math.max(f, f2), f3);
        float f6 = f5 - f4;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        f9 = (f5 + f4) / 2.0f;
        if ((double)f6 == 0.0) {
            f7 = 0.0f;
            f8 = 0.0f;
        } else {
            f8 = f9 < 0.5f ? f6 / (f5 + f4) : f6 / (2.0f - f5 - f4);
            float f10 = ((f5 - f) / 6.0f + f6 / 2.0f) / f6;
            float f11 = ((f5 - f2) / 6.0f + f6 / 2.0f) / f6;
            float f12 = ((f5 - f3) / 6.0f + f6 / 2.0f) / f6;
            if (f == f5) {
                f7 = f12 - f11;
            } else if (f2 == f5) {
                f7 = 0.33333334f + f10 - f12;
            } else if (f3 == f5) {
                f7 = 0.6666667f + f11 - f10;
            }
            if (f7 < 0.0f) {
                f7 += 1.0f;
            } else if (f7 > 1.0f) {
                f7 -= 1.0f;
            }
        }
        return new float[]{f7, f8, f9};
    }

    public static float[] hslToRgb(float f, float f2, float f3) {
        float[] fArray = new float[3];
        if (f2 == 0.0f) {
            fArray[0] = f3;
            fArray[1] = f3;
            fArray[2] = f3;
        } else {
            float f4 = (double)f3 <= 0.5 ? f3 * (1.0f + f2) : f3 + f2 - f3 * f2;
            float f5 = 2.0f * f3 - f4;
            fArray[0] = BaseImageUtils.hueToRgb(f5, f4, f + 0.3333333f);
            fArray[1] = BaseImageUtils.hueToRgb(f5, f4, f);
            fArray[2] = BaseImageUtils.hueToRgb(f5, f4, f - 0.3333333f);
        }
        return fArray;
    }

    private static float hueToRgb(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (f3 * 6.0f < 1.0f) {
            return f + (f2 - f) * f3 * 6.0f;
        }
        if (f3 * 2.0f < 1.0f) {
            return f2;
        }
        if (f3 * 3.0f < 2.0f) {
            return f + (f2 - f) * (0.6666667f - f3) * 6.0f;
        }
        return f;
    }

    public static float[] rgbToHsb(int n) {
        float f;
        int n2;
        int n3;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n3 = n4 > n5 ? n4 : n5;
        if (n6 > n3) {
            n3 = n6;
        }
        int n8 = n2 = n4 < n5 ? n4 : n5;
        if (n6 < n2) {
            n2 = n6;
        }
        float f2 = (float)n3 / 255.0f;
        float f3 = n3 != 0 ? (float)(n3 - n2) / (float)n3 : 0.0f;
        if (f3 == 0.0f) {
            f = 0.0f;
        } else {
            float f4 = (float)(n3 - n4) / (float)(n3 - n2);
            float f5 = (float)(n3 - n5) / (float)(n3 - n2);
            float f6 = (float)(n3 - n6) / (float)(n3 - n2);
            f = n4 == n3 ? f6 - f5 : (n5 == n3 ? 2.0f + f4 - f6 : 4.0f + f5 - f4);
            if ((f /= 6.0f) < 0.0f) {
                f += 1.0f;
            }
        }
        float[] fArray = new float[]{f, f3, f2};
        return fArray;
    }

    public static int[] hslToSRGBInt(int n, int n2, int n3) {
        int[] nArray = new int[3];
        if (n2 == 0) {
            nArray[0] = n3;
            nArray[1] = n3;
            nArray[2] = n3;
        } else {
            float f = n3 < 128 ? (float)(n3 * (255 + n2)) / 65025.0f : ((float)(n3 + n2) - (float)(n3 * n2) / 255.0f) / 255.0f;
            float f2 = (float)n3 / 127.5f - f;
            nArray[0] = BaseImageUtils.hslValueInt(f2, f, n + 85);
            nArray[1] = BaseImageUtils.hslValueInt(f2, f, n);
            nArray[2] = BaseImageUtils.hslValueInt(f2, f, n - 85);
        }
        return nArray;
    }

    private static int hslValueInt(float f, float f2, float f3) {
        if (f3 > 255.0f) {
            f3 -= 255.0f;
        } else if (f3 < 0.0f) {
            f3 += 255.0f;
        }
        float f4 = (double)f3 < 42.5 ? f + (f2 - f) * f3 / 42.5f : ((double)f3 < 127.5 ? f2 : (f3 < 170.0f ? f + (f2 - f) * (170.0f - f3) / 42.5f : f));
        return FastMath.round((double)f4 * 255.0);
    }

    public static int[] srgbToHSLInt(int n, int n2, int n3) {
        float f;
        float f2;
        int n4;
        int n5;
        if (n > n2) {
            n5 = Math.max(n, n3);
            n4 = Math.min(n2, n3);
        } else {
            n5 = Math.max(n2, n3);
            n4 = Math.min(n, n3);
        }
        float f3 = (float)(n5 + n4) / 2.0f;
        if (n5 == n4) {
            f2 = 0.0f;
            f = 0.0f;
        } else {
            int n6 = n5 - n4;
            f2 = f3 < 128.0f ? (float)(255 * n6) / (float)(n5 + n4) : 255.0f * (float)n6 / (float)(511 - n5 - n4);
            f = n == n5 ? (float)(n2 - n3) / (float)n6 : (n2 == n5 ? 2.0f + (float)(n3 - n) / (float)n6 : 4.0f + (float)(n - n2) / (float)n6);
            if ((f *= 42.5f) < 0.0f) {
                f += 255.0f;
            } else if (f > 255.0f) {
                f -= 255.0f;
            }
        }
        int[] nArray = new int[]{FastMath.round(f), FastMath.round(f2), FastMath.round(f3)};
        return nArray;
    }

    public static int floatRgbToIntRgb(float[] fArray) {
        int n = BaseImageUtils.clampFT255(fArray[0] * 255.0f + 0.5f) << 16 | BaseImageUtils.clampFT255(fArray[1] * 255.0f + 0.5f) << 8 | BaseImageUtils.clampFT255(fArray[2] * 255.0f + 0.5f);
        return n;
    }

    public static float[] rgbToYiq(float f, float f2, float f3) {
        return new float[]{0.299f * f + 0.587f * f2 + 0.114f * f3, 0.595716f * f - 0.274453f * f2 - 0.321263f * f3, 0.211456f * f - 0.522591f * f2 + 0.311135f * f3};
    }

    public static float[] yiqToRgb(float f, float f2, float f3) {
        return new float[]{f + 0.9563f * f2 + 0.621f * f3, f - 0.2721f * f2 - 0.6474f * f3, f - 1.107f * f2 + 1.7046f * f3};
    }

    public static float getBrightnessRGB(int n, int n2, int n3) {
        return 0.298839f * (float)n + 0.586811f * (float)n2 + 0.11435f * (float)n3;
    }

    public static float getBrightnessLinear(int n, int n2, int n3) {
        return 0.33333f * (float)n + 0.33333f * (float)n2 + 0.33333f * (float)n3;
    }

    public static float getBrightnessSRGB(int n, int n2, int n3) {
        return 0.2126f * (float)n + 0.7152f * (float)n2 + 0.0722f * (float)n3;
    }

    public static float[] RGBtoHSY(float f, float f2, float f3) {
        float[] fArray;
        float f4;
        float f5;
        float[] fArray2 = BaseImageUtils.rgbToHsl(f, f2, f3);
        float f6 = fArray2[0];
        float f7 = Math.min(f, Math.min(f2, f3));
        float f8 = Math.max(f, Math.max(f2, f3));
        float f9 = f8 - f7;
        float f10 = f * 0.298839f + f2 * 0.586811f + f3 * 0.11435f;
        if (f10 > 255.0f) {
            f10 = 255.0f;
        }
        if (f10 < 0.0f) {
            f10 = 0.0f;
        }
        if (f9 > (f5 = f10 >= (f4 = (f = (fArray = BaseImageUtils.hslToRgb(f6, 1.0f, 0.5f))[0] * 255.0f) * 0.298839f + (f2 = fArray[1] * 255.0f) * 0.586811f + (f3 = fArray[2] * 255.0f) * 0.11435f) ? 255.0f * (255.0f - f10) / (255.0f - f4) : f10 / f4 * 255.0f)) {
            f9 = f5;
        }
        if (f9 < 0.0f) {
            f9 = 0.0f;
        }
        f = BaseImageUtils.scaleValue(f, 0.0f, 255.0f, 0.0f, f9);
        f2 = BaseImageUtils.scaleValue(f2, 0.0f, 255.0f, 0.0f, f9);
        f3 = BaseImageUtils.scaleValue(f3, 0.0f, 255.0f, 0.0f, f9);
        float f11 = f * 0.298839f + f2 * 0.586811f + f3 * 0.11435f;
        f11 = f10 - f11;
        return new float[]{f += f11, f2 += f11, f3 += f11};
    }

    public static float[] RGBtoHLSho(int n, int n2, int n3) {
        float f;
        float f2 = (float)n / 255.0f;
        float f3 = (float)n2 / 255.0f;
        float f4 = (float)n3 / 255.0f;
        float f5 = 0.333333f * (f2 + f3 + f4);
        float f6 = 0.866025f * (f3 - f4);
        float f7 = f2 - 0.5f * (f3 + f4);
        float f8 = (float)Math.atan2(f6, f7);
        if (f8 < 0.0f) {
            f8 += 360.0f;
        }
        float f9 = 1.73205f * f7;
        if (f6 > 0.0f) {
            if (f9 > f6) {
                f = f7 + 0.57735f * f6;
            } else if (-f9 > f6) {
                f = -f7 * 0.57735f * f6;
            }
            f = 1.154701f * f6;
        } else {
            if (f9 > -f6) {
                f = f7 - 0.57735f * f6;
            } else if (-f9 > -f6) {
                f = -f7 - 0.57735f * f6;
            }
            f = -1.154701f * f6;
        }
        return new float[]{f8, f, f5};
    }

    public static float scaleValue(float f, float f2, float f3, float f4, float f5) {
        return (f5 - f4) / (f3 - f2) * f + f4;
    }

    public static int scaleToIntValue(float f, float f2, float f3, float f4, float f5) {
        return (int)((f5 - f4) / (f3 - f2) * f + f4);
    }

    public static float[] rgbToFloat1(int n) {
        float[] fArray = new float[]{(float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f};
        return fArray;
    }

    public static float[] argbToFloat1(int n) {
        float[] fArray;
        fArray = new float[]{(float)(n >>> 24) / 255.0f, (float)(n >> 16 & 0xFF) / 255.0f * fArray[0], (float)(n >> 8 & 0xFF) / 255.0f * fArray[0], (float)(n & 0xFF) / 255.0f * fArray[0]};
        return fArray;
    }

    public static double[] argbToDouble1(int n) {
        double[] dArray;
        dArray = new double[]{(double)(n >>> 24) / 255.0, (double)(n >> 16 & 0xFF) / 255.0 * dArray[0], (double)(n >> 8 & 0xFF) / 255.0 * dArray[0], (double)(n & 0xFF) / 255.0 * dArray[0]};
        return dArray;
    }

    public static float[] rgbD65toXYZ(float f, float f2, float f3) {
        return new float[]{f * 0.4124564f + f2 * 0.3575761f + f3 * 0.1804375f, f * 0.2126729f + f2 * 0.7151522f + f3 * 0.072175f, f * 0.0193339f + f2 * 0.119192f + f3 * 0.9503041f};
    }

    public static float[] rgbD65toXYZ(float[] fArray) {
        return new float[]{fArray[0] * 0.4124564f + fArray[1] * 0.3575761f + fArray[2] * 0.1804375f, fArray[0] * 0.2126729f + fArray[1] * 0.7151522f + fArray[2] * 0.072175f, fArray[0] * 0.0193339f + fArray[1] * 0.119192f + fArray[2] * 0.9503041f};
    }

    public static float[] rgb2xyz(float[] fArray) {
        double d = fArray[0];
        double d2 = fArray[1];
        double d3 = fArray[2];
        d = d > 0.04045 ? Math.pow((d + 0.055) / 1.055, 2.4) : (d /= 12.92);
        d2 = d2 > 0.04045 ? Math.pow((d2 + 0.055) / 1.055, 2.4) : (d2 /= 12.92);
        d3 = d3 > 0.04045 ? Math.pow((d3 + 0.055) / 1.055, 2.4) : (d3 /= 12.92);
        return new float[]{(float)(d * 0.4124564 + d2 * 0.3575761 + d3 * 0.1804375), (float)(d * 0.2126729 + d2 * 0.7151522 + d3 * 0.072175), (float)(d * 0.0193339 + d2 * 0.119192 + d3 * 0.9503041)};
    }

    public static float[] xyz2rgb(float[] fArray) {
        double d = fArray[0];
        double d2 = fArray[1];
        double d3 = fArray[2];
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 0.95047) {
            d = 0.95047;
        }
        double d4 = d * 3.2406 + d2 * -1.5372 + d3 * -0.4986;
        double d5 = d * -0.9689 + d2 * 1.8758 + d3 * 0.0415;
        double d6 = d * 0.0557 + d2 * -0.204 + d3 * 1.057;
        d4 = d4 > 0.0031308 ? 1.055 * Math.pow(d4, 0.4166666567325592) - 0.055 : 12.92 * d4;
        d5 = d5 > 0.0031308 ? 1.055 * Math.pow(d5, 0.4166666567325592) - 0.055 : 12.92 * d5;
        d6 = d6 > 0.0031308 ? 1.055 * Math.pow(d6, 0.4166666567325592) - 0.055 : 12.92 * d6;
        return new float[]{(float)BaseImageUtils.clamp(d4), (float)BaseImageUtils.clamp(d5), (float)BaseImageUtils.clamp(d6)};
    }

    public static float[] xyz2lab(float[] fArray) {
        double d = (double)fArray[0] / 0.95047;
        double d2 = fArray[1];
        double d3 = (double)fArray[2] / 1.08883;
        d = d > 0.008856 ? Math.pow(d, 0.3333333432674408) : 7.787 * d + 0.13793103448275862;
        d2 = d2 > 0.008856 ? Math.pow(d2, 0.3333333432674408) : 7.787 * d2 + 0.13793103448275862;
        d3 = d3 > 0.008856 ? Math.pow(d3, 0.3333333432674408) : 7.787 * d3 + 0.13793103448275862;
        return new float[]{(float)(116.0 * d2 - 16.0), (float)(500.0 * (d - d2)), (float)(200.0 * (d2 - d3))};
    }

    public static float[] lab2xyz(float[] fArray) {
        double d = (fArray[0] + 16.0f) / 116.0f;
        double d2 = (double)(fArray[1] / 500.0f) + d;
        double d3 = d - (double)(fArray[2] / 200.0f);
        d = Math.pow(d, 3.0) > 0.008856 ? Math.pow(d, 3.0) : (d - 0.0) / 7.787;
        d2 = Math.pow(d2, 3.0) > 0.008856 ? Math.pow(d2, 3.0) : (d2 - 0.0) / 7.787;
        d3 = Math.pow(d3, 3.0) > 0.008856 ? Math.pow(d3, 3.0) : (d3 - 0.0) / 7.787;
        return new float[]{(float)(d2 * 0.95047), (float)d, (float)(d3 * 1.08883)};
    }

    public static int double1ToARGB(double[] dArray) {
        int n = BaseImageUtils.clampFT255(dArray[0] * 255.0 + 0.5) << 24 | BaseImageUtils.clampFT255(dArray[1] * 255.0 + 0.5) << 16 | BaseImageUtils.clampFT255(dArray[2] * 255.0 + 0.5) << 8 | BaseImageUtils.clampFT255(dArray[3] * 255.0 + 0.5);
        return n;
    }
}

