/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.converter;

import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ICC_ProfileRGBExt {
    private static final int \u00d500000 = 0;
    private static final int void = 1;
    private static final int \u00d400000 = 2;
    private final transient float[][] Object;
    private transient float o00000 = 0.0f;
    private final transient float[] \u00d200000;
    private final transient float[] \u00f400000;
    private final ICC_Profile \u00d600000;

    public ICC_ProfileRGBExt(ICC_Profile iCC_Profile) {
        this.\u00d600000 = iCC_Profile;
        this.Object = this.createMatrix();
        this.\u00d200000 = this.getXYZData(0x77747074);
        this.\u00f400000 = this.getXYZData(1651208308);
    }

    public ICC_ProfileRGBExt(byte[] byArray) {
        this(ICC_Profile.getInstance(byArray));
    }

    public ICC_Profile getICCProfile() {
        return this.\u00d600000;
    }

    public float[] getMediaWhitePoint() {
        float[] fArray = new float[]{this.\u00d200000[0], this.\u00d200000[1], this.\u00d200000[2]};
        return fArray;
    }

    public float[][] getMatrix() {
        float[][] fArray;
        if (this.Object != null) {
            fArray = new float[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    fArray[i][j] = this.Object[i][j];
                }
            }
        } else {
            fArray = null;
        }
        return fArray;
    }

    public float getGamma(int n) {
        short[] sArray;
        if (this.o00000 != 0.0f) {
            return this.o00000;
        }
        switch (n) {
            case 0: {
                sArray = this.getCurve(1918128707);
                break;
            }
            case 1: {
                sArray = this.getCurve(1733579331);
                break;
            }
            case 2: {
                sArray = this.getCurve(1649693251);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid component");
            }
        }
        if (sArray == null) {
            throw new ProfileDataException("No TRC");
        }
        if (sArray.length != 1) {
            throw new ProfileDataException("Not a single-gamma TRC: " + sArray.length);
        }
        float f = (sArray[0] & 0xFF00) >> 8;
        double d = (double)(sArray[0] & 0xFF) / 256.0;
        this.o00000 = f + (float)d;
        return this.o00000;
    }

    public short[] getTRC(int n) {
        short[] sArray;
        switch (n) {
            case 0: {
                sArray = this.getCurve(1918128707);
                break;
            }
            case 1: {
                sArray = this.getCurve(1733579331);
                break;
            }
            case 2: {
                sArray = this.getCurve(1649693251);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid component");
            }
        }
        if (sArray == null) {
            throw new ProfileDataException("Error reading TRC");
        }
        if (sArray.length <= 1) {
            throw new ProfileDataException("Gamma value, not a TRC table.");
        }
        return sArray;
    }

    private float[][] createMatrix() throws IllegalArgumentException {
        float[][] fArray = null;
        float[] fArray2 = this.getXYZData(1918392666);
        float[] fArray3 = this.getXYZData(1733843290);
        float[] fArray4 = this.getXYZData(1649957210);
        if (fArray2 != null && fArray3 != null && fArray4 != null) {
            fArray = new float[3][3];
            for (int i = 0; i < 3; ++i) {
                fArray[i][0] = fArray2[i];
                fArray[i][1] = fArray3[i];
                fArray[i][2] = fArray4[i];
            }
        }
        return fArray;
    }

    private float[] getXYZData(int n) {
        byte[] byArray = this.\u00d600000.getData(n);
        if (byArray == null) {
            return null;
        }
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray, ByteOrder.BIG_ENDIAN);
        if (byteArrayWalker.getInt(0) != 1482250784) {
            return null;
        }
        float[] fArray = new float[]{(float)byteArrayWalker.getInt(8) / 65536.0f, (float)byteArrayWalker.getInt(12) / 65536.0f, (float)byteArrayWalker.getInt(16) / 65536.0f};
        return fArray;
    }

    private short[] getCurve(int n) {
        byte[] byArray = this.\u00d600000.getData(n);
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (byteBuffer.getInt(0) != 1668641398) {
            return null;
        }
        int n2 = byteBuffer.getInt(8);
        if (n2 == 0) {
            short[] sArray = new short[]{256};
            return sArray;
        }
        if (n2 == 1) {
            short[] sArray = new short[]{byteBuffer.getShort(12)};
            return sArray;
        }
        short[] sArray = new short[n2];
        for (int i = 0; i < n2; ++i) {
            sArray[i] = byteBuffer.getShort(12 + i * 2);
        }
        return sArray;
    }

    public String toString() {
        return this.\u00d600000.toString();
    }
}

