/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.metareader;

import com.neptunelabs.fsiserver.framework.io.LittleEndianDataInputStream;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import com.neptunelabs.fsiserver.imagereader.converter.ColorType;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderAbstract;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;

public final class MetaReaderBMP
extends MetaReaderAbstract {
    public static final int \u00d4o0000 = 512;

    public MetaReaderBMP(FSILogger fSILogger, ImageFormat imageFormat) {
        super(fSILogger, imageFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanImage(PathCached pathCached, boolean bl) throws IOException {
        block30: {
            this.\u00d300000 = new FSIMetaData(pathCached);
            try (LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream(Files.newInputStream(pathCached.getPath(), new OpenOption[0]));){
                byte[] byArray = new byte[2];
                littleEndianDataInputStream.read(byArray);
                if (byArray[0] != 66 || byArray[1] != 77) {
                    this.\u00f800000 |= 4;
                }
                if (this.\u00f800000 != 0) break block30;
                FSISubImageMetaData fSISubImageMetaData = this.\u00d300000.createImage(0);
                try {
                    littleEndianDataInputStream.skip(12L);
                    int n = littleEndianDataInputStream.readInt();
                    if (n == 12) {
                        fSISubImageMetaData.\u00d5O0000 = littleEndianDataInputStream.readShort();
                        fSISubImageMetaData.\u00d4O0000 = Math.abs(littleEndianDataInputStream.readShort());
                    } else {
                        fSISubImageMetaData.\u00d5O0000 = littleEndianDataInputStream.readInt();
                        fSISubImageMetaData.\u00d4O0000 = Math.abs(littleEndianDataInputStream.readInt());
                    }
                    littleEndianDataInputStream.skip(2L);
                    short s = littleEndianDataInputStream.readShort();
                    this.\u00d300000.\u00f600000 = this.getColorspace(s);
                    fSISubImageMetaData.float = this.getBitsPerSamples(s);
                    fSISubImageMetaData.OO0000 = this.getSamplesPerPixel(s);
                    this.\u00f800000 |= this.validateMetaData(fSISubImageMetaData);
                    if (this.\u00f800000 == 0) {
                        this.\u00d300000.addImage(fSISubImageMetaData);
                    }
                }
                catch (IOException iOException) {
                    this.\u00f800000 |= 4;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                this.while.logException(noSuchFileException, 3801, this.\u00d300000.o00000);
                this.\u00f800000 |= 1;
            }
            catch (IOException iOException) {
                this.while.logException(iOException, 3802, this.\u00d300000.o00000);
                this.\u00f800000 |= 2;
            }
            catch (Exception exception) {
                this.while.logException(exception, 3850, this.\u00d300000.o00000);
                this.\u00f800000 |= 4;
            }
            catch (Error error) {
                this.while.logError(error, 3850, this.\u00d300000.o00000);
                this.\u00f800000 |= 4;
            }
            finally {
                if (this.\u00f800000 != 0) {
                    this.close();
                }
            }
        }
    }

    private void close() {
    }

    private ColorType getColorspace(int n) {
        ColorType colorType = ColorType.\u00f500000;
        if (n == 1) {
            colorType = ColorType.OO0000;
        } else if (n == 4 || n == 8) {
            colorType = ColorType.\u00f800000;
        } else if (n == 15) {
            colorType = ColorType.\u00d800000;
        } else if (n == 16) {
            colorType = ColorType.return;
        } else if (n == 24 || n == 32) {
            colorType = ColorType.new;
        }
        return colorType;
    }

    private int getBitsPerSamples(int n) {
        int n2 = 1;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                n2 = -1;
                break;
            }
            case 24: 
            case 32: {
                n2 = 8;
            }
        }
        return n2;
    }

    private int getSamplesPerPixel(int n) {
        int n2 = 1;
        switch (n) {
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                n2 = -1;
                break;
            }
            case 24: 
            case 32: {
                n2 = 3;
            }
        }
        return n2;
    }
}

