/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.metareader;

import com.neptunelabs.fsiserver.framework.helpers.Bits;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.io.ReaderAbstract;
import com.neptunelabs.fsiserver.framework.io.ReaderChannel;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import com.neptunelabs.fsiserver.imagereader.converter.ColorType;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.imagereader.exif.ExifBuilder;
import com.neptunelabs.fsiserver.imagereader.exif.ExifIDFRawTag;
import com.neptunelabs.fsiserver.imagereader.helper.Decode8BIM;
import com.neptunelabs.fsiserver.imagereader.helper.Rational;
import com.neptunelabs.fsiserver.imagereader.helper.TIFFRawTag;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderAbstract;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;

public final class MetaReaderTIFF
extends MetaReaderAbstract {
    public static final int \u00d3o0000 = 256;
    private static final int \u00f4O0000 = 1;
    private static final int \u00d8O0000 = 5;
    private static final int nullsuper = 7;
    private static final int Oo0000 = 8;
    private static final int oo0000 = 32946;
    private boolean \u00f5O0000 = false;
    private ReaderAbstract \u00f8O0000;
    private long Stringsuper = -1L;
    private boolean thissuper = false;

    public MetaReaderTIFF(FSILogger fSILogger, ImageFormat imageFormat) {
        super(fSILogger, imageFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanImage(PathCached pathCached, boolean bl) throws IOException {
        this.\u00d300000 = new FSIMetaData(pathCached);
        this.\u00f5O0000 = bl;
        try {
            this.\u00f8O0000 = new ReaderChannel(pathCached.getPath(), StandardOpenOption.READ);
        }
        catch (NoSuchFileException noSuchFileException) {
            this.while.logException(noSuchFileException, 3801, pathCached);
            this.\u00f800000 |= 1;
        }
        catch (IOException iOException) {
            this.while.logException(iOException, 3802, pathCached);
            this.\u00f800000 |= 2;
        }
        finally {
            if (this.\u00f800000 != 0) {
                this.close();
            }
        }
        if (this.\u00f800000 == 0 && this.\u00f8O0000 != null) {
            try {
                byte[] byArray = new byte[4];
                this.\u00f8O0000.read(byArray);
                this.parseHeader(byArray);
                this.Stringsuper = this.\u00f8O0000.readUInt();
                this.\u00d300000.for = ByteOrder.BIG_ENDIAN;
                int n = 0;
                while (this.\u00f800000 == 0 && this.Stringsuper >= 8L) {
                    FSISubImageMetaData fSISubImageMetaData = this.\u00d300000.createImage(n++);
                    long l = this.scanIDF(fSISubImageMetaData);
                    if (fSISubImageMetaData.oo0000 == null) {
                        Object object;
                        ExifBuilder exifBuilder = new ExifBuilder();
                        if (fSISubImageMetaData.\u00f500000 != null) {
                            object = fSISubImageMetaData.\u00f500000.getBytes(FileOperations.o00000);
                            ExifIDFRawTag exifIDFRawTag = new ExifIDFRawTag();
                            exifIDFRawTag.\u00d200000 = 305;
                            exifIDFRawTag.\u00d300000 = 2;
                            exifIDFRawTag.o00000 = fSISubImageMetaData.\u00f500000.length();
                            exifBuilder.addTag(exifIDFRawTag, object);
                        }
                        if (fSISubImageMetaData.\u00d400000 != -1) {
                            object = new ExifIDFRawTag();
                            object.\u00d200000 = 274;
                            object.\u00d300000 = 3;
                            object.o00000 = 1;
                            object.String = fSISubImageMetaData.\u00d400000;
                            exifBuilder.addTag((ExifIDFRawTag)object, null);
                        }
                        try {
                            fSISubImageMetaData.oo0000 = exifBuilder.evaluate(false);
                        }
                        catch (IOException iOException) {
                            this.\u00f800000 |= 2;
                        }
                    }
                    if (fSISubImageMetaData.\u00f500000 != null && fSISubImageMetaData.\u00f500000.equals("MRT Converter")) {
                        fSISubImageMetaData.\u00d6O0000 = null;
                    }
                    if (fSISubImageMetaData.\u00d2O0000 != null && fSISubImageMetaData.supersuper != null) {
                        fSISubImageMetaData.\u00f5O0000 = this.getPixelAspectRatio(fSISubImageMetaData.\u00d2O0000, fSISubImageMetaData.supersuper);
                    }
                    fSISubImageMetaData.\u00f400000 = this.isTiled(fSISubImageMetaData.o00000, fSISubImageMetaData.\u00f600000);
                    if (fSISubImageMetaData.public != null) {
                        int n2;
                        int n3;
                        int n4 = fSISubImageMetaData.public.length;
                        if (n4 > 0) {
                            this.\u00d300000.private = n4;
                        }
                        if (this.\u00d300000.private < 0 || this.\u00d300000.private > 64) {
                            this.\u00d300000.private = 0;
                        }
                        if (fSISubImageMetaData.public != null) {
                            for (int i = 0; i < fSISubImageMetaData.public.length; ++i) {
                                if (fSISubImageMetaData.public[i] == 1) {
                                    this.\u00d300000.\u00d3O0000 = fSISubImageMetaData.OO0000 - fSISubImageMetaData.public.length + i;
                                    this.\u00d300000.\u00d800000 = true;
                                    this.\u00d300000.\u00f500000 = true;
                                    break;
                                }
                                if (fSISubImageMetaData.public[i] != 0 && fSISubImageMetaData.public[i] != 2) continue;
                                this.\u00d300000.\u00d3O0000 = fSISubImageMetaData.OO0000 - fSISubImageMetaData.public.length + i;
                                this.\u00d300000.\u00d800000 = false;
                                this.\u00d300000.\u00f500000 = true;
                                break;
                            }
                        }
                        if (this.\u00d300000.\u00f600000 == ColorType.if || this.\u00d300000.\u00f600000 == ColorType.\u00d400000) {
                            if (fSISubImageMetaData.OO0000 - this.\u00d300000.private > 1) {
                                int[] nArray = fSISubImageMetaData.public;
                                int n5 = nArray.length;
                                for (n3 = 0; n3 < n5; ++n3) {
                                    n2 = nArray[n3];
                                    if (n2 != 1) continue;
                                    this.\u00d300000.\u00f500000 = true;
                                    break;
                                }
                            }
                        } else if (this.\u00d300000.\u00f600000 == ColorType.\u00d800000 || this.\u00d300000.\u00f600000 == ColorType.return || this.\u00d300000.\u00f600000 == ColorType.new) {
                            if (fSISubImageMetaData.OO0000 - this.\u00d300000.private > 3) {
                                int[] nArray = fSISubImageMetaData.public;
                                int n6 = nArray.length;
                                for (n3 = 0; n3 < n6; ++n3) {
                                    n2 = nArray[n3];
                                    if (n2 != 1) continue;
                                    this.\u00d300000.\u00f500000 = true;
                                    break;
                                }
                            }
                        } else if (this.\u00d300000.\u00f600000 == ColorType.\u00d300000) {
                            if (fSISubImageMetaData.OO0000 - this.\u00d300000.private > 4) {
                                int[] nArray = fSISubImageMetaData.public;
                                int n7 = nArray.length;
                                for (n3 = 0; n3 < n7; ++n3) {
                                    n2 = nArray[n3];
                                    if (n2 != 1) continue;
                                    this.\u00d300000.\u00f500000 = true;
                                    break;
                                }
                            }
                        } else {
                            this.\u00d300000.\u00f500000 = false;
                        }
                    } else {
                        if (this.\u00d300000.\u00f600000 == ColorType.if || this.\u00d300000.\u00f600000 == ColorType.\u00d400000) {
                            if (fSISubImageMetaData.OO0000 > 1) {
                                this.\u00d300000.private = fSISubImageMetaData.OO0000 - 1;
                            }
                        } else if (this.\u00d300000.\u00f600000 == ColorType.\u00d800000 || this.\u00d300000.\u00f600000 == ColorType.return || this.\u00d300000.\u00f600000 == ColorType.new) {
                            if (fSISubImageMetaData.OO0000 > 3) {
                                this.\u00d300000.private = fSISubImageMetaData.OO0000 - 3;
                            }
                        } else if (this.\u00d300000.\u00f600000 == ColorType.\u00d300000 && fSISubImageMetaData.OO0000 > 4) {
                            this.\u00d300000.private = fSISubImageMetaData.OO0000 - 4;
                        }
                        if (this.\u00d300000.private < 0 || this.\u00d300000.private > 64) {
                            this.\u00d300000.private = 0;
                        }
                    }
                    this.\u00f800000 |= this.validateMetaData(fSISubImageMetaData);
                    if (this.\u00f800000 == 0) {
                        this.\u00d300000.addImage(fSISubImageMetaData);
                    }
                    if (l != 0L && this.\u00f800000 == 0 && this.Stringsuper != l) {
                        this.Stringsuper = l;
                        continue;
                    }
                    break;
                }
            }
            catch (Error error) {
                this.while.logError(error, 3850, this.\u00d300000.o00000);
                this.\u00f800000 |= 4;
            }
            catch (NoSuchFileException noSuchFileException) {
                this.while.logException(noSuchFileException, 3801, this.\u00d300000.o00000);
                this.\u00f800000 |= 1;
            }
            catch (IOException iOException) {
                this.while.logException(iOException, 3850, this.\u00d300000.o00000);
                this.\u00f800000 |= 2;
            }
            catch (Exception exception) {
                this.while.logException(exception, 3850, this.\u00d300000.o00000);
                this.\u00f800000 |= 4;
            }
            finally {
                this.close();
            }
        }
    }

    private ColorType getColorType(int n) {
        ColorType colorType = ColorType.\u00f500000;
        switch (n) {
            case 0: {
                colorType = ColorType.\u00d400000;
                break;
            }
            case 1: {
                colorType = ColorType.if;
                break;
            }
            case 2: {
                colorType = ColorType.new;
                break;
            }
            case 3: {
                colorType = ColorType.\u00f800000;
                break;
            }
            case 5: {
                colorType = ColorType.\u00d300000;
                break;
            }
            case 6: {
                colorType = ColorType.new;
                break;
            }
            case 8: {
                colorType = ColorType.o00000;
                break;
            }
            case 9: {
                colorType = ColorType.o00000;
                break;
            }
            case 10: {
                colorType = ColorType.o00000;
            }
        }
        return colorType;
    }

    private float getPixelAspectRatio(Rational rational, Rational rational2) {
        if (rational != null && rational2 != null) {
            return (float)((double)rational.new * (double)rational2.o00000) / (float)(rational.o00000 * rational2.new);
        }
        return -1.0f;
    }

    private boolean isStriped(int n, int n2) {
        boolean bl = false;
        if (n == -1 && n2 != -1) {
            bl = true;
        }
        return bl;
    }

    private boolean isTiled(int n, int n2) {
        return !this.isStriped(n, n2);
    }

    private void close() {
        block3: {
            try {
                if (this.\u00f8O0000 != null) {
                    this.\u00f8O0000.close();
                }
            }
            catch (IOException iOException) {
                if (this.while == null) break block3;
                this.while.logException(iOException, 3899, iOException.getLocalizedMessage());
            }
        }
    }

    private long evaluateTag(FSISubImageMetaData fSISubImageMetaData, int n, int n2, long l, long l2) throws IOException {
        long l3 = 0L;
        boolean bl = false;
        switch (n) {
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 262: 
            case 274: 
            case 277: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 296: 
            case 305: 
            case 322: 
            case 323: 
            case 330: 
            case 338: {
                bl = true;
                break;
            }
            case 700: 
            case 33723: 
            case 34377: 
            case 34665: 
            case 34675: {
                if (!this.\u00f5O0000) break;
                bl = true;
            }
        }
        if (bl) {
            byte[] byArray;
            long l4 = -1L;
            float f = -1.0f;
            double d = -1.0;
            Rational rational = null;
            byte[] byArray2 = null;
            long[] lArray = null;
            String string = null;
            if (n2 == 3 || n2 == 8) {
                l4 = l == 1L ? (this.thissuper ? l2 & 0xFFFFL : (long)(((int)(l2 >> 24) & 0xFF) * 256 + ((int)(l2 >> 16) & 0xFF))) : (long)this.getTagValueShort(l2, l);
            } else if (n2 == 4 || n2 == 9 || n2 == 13) {
                if (l == 1L) {
                    l4 = l2;
                } else {
                    lArray = this.getTagValueLong(l2, l);
                }
            } else if (n2 == 11) {
                f = this.getTagValueFloat((int)l2, l);
            } else if (n2 == 12) {
                d = this.getTagValueDouble(l2, l);
            } else if (n2 == 5 || n2 == 10) {
                rational = this.getTagValueRational(l2, l);
            } else if (n2 == 1 || n2 == 7) {
                byArray2 = this.getTagValueBytes(l2, l);
            } else if (n2 == 2) {
                byArray = this.getTagValueBytes(l2, l);
                string = new String(byArray, FileOperations.o00000);
                if ((string = string.trim()).length() == 0) {
                    string = null;
                }
            }
            switch (n) {
                case 256: {
                    fSISubImageMetaData.\u00d5O0000 = (int)l4;
                    break;
                }
                case 257: {
                    fSISubImageMetaData.\u00d4O0000 = (int)l4;
                    break;
                }
                case 258: {
                    fSISubImageMetaData.float = (int)l4;
                    break;
                }
                case 259: {
                    fSISubImageMetaData.classsuper = (int)l4;
                    break;
                }
                case 274: {
                    fSISubImageMetaData.\u00d400000 = (int)l4;
                    break;
                }
                case 262: {
                    fSISubImageMetaData.\u00f6O0000 = (int)l4;
                    this.\u00d300000.\u00f600000 = this.getColorType(fSISubImageMetaData.\u00f6O0000);
                    break;
                }
                case 277: {
                    fSISubImageMetaData.OO0000 = (int)l4;
                    break;
                }
                case 338: {
                    fSISubImageMetaData.public = this.getTagValueShortArray(l2, l);
                    break;
                }
                case 284: {
                    fSISubImageMetaData.\u00d600000 = (int)l4;
                    break;
                }
                case 278: {
                    fSISubImageMetaData.\u00f600000 = (int)l4;
                    break;
                }
                case 322: {
                    fSISubImageMetaData.o00000 = (int)l4;
                    break;
                }
                case 323: {
                    fSISubImageMetaData.\u00f600000 = (int)l4;
                    break;
                }
                case 296: {
                    fSISubImageMetaData.Object = (int)l4;
                    break;
                }
                case 282: {
                    fSISubImageMetaData.\u00d2O0000 = rational;
                    break;
                }
                case 283: {
                    fSISubImageMetaData.supersuper = rational;
                    break;
                }
                case 700: {
                    fSISubImageMetaData.\u00d200000 = byArray2;
                    break;
                }
                case 305: {
                    if (string == null) break;
                    fSISubImageMetaData.\u00f500000 = string;
                    break;
                }
                case 33723: {
                    if (lArray != null) {
                        fSISubImageMetaData.Oo0000 = this.longsToBytes(lArray, this.\u00f8O0000.getByteOrder());
                        break;
                    }
                    if (byArray2 != null) {
                        fSISubImageMetaData.Oo0000 = byArray2;
                        break;
                    }
                    if (l4 == -1L) break;
                    this.\u00f8O0000.seek(l4);
                    fSISubImageMetaData.Oo0000 = this.intToBytes((int)this.\u00f8O0000.readUInt(), this.\u00f8O0000.getByteOrder());
                    break;
                }
                case 34377: {
                    byArray = null;
                    if (byArray2 != null) {
                        byArray = byArray2;
                    } else if (lArray != null) {
                        byArray = this.longsToBytes(lArray, this.\u00f8O0000.getByteOrder());
                    } else if (l4 != -1L) {
                        this.\u00f8O0000.seek(l4);
                        byArray = this.intToBytes((int)this.\u00f8O0000.readUInt(), this.\u00f8O0000.getByteOrder());
                    }
                    if (byArray == null) break;
                    int n3 = this.is8BIM(byArray);
                    if (n3 != -1) {
                        byte[] byArray3;
                        Decode8BIM decode8BIM = new Decode8BIM(byArray);
                        byte[] byArray4 = decode8BIM.getResource("EXIF");
                        if (byArray4 != null) {
                            fSISubImageMetaData.oo0000 = byArray4;
                        }
                        if ((byArray3 = decode8BIM.getResource("XMP")) != null) {
                            fSISubImageMetaData.\u00d200000 = byArray3;
                        }
                        if (decode8BIM.getPathCount() > 0) {
                            fSISubImageMetaData.\u00d500000 = decode8BIM.getPaths();
                        }
                        fSISubImageMetaData.oO0000 = decode8BIM.getAlphaNames();
                        break;
                    }
                    n3 = this.isEXIF(byArray);
                    if (n3 == 0) {
                        int n4 = byArray.length - n3;
                        fSISubImageMetaData.oo0000 = new byte[n4];
                        System.arraycopy(byArray, n3, fSISubImageMetaData.oo0000, 0, n4);
                        break;
                    }
                    n3 = this.isIPTC(byArray);
                    if (n3 != 0) break;
                    int n5 = byArray.length - n3;
                    fSISubImageMetaData.Oo0000 = new byte[n5];
                    System.arraycopy(byArray, n3, fSISubImageMetaData.Oo0000, 0, n5);
                    break;
                }
                case 34665: {
                    fSISubImageMetaData.oo0000 = this.scanExifIDF(l4);
                    break;
                }
                case 34675: {
                    fSISubImageMetaData.\u00d6O0000 = new ICCProfileWrap(byArray2);
                    break;
                }
                case 330: {
                    l3 = l4;
                }
            }
        }
        return l3;
    }

    private long[] getTagValueLong(long l, long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("tagvaluecount > 2147483647");
        }
        long[] lArray = new long[(int)l2];
        if (l2 == 1L) {
            lArray[0] = (int)l;
        } else {
            this.\u00f8O0000.seek(l);
            int n = 0;
            while ((long)n < l2) {
                lArray[n] = this.\u00f8O0000.readUInt();
                ++n;
            }
        }
        return lArray;
    }

    private float getTagValueFloat(long l, long l2) throws IOException {
        float f = -1.0f;
        if (l2 <= 2L) {
            return Float.intBitsToFloat(this.thissuper ? (int)l : Bits.swap((int)l));
        }
        this.\u00f8O0000.seek(l);
        f = this.\u00f8O0000.readFloat();
        return f;
    }

    private double getTagValueDouble(long l, long l2) throws IOException {
        double d = -1.0;
        if (l2 == 1L) {
            return Double.longBitsToDouble(this.thissuper ? l : Bits.swap(l));
        }
        this.\u00f8O0000.seek(l);
        d = this.\u00f8O0000.readDouble();
        return d;
    }

    private Rational getTagValueRational(long l, long l2) throws IOException {
        this.\u00f8O0000.seek(l);
        long l3 = this.\u00f8O0000.readUInt();
        long l4 = this.\u00f8O0000.readUInt();
        return new Rational(l3, l4);
    }

    private int getTagValueShort(long l, long l2) throws IOException {
        int n = -1;
        if (l2 <= 2L) {
            n = this.thissuper ? (int)l : ((int)(l >> 24) & 0xFF) * 256 + ((int)(l >> 16) & 0xFF);
        } else {
            try {
                this.\u00f8O0000.seek(l);
                n = this.\u00f8O0000.readUShort();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.while != null) {
                    this.while.logException(illegalArgumentException, 3811, this.\u00d300000.o00000, illegalArgumentException.getLocalizedMessage());
                }
                this.\u00f800000 |= 4;
            }
        }
        return n;
    }

    private int[] getTagValueShortArray(long l, long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("tagvaluecount > 2147483647");
        }
        int[] nArray = new int[(int)l2];
        if (l2 > 2L) {
            this.\u00f8O0000.seek(l);
            int n = 0;
            while ((long)n < l2) {
                nArray[n] = this.\u00f8O0000.readUShort();
                ++n;
            }
        } else if (this.thissuper) {
            int n = 0;
            int n2 = 0;
            while ((long)n < l2) {
                nArray[n] = (int)(l >> n2 & 0xFFFFL);
                ++n;
                n2 += 16;
            }
        } else {
            int n = 0;
            int n3 = 0;
            while ((long)n < l2) {
                nArray[(int)l2 - n - 1] = (int)(l >> n3 & 0xFFFFL);
                ++n;
                n3 += 16;
            }
        }
        return nArray;
    }

    private byte[] getTagValueBytes(long l, long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("tagvaluecount > 2147483647");
        }
        byte[] byArray = new byte[(int)l2];
        if (l2 <= 4L) {
            int n = 0;
            while ((long)n < l2) {
                byArray[n] = (byte)(l >> 8 * n & 0xFFL);
                ++n;
            }
        } else {
            this.\u00f8O0000.seek(l);
            this.\u00f8O0000.read(byArray);
        }
        return byArray;
    }

    private byte[] longsToBytes(long[] lArray, ByteOrder byteOrder) {
        byte[] byArray = new byte[lArray.length * 4];
        int n = 0;
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            for (long l : lArray) {
                byArray[n++] = (byte)(l >> 24);
                byArray[n++] = (byte)(l >> 16 & 0xFFL);
                byArray[n++] = (byte)(l >> 8 & 0xFFL);
                byArray[n++] = (byte)(l & 0xFFL);
            }
        } else {
            for (long l : lArray) {
                byArray[n++] = (byte)(l & 0xFFL);
                byArray[n++] = (byte)(l >> 8 & 0xFFL);
                byArray[n++] = (byte)(l >> 16 & 0xFFL);
                byArray[n++] = (byte)(l >> 24);
            }
        }
        return byArray;
    }

    private byte[] intToBytes(int n, ByteOrder byteOrder) {
        byte[] byArray = new byte[4];
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[0] = (byte)(n >> 24);
            byArray[1] = (byte)(n >> 16 & 0xFF);
            byArray[2] = (byte)(n >> 8 & 0xFF);
            byArray[3] = (byte)(n & 0xFF);
        } else {
            byArray[0] = (byte)(n & 0xFF);
            byArray[1] = (byte)(n >> 8 & 0xFF);
            byArray[2] = (byte)(n >> 16 & 0xFF);
            byArray[3] = (byte)(n >> 24);
        }
        return byArray;
    }

    private void parseHeader(byte[] byArray) {
        boolean bl = false;
        if (byArray[0] == 73 && byArray[1] == 73) {
            this.thissuper = true;
            this.\u00f8O0000.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else if (byArray[0] == 77 && byArray[1] == 77) {
            this.thissuper = false;
            this.\u00f8O0000.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else {
            bl = true;
        }
        if (this.thissuper && byArray[2] != 42 && byArray[3] != 0) {
            bl = true;
        } else if (!this.thissuper && byArray[2] != 0 && byArray[3] != 42) {
            bl = true;
        }
        if (bl) {
            this.\u00f800000 |= 4;
            if (this.while != null) {
                this.while.log(3804, "TIFF", this.\u00d300000.o00000);
            }
        }
    }

    private long scanIDF(FSISubImageMetaData fSISubImageMetaData) {
        long l = 0L;
        try {
            this.\u00f8O0000.seek(this.Stringsuper);
            int n = this.\u00f8O0000.readUShort();
            if (n > 0) {
                int n2;
                TIFFRawTag[] tIFFRawTagArray = new TIFFRawTag[n];
                for (n2 = 0; n2 < n; ++n2) {
                    tIFFRawTagArray[n2] = new TIFFRawTag();
                    tIFFRawTagArray[n2].\u00d200000 = this.\u00f8O0000.readUShort();
                    tIFFRawTagArray[n2].\u00d300000 = this.\u00f8O0000.readUShort();
                    tIFFRawTagArray[n2].super = this.\u00f8O0000.readUInt();
                    tIFFRawTagArray[n2].\u00d400000 = this.\u00f8O0000.readUInt();
                }
                l = this.\u00f8O0000.readUInt();
                for (n2 = 0; n2 < n; ++n2) {
                    long l2 = this.evaluateTag(fSISubImageMetaData, tIFFRawTagArray[n2].\u00d200000, tIFFRawTagArray[n2].\u00d300000, tIFFRawTagArray[n2].super, tIFFRawTagArray[n2].\u00d400000);
                    if (l2 == 0L) continue;
                    l = l2;
                }
            } else {
                if (this.while != null) {
                    this.while.log(3850, this.\u00d300000.o00000);
                }
                this.\u00f800000 |= 4;
            }
        }
        catch (Error error) {
            this.while.logError(error, 3834, this.\u00d300000.o00000);
            this.\u00f800000 |= 4;
        }
        catch (Exception exception) {
            this.while.logException(exception, 3850, this.\u00d300000.o00000);
            this.\u00f800000 |= 4;
        }
        return l;
    }

    private byte[] scanExifIDF(long l) {
        byte[] byArray = null;
        try {
            this.\u00f8O0000.seek(l);
            int n = this.\u00f8O0000.readUShort();
            long l2 = -1L;
            int n2 = 0;
            if (n > 0 && n < 2000) {
                ExifBuilder exifBuilder = new ExifBuilder();
                ExifIDFRawTag[] exifIDFRawTagArray = new ExifIDFRawTag[n];
                while (l2 != 0L) {
                    int n3;
                    for (n3 = n2; n3 < n; ++n3) {
                        exifIDFRawTagArray[n3] = new ExifIDFRawTag();
                        exifIDFRawTagArray[n3].\u00d200000 = this.\u00f8O0000.readUShort();
                        exifIDFRawTagArray[n3].\u00d300000 = this.\u00f8O0000.readUShort();
                        exifIDFRawTagArray[n3].o00000 = this.\u00f8O0000.readInt();
                        exifIDFRawTagArray[n3].String = this.\u00f8O0000.readInt();
                    }
                    l2 = 0L;
                    for (n3 = n2; n3 < n; ++n3) {
                        this.evaluateExifTag(exifBuilder, exifIDFRawTagArray[n3]);
                    }
                }
                byArray = exifBuilder.evaluate(false);
            } else if (n != 0 && this.while != null) {
                this.while.log(3862, this.\u00d300000.o00000);
            }
        }
        catch (Exception exception) {
            if (this.while != null) {
                this.while.logException(exception, 3850, this.\u00d300000.o00000);
            }
            this.\u00f800000 |= 4;
        }
        return byArray;
    }

    private void evaluateExifTag(ExifBuilder exifBuilder, ExifIDFRawTag exifIDFRawTag) throws IOException {
        if (exifIDFRawTag.\u00d300000 == 3 || exifIDFRawTag.\u00d300000 == 8) {
            int n = this.getTagValueShort(exifIDFRawTag.String, exifIDFRawTag.o00000);
            exifIDFRawTag.o00000 = 1;
            exifIDFRawTag.String = n;
            exifBuilder.addTag(exifIDFRawTag, null);
        } else if (exifIDFRawTag.\u00d300000 == 4 || exifIDFRawTag.\u00d300000 == 9 || exifIDFRawTag.\u00d300000 == 13) {
            long[] lArray = null;
            if (exifIDFRawTag.o00000 != 1) {
                lArray = this.getTagValueLong(exifIDFRawTag.String, exifIDFRawTag.o00000);
            }
            exifBuilder.addTag(exifIDFRawTag, lArray);
        } else if (exifIDFRawTag.\u00d300000 == 11) {
            float f = this.getTagValueFloat(exifIDFRawTag.String, exifIDFRawTag.o00000);
            exifIDFRawTag.o00000 = 0;
            exifIDFRawTag.String = Float.floatToIntBits(f);
            exifBuilder.addTag(exifIDFRawTag, null);
        } else if (exifIDFRawTag.\u00d300000 == 12) {
            double d = this.getTagValueDouble(exifIDFRawTag.String, exifIDFRawTag.o00000);
            exifIDFRawTag.o00000 = 1;
            exifIDFRawTag.String = 0L;
            Long l = Double.doubleToLongBits(d);
            exifBuilder.addTag(exifIDFRawTag, l);
        } else if (exifIDFRawTag.\u00d300000 == 5 || exifIDFRawTag.\u00d300000 == 10) {
            Rational rational = this.getTagValueRational(exifIDFRawTag.String, exifIDFRawTag.o00000);
            exifBuilder.addTag(exifIDFRawTag, rational);
        } else if (exifIDFRawTag.\u00d300000 == 1 || exifIDFRawTag.\u00d300000 == 2) {
            byte[] byArray = null;
            if (exifIDFRawTag.o00000 > 4) {
                byArray = this.getTagValueBytes(exifIDFRawTag.String, exifIDFRawTag.o00000);
            }
            exifBuilder.addTag(exifIDFRawTag, byArray);
        }
    }

    private float resolution(Rational rational, int n) {
        float f = -1.0f;
        if (rational != null && n != 1) {
            long l = rational.o00000;
            long l2 = rational.new;
            if (n == 2) {
                l *= 100L;
                l2 *= 254L;
            }
            f = (float)(10.0 * (double)l2 / (double)l);
            if (n == 2) {
                f = (float)Math.floor(25.4f / f);
            }
        }
        return f;
    }
}

