/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.filters;

import com.neptunelabs.fsiserver.framework.cache.CacheKey;
import com.neptunelabs.fsiserver.framework.cache.CacheLoad;
import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.cache.CacheType;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.cache.CacheableHttpServletResponse;
import com.yworks.util.annotation.Obfuscation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Obfuscation
public class RequestFilter
implements Filter {
    private boolean cacheResponses = false;
    private ServletContext context;
    private SystemMonitor sysMon = null;
    private CacheManager cacheManager = null;
    private UserAuthenticationInterface authenticationInterface = null;
    private final AtomicInteger concurrentRequests = new AtomicInteger(0);
    private static final int CHUNK_LENGTH = 8192;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        this.sysMon = (SystemMonitor)this.context.getAttribute("com.neptunelabs.fsiserver.SystemMonitor");
        this.cacheManager = (CacheManager)this.context.getAttribute("com.neptunelabs.fsiserver.CacheManager");
        this.authenticationInterface = (UserAuthenticationInterface)this.context.getAttribute("com.neptunelabs.fsiserver.AuthenticationInterface");
        if (this.cacheManager != null) {
            this.cacheResponses = this.cacheManager.cacheReponses();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        long l = System.currentTimeMillis();
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        try {
            this.sysMon.setConcurrentRequests(this.concurrentRequests.incrementAndGet());
            if (servletRequest.getCharacterEncoding() == null) {
                servletRequest.setCharacterEncoding("UTF-8");
            }
            Parameters parameters = new Parameters(httpServletRequest);
            httpServletRequest.setAttribute("parameters", (Object)parameters);
            CacheableHttpServletResponse cacheableHttpServletResponse = null;
            boolean bl = false;
            if (this.cacheResponses) {
                CacheKey cacheKey;
                Object object;
                Object object2;
                String string = httpServletRequest.getParameter("source");
                if (string != null) {
                    object2 = httpServletRequest.getQueryString();
                    if (object2 != null) {
                        String string2;
                        String string3;
                        object = httpServletRequest.getSession(false);
                        if (object != null) {
                            string3 = object.getId();
                            string2 = this.authenticationInterface.getUser(string3);
                        } else {
                            string3 = null;
                            string2 = null;
                        }
                        cacheKey = CacheKey.calculateRequestCacheKey(string, parameters, string3, string2, httpServletRequest.getMethod());
                    } else {
                        cacheKey = null;
                    }
                } else {
                    cacheKey = null;
                }
                if (cacheKey != null && (object2 = this.cacheManager.get(cacheKey, CacheType.new)) != null) {
                    cacheableHttpServletResponse = ((CacheLoad)object2).Object != null ? (CacheableHttpServletResponse)((CacheLoad)object2).Object : CacheableHttpServletResponse.unpack(((CacheLoad)object2).\u00d200000, httpServletResponse);
                }
                object2 = httpServletRequest.getHeaderNames();
                object = new HashSet();
                while (object2.hasMoreElements()) {
                    object.add(object2.nextElement());
                }
                if (cacheableHttpServletResponse != null && cacheableHttpServletResponse.getStatus() == 304 && !object.contains("If-Modified-Since") && !object.contains("If-None-Match")) {
                    cacheableHttpServletResponse = null;
                }
                if (object.contains("If-Modified-Since")) {
                    long l2;
                    try {
                        l2 = httpServletRequest.getDateHeader("If-Modified-Since");
                        if (l2 > 0L) {
                            l2 = l2 / 1000L * 1000L;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        l2 = 0L;
                    }
                    if (cacheableHttpServletResponse != null && l2 > 0L) {
                        if (cacheableHttpServletResponse.getLastModified() != l2) {
                            cacheableHttpServletResponse = null;
                        } else {
                            bl = true;
                        }
                    }
                }
                String string4 = httpServletRequest.getHeader("If-None-Match");
                if (cacheableHttpServletResponse != null && string4 != null && cacheableHttpServletResponse.getETag() != null) {
                    if (!string4.equals(cacheableHttpServletResponse.getETag().getStrongTag(cacheableHttpServletResponse.getAssetURLHash(), cacheableHttpServletResponse.getQueryHash()))) {
                        cacheableHttpServletResponse = null;
                    } else {
                        bl = true;
                    }
                }
            }
            if (cacheableHttpServletResponse != null) {
                this.sysMon.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_CACHE);
                if (bl) {
                    this.transferCachedHeader(cacheableHttpServletResponse, (HttpServletResponse)servletResponse, false);
                    httpServletResponse.sendError(304);
                    this.sysMon.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_304);
                } else {
                    this.transferCachedHeader(cacheableHttpServletResponse, (HttpServletResponse)servletResponse, true);
                    boolean bl2 = httpServletRequest.getMethod() != null && httpServletRequest.getMethod().equals("HEAD");
                    long l3 = System.currentTimeMillis() - l;
                    this.sysMon.setTTFB(l3);
                    int n = this.transferCachedData(cacheableHttpServletResponse, (HttpServletResponse)servletResponse, bl2);
                    this.sysMon.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_200);
                    this.sysMon.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_CACHE, n);
                }
            } else {
                httpServletRequest.getRequestDispatcher(httpServletRequest.getServletPath()).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            this.sysMon.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_ALL);
            this.sysMon.setTTLB(System.currentTimeMillis() - l);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            httpServletResponse.setStatus(400);
        }
        finally {
            if (this.sysMon != null) {
                this.sysMon.setConcurrentRequests(this.concurrentRequests.decrementAndGet());
            }
        }
    }

    public void destroy() {
    }

    private int transferCachedData(CacheableHttpServletResponse cacheableHttpServletResponse, HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        int n = 0;
        if (!bl && cacheableHttpServletResponse.getContent() != null) {
            try (ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();){
                byte[] byArray = cacheableHttpServletResponse.getContent();
                int n2 = (int)Math.ceil((float)byArray.length / 8192.0f);
                for (int i = 0; i < n2; ++i) {
                    int n3 = i + 1 == n2 ? byArray.length - i * 8192 : 8192;
                    try {
                        servletOutputStream.write(byArray, i * 8192, n3);
                    }
                    catch (IOException iOException) {
                        break;
                    }
                    n += n3;
                }
            }
        }
        return n;
    }

    private void transferCachedHeader(CacheableHttpServletResponse cacheableHttpServletResponse, HttpServletResponse httpServletResponse, boolean bl) {
        if (cacheableHttpServletResponse.getDateHeaderMap().size() > 0) {
            for (Map.Entry<String, Long> entry : cacheableHttpServletResponse.getDateHeaderMap().entrySet()) {
                httpServletResponse.setDateHeader(entry.getKey(), entry.getValue().longValue());
            }
        }
        if (cacheableHttpServletResponse.getHeaderMap().size() > 0) {
            for (Map.Entry<String, Object> entry : cacheableHttpServletResponse.getHeaderMap().entrySet()) {
                String string = entry.getKey();
                if (string.startsWith("X-TTFB")) continue;
                httpServletResponse.setHeader(string, (String)entry.getValue());
            }
        }
        if (bl && cacheableHttpServletResponse.getContentLength() > 0) {
            httpServletResponse.setContentLength(cacheableHttpServletResponse.getContentLength());
        }
        if (cacheableHttpServletResponse.getContentType() != null) {
            httpServletResponse.setContentType(cacheableHttpServletResponse.getContentType());
        }
        if (cacheableHttpServletResponse.getEncoding() != null) {
            httpServletResponse.setCharacterEncoding(cacheableHttpServletResponse.getEncoding());
        }
    }
}

