/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.framework.helpers.Escaper;
import com.neptunelabs.fsiserver.framework.io.StringWriterFast;
import com.neptunelabs.fsiserver.imagereader.metrics.Histogram;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MetricsInfoRenderer
extends RendererAbstract {
    public MetricsInfoRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
    }

    @Override
    public String getOption(String string) {
        return null;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) {
        RendererTextResponse rendererTextResponse;
        block29: {
            HttpSession httpSession = httpServletRequest.getSession(false);
            Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
            String string = parameters.getAssetURLPath();
            if (string == null) {
                return MetricsInfoRenderer.generateMissingParameterResponse("source");
            }
            rendererTextResponse = new RendererTextResponse();
            try {
                String string2 = parameters.contains(Parameters.General.\u00f4\u00d40000) ? parameters.get(Parameters.General.\u00f4\u00d40000) : "info";
                Template template = this.\u00d300000.getTemplateCache().getTemplate(TemplateType.new, string2 + ".ftl");
                TemplateAttributes templateAttributes = new TemplateAttributes(this.new, template);
                templateAttributes.setRendererResponseContentType(rendererTextResponse);
                Escaper.EscaperType escaperType = templateAttributes.getStaticEscape();
                if (!this.checkTemplateAccessRestrictions(templateAttributes, httpSession)) {
                    return MetricsInfoRenderer.generateNotAuthorizedResponse();
                }
                SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(string);
                PermissionSet permissionSet = this.\u00d300000.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
                if (permissionSet == null || !permissionSet.read.basicMetadata.booleanValue() || !permissionSet.read.extendedMetadata.booleanValue()) {
                    return MetricsInfoRenderer.generateNotAuthorizedResponse();
                }
                MetaData metaData = this.\u00d300000.getImageBuilder().getImageMetaData(sourceConnectorReader, string, 32, true, httpSession);
                if (metaData != null && metaData instanceof ImageMetaData) {
                    ImageMetaData imageMetaData = (ImageMetaData)metaData;
                    if (imageMetaData.getImportStatus() != 1) {
                        rendererTextResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                    }
                    rendererTextResponse.setDateHeader("Last-Modified", metaData.getLastModified());
                    Histogram histogram = imageMetaData.getHistogram();
                    if (histogram != null) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("pixels", histogram.\u00f500000);
                        HashMap<String, Float> hashMap2 = new HashMap<String, Float>();
                        hashMap2.put("redFraction", Float.valueOf(histogram.new));
                        hashMap2.put("greenFraction", Float.valueOf(histogram.\u00d3o0000));
                        hashMap2.put("blueFraction", Float.valueOf(histogram.while));
                        hashMap.put("fraction", this.getSimpleFloatSequence(hashMap2, escaperType));
                        HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
                        hashMap3.put("redMin", histogram.\u00f400000 & 0xFF);
                        hashMap3.put("greenMin", histogram.\u00d300000 & 0xFF);
                        hashMap3.put("blueMin", histogram.return & 0xFF);
                        hashMap3.put("saturationMin", histogram.\u00d800000 & 0xFF);
                        hashMap3.put("brightnessMin", histogram.\u00d4O0000 & 0xFF);
                        hashMap.put("min", this.getSimpleIntegerSequence(hashMap3, escaperType));
                        HashMap<String, Integer> hashMap4 = new HashMap<String, Integer>();
                        hashMap4.put("redMax", histogram.OO0000 & 0xFF);
                        hashMap4.put("greenMax", histogram.\u00d500000 & 0xFF);
                        hashMap4.put("blueMax", histogram.if & 0xFF);
                        hashMap4.put("saturationMax", histogram.\u00f800000 & 0xFF);
                        hashMap4.put("brightnessMax", histogram.\u00d8O0000 & 0xFF);
                        hashMap.put("max", this.getSimpleIntegerSequence(hashMap4, escaperType));
                        ArrayList<Float> arrayList = new ArrayList<Float>(histogram.nullsuper.length);
                        for (float f : histogram.nullsuper) {
                            arrayList.add(Float.valueOf(f));
                        }
                        hashMap.put("redHistogram", arrayList);
                        Object object = new ArrayList(histogram.\u00d5o0000.length);
                        for (float f : histogram.\u00d5o0000) {
                            object.add(Float.valueOf(f));
                        }
                        hashMap.put("greenHistogram", object);
                        Object object2 = new ArrayList(histogram.\u00d400000.length);
                        for (float f : histogram.\u00d400000) {
                            object2.add(Float.valueOf(f));
                        }
                        hashMap.put("blueHistogram", object2);
                        Object object3 = new ArrayList(histogram.\u00f8O0000.length);
                        for (float f : histogram.\u00f8O0000) {
                            object3.add(Float.valueOf(f));
                        }
                        hashMap.put("hueHistogram", object3);
                        Object object4 = new ArrayList(histogram.\u00f4O0000.length);
                        for (float f : histogram.\u00f4O0000) {
                            object4.add(Float.valueOf(f));
                        }
                        hashMap.put("saturationHistogram", object4);
                        Object object5 = new ArrayList(histogram.\u00d4o0000.length);
                        for (float f : histogram.\u00d4o0000) {
                            object5.add(Float.valueOf(f));
                        }
                        hashMap.put("brightnessHistogram", object5);
                        hashMap.put("query", parameters);
                        try (Object object6 = new StringWriterFast();){
                            Environment environment = template.createProcessingEnvironment(hashMap, (Writer)object6);
                            environment.process();
                            rendererTextResponse.setBody(((StringWriterFast)object6).toString());
                        }
                        rendererTextResponse.setStatus(200);
                        break block29;
                    }
                    rendererTextResponse.setStatus(404);
                    break block29;
                }
                throw new IllegalArgumentException("Histogram requests not supported for non-image files.");
            }
            catch (NoSuchFileException noSuchFileException) {
                return MetricsInfoRenderer.generateNotFoundResponse();
            }
            catch (TemplateException | IOException throwable) {
                rendererTextResponse.setStatus(500);
                this.new.logException((Exception)throwable, 3191, throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
            }
            catch (NotConfiguredException notConfiguredException) {
                rendererTextResponse.setStatus(503);
                this.new.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
            }
        }
        return rendererTextResponse;
    }

    private List getSimpleFloatSequence(Map<String, Float> map, Escaper.EscaperType escaperType) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<String, Float> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("key", MetricsInfoRenderer.escapeString(entry.getKey(), escaperType));
            hashMap.put("name", entry.getValue());
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private List getSimpleIntegerSequence(Map<String, Integer> map, Escaper.EscaperType escaperType) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("key", MetricsInfoRenderer.escapeString(entry.getKey(), escaperType));
            hashMap.put("name", entry.getValue());
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new TreeSet<String>();
    }

    @Override
    public void setOption(String string, String string2) {
    }
}

