/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.authentication.PublishingSet;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.helpers.FileEventCallback;
import com.neptunelabs.fsiserver.framework.io.FileEventCursor;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.jmx.MBeanUtils;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.framework.settings.Section;
import com.neptunelabs.fsiserver.mbeans.FSISourceManagerCache;
import com.neptunelabs.fsiserver.mbeans.FSISourceManagerCacheMBean;
import com.neptunelabs.fsiserver.mbeans.FSISourceManagerScanner;
import com.neptunelabs.fsiserver.mbeans.FSISourceManagerScannerMBean;
import com.neptunelabs.fsiserver.mbeans.FSISourceManagerStorage;
import com.neptunelabs.fsiserver.mbeans.FSISourceManagerStorageMBean;
import com.neptunelabs.fsiserver.requestprocessor.effects.EffectsManager;
import com.neptunelabs.fsiserver.sourcemanager.DeleteDaemon;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.small.ScannerPauseReason;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.ServletUtils;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.yworks.util.annotation.Obfuscation;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public final class SourceManagerSettings
extends FSIServerSettings {
    private Path \u00f4\u00d20000;
    private boolean \u00d8\u00d20000 = false;
    private Path returnnew = null;

    public SourceManagerSettings(ServletContext servletContext) {
        super(servletContext, false, false);
        if (this.getConfigHome() != null) {
            this.setSettingsFile(this.getConfigHome().resolve("sourcemanager.xml"));
            this.setLicenceFile(this.getLicenceLocation(), 22, 3);
        }
        this.initDefaults();
    }

    public short getTileSize() {
        return 384;
    }

    private void initDefaults() {
        HashMap<String, Section> hashMap = new HashMap<String, Section>();
        Section section = new Section(Section.SectionTypes.\u00d200000);
        section.enable(true);
        section.put("standalone", "false");
        section.put("conversionthreads", "auto");
        section.put("logtostorage", "false");
        section.put("userdb", "xmlfile");
        section.put("ldapuri", "ldap://localhost:389/");
        section.put("ldapuser", "");
        section.put("ldappassword", "");
        section.put("ldapbasedn", "");
        section.put("usekrb", "false");
        section.put("krbdebug", "false");
        if (this.getWebInfPath() != null) {
            section.put("storage", this.getWebInfPath().resolve("storage").toString());
        }
        section.put("storagehasher", "crc32");
        section.put("byteorder", "litte_endian");
        section.put("maxcpu", "auto");
        section.put("hasht", "true");
        section.put("maxio", "auto");
        section.put("forcecputhreads", "");
        section.put("forceiothreads", "");
        section.put("maxscalememratio", "0.75");
        section.put("prefetch", "true");
        section.put("prefetchmaxsize", Integer.toString(0x3000000));
        section.put("tempdirectory", "auto");
        section.put("jmx", "false");
        section.put("import", "true");
        hashMap.put("application", section);
        Section section2 = new Section(Section.SectionTypes.\u00d200000);
        section2.put("maxmemory", "auto");
        section2.put("directmemory", "false");
        section2.put("l1", "true");
        section2.put("l1size", "1000");
        section2.put("l2", "true");
        section2.put("response", "true");
        section2.put("packasync", "true");
        section2.put("writecachedir", "");
        hashMap.put("cache", section2);
        Section section3 = new Section(Section.SectionTypes.\u00d200000);
        section3.enable(true);
        section3.put("filescandelay", "1");
        section3.put("sorting", "true");
        section3.put("convertBefore1stScan", "false");
        section3.put("useMagicBytes", "false");
        hashMap.put("scanner", section3);
        Section section4 = new Section(Section.SectionTypes.\u00d200000);
        section4.enable(true);
        section4.put("defaultcmykprofile", "auto");
        section4.put("defaultrgbprofile", "auto");
        section4.put("defaultgrayprofile", "auto");
        section4.put("fallbackiccconversion", "true");
        hashMap.put("colormanagementsystem", section4);
        Section section5 = new Section(Section.SectionTypes.\u00d200000);
        section5.enable(false);
        section5.put("type", "solr");
        section5.put("solrserveruri", "http://localhost/solr");
        section5.put("core", "fsi-server-3");
        section5.put("authentication", "false");
        section5.put("authenticationtype", "basic");
        section5.put("authenticationusername", "");
        section5.put("authenticationpassword", "");
        section5.put("proxy", "false");
        section5.put("proxyhostname", "");
        section5.put("proxyport", "80");
        section5.put("proxyssl", "false");
        section5.put("proxyauthentication", "false");
        section5.put("proxyusername", "");
        section5.put("proxypassword", "");
        section5.put("connectionpoolmax", "500");
        hashMap.put("search", section5);
        this.setDefaultSection(hashMap);
    }

    private void dumpConnectorAccess() {
        this.log("Connectors and access rules:");
        for (Map.Entry entry : this.o\u00d20000.entrySet()) {
            this.log(((SourceConnectorReader)entry.getValue()).getPrefix() + " - " + ((SourceConnectorReader)entry.getValue()).getAccessPermissions());
        }
    }

    public Path getSourceConnectorPath() {
        return this.getConfigHome().resolve("connectors");
    }

    public boolean isPermissionSetInUse(String string) {
        boolean bl = false;
        UserAuthenticationInterface userAuthenticationInterface = this.getUserAuthenticationInterface();
        if (string.equals("public_images") || string.equals("public_statics")) {
            bl = true;
        } else {
            for (Users.User object : userAuthenticationInterface.if) {
                if (!string.equals(object.permissionSet)) continue;
                return true;
            }
            for (Group group : userAuthenticationInterface.getGroups().values()) {
                if (!string.equals(group.getPermissionSet())) continue;
                return true;
            }
            block2: for (SourceConnectorReader sourceConnectorReader : this.o\u00d20000.values()) {
                for (PermissionSet permissionSet : sourceConnectorReader.getAccessPermissions().values()) {
                    if (!string.equals(permissionSet.getName())) continue;
                    bl = true;
                    continue block2;
                }
            }
        }
        return bl;
    }

    public boolean isPropertySetInUse(String string) {
        boolean bl = false;
        UserAuthenticationInterface userAuthenticationInterface = this.getUserAuthenticationInterface();
        for (Users.User object : userAuthenticationInterface.if) {
            if (!string.equals(object.propertySet)) continue;
            return true;
        }
        for (Group group : userAuthenticationInterface.getGroups().values()) {
            if (!string.equals(group.getPropertySet())) continue;
            return true;
        }
        block2: for (SourceConnectorReader sourceConnectorReader : this.o\u00d20000.values()) {
            for (String string2 : sourceConnectorReader.getAccessProperties().values()) {
                if (!string.equals(string2)) continue;
                bl = true;
                continue block2;
            }
        }
        return bl;
    }

    public boolean isPublishingSetInUse(String string) {
        List<PublishingSet> list = this.getUserAuthenticationInterface().getAllUserPublishingSets();
        for (PublishingSet publishingSet : list) {
            if (!string.equals(publishingSet.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupInUse(String string) {
        boolean bl = false;
        if (string.equals("public")) {
            bl = true;
        } else {
            block0: for (SourceConnectorReader sourceConnectorReader : this.o\u00d20000.values()) {
                for (Group group : sourceConnectorReader.getAccessPermissions().keySet()) {
                    if (!group.getName().equals(string)) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        return bl;
    }

    public Path getCacheDirectory() {
        return this.returnnew;
    }

    public void readSourceConnectors() {
        FSILogger fSILogger = this.getLogger();
        UserAuthenticationInterface userAuthenticationInterface = this.getUserAuthenticationInterface();
        this.o\u00d20000.clear();
        Path path = this.getSourceConnectorPath();
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            try {
                List<PathCached> list = FileOperations.listFiles(path, "*.xml");
                if (list != null && list.size() > 0) {
                    EffectsManager effectsManager = (EffectsManager)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.EffectManager");
                    for (PathCached pathCached : list) {
                        if (!pathCached.isReadable()) continue;
                        String string = pathCached.getFileName().substring(0, pathCached.getFileName().length() - 4);
                        SourceConnectorReader sourceConnectorReader = new SourceConnectorReader(fSILogger, string, pathCached, this.getWebInfPath(), this.getWorkDirectory(), userAuthenticationInterface, effectsManager);
                        if (sourceConnectorReader.isEnabled()) {
                            fSILogger.log(2500, string);
                        } else if (sourceConnectorReader.hasError()) {
                            fSILogger.log(2501, string, "Error reading " + pathCached.getAbsoluteName() + " - " + sourceConnectorReader.getErrorMessage());
                        } else {
                            fSILogger.log(2502, string);
                        }
                        this.o\u00d20000.put(string, sourceConnectorReader);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.getSystemMonitor().setConnectorCount(this.o\u00d20000.size());
        this.updateSourceConnectorAccessRules();
    }

    public void updateSourceConnectorAccessRules() {
        UserAuthenticationInterface userAuthenticationInterface = this.getUserAuthenticationInterface();
        userAuthenticationInterface.updateSourceConnectors(this.o\u00d20000);
    }

    public Map<String, SourceConnectorReader> getEnabledConnectors() {
        HashMap<String, SourceConnectorReader> hashMap = new HashMap<String, SourceConnectorReader>();
        for (Map.Entry entry : this.o\u00d20000.entrySet()) {
            if (!((SourceConnectorReader)entry.getValue()).isEnabled()) continue;
            hashMap.put((String)entry.getKey(), (SourceConnectorReader)entry.getValue());
        }
        return hashMap;
    }

    public Map<String, SourceConnectorReader> getAllConnectors() {
        return new HashMap<String, SourceConnectorReader>(this.o\u00d20000);
    }

    public SourceConnectorReader getSourceConnector(String string) {
        return (SourceConnectorReader)this.o\u00d20000.get(string);
    }

    public Path getTrashLocation() {
        return this.getStorageLocation().resolve(".trash");
    }

    void initCacheDirectory() {
        Path path;
        String string = this.getPrefsString("cache", "writecachedir");
        if (string != null && !string.equals("") && Files.isDirectory(path = Paths.get(string, new String[0]), new LinkOption[0]) && Files.isWritable(path)) {
            this.returnnew = path;
        }
    }

    public void initWorkDirectory() {
        String string;
        Path path = this.getTempDirectory();
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                path = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                this.getLogger().log(2010, path);
            }
        }
        Path path2 = (string = this.getPrefsString("application", "tempDirectory")) == null || string.equals("") || string.equalsIgnoreCase("auto") ? path : Paths.get(string, new String[0]);
        Path path3 = !path2.isAbsolute() ? ServletUtils.getRealPath(this.\u00d300000, string) : path2;
        this.\u00f4\u00d20000 = path3.resolve("sourcemanager");
        if (Files.notExists(this.\u00f4\u00d20000, new LinkOption[0])) {
            try {
                Files.createDirectories(this.\u00f4\u00d20000, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                this.getLogger().log(3199, this.\u00f4\u00d20000);
            }
        } else {
            try {
                this.clearWorkDirectory();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void clearWorkDirectory() throws IOException {
        List<PathCached> list = FileOperations.listAllFiles(this.\u00f4\u00d20000, "*", 0, 1);
        if (list.size() > 0) {
            try {
                FileOperations.deleteDir(this.\u00f4\u00d20000);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Files.createDirectory(this.\u00f4\u00d20000, new FileAttribute[0]);
        }
    }

    public Path getWorkDirectory() {
        return this.\u00f4\u00d20000;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void updateLicenceFromLicenceManager() {
        CacheManager cacheManager;
        this.\u00d8\u00d20000 = true;
        super.updateLicenceFromLicenceManager();
        ScannerDaemon scannerDaemon = this.getScannerDaemon();
        if (scannerDaemon != null) {
            scannerDaemon.resetLicenceLogging();
        }
        if ((cacheManager = this.getCacheManager()) != null) {
            cacheManager.clearAll();
        }
        this.\u00d8\u00d20000 = false;
    }

    void initSourceConnectorWatcher() {
        FileEventCallback fileEventCallback = new FileEventCallback(this, "reReadSourceConnectorsAndResetScanner", null);
        ArrayList<FileEventCallback> arrayList = new ArrayList<FileEventCallback>();
        arrayList.add(fileEventCallback);
        DirectoryStream.Filter<Path> filter = path -> path.getFileName().toString().endsWith(".xml");
        try {
            FileEventCursor fileEventCursor = this.getFileEventCursor();
            fileEventCursor.addPathMonitor(this.getSourceConnectorPath(), filter, false, arrayList);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Obfuscation
    public void reReadSourceConnectorsAndResetScanner() {
        boolean bl = false;
        FSILogger fSILogger = this.getLogger();
        fSILogger.log(2505, this.getSourceConnectorPath());
        ScannerDaemon scannerDaemon = this.getScannerDaemon();
        try {
            if (scannerDaemon != null) {
                scannerDaemon.pauseScanner("pausedToRestart", new ScannerPauseReason[0]);
                bl = true;
            }
            this.readSourceConnectors();
            DeleteDaemon deleteDaemon = this.getDeleteDaemon();
            deleteDaemon.updateProfileMap();
        }
        finally {
            if (bl) {
                scannerDaemon.resetScanner();
            }
        }
    }

    private Path getLicenceLocation() {
        if (this.getConfigHome() != null) {
            return this.getConfigHome().resolve(Defines.if);
        }
        return null;
    }

    @Override
    protected void initMBeans() {
        FSILogger fSILogger = this.getLogger();
        if (System.getProperty("com.sun.management.jmxremote") == null) {
            fSILogger.log(2036, new Object[0]);
        } else if (System.getProperty("com.sun.management.jmxremote.port") != null) {
            fSILogger.log(2037, Integer.parseInt(System.getProperty("com.sun.management.jmxremote.port")));
        }
        this.\u00f5o0000.add(MBeanUtils.registerMBean(fSILogger, "FSI Server:Type=Cache", new FSISourceManagerCache(this.getCacheManager()), FSISourceManagerCacheMBean.class));
        this.\u00f5o0000.add(MBeanUtils.registerMBean(fSILogger, "FSI Server:Type=Scanner", new FSISourceManagerScanner(this.getSystemMonitor()), FSISourceManagerScannerMBean.class));
        this.\u00f5o0000.add(MBeanUtils.registerMBean(fSILogger, "FSI Server:Type=Storage", new FSISourceManagerStorage(this.getSystemMonitor()), FSISourceManagerStorageMBean.class));
    }

    @Override
    public FSILogger getLogger() {
        if (this.\u00d300000 == null) {
            return null;
        }
        Object object = this.\u00d300000.getAttribute("logger.sourcemanager");
        if (object != null) {
            return (FSILogger)object;
        }
        return null;
    }
}

