/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider;

import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.StorageDataProvider;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TagInfo;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EISImageStatusUpdater
extends StorageDataProvider {
    private short class;
    private ByteOrder \u00d600000;
    private int \u00d400000;
    private short \u00f400000;
    private TagInfo \u00d800000;

    @Override
    public boolean useTemporaryFile() {
        return false;
    }

    public void setNewStatus(short s) {
        this.class = s;
    }

    @Override
    public boolean execute() throws IOException {
        boolean bl;
        block29: {
            bl = false;
            try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(this.super, StandardOpenOption.WRITE, StandardOpenOption.READ);){
                ByteBuffer byteBuffer = ByteBuffer.allocate(8);
                seekableByteChannel.read(byteBuffer);
                byteBuffer.flip();
                if (Arrays.equals(byteBuffer.array(), EISEnvironment.String)) {
                    this.readHeader(seekableByteChannel);
                    bl = this.updateMetaData(seekableByteChannel);
                    break block29;
                }
                if (Arrays.equals(byteBuffer.array(), EISEnvironment.\u00d600000)) {
                    int n = EISChainReader.findChainEntryNumber(this.super, this.getAssetURLPath());
                    Path path = StorageManager.getChainedDestination(this.super, n);
                    bl = true;
                    try (SeekableByteChannel seekableByteChannel2 = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.READ);){
                        ByteBuffer byteBuffer2 = ByteBuffer.allocate(8);
                        seekableByteChannel2.read(byteBuffer2);
                        byteBuffer2.flip();
                        if (Arrays.equals(byteBuffer2.array(), EISEnvironment.String)) {
                            this.readHeader(seekableByteChannel2);
                            bl = this.updateMetaData(seekableByteChannel2);
                        }
                        break block29;
                    }
                }
                throw new IOException("Not a valid EIS Image file: " + this.super);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    private void readHeader(SeekableByteChannel seekableByteChannel) throws IOException {
        byte[] byArray = this.getRawByteData(seekableByteChannel, 8L, 16);
        this.parseBaseHeaderBytes(byArray);
        byte[] byArray2 = this.getRawByteData(seekableByteChannel, 16L, this.\u00d400000 * 24);
        this.parseTagMapBytes(byArray2);
    }

    private void parseBaseHeaderBytes(byte[] byArray) {
        byte by = byArray[0];
        if (by == 126) {
            this.\u00d600000 = ByteOrder.LITTLE_ENDIAN;
        } else if (by == -66) {
            this.\u00d600000 = ByteOrder.BIG_ENDIAN;
        }
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray, this.\u00d600000);
        byteArrayWalker.position(2);
        this.\u00f400000 = byteArrayWalker.getShort();
        this.\u00d400000 = byteArrayWalker.getInt();
    }

    private void parseTagMapBytes(byte[] byArray) throws IOException {
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray, this.\u00d600000);
        if (this.\u00f400000 == 3) {
            for (int i = 0; i < this.\u00d400000; ++i) {
                TagInfo tagInfo = new TagInfo();
                tagInfo.\u00d200000 = byteArrayWalker.getLong();
                tagInfo.o00000 = byteArrayWalker.getLong();
                tagInfo.\u00d400000 = (int)byteArrayWalker.getLong();
                tagInfo.Object = (tagInfo.\u00d200000 & 0x1000L) > 0L;
                tagInfo.\u00d200000 &= 0xFFFL;
                if (tagInfo.\u00d200000 != 501L) continue;
                this.\u00d800000 = tagInfo;
            }
        } else {
            throw new IOException("Unsupported EIS version " + this.\u00f400000 + " in " + this.super);
        }
    }

    private byte[] getRawByteData(SeekableByteChannel seekableByteChannel, long l, int n) throws IOException {
        byte[] byArray = null;
        if (l > 0L && n > 0) {
            seekableByteChannel.position(l);
            byArray = new byte[n];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            seekableByteChannel.read(byteBuffer);
            if (byArray.length == 0) {
                byArray = null;
            }
        }
        return byArray;
    }

    private boolean updateMetaData(SeekableByteChannel seekableByteChannel) throws IOException {
        boolean bl = false;
        long l = this.\u00d800000.o00000;
        long l2 = l + this.\u00d800000.\u00d400000;
        seekableByteChannel.position(l);
        while (seekableByteChannel.position() < l2) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(2);
            byteBuffer.order(this.\u00d600000);
            seekableByteChannel.read(byteBuffer);
            byteBuffer.flip();
            short s = byteBuffer.getShort();
            byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.order(this.\u00d600000);
            seekableByteChannel.read(byteBuffer);
            byteBuffer.flip();
            int n = byteBuffer.getInt();
            if (s == 2) {
                byteBuffer = ByteBuffer.allocate(2);
                byteBuffer.order(this.\u00d600000);
                byteBuffer.putShort(this.class);
                byteBuffer.flip();
                seekableByteChannel.write(byteBuffer);
                bl = true;
                break;
            }
            seekableByteChannel.position(seekableByteChannel.position() + (long)n);
        }
        return bl;
    }
}

