/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.CaselessStringArrayTable;
import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.io.Serializable;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationNode;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.ParameterListDescriptorImpl;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.RegistryMode;
import javax.media.jai.util.Range;

public abstract class OperationDescriptorImpl
implements OperationDescriptor,
Serializable {
    private boolean deprecated = false;
    protected final String[][] resources;
    protected final String[] supportedModes;
    private CaselessStringArrayTable modeIndices;
    protected final String[] sourceNames;
    private Class[][] sourceClasses;
    private CaselessStringArrayTable sourceIndices;
    private ParameterListDescriptor[] paramListDescriptors;
    String[] paramNames;
    private String name = null;
    static /* synthetic */ Class class$java$awt$image$RenderedImage;
    static /* synthetic */ Class class$java$awt$image$renderable$RenderableImage;
    static /* synthetic */ Class class$java$util$Collection;

    private String[] checkSources(String[][] stringArray, String[] stringArray2, String[] stringArray3, Class[][] classArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("resources: " + JaiI18N.getString("Generic2"));
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            throw new IllegalArgumentException("supportedModes: " + JaiI18N.getString("Generic2"));
        }
        int n = stringArray2.length;
        if (classArray != null) {
            int n2;
            if (classArray.length != n) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationDescriptorImpl0", new Object[]{"sourceClasses", new Integer(n)}));
            }
            int n3 = n2 = classArray[0] == null ? 0 : classArray[0].length;
            if (stringArray3 == null) {
                stringArray3 = this.getDefaultSourceNames(n2);
            } else if (stringArray3.length != n2) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationDescriptorImpl1", new Object[]{new Integer(stringArray3.length), new Integer(n2)}));
            }
            for (int i = 0; i < classArray.length; ++i) {
                int n4;
                int n5 = n4 = classArray[i] == null ? 0 : classArray[i].length;
                if (n2 == n4) continue;
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationDescriptorImpl2", new Object[]{new Integer(n4), new Integer(n2), stringArray2[i]}));
            }
        } else if (stringArray3 != null && stringArray3.length != 0) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationDescriptorImpl1", new Object[]{new Integer(stringArray3.length), new Integer(0)}));
        }
        return stringArray3;
    }

    public OperationDescriptorImpl(String[][] stringArray, String[] stringArray2, String[] stringArray3, Class[][] classArray, String[] stringArray4, Class[][] classArray2, Object[][] objectArray, Object[][] objectArray2) {
        stringArray3 = this.checkSources(stringArray, stringArray2, stringArray3, classArray);
        this.resources = stringArray;
        this.supportedModes = stringArray2;
        this.sourceNames = stringArray3;
        this.sourceClasses = classArray;
        this.paramNames = stringArray4;
        this.modeIndices = new CaselessStringArrayTable(stringArray2);
        this.sourceIndices = new CaselessStringArrayTable(stringArray3);
        int n = stringArray4 == null ? 0 : stringArray4.length;
        int n2 = stringArray2.length;
        if (n == 0 ? classArray2 != null && classArray2.length != n2 : classArray2 == null || classArray2.length != n2) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationDescriptorImpl0", new Object[]{"paramClasses", new Integer(n2)}));
        }
        if (objectArray != null && objectArray.length != n2) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationDescriptorImpl0", new Object[]{"paramDefaults", new Integer(n2)}));
        }
        if (objectArray2 != null && objectArray2.length != n2) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationDescriptorImpl0", new Object[]{"validParamValues", new Integer(n2)}));
        }
        this.paramListDescriptors = new ParameterListDescriptor[n2];
        for (int i = 0; i < n2; ++i) {
            this.paramListDescriptors[i] = new ParameterListDescriptorImpl(this, stringArray4, classArray2[i], objectArray == null ? null : objectArray[i], objectArray2 == null ? null : objectArray2[i]);
        }
    }

    public OperationDescriptorImpl(String[][] stringArray, String[] stringArray2, String[] stringArray3, Class[][] classArray, String[] stringArray4, Class[] classArray2, Object[] objectArray, Object[] objectArray2) {
        stringArray3 = this.checkSources(stringArray, stringArray2, stringArray3, classArray);
        this.resources = stringArray;
        this.supportedModes = stringArray2;
        this.sourceNames = stringArray3;
        this.sourceClasses = classArray;
        this.paramNames = stringArray4;
        this.modeIndices = new CaselessStringArrayTable(stringArray2);
        this.sourceIndices = new CaselessStringArrayTable(stringArray3);
        ParameterListDescriptorImpl parameterListDescriptorImpl = new ParameterListDescriptorImpl(this, stringArray4, classArray2, objectArray, objectArray2);
        this.paramListDescriptors = new ParameterListDescriptor[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            this.paramListDescriptors[i] = parameterListDescriptorImpl;
        }
    }

    public OperationDescriptorImpl(String[][] stringArray, String[] stringArray2, int n, String[] stringArray3, Class[] classArray, Object[] objectArray, Object[] objectArray2) {
        Class[][] classArray2 = OperationDescriptorImpl.makeDefaultSourceClassList(stringArray2, n);
        String[] stringArray4 = this.checkSources(stringArray, stringArray2, null, classArray2);
        this.resources = stringArray;
        this.supportedModes = stringArray2;
        this.sourceNames = stringArray4;
        this.sourceClasses = classArray2;
        this.paramNames = stringArray3;
        this.modeIndices = new CaselessStringArrayTable(stringArray2);
        this.sourceIndices = new CaselessStringArrayTable(stringArray4);
        ParameterListDescriptorImpl parameterListDescriptorImpl = new ParameterListDescriptorImpl(this, stringArray3, classArray, objectArray, objectArray2);
        this.paramListDescriptors = new ParameterListDescriptor[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            this.paramListDescriptors[i] = parameterListDescriptorImpl;
        }
    }

    public OperationDescriptorImpl(String[][] stringArray, String[] stringArray2, String[] stringArray3, Class[][] classArray, ParameterListDescriptor[] parameterListDescriptorArray) {
        stringArray3 = this.checkSources(stringArray, stringArray2, stringArray3, classArray);
        this.resources = stringArray;
        this.supportedModes = stringArray2;
        this.sourceNames = stringArray3;
        this.sourceClasses = classArray;
        this.modeIndices = new CaselessStringArrayTable(stringArray2);
        this.sourceIndices = new CaselessStringArrayTable(stringArray3);
        if (parameterListDescriptorArray != null && parameterListDescriptorArray.length != stringArray2.length) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationDescriptorImpl0", new Object[]{"ParameterListDescriptor's", new Integer(stringArray2.length)}));
        }
        if (parameterListDescriptorArray == null) {
            ParameterListDescriptorImpl parameterListDescriptorImpl = new ParameterListDescriptorImpl();
            this.paramListDescriptors = new ParameterListDescriptor[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                this.paramListDescriptors[i] = parameterListDescriptorImpl;
            }
            this.paramNames = null;
        } else {
            this.paramListDescriptors = parameterListDescriptorArray;
            this.paramNames = this.paramListDescriptors[0].getParamNames();
        }
    }

    public OperationDescriptorImpl(String[][] stringArray, String[] stringArray2, String[] stringArray3, Class[][] classArray, ParameterListDescriptor parameterListDescriptor) {
        stringArray3 = this.checkSources(stringArray, stringArray2, stringArray3, classArray);
        this.resources = stringArray;
        this.supportedModes = stringArray2;
        this.sourceNames = stringArray3;
        this.sourceClasses = classArray;
        this.modeIndices = new CaselessStringArrayTable(stringArray2);
        this.sourceIndices = new CaselessStringArrayTable(stringArray3);
        if (parameterListDescriptor == null) {
            parameterListDescriptor = new ParameterListDescriptorImpl();
        }
        this.paramNames = parameterListDescriptor.getParamNames();
        this.paramListDescriptors = new ParameterListDescriptor[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            this.paramListDescriptors[i] = parameterListDescriptor;
        }
    }

    private String[] getDefaultSourceNames(int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "source" + i;
        }
        return stringArray;
    }

    public String getName() {
        if (this.name == null) {
            this.name = (String)this.getResourceBundle(Locale.getDefault()).getObject("GlobalName");
        }
        return this.name;
    }

    public String[] getSupportedModes() {
        return this.supportedModes;
    }

    public boolean isModeSupported(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.modeIndices.contains(string);
    }

    public boolean arePropertiesSupported() {
        return true;
    }

    public PropertyGenerator[] getPropertyGenerators(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.deprecated && (string.equalsIgnoreCase("rendered") || string.equalsIgnoreCase("renderable"))) {
            return this.getPropertyGenerators();
        }
        if (!this.arePropertiesSupported()) {
            throw new UnsupportedOperationException(JaiI18N.formatMsg("OperationDescriptorImpl3", new Object[]{string}));
        }
        return null;
    }

    public ParameterListDescriptor getParameterListDescriptor(String string) {
        return this.paramListDescriptors[this.modeIndices.indexOf(string)];
    }

    public String[][] getResources(Locale locale) {
        return this.resources;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        final Locale locale2 = locale;
        return new ListResourceBundle(){

            public Object[][] getContents() {
                return OperationDescriptorImpl.this.getResources(locale2);
            }
        };
    }

    public int getNumSources() {
        return this.sourceNames.length;
    }

    public Class[] getSourceClasses(String string) {
        this.checkModeName(string);
        Class[] classArray = this.sourceClasses[this.modeIndices.indexOf(string)];
        if (classArray != null && classArray.length <= 0) {
            return null;
        }
        return classArray;
    }

    public String[] getSourceNames() {
        if (this.sourceNames == null || this.sourceNames.length <= 0) {
            return null;
        }
        return this.sourceNames;
    }

    public Class getDestClass(String string) {
        this.checkModeName(string);
        if (this.deprecated) {
            if (string.equalsIgnoreCase("rendered")) {
                return this.getDestClass();
            }
            if (string.equalsIgnoreCase("renderable")) {
                return this.getRenderableDestClass();
            }
        }
        return RegistryMode.getMode(string).getProductClass();
    }

    protected boolean validateSources(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.deprecated) {
            if (string.equalsIgnoreCase("rendered")) {
                return this.validateSources(parameterBlock, stringBuffer);
            }
            if (string.equalsIgnoreCase("renderable")) {
                return this.validateRenderableSources(parameterBlock, stringBuffer);
            }
        }
        return this.validateSources(this.getSourceClasses(string), parameterBlock, stringBuffer);
    }

    protected boolean validateParameters(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.deprecated && (string.equalsIgnoreCase("rendered") || string.equalsIgnoreCase("renderable"))) {
            return this.validateParameters(parameterBlock, stringBuffer);
        }
        return this.validateParameters(this.getParameterListDescriptor(string), parameterBlock, stringBuffer);
    }

    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        return this.isModeSupported(string) && this.validateSources(string, parameterBlock, stringBuffer) && this.validateParameters(string, parameterBlock, stringBuffer);
    }

    public boolean isImmediate() {
        return false;
    }

    public Object getInvalidRegion(String string, ParameterBlock parameterBlock, RenderingHints renderingHints, ParameterBlock parameterBlock2, RenderingHints renderingHints2, OperationNode operationNode) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    protected static Class getDefaultSourceClass(String string) {
        if ("rendered".equalsIgnoreCase(string)) {
            return class$java$awt$image$RenderedImage == null ? (class$java$awt$image$RenderedImage = OperationDescriptorImpl.class$("java.awt.image.RenderedImage")) : class$java$awt$image$RenderedImage;
        }
        if ("renderable".equalsIgnoreCase(string)) {
            return class$java$awt$image$renderable$RenderableImage == null ? (class$java$awt$image$renderable$RenderableImage = OperationDescriptorImpl.class$("java.awt.image.renderable.RenderableImage")) : class$java$awt$image$renderable$RenderableImage;
        }
        if ("collection".equalsIgnoreCase(string)) {
            return class$java$util$Collection == null ? (class$java$util$Collection = OperationDescriptorImpl.class$("java.util.Collection")) : class$java$util$Collection;
        }
        if ("renderableCollection".equalsIgnoreCase(string)) {
            return class$java$util$Collection == null ? (class$java$util$Collection = OperationDescriptorImpl.class$("java.util.Collection")) : class$java$util$Collection;
        }
        return null;
    }

    protected static Class[][] makeDefaultSourceClassList(String[] stringArray, int n) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n2 = stringArray.length;
        Class[][] classArray = new Class[n2][n];
        for (int i = 0; i < n2; ++i) {
            Class clazz = OperationDescriptorImpl.getDefaultSourceClass(stringArray[i]);
            for (int j = 0; j < n; ++j) {
                classArray[i][j] = clazz;
            }
        }
        return classArray;
    }

    private String[] makeSupportedModeList() {
        int n = 0;
        if (this.isRenderedSupported()) {
            ++n;
        }
        if (this.isRenderableSupported()) {
            ++n;
        }
        String[] stringArray = new String[n];
        n = 0;
        if (this.isRenderedSupported()) {
            stringArray[n++] = "rendered";
        }
        if (this.isRenderableSupported()) {
            stringArray[n++] = "renderable";
        }
        return stringArray;
    }

    private Class[][] makeSourceClassList(Class[] classArray, Class[] classArray2) {
        int n = 0;
        if (this.isRenderedSupported()) {
            ++n;
        }
        if (this.isRenderableSupported()) {
            ++n;
        }
        Class[][] classArray3 = new Class[n][];
        n = 0;
        if (this.isRenderedSupported()) {
            classArray3[n++] = classArray;
        }
        if (this.isRenderableSupported()) {
            classArray3[n++] = classArray2;
        }
        return classArray3;
    }

    private Object[] makeValidParamValueList(Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        int n = classArray.length;
        Object[] objectArray = null;
        for (int i = 0; i < n; ++i) {
            Number number = this.getParamMinValue(i);
            Number number2 = this.getParamMaxValue(i);
            if (number == null && number2 == null) continue;
            if (objectArray == null) {
                objectArray = new Object[n];
            }
            objectArray[i] = new Range(number.getClass(), (Comparable)((Object)number), (Comparable)((Object)number2));
        }
        return objectArray;
    }

    public OperationDescriptorImpl(String[][] stringArray, Class[] classArray, Class[] classArray2, Class[] classArray3, String[] stringArray2, Object[] objectArray) {
        this.deprecated = true;
        String[] stringArray3 = this.makeSupportedModeList();
        Class[][] classArray4 = this.makeSourceClassList(classArray, classArray2);
        String[] stringArray4 = this.checkSources(stringArray, stringArray3, null, classArray4);
        Object[] objectArray2 = this.makeValidParamValueList(classArray3);
        this.resources = stringArray;
        this.supportedModes = stringArray3;
        this.sourceNames = stringArray4;
        this.sourceClasses = classArray4;
        this.paramNames = stringArray2;
        this.modeIndices = new CaselessStringArrayTable(stringArray3);
        this.sourceIndices = new CaselessStringArrayTable(stringArray4);
        ParameterListDescriptorImpl parameterListDescriptorImpl = new ParameterListDescriptorImpl(this, stringArray2, classArray3, objectArray, objectArray2);
        this.paramListDescriptors = new ParameterListDescriptor[stringArray3.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            this.paramListDescriptors[i] = parameterListDescriptorImpl;
        }
    }

    public OperationDescriptorImpl(String[][] stringArray, int n, Class[] classArray, String[] stringArray2, Object[] objectArray) {
        this.deprecated = true;
        String[] stringArray3 = this.makeSupportedModeList();
        Class[][] classArray2 = OperationDescriptorImpl.makeDefaultSourceClassList(stringArray3, n);
        String[] stringArray4 = this.checkSources(stringArray, stringArray3, null, classArray2);
        Object[] objectArray2 = this.makeValidParamValueList(classArray);
        this.resources = stringArray;
        this.supportedModes = stringArray3;
        this.sourceNames = stringArray4;
        this.sourceClasses = classArray2;
        this.paramNames = stringArray2;
        this.modeIndices = new CaselessStringArrayTable(stringArray3);
        this.sourceIndices = new CaselessStringArrayTable(stringArray4);
        ParameterListDescriptorImpl parameterListDescriptorImpl = new ParameterListDescriptorImpl(this, stringArray2, classArray, objectArray, objectArray2);
        this.paramListDescriptors = new ParameterListDescriptor[stringArray3.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            this.paramListDescriptors[i] = parameterListDescriptorImpl;
        }
    }

    public OperationDescriptorImpl(String[][] stringArray, Class[] classArray) {
        this(stringArray, classArray, null, null, null, null);
    }

    public OperationDescriptorImpl(String[][] stringArray, Class[] classArray, Class[] classArray2) {
        this(stringArray, classArray, classArray2, null, null, null);
    }

    public OperationDescriptorImpl(String[][] stringArray, Class[] classArray, String[] stringArray2, Object[] objectArray) {
        this(stringArray, null, null, classArray, stringArray2, objectArray);
    }

    public OperationDescriptorImpl(String[][] stringArray, int n) {
        this(stringArray, n, null, null, null);
    }

    public PropertyGenerator[] getPropertyGenerators() {
        return this.deprecated ? null : this.getPropertyGenerators("rendered");
    }

    public boolean isRenderedSupported() {
        return this.deprecated ? true : this.isModeSupported("rendered");
    }

    public Class[] getSourceClasses() {
        return this.getSourceClasses("rendered");
    }

    public Class getDestClass() {
        if (this.deprecated) {
            Class clazz = this.isRenderedSupported() ? (class$java$awt$image$RenderedImage == null ? (class$java$awt$image$RenderedImage = OperationDescriptorImpl.class$("java.awt.image.RenderedImage")) : class$java$awt$image$RenderedImage) : null;
            return clazz;
        }
        return this.getDestClass("rendered");
    }

    public boolean validateArguments(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (this.deprecated) {
            return this.validateSources(parameterBlock, stringBuffer) && this.validateParameters(parameterBlock, stringBuffer);
        }
        return this.validateArguments("rendered", parameterBlock, stringBuffer);
    }

    public boolean isRenderableSupported() {
        return this.deprecated ? false : this.isModeSupported("renderable");
    }

    public Class[] getRenderableSourceClasses() {
        return this.getSourceClasses("renderable");
    }

    public Class getRenderableDestClass() {
        if (this.deprecated) {
            Class clazz = this.isRenderableSupported() ? (class$java$awt$image$renderable$RenderableImage == null ? (class$java$awt$image$renderable$RenderableImage = OperationDescriptorImpl.class$("java.awt.image.renderable.RenderableImage")) : class$java$awt$image$renderable$RenderableImage) : null;
            return clazz;
        }
        return this.getDestClass("renderable");
    }

    public boolean validateRenderableArguments(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (this.deprecated) {
            return this.validateRenderableSources(parameterBlock, stringBuffer) && this.validateParameters(parameterBlock, stringBuffer);
        }
        return this.validateArguments("renderable", parameterBlock, stringBuffer);
    }

    private ParameterListDescriptor getDefaultPLD() {
        return this.getParameterListDescriptor(this.getSupportedModes()[0]);
    }

    public int getNumParameters() {
        return this.getDefaultPLD().getNumParameters();
    }

    public Class[] getParamClasses() {
        return this.getDefaultPLD().getParamClasses();
    }

    public String[] getParamNames() {
        return this.getDefaultPLD().getParamNames();
    }

    public Object[] getParamDefaults() {
        return this.getDefaultPLD().getParamDefaults();
    }

    public Object getParamDefaultValue(int n) {
        return this.getDefaultPLD().getParamDefaultValue(this.paramNames[n]);
    }

    public Number getParamMinValue(int n) {
        return null;
    }

    public Number getParamMaxValue(int n) {
        return null;
    }

    protected boolean validateSources(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (this.deprecated) {
            return this.isRenderedSupported() && this.validateSources(this.getSourceClasses(), parameterBlock, stringBuffer);
        }
        return this.validateSources("rendered", parameterBlock, stringBuffer);
    }

    protected boolean validateRenderableSources(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (this.deprecated) {
            return this.isRenderableSupported() && this.validateSources(this.getRenderableSourceClasses(), parameterBlock, stringBuffer);
        }
        return this.validateSources("renderable", parameterBlock, stringBuffer);
    }

    protected boolean validateParameters(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        return this.validateParameters(this.getDefaultPLD(), parameterBlock, stringBuffer);
    }

    private int getMinNumParameters(ParameterListDescriptor parameterListDescriptor) {
        int n = parameterListDescriptor.getNumParameters();
        Object[] objectArray = parameterListDescriptor.getParamDefaults();
        for (int i = n - 1; i >= 0 && objectArray[i] != ParameterListDescriptor.NO_PARAMETER_DEFAULT; --i) {
            --n;
        }
        return n;
    }

    private boolean validateSources(Class[] classArray, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (parameterBlock == null || stringBuffer == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = this.getNumSources();
        if (parameterBlock.getNumSources() < n) {
            stringBuffer.append(JaiI18N.formatMsg("OperationDescriptorImpl6", new Object[]{this.getName(), new Integer(n)}));
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object = parameterBlock.getSource(i);
            if (object == null) {
                stringBuffer.append(JaiI18N.formatMsg("OperationDescriptorImpl7", new Object[]{this.getName()}));
                return false;
            }
            Class clazz = classArray[i];
            if (clazz.isInstance(object)) continue;
            stringBuffer.append(JaiI18N.formatMsg("OperationDescriptorImpl8", new Object[]{this.getName(), new Integer(i), new String(clazz.toString()), new String(object.getClass().toString())}));
            return false;
        }
        return true;
    }

    private boolean validateParameters(ParameterListDescriptor parameterListDescriptor, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        int n;
        if (parameterBlock == null || stringBuffer == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = parameterListDescriptor.getNumParameters();
        int n3 = parameterBlock.getNumParameters();
        Object[] objectArray = parameterListDescriptor.getParamDefaults();
        if (n3 < n2) {
            if (n3 < this.getMinNumParameters(parameterListDescriptor)) {
                stringBuffer.append(JaiI18N.formatMsg("OperationDescriptorImpl9", new Object[]{this.getName(), new Integer(n2)}));
                return false;
            }
            for (n = n3; n < n2; ++n) {
                parameterBlock.add(objectArray[n]);
            }
        }
        for (n = 0; n < n2; ++n) {
            Object object = parameterBlock.getObjectParameter(n);
            if (object == null) {
                object = objectArray[n];
                if (object == OperationDescriptor.NO_PARAMETER_DEFAULT) {
                    stringBuffer.append(JaiI18N.formatMsg("OperationDescriptorImpl11", new Object[]{this.getName(), new Integer(n)}));
                    return false;
                }
                parameterBlock.set(object, n);
            }
            try {
                if (parameterListDescriptor.isParameterValueValid(this.paramNames[n], object)) continue;
                stringBuffer.append(JaiI18N.formatMsg("OperationDescriptorImpl10", new Object[]{this.getName(), parameterListDescriptor.getParamNames()[n]}));
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                stringBuffer.append(this.getName() + " - " + illegalArgumentException.getLocalizedMessage());
                return false;
            }
        }
        return true;
    }

    private void checkModeName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("OperationDescriptorImpl12"));
        }
        if (!this.modeIndices.contains(string)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationDescriptorImpl13", new Object[]{this.getName(), string}));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

