/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;

final class DilateBinaryOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    private int kx;
    private int ky;
    private int[] kdataPack;
    private int kwPack;

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
            }
        }
        return map2;
    }

    public DilateBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, DilateBinaryOpImage.configHelper(map), true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
        this.kwPack = (this.kw + 31) / 32;
        this.kdataPack = this.packKernel(kernelJAI);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData2 = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int[] nArray = new int[this.kwPack * this.kh];
        int n = rectangle.height;
        int n2 = rectangle.width;
        int n3 = packedImageData.offset;
        int n4 = packedImageData2.offset;
        for (int i = 0; i < n; ++i) {
            int n5;
            byte by;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            for (n11 = 0; n11 < nArray.length; ++n11) {
                nArray[n11] = 0;
            }
            for (n11 = 0; n11 < this.kw - 1; ++n11) {
                DilateBinaryOpImage.bitShiftMatrixLeft(nArray, this.kh, this.kwPack);
                n10 = this.kwPack - 1;
                n9 = packedImageData.bitOffset + n11;
                n8 = n9 >> 3;
                n9 = 7 - (n9 & 7);
                n7 = 0;
                n6 = n3;
                while (n7 < this.kh) {
                    by = packedImageData.data[n6 + n8];
                    n5 = by >> n9 & 1;
                    int n12 = n10;
                    nArray[n12] = nArray[n12] | n5;
                    n10 += this.kwPack;
                    ++n7;
                    n6 += packedImageData.lineStride;
                }
            }
            block4: for (n11 = 0; n11 < n2; ++n11) {
                DilateBinaryOpImage.bitShiftMatrixLeft(nArray, this.kh, this.kwPack);
                n10 = this.kwPack - 1;
                n9 = packedImageData.bitOffset + n11 + this.kw - 1;
                n8 = n9 >> 3;
                n9 = 7 - (n9 & 7);
                n7 = 0;
                n6 = n3;
                while (n7 < this.kh) {
                    by = packedImageData.data[n6 + n8];
                    n5 = by >> n9 & 1;
                    int n13 = n10;
                    nArray[n13] = nArray[n13] | n5;
                    n10 += this.kwPack;
                    ++n7;
                    n6 += packedImageData.lineStride;
                }
                for (n7 = 0; n7 < nArray.length; ++n7) {
                    if ((nArray[n7] & this.kdataPack[n7]) == 0) continue;
                    n6 = packedImageData2.bitOffset + n11;
                    int n14 = 7 - (n6 & 7);
                    int n15 = (n6 >> 3) + n4;
                    int n16 = packedImageData2.data[n15];
                    packedImageData2.data[n15] = (byte)(n16 |= 1 << n14);
                    continue block4;
                }
            }
            n3 += packedImageData.lineStride;
            n4 += packedImageData2.lineStride;
        }
        pixelAccessor.setPackedPixels(packedImageData2);
    }

    private final int[] packKernel(KernelJAI kernelJAI) {
        int n = kernelJAI.getWidth();
        int n2 = kernelJAI.getHeight();
        int n3 = (31 + n) / 32;
        int[] nArray = new int[n3 * n2];
        float[] fArray = kernelJAI.getKernelData();
        for (int i = 0; i < n; ++i) {
            int n4 = i;
            int n5 = n3 - 1;
            DilateBinaryOpImage.bitShiftMatrixLeft(nArray, n2, n3);
            int n6 = 0;
            while (n6 < n2) {
                if (fArray[n4] > 0.9f) {
                    int n7 = n5;
                    nArray[n7] = nArray[n7] | 1;
                }
                ++n6;
                n5 += n3;
                n4 += n;
            }
        }
        return nArray;
    }

    private static final void bitShiftMatrixLeft(int[] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2 - 1; ++j) {
                nArray[n3] = nArray[n3] << 1 | nArray[n3 + 1] >>> 31;
                ++n3;
            }
            int n4 = n3++;
            nArray[n4] = nArray[n4] << 1;
        }
    }
}

