/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class PiecewiseOpImage
extends ColormapOpImage {
    private float[][] abscissas;
    private float[][] slopes;
    private float[][] intercepts;
    private float[] minOrdinates;
    private float[] maxOrdinates;
    private boolean isByteData = false;
    private LookupTableJAI lut;

    private static float binarySearch(float[] fArray, float f, float f2, float[] fArray2, float[] fArray3, float f3) {
        int n = fArray.length - 1;
        if (f3 <= fArray[0]) {
            return f;
        }
        if (f3 >= fArray[n]) {
            return f2;
        }
        int n2 = 0;
        int n3 = n - n2;
        while (n3 > 1) {
            int n4 = n2 + n3 / 2;
            if (f3 >= fArray[n4]) {
                n2 = n4;
            } else {
                n = n4;
            }
            n3 = n - n2;
        }
        return fArray2[n2] * f3 + fArray3[n2];
    }

    public PiecewiseOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, float[][][] fArray) {
        super(renderedImage, imageLayout, map, true);
        int n = this.sampleModel.getNumBands();
        this.initFields(n, fArray);
        boolean bl = this.isByteData = this.sampleModel.getTransferType() == 0;
        if (this.isByteData) {
            this.createLUT();
            this.unsetFields();
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        byte[][] byArray2 = this.lut.getByteData();
        for (int i = 0; i < 3; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i >= byArray2.length ? 0 : i];
            int n = byArray3.length;
            for (int j = 0; j < n; ++j) {
                byArray3[j] = byArray4[byArray3[j] & 0xFF];
            }
        }
    }

    private void initFields(int n, float[][][] fArray) {
        this.abscissas = new float[n][];
        this.slopes = new float[n][];
        this.intercepts = new float[n][];
        this.minOrdinates = new float[n];
        this.maxOrdinates = new float[n];
        for (int i = 0; i < n; ++i) {
            this.abscissas[i] = fArray.length == 1 ? fArray[0][0] : fArray[i][0];
            int n2 = this.abscissas[i].length - 1;
            this.minOrdinates[i] = fArray.length == 1 ? fArray[0][1][0] : fArray[i][1][0];
            this.maxOrdinates[i] = fArray.length == 1 ? fArray[0][1][n2] : fArray[i][1][n2];
            this.slopes[i] = new float[n2];
            this.intercepts[i] = new float[n2];
            float[] fArray2 = this.abscissas[i];
            float[] fArray3 = fArray.length == 1 ? fArray[0][1] : fArray[i][1];
            float[] fArray4 = this.slopes[i];
            float[] fArray5 = this.intercepts[i];
            for (int j = 0; j < n2; ++j) {
                int n3 = j + 1;
                fArray4[j] = (fArray3[n3] - fArray3[j]) / (fArray2[n3] - fArray2[j]);
                fArray5[j] = fArray3[j] - fArray2[j] * fArray4[j];
            }
        }
    }

    private void unsetFields() {
        this.abscissas = null;
        this.slopes = null;
        this.intercepts = null;
        this.minOrdinates = null;
        this.maxOrdinates = null;
    }

    private void createLUT() {
        int n = this.abscissas.length;
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byArrayArray[i] = new byte[256];
            byte[] byArray = byArrayArray[i];
            float[] fArray = this.abscissas[i];
            float[] fArray2 = this.slopes[i];
            float[] fArray3 = this.intercepts[i];
            float f = this.minOrdinates[i];
            float f2 = this.maxOrdinates[i];
            for (int j = 0; j < 256; ++j) {
                byArray[j] = ImageUtil.clampRoundByte(PiecewiseOpImage.binarySearch(fArray, f, f2, fArray2, fArray3, j));
            }
        }
        this.lut = new LookupTableJAI(byArrayArray);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        if (this.isByteData) {
            this.computeRectByte(rasterArray, writableRaster, rectangle);
        } else {
            RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
            RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
            switch (rasterAccessor.getDataType()) {
                case 1: {
                    this.computeRectUShort(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 2: {
                    this.computeRectShort(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 3: {
                    this.computeRectInt(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 4: {
                    this.computeRectFloat(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 5: {
                    this.computeRectDouble(rasterAccessor2, rasterAccessor);
                }
            }
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        this.lut.lookup(rasterArray[0], writableRaster, rectangle);
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            float[] fArray = this.abscissas[i];
            float[] fArray2 = this.slopes[i];
            float[] fArray3 = this.intercepts[i];
            float f = this.minOrdinates[i];
            float f2 = this.maxOrdinates[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    sArray3[n10] = ImageUtil.clampRoundUShort(PiecewiseOpImage.binarySearch(fArray, f, f2, fArray2, fArray3, sArray4[n11] & 0xFFFF));
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            float[] fArray = this.abscissas[i];
            float[] fArray2 = this.slopes[i];
            float[] fArray3 = this.intercepts[i];
            float f = this.minOrdinates[i];
            float f2 = this.maxOrdinates[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    sArray3[n10] = ImageUtil.clampRoundShort(PiecewiseOpImage.binarySearch(fArray, f, f2, fArray2, fArray3, sArray4[n11]));
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        for (int i = 0; i < n3; ++i) {
            int[] nArray5 = nArray2[i];
            int[] nArray6 = nArray4[i];
            int n8 = nArray[i];
            int n9 = nArray3[i];
            float[] fArray = this.abscissas[i];
            float[] fArray2 = this.slopes[i];
            float[] fArray3 = this.intercepts[i];
            float f = this.minOrdinates[i];
            float f2 = this.maxOrdinates[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    nArray5[n10] = ImageUtil.clampRoundInt(PiecewiseOpImage.binarySearch(fArray, f, f2, fArray2, fArray3, nArray6[n11]));
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        for (int i = 0; i < n3; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            float[] fArray5 = this.abscissas[i];
            float[] fArray6 = this.slopes[i];
            float[] fArray7 = this.intercepts[i];
            float f = this.minOrdinates[i];
            float f2 = this.maxOrdinates[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    fArray3[n10] = PiecewiseOpImage.binarySearch(fArray5, f, f2, fArray6, fArray7, fArray4[n11]);
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        for (int i = 0; i < n3; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            float[] fArray = this.abscissas[i];
            float[] fArray2 = this.slopes[i];
            float[] fArray3 = this.intercepts[i];
            float f = this.minOrdinates[i];
            float f2 = this.maxOrdinates[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    dArray3[n10] = PiecewiseOpImage.binarySearch(fArray, f, f2, fArray2, fArray3, (float)dArray4[n11]);
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }
}

