/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationTable;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleBicubicOpImage
extends ScaleOpImage {
    private int subsampleBits;
    private int one;
    private int[] tableDataHi = null;
    private int[] tableDataVi = null;
    private float[] tableDataHf = null;
    private float[] tableDataVf = null;
    private double[] tableDataHd = null;
    private double[] tableDataVd = null;
    private int precisionBits;
    private int round;
    private Rational half = new Rational(1L, 2L);
    InterpolationTable interpTable;
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;

    public ScaleBicubicOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.interpTable = (InterpolationTable)interpolation;
        this.one = 1 << this.subsampleBits;
        this.precisionBits = this.interpTable.getPrecisionBits();
        if (this.precisionBits > 0) {
            this.round = 1 << this.precisionBits - 1;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n7];
        int[] nArray4 = new int[n6];
        long l = n5;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n10 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n10 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n4;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n11 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n11 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        for (n = 0; n < n6; ++n) {
            nArray2[n] = (n11 - n2) * n8;
            nArray4[n] = (int)((float)l8 / (float)l9 * (float)this.one);
            n11 = (int)((long)n11 + this.invScaleXInt);
            if ((l8 += l10) < l9) continue;
            ++n11;
            l8 -= l9;
        }
        for (n = 0; n < n7; ++n) {
            nArray[n] = (n10 - n3) * n9;
            nArray3[n] = (int)((float)l3 / (float)l4 * (float)this.one);
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l3 += l5) < l4) continue;
            ++n10;
            l3 -= l4;
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.initTableDataI();
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 2: {
                this.initTableDataI();
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 1: {
                this.initTableDataI();
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 3: {
                this.initTableDataI();
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 4: {
                this.initTableDataF();
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 5: {
                this.initTableDataD();
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n5; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray5[i];
            int n9 = nArray6[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = nArray4[j];
                int n12 = nArray2[j] + n9;
                int n13 = n12 - n2;
                int n14 = n12 + n2;
                int n15 = n14 + n2;
                for (int k = 0; k < n3; ++k) {
                    int n16 = nArray3[k];
                    int n17 = nArray[k];
                    int n18 = n17 - n;
                    int n19 = n17 + n;
                    int n20 = n19 + n;
                    int n21 = byArray4[n18 + n13] & 0xFF;
                    int n22 = byArray4[n17 + n13] & 0xFF;
                    int n23 = byArray4[n19 + n13] & 0xFF;
                    int n24 = byArray4[n20 + n13] & 0xFF;
                    int n25 = byArray4[n18 + n12] & 0xFF;
                    int n26 = byArray4[n17 + n12] & 0xFF;
                    int n27 = byArray4[n19 + n12] & 0xFF;
                    int n28 = byArray4[n20 + n12] & 0xFF;
                    int n29 = byArray4[n18 + n14] & 0xFF;
                    int n30 = byArray4[n17 + n14] & 0xFF;
                    int n31 = byArray4[n19 + n14] & 0xFF;
                    int n32 = byArray4[n20 + n14] & 0xFF;
                    int n33 = byArray4[n18 + n15] & 0xFF;
                    int n34 = byArray4[n17 + n15] & 0xFF;
                    int n35 = byArray4[n19 + n15] & 0xFF;
                    int n36 = byArray4[n20 + n15] & 0xFF;
                    int n37 = 4 * n16;
                    int n38 = n37 + 1;
                    int n39 = n37 + 2;
                    int n40 = n37 + 3;
                    long l = (long)this.tableDataHi[n37] * (long)n21;
                    l += (long)this.tableDataHi[n38] * (long)n22;
                    l += (long)this.tableDataHi[n39] * (long)n23;
                    l += (long)this.tableDataHi[n40] * (long)n24;
                    long l2 = (long)this.tableDataHi[n37] * (long)n25;
                    l2 += (long)this.tableDataHi[n38] * (long)n26;
                    l2 += (long)this.tableDataHi[n39] * (long)n27;
                    l2 += (long)this.tableDataHi[n40] * (long)n28;
                    long l3 = (long)this.tableDataHi[n37] * (long)n29;
                    l3 += (long)this.tableDataHi[n38] * (long)n30;
                    l3 += (long)this.tableDataHi[n39] * (long)n31;
                    l3 += (long)this.tableDataHi[n40] * (long)n32;
                    long l4 = (long)this.tableDataHi[n37] * (long)n33;
                    l4 += (long)this.tableDataHi[n38] * (long)n34;
                    l4 += (long)this.tableDataHi[n39] * (long)n35;
                    l4 += (long)this.tableDataHi[n40] * (long)n36;
                    l = l + (long)this.round >> this.precisionBits;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    int n41 = 4 * n11;
                    long l5 = (long)this.tableDataVi[n41] * l;
                    l5 += (long)this.tableDataVi[n41 + 1] * l2;
                    l5 += (long)this.tableDataVi[n41 + 2] * l3;
                    int n42 = (int)((l5 += (long)this.tableDataVi[n41 + 3] * l4) + (long)this.round >> this.precisionBits);
                    if (n42 > 255) {
                        n42 = 255;
                    } else if (n42 < 0) {
                        n42 = 0;
                    }
                    byArray3[n10] = (byte)(n42 & 0xFF);
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n5; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray5[i];
            int n9 = nArray6[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = nArray4[j];
                int n12 = nArray2[j] + n9;
                int n13 = n12 - n2;
                int n14 = n12 + n2;
                int n15 = n14 + n2;
                for (int k = 0; k < n3; ++k) {
                    int n16 = nArray3[k];
                    int n17 = nArray[k];
                    int n18 = n17 - n;
                    int n19 = n17 + n;
                    int n20 = n19 + n;
                    short s = sArray4[n18 + n13];
                    short s2 = sArray4[n17 + n13];
                    short s3 = sArray4[n19 + n13];
                    short s4 = sArray4[n20 + n13];
                    short s5 = sArray4[n18 + n12];
                    short s6 = sArray4[n17 + n12];
                    short s7 = sArray4[n19 + n12];
                    short s8 = sArray4[n20 + n12];
                    short s9 = sArray4[n18 + n14];
                    short s10 = sArray4[n17 + n14];
                    short s11 = sArray4[n19 + n14];
                    short s12 = sArray4[n20 + n14];
                    short s13 = sArray4[n18 + n15];
                    short s14 = sArray4[n17 + n15];
                    short s15 = sArray4[n19 + n15];
                    short s16 = sArray4[n20 + n15];
                    int n21 = 4 * n16;
                    int n22 = n21 + 1;
                    int n23 = n21 + 2;
                    int n24 = n21 + 3;
                    long l = (long)this.tableDataHi[n21] * (long)s;
                    l += (long)this.tableDataHi[n22] * (long)s2;
                    l += (long)this.tableDataHi[n23] * (long)s3;
                    l += (long)this.tableDataHi[n24] * (long)s4;
                    long l2 = (long)this.tableDataHi[n21] * (long)s5;
                    l2 += (long)this.tableDataHi[n22] * (long)s6;
                    l2 += (long)this.tableDataHi[n23] * (long)s7;
                    l2 += (long)this.tableDataHi[n24] * (long)s8;
                    long l3 = (long)this.tableDataHi[n21] * (long)s9;
                    l3 += (long)this.tableDataHi[n22] * (long)s10;
                    l3 += (long)this.tableDataHi[n23] * (long)s11;
                    l3 += (long)this.tableDataHi[n24] * (long)s12;
                    long l4 = (long)this.tableDataHi[n21] * (long)s13;
                    l4 += (long)this.tableDataHi[n22] * (long)s14;
                    l4 += (long)this.tableDataHi[n23] * (long)s15;
                    l4 += (long)this.tableDataHi[n24] * (long)s16;
                    l = l + (long)this.round >> this.precisionBits;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    int n25 = 4 * n11;
                    long l5 = (long)this.tableDataVi[n25] * l;
                    l5 += (long)this.tableDataVi[n25 + 1] * l2;
                    l5 += (long)this.tableDataVi[n25 + 2] * l3;
                    int n26 = (int)((l5 += (long)this.tableDataVi[n25 + 3] * l4) + (long)this.round >> this.precisionBits);
                    if (n26 > Short.MAX_VALUE) {
                        n26 = Short.MAX_VALUE;
                    } else if (n26 < Short.MIN_VALUE) {
                        n26 = Short.MIN_VALUE;
                    }
                    sArray3[n10] = (short)n26;
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n5; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray5[i];
            int n9 = nArray6[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = nArray4[j];
                int n12 = nArray2[j] + n9;
                int n13 = n12 - n2;
                int n14 = n12 + n2;
                int n15 = n14 + n2;
                for (int k = 0; k < n3; ++k) {
                    int n16 = nArray3[k];
                    int n17 = nArray[k];
                    int n18 = n17 - n;
                    int n19 = n17 + n;
                    int n20 = n19 + n;
                    int n21 = sArray4[n18 + n13] & 0xFFFF;
                    int n22 = sArray4[n17 + n13] & 0xFFFF;
                    int n23 = sArray4[n19 + n13] & 0xFFFF;
                    int n24 = sArray4[n20 + n13] & 0xFFFF;
                    int n25 = sArray4[n18 + n12] & 0xFFFF;
                    int n26 = sArray4[n17 + n12] & 0xFFFF;
                    int n27 = sArray4[n19 + n12] & 0xFFFF;
                    int n28 = sArray4[n20 + n12] & 0xFFFF;
                    int n29 = sArray4[n18 + n14] & 0xFFFF;
                    int n30 = sArray4[n17 + n14] & 0xFFFF;
                    int n31 = sArray4[n19 + n14] & 0xFFFF;
                    int n32 = sArray4[n20 + n14] & 0xFFFF;
                    int n33 = sArray4[n18 + n15] & 0xFFFF;
                    int n34 = sArray4[n17 + n15] & 0xFFFF;
                    int n35 = sArray4[n19 + n15] & 0xFFFF;
                    int n36 = sArray4[n20 + n15] & 0xFFFF;
                    int n37 = 4 * n16;
                    int n38 = n37 + 1;
                    int n39 = n37 + 2;
                    int n40 = n37 + 3;
                    long l = (long)this.tableDataHi[n37] * (long)n21;
                    l += (long)this.tableDataHi[n38] * (long)n22;
                    l += (long)this.tableDataHi[n39] * (long)n23;
                    l += (long)this.tableDataHi[n40] * (long)n24;
                    long l2 = (long)this.tableDataHi[n37] * (long)n25;
                    l2 += (long)this.tableDataHi[n38] * (long)n26;
                    l2 += (long)this.tableDataHi[n39] * (long)n27;
                    l2 += (long)this.tableDataHi[n40] * (long)n28;
                    long l3 = (long)this.tableDataHi[n37] * (long)n29;
                    l3 += (long)this.tableDataHi[n38] * (long)n30;
                    l3 += (long)this.tableDataHi[n39] * (long)n31;
                    l3 += (long)this.tableDataHi[n40] * (long)n32;
                    long l4 = (long)this.tableDataHi[n37] * (long)n33;
                    l4 += (long)this.tableDataHi[n38] * (long)n34;
                    l4 += (long)this.tableDataHi[n39] * (long)n35;
                    l4 += (long)this.tableDataHi[n40] * (long)n36;
                    l = l + (long)this.round >> this.precisionBits;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    int n41 = 4 * n11;
                    long l5 = (long)this.tableDataVi[n41] * l;
                    l5 += (long)this.tableDataVi[n41 + 1] * l2;
                    l5 += (long)this.tableDataVi[n41 + 2] * l3;
                    int n42 = (int)((l5 += (long)this.tableDataVi[n41 + 3] * l4) + (long)this.round >> this.precisionBits);
                    if (n42 > 65536) {
                        n42 = 65536;
                    } else if (n42 < 0) {
                        n42 = 0;
                    }
                    sArray3[n10] = (short)(n42 & 0xFFFF);
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        int[][] nArray5 = rasterAccessor2.getIntDataArrays();
        int[] nArray6 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int[][] nArray7 = rasterAccessor.getIntDataArrays();
        int[] nArray8 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n5; ++i) {
            int[] nArray9 = nArray5[i];
            int[] nArray10 = nArray7[i];
            int n8 = nArray6[i];
            int n9 = nArray8[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                long l = nArray4[j];
                int n11 = nArray2[j] + n9;
                int n12 = n11 - n2;
                int n13 = n11 + n2;
                int n14 = n13 + n2;
                for (int k = 0; k < n3; ++k) {
                    int n15;
                    long l2 = nArray3[k];
                    int n16 = nArray[k];
                    int n17 = n16 - n;
                    int n18 = n16 + n;
                    int n19 = n18 + n;
                    int n20 = nArray10[n17 + n12];
                    int n21 = nArray10[n16 + n12];
                    int n22 = nArray10[n18 + n12];
                    int n23 = nArray10[n19 + n12];
                    int n24 = nArray10[n17 + n11];
                    int n25 = nArray10[n16 + n11];
                    int n26 = nArray10[n18 + n11];
                    int n27 = nArray10[n19 + n11];
                    int n28 = nArray10[n17 + n13];
                    int n29 = nArray10[n16 + n13];
                    int n30 = nArray10[n18 + n13];
                    int n31 = nArray10[n19 + n13];
                    int n32 = nArray10[n17 + n14];
                    int n33 = nArray10[n16 + n14];
                    int n34 = nArray10[n18 + n14];
                    int n35 = nArray10[n19 + n14];
                    int n36 = (int)(4L * l2);
                    int n37 = n36 + 1;
                    int n38 = n36 + 2;
                    int n39 = n36 + 3;
                    long l3 = (long)this.tableDataHi[n36] * (long)n20;
                    l3 += (long)this.tableDataHi[n37] * (long)n21;
                    l3 += (long)this.tableDataHi[n38] * (long)n22;
                    l3 += (long)this.tableDataHi[n39] * (long)n23;
                    long l4 = (long)this.tableDataHi[n36] * (long)n24;
                    l4 += (long)this.tableDataHi[n37] * (long)n25;
                    l4 += (long)this.tableDataHi[n38] * (long)n26;
                    l4 += (long)this.tableDataHi[n39] * (long)n27;
                    long l5 = (long)this.tableDataHi[n36] * (long)n28;
                    l5 += (long)this.tableDataHi[n37] * (long)n29;
                    l5 += (long)this.tableDataHi[n38] * (long)n30;
                    l5 += (long)this.tableDataHi[n39] * (long)n31;
                    long l6 = (long)this.tableDataHi[n36] * (long)n32;
                    l6 += (long)this.tableDataHi[n37] * (long)n33;
                    l6 += (long)this.tableDataHi[n38] * (long)n34;
                    l6 += (long)this.tableDataHi[n39] * (long)n35;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    l5 = l5 + (long)this.round >> this.precisionBits;
                    l6 = l6 + (long)this.round >> this.precisionBits;
                    int n40 = (int)(4L * l);
                    long l7 = (long)this.tableDataVi[n40] * l3;
                    l7 += (long)this.tableDataVi[n40 + 1] * l4;
                    l7 += (long)this.tableDataVi[n40 + 2] * l5;
                    nArray9[n10] = n15 = (int)((l7 += (long)this.tableDataVi[n40 + 3] * l6) + (long)this.round >> this.precisionBits);
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n5; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n8 = nArray5[i];
            int n9 = nArray6[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = nArray4[j];
                int n12 = nArray2[j] + n9;
                int n13 = n12 - n2;
                int n14 = n12 + n2;
                int n15 = n14 + n2;
                for (int k = 0; k < n3; ++k) {
                    int n16 = nArray3[k];
                    int n17 = nArray[k];
                    int n18 = n17 - n;
                    int n19 = n17 + n;
                    int n20 = n19 + n;
                    float f = fArray4[n18 + n13];
                    float f2 = fArray4[n17 + n13];
                    float f3 = fArray4[n19 + n13];
                    float f4 = fArray4[n20 + n13];
                    float f5 = fArray4[n18 + n12];
                    float f6 = fArray4[n17 + n12];
                    float f7 = fArray4[n19 + n12];
                    float f8 = fArray4[n20 + n12];
                    float f9 = fArray4[n18 + n14];
                    float f10 = fArray4[n17 + n14];
                    float f11 = fArray4[n19 + n14];
                    float f12 = fArray4[n20 + n14];
                    float f13 = fArray4[n18 + n15];
                    float f14 = fArray4[n17 + n15];
                    float f15 = fArray4[n19 + n15];
                    float f16 = fArray4[n20 + n15];
                    int n21 = 4 * n16;
                    int n22 = n21 + 1;
                    int n23 = n21 + 2;
                    int n24 = n21 + 3;
                    double d = this.tableDataHf[n21] * f;
                    d += (double)(this.tableDataHf[n22] * f2);
                    d += (double)(this.tableDataHf[n23] * f3);
                    d += (double)(this.tableDataHf[n24] * f4);
                    double d2 = this.tableDataHf[n21] * f5;
                    d2 += (double)(this.tableDataHf[n22] * f6);
                    d2 += (double)(this.tableDataHf[n23] * f7);
                    d2 += (double)(this.tableDataHf[n24] * f8);
                    double d3 = this.tableDataHf[n21] * f9;
                    d3 += (double)(this.tableDataHf[n22] * f10);
                    d3 += (double)(this.tableDataHf[n23] * f11);
                    d3 += (double)(this.tableDataHf[n24] * f12);
                    double d4 = this.tableDataHf[n21] * f13;
                    d4 += (double)(this.tableDataHf[n22] * f14);
                    d4 += (double)(this.tableDataHf[n23] * f15);
                    d4 += (double)(this.tableDataHf[n24] * f16);
                    int n25 = 4 * n11;
                    double d5 = (double)this.tableDataVf[n25] * d;
                    d5 += (double)this.tableDataVf[n25 + 1] * d2;
                    d5 += (double)this.tableDataVf[n25 + 2] * d3;
                    if ((d5 += (double)this.tableDataVf[n25 + 3] * d4) > 3.4028234663852886E38) {
                        d5 = 3.4028234663852886E38;
                    } else if (d5 < -3.4028234663852886E38) {
                        d5 = -3.4028234663852886E38;
                    }
                    fArray3[n10] = (float)d5;
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n5; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n8 = nArray5[i];
            int n9 = nArray6[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = nArray4[j];
                int n12 = nArray2[j] + n9;
                int n13 = n12 - n2;
                int n14 = n12 + n2;
                int n15 = n14 + n2;
                for (int k = 0; k < n3; ++k) {
                    int n16 = nArray3[k];
                    int n17 = nArray[k];
                    int n18 = n17 - n;
                    int n19 = n17 + n;
                    int n20 = n19 + n;
                    double d = dArray4[n18 + n13];
                    double d2 = dArray4[n17 + n13];
                    double d3 = dArray4[n19 + n13];
                    double d4 = dArray4[n20 + n13];
                    double d5 = dArray4[n18 + n12];
                    double d6 = dArray4[n17 + n12];
                    double d7 = dArray4[n19 + n12];
                    double d8 = dArray4[n20 + n12];
                    double d9 = dArray4[n18 + n14];
                    double d10 = dArray4[n17 + n14];
                    double d11 = dArray4[n19 + n14];
                    double d12 = dArray4[n20 + n14];
                    double d13 = dArray4[n18 + n15];
                    double d14 = dArray4[n17 + n15];
                    double d15 = dArray4[n19 + n15];
                    double d16 = dArray4[n20 + n15];
                    int n21 = 4 * n16;
                    int n22 = n21 + 1;
                    int n23 = n21 + 2;
                    int n24 = n21 + 3;
                    double d17 = this.tableDataHd[n21] * d;
                    d17 += this.tableDataHd[n22] * d2;
                    d17 += this.tableDataHd[n23] * d3;
                    d17 += this.tableDataHd[n24] * d4;
                    double d18 = this.tableDataHd[n21] * d5;
                    d18 += this.tableDataHd[n22] * d6;
                    d18 += this.tableDataHd[n23] * d7;
                    d18 += this.tableDataHd[n24] * d8;
                    double d19 = this.tableDataHd[n21] * d9;
                    d19 += this.tableDataHd[n22] * d10;
                    d19 += this.tableDataHd[n23] * d11;
                    d19 += this.tableDataHd[n24] * d12;
                    double d20 = this.tableDataHd[n21] * d13;
                    d20 += this.tableDataHd[n22] * d14;
                    d20 += this.tableDataHd[n23] * d15;
                    int n25 = 4 * n11;
                    double d21 = this.tableDataVd[n25] * d17;
                    d21 += this.tableDataVd[n25 + 1] * d18;
                    d21 += this.tableDataVd[n25 + 2] * d19;
                    dArray3[n10] = d21 += this.tableDataVd[n25 + 3] * (d20 += this.tableDataHd[n24] * d16);
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private synchronized void initTableDataI() {
        if (this.tableDataHi == null || this.tableDataVi == null) {
            this.tableDataHi = this.interpTable.getHorizontalTableData();
            this.tableDataVi = this.interpTable.getVerticalTableData();
        }
    }

    private synchronized void initTableDataF() {
        if (this.tableDataHf == null || this.tableDataVf == null) {
            this.tableDataHf = this.interpTable.getHorizontalTableDataFloat();
            this.tableDataVf = this.interpTable.getVerticalTableDataFloat();
        }
    }

    private synchronized void initTableDataD() {
        if (this.tableDataHd == null || this.tableDataVd == null) {
            this.tableDataHd = this.interpTable.getHorizontalTableDataDouble();
            this.tableDataVd = this.interpTable.getVerticalTableDataDouble();
        }
    }
}

