/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.remote.JAIServerConfigurationSpi;
import com.sun.media.jai.rmi.ImageServer;
import com.sun.media.jai.rmi.JAIRMIUtil;
import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.rmi.RMIImageImpl;
import com.sun.media.jai.rmi.RMIServerProxy;
import com.sun.media.jai.rmi.RenderableRMIServerProxy;
import com.sun.media.jai.rmi.SerializableRenderableImage;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.Service;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.jai.CollectionImage;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.RenderingChangeEvent;
import javax.media.jai.registry.CRIFRegistry;
import javax.media.jai.remote.NegotiableCapability;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileEncoderFactory;
import javax.media.jai.util.ImagingListener;

public class JAIRMIImageServer
extends UnicastRemoteObject
implements ImageServer {
    private boolean DEBUG = true;
    public static final Object NULL_PROPERTY = RMIImageImpl.NULL_PROPERTY;
    private static long idCounter = 0L;
    private static Hashtable nodes = new Hashtable();
    private static Hashtable negotiated = new Hashtable();
    private static Hashtable refCount = new Hashtable();
    static /* synthetic */ Class class$javax$media$jai$tilecodec$TileEncoderFactory;
    static /* synthetic */ Class class$javax$media$jai$OperationDescriptor;
    static /* synthetic */ Class class$com$sun$media$jai$remote$JAIServerConfigurationSpi;
    static /* synthetic */ Class class$com$sun$media$jai$rmi$JAIRMIImageServer;

    private static PlanarImage getSource(Long l) throws RemoteException {
        Object var1_1;
        block3: {
            block2: {
                var1_1 = null;
                if (nodes == null) break block2;
                Object v = nodes.get(l);
                var1_1 = v;
                if (v != null) break block3;
            }
            throw new RemoteException(JaiI18N.getString("RMIImageImpl2"));
        }
        return var1_1;
    }

    private static PropertySource getPropertySource(Long l) throws RemoteException {
        Object v = nodes.get(l);
        return (PropertySource)v;
    }

    public JAIRMIImageServer(int n) throws RemoteException {
        super(n);
    }

    public synchronized Long getRemoteID() throws RemoteException {
        return new Long(++idCounter);
    }

    public synchronized void dispose(Long l) throws RemoteException {
        int n = (Integer)refCount.get(l);
        if (n == 1) {
            if (nodes != null) {
                nodes.remove(l);
                negotiated.remove(l);
            }
            refCount.remove(l);
        } else {
            if (--n == 0) {
                refCount.remove(l);
            }
            refCount.put(l, new Integer(n));
        }
    }

    public void incrementRefCount(Long l) throws RemoteException {
        Integer n = (Integer)refCount.get(l);
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        refCount.put(l, new Integer(++n2));
    }

    public Object getProperty(Long l, String string) throws RemoteException {
        PropertySource propertySource = JAIRMIImageServer.getPropertySource(l);
        Object object = propertySource.getProperty(string);
        if (object == null || object.equals(Image.UndefinedProperty)) {
            object = NULL_PROPERTY;
        }
        return object;
    }

    public String[] getPropertyNames(Long l) throws RemoteException {
        PropertySource propertySource = JAIRMIImageServer.getPropertySource(l);
        return propertySource.getPropertyNames();
    }

    public String[] getPropertyNames(String string) throws RemoteException {
        return CRIFRegistry.get(null, string).getPropertyNames();
    }

    public int getMinX(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getMinX();
    }

    public int getMaxX(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getMaxX();
    }

    public int getMinY(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getMinY();
    }

    public int getMaxY(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getMaxY();
    }

    public int getWidth(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getWidth();
    }

    public int getHeight(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getHeight();
    }

    public int getTileWidth(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getTileWidth();
    }

    public int getTileHeight(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getTileHeight();
    }

    public int getTileGridXOffset(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getTileGridXOffset();
    }

    public int getTileGridYOffset(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getTileGridYOffset();
    }

    public int getMinTileX(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getMinTileX();
    }

    public int getNumXTiles(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getNumXTiles();
    }

    public int getMinTileY(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getMinTileY();
    }

    public int getNumYTiles(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getNumYTiles();
    }

    public int getMaxTileX(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getMaxTileX();
    }

    public int getMaxTileY(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getMaxTileY();
    }

    public SerializableState getSampleModel(Long l) throws RemoteException {
        return SerializerFactory.getState(JAIRMIImageServer.getSource(l).getSampleModel(), null);
    }

    public SerializableState getColorModel(Long l) throws RemoteException {
        return SerializerFactory.getState(JAIRMIImageServer.getSource(l).getColorModel(), null);
    }

    public Rectangle getBounds(Long l) throws RemoteException {
        return JAIRMIImageServer.getSource(l).getBounds();
    }

    public SerializableState getTile(Long l, int n, int n2) throws RemoteException {
        Raster raster = JAIRMIImageServer.getSource(l).getTile(n, n2);
        return SerializerFactory.getState(raster, null);
    }

    public byte[] getCompressedTile(Long l, int n, int n2) throws RemoteException {
        TileCodecParameterList tileCodecParameterList = null;
        TileEncoderFactory tileEncoderFactory = null;
        NegotiableCapability negotiableCapability = null;
        if (negotiated != null) {
            negotiableCapability = ((NegotiableCapabilitySet)negotiated.get(l)).getNegotiatedValue("tileCodec");
        }
        if (negotiableCapability != null) {
            Object object;
            Object object2;
            Object object3;
            String string = negotiableCapability.getCategory();
            String string2 = negotiableCapability.getCapabilityName();
            List list = negotiableCapability.getGenerators();
            Object object4 = list.iterator();
            while (object4.hasNext()) {
                Class clazz = (Class)object4.next();
                if (tileEncoderFactory != null || !(class$javax$media$jai$tilecodec$TileEncoderFactory == null ? JAIRMIImageServer.class$("javax.media.jai.tilecodec.TileEncoderFactory") : class$javax$media$jai$tilecodec$TileEncoderFactory).isAssignableFrom(clazz)) continue;
                try {
                    tileEncoderFactory = (TileEncoderFactory)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException.getMessage());
                }
            }
            if (tileEncoderFactory == null) {
                throw new RuntimeException(JaiI18N.getString("JAIRMIImageServer0"));
            }
            object4 = (TileCodecDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor("tileEncoder", string2);
            if (!object4.includesSampleModelInfo() || !object4.includesLocationInfo()) {
                throw new RuntimeException(JaiI18N.getString("JAIRMIImageServer1"));
            }
            ParameterListDescriptor parameterListDescriptor = object4.getParameterListDescriptor("tileEncoder");
            tileCodecParameterList = new TileCodecParameterList(string2, new String[]{"tileEncoder"}, parameterListDescriptor);
            if (parameterListDescriptor != null && (object3 = parameterListDescriptor.getParamNames()) != null) {
                for (int i = 0; i < ((String[])object3).length; ++i) {
                    object2 = object3[i];
                    try {
                        object = negotiableCapability.getNegotiatedValue((String)object2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    tileCodecParameterList.setParameter((String)object2, object);
                }
            }
            object3 = JAIRMIImageServer.getSource(l).getTile(n, n2);
            object2 = new ByteArrayOutputStream();
            object = tileEncoderFactory.createEncoder((OutputStream)object2, tileCodecParameterList, ((Raster)object3).getSampleModel());
            try {
                object.encode((Raster)object3);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
            return ((ByteArrayOutputStream)object2).toByteArray();
        }
        throw new RuntimeException(JaiI18N.getString("JAIRMIImageServer2"));
    }

    public SerializableState getData(Long l) throws RemoteException {
        return SerializerFactory.getState(JAIRMIImageServer.getSource(l).getData(), null);
    }

    public SerializableState getData(Long l, Rectangle rectangle) throws RemoteException {
        if (rectangle == null) {
            return this.getData(l);
        }
        rectangle = rectangle.intersection(this.getBounds(l));
        return SerializerFactory.getState(JAIRMIImageServer.getSource(l).getData(rectangle), null);
    }

    public SerializableState copyData(Long l, Rectangle rectangle) throws RemoteException {
        return this.getData(l, rectangle);
    }

    public void createRenderedOp(Long l, String string, ParameterBlock parameterBlock, SerializableState serializableState) throws RemoteException {
        RenderingHints renderingHints = (RenderingHints)serializableState.getObject();
        JAIRMIUtil.checkServerParameters(parameterBlock, nodes);
        RenderedOp renderedOp = new RenderedOp(string, parameterBlock, renderingHints);
        renderedOp.removeSinks();
        nodes.put(l, renderedOp);
    }

    public boolean getRendering(Long l) throws RemoteException {
        RenderedOp renderedOp = this.getNode(l);
        return renderedOp.getRendering() != null;
    }

    public RenderedOp getNode(Long l) throws RemoteException {
        return (RenderedOp)nodes.get(l);
    }

    public synchronized void setRenderedSource(Long l, RenderedImage renderedImage, int n) throws RemoteException {
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        Object v = nodes.get(l);
        if (v instanceof RenderedOp) {
            RenderedOp renderedOp = (RenderedOp)v;
            renderedOp.setSource(planarImage, n);
            ((PlanarImage)renderedOp.getSourceObject(n)).removeSinks();
        } else if (v instanceof RenderableOp) {
            ((RenderableOp)v).setSource(planarImage, n);
        }
    }

    public synchronized void setRenderedSource(Long l, RenderedOp renderedOp, int n) throws RemoteException {
        Object v = nodes.get(l);
        if (v instanceof RenderedOp) {
            RenderedOp renderedOp2 = (RenderedOp)v;
            renderedOp2.setSource(renderedOp.getRendering(), n);
            ((PlanarImage)renderedOp2.getSourceObject(n)).removeSinks();
        } else if (v instanceof RenderableOp) {
            ((RenderableOp)v).setSource(renderedOp.getRendering(), n);
        }
    }

    public synchronized void setRenderedSource(Long l, Long l2, int n) throws RemoteException {
        Object v = nodes.get(l);
        if (v instanceof RenderedOp) {
            RenderedOp renderedOp = (RenderedOp)v;
            renderedOp.setSource(nodes.get(l2), n);
            ((PlanarImage)nodes.get(l2)).removeSinks();
        } else if (v instanceof RenderableOp) {
            ((RenderableOp)v).setSource(nodes.get(l2), n);
        }
    }

    public synchronized void setRenderedSource(Long l, Long l2, String string, String string2, int n) throws RemoteException {
        Object v = nodes.get(l);
        if (v instanceof RenderedOp) {
            RenderedOp renderedOp = (RenderedOp)v;
            renderedOp.setSource(new RMIServerProxy(string + "::" + l2, string2, null), n);
            ((PlanarImage)renderedOp.getSourceObject(n)).removeSinks();
        } else if (v instanceof RenderableOp) {
            ((RenderableOp)v).setSource(new RMIServerProxy(string + "::" + l2, string2, null), n);
        }
    }

    public float getRenderableMinX(Long l) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l);
        return renderableImage.getMinX();
    }

    public float getRenderableMinY(Long l) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l);
        return renderableImage.getMinY();
    }

    public float getRenderableWidth(Long l) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l);
        return renderableImage.getWidth();
    }

    public float getRenderableHeight(Long l) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l);
        return renderableImage.getHeight();
    }

    public RenderedImage createScaledRendering(Long l, int n, int n2, SerializableState serializableState) throws RemoteException {
        RenderingHints renderingHints;
        RenderableImage renderableImage = (RenderableImage)nodes.get(l);
        RenderedImage renderedImage = renderableImage.createScaledRendering(n, n2, renderingHints = (RenderingHints)serializableState.getObject());
        if (renderedImage instanceof Serializable) {
            return renderedImage;
        }
        return new SerializableRenderedImage(renderedImage);
    }

    public RenderedImage createDefaultRendering(Long l) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l);
        RenderedImage renderedImage = renderableImage.createDefaultRendering();
        if (renderedImage instanceof Serializable) {
            return renderedImage;
        }
        return new SerializableRenderedImage(renderedImage);
    }

    public RenderedImage createRendering(Long l, SerializableState serializableState) throws RemoteException {
        RenderContext renderContext;
        RenderableImage renderableImage = (RenderableImage)nodes.get(l);
        RenderedImage renderedImage = renderableImage.createRendering(renderContext = (RenderContext)serializableState.getObject());
        if (renderedImage instanceof Serializable) {
            return renderedImage;
        }
        return new SerializableRenderedImage(renderedImage);
    }

    public synchronized void createRenderableOp(Long l, String string, ParameterBlock parameterBlock) throws RemoteException {
        RenderableOp renderableOp = new RenderableOp(string, parameterBlock);
        nodes.put(l, renderableOp);
    }

    public synchronized Long getRendering(Long l, SerializableState serializableState) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l);
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderableOp.createRendering((RenderContext)serializableState.getObject()));
        Long l2 = this.getRemoteID();
        nodes.put(l2, planarImage);
        this.setServerNegotiatedValues(l2, (NegotiableCapabilitySet)negotiated.get(l));
        return l2;
    }

    public synchronized void setRenderableSource(Long l, Long l2, int n) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l);
        Object v = nodes.get(l2);
        if (v instanceof RenderableOp) {
            renderableOp.setSource((RenderableOp)v, n);
        } else if (v instanceof RenderedImage) {
            renderableOp.setSource(PlanarImage.wrapRenderedImage((RenderedImage)v), n);
        }
    }

    public synchronized void setRenderableSource(Long l, Long l2, String string, String string2, int n) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l);
        renderableOp.setSource(new RMIServerProxy(string + "::" + l2, string2, null), n);
    }

    public synchronized void setRenderableRMIServerProxyAsSource(Long l, Long l2, String string, String string2, int n) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l);
        renderableOp.setSource(new RenderableRMIServerProxy(string, string2, null, l2), n);
    }

    public synchronized void setRenderableSource(Long l, RenderableOp renderableOp, int n) throws RemoteException {
        RenderableOp renderableOp2 = (RenderableOp)nodes.get(l);
        renderableOp2.setSource(renderableOp, n);
    }

    public synchronized void setRenderableSource(Long l, SerializableRenderableImage serializableRenderableImage, int n) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l);
        renderableOp.setSource(serializableRenderableImage, n);
    }

    public synchronized void setRenderableSource(Long l, RenderedImage renderedImage, int n) throws RemoteException {
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        RenderableOp renderableOp = (RenderableOp)nodes.get(l);
        renderableOp.setSource(planarImage, n);
    }

    public SerializableState mapRenderContext(int n, Long l, String string, SerializableState serializableState) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l);
        ContextualRenderedImageFactory contextualRenderedImageFactory = CRIFRegistry.get(renderableOp.getRegistry(), string);
        if (contextualRenderedImageFactory == null) {
            throw new RuntimeException(JaiI18N.getString("JAIRMIImageServer3"));
        }
        RenderContext renderContext = contextualRenderedImageFactory.mapRenderContext(n, (RenderContext)serializableState.getObject(), renderableOp.getParameterBlock(), renderableOp);
        return SerializerFactory.getState(renderContext, null);
    }

    public SerializableState getBounds2D(Long l, String string) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l);
        ContextualRenderedImageFactory contextualRenderedImageFactory = CRIFRegistry.get(renderableOp.getRegistry(), string);
        if (contextualRenderedImageFactory == null) {
            throw new RuntimeException(JaiI18N.getString("JAIRMIImageServer3"));
        }
        Rectangle2D rectangle2D = contextualRenderedImageFactory.getBounds2D(renderableOp.getParameterBlock());
        return SerializerFactory.getState(rectangle2D, null);
    }

    public boolean isDynamic(String string) throws RemoteException {
        return CRIFRegistry.get(null, string).isDynamic();
    }

    public boolean isDynamic(Long l) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l);
        return renderableImage.isDynamic();
    }

    public String[] getServerSupportedOperationNames() throws RemoteException {
        return JAI.getDefaultInstance().getOperationRegistry().getDescriptorNames(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = JAIRMIImageServer.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor);
    }

    public List getOperationDescriptors() throws RemoteException {
        return JAI.getDefaultInstance().getOperationRegistry().getDescriptors(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = JAIRMIImageServer.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor);
    }

    public synchronized SerializableState getInvalidRegion(Long l, ParameterBlock parameterBlock, SerializableState serializableState, ParameterBlock parameterBlock2, SerializableState serializableState2) throws RemoteException {
        Serializable serializable;
        Object object;
        RenderingHints renderingHints = (RenderingHints)serializableState.getObject();
        RenderingHints renderingHints2 = (RenderingHints)serializableState2.getObject();
        RenderedOp renderedOp = (RenderedOp)nodes.get(l);
        OperationDescriptor operationDescriptor = (OperationDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor("rendered", renderedOp.getOperationName());
        boolean bl = false;
        if (parameterBlock == parameterBlock2) {
            bl = true;
        }
        Vector<Object> vector = parameterBlock.getSources();
        parameterBlock.removeSources();
        Vector vector2 = JAIRMIUtil.replaceIdWithSources(vector, nodes, renderedOp.getOperationName(), renderedOp.getRenderingHints());
        parameterBlock.setSources(vector2);
        if (bl) {
            parameterBlock2 = parameterBlock;
        } else {
            object = parameterBlock2.getSources();
            parameterBlock2.removeSources();
            serializable = JAIRMIUtil.replaceIdWithSources(object, nodes, renderedOp.getOperationName(), renderedOp.getRenderingHints());
            parameterBlock2.setSources((Vector<Object>)serializable);
        }
        object = operationDescriptor.getInvalidRegion("rendered", parameterBlock, renderingHints, parameterBlock2, renderingHints2, renderedOp);
        serializable = SerializerFactory.getState((Shape)object, null);
        return serializable;
    }

    public Rectangle mapSourceRect(Long l, Rectangle rectangle, int n) throws RemoteException {
        RenderedOp renderedOp = (RenderedOp)nodes.get(l);
        OpImage opImage = (OpImage)renderedOp.getRendering();
        return opImage.mapSourceRect(rectangle, n);
    }

    public Rectangle mapDestRect(Long l, Rectangle rectangle, int n) throws RemoteException {
        RenderedOp renderedOp = (RenderedOp)nodes.get(l);
        OpImage opImage = (OpImage)renderedOp.getRendering();
        return opImage.mapDestRect(rectangle, n);
    }

    public synchronized Long handleEvent(Long l, String string, Object object, Object object2) throws RemoteException {
        RenderedOp renderedOp = (RenderedOp)nodes.get(l);
        PlanarImage planarImage = renderedOp.getRendering();
        Long l2 = this.getRemoteID();
        nodes.put(l2, planarImage);
        this.setServerNegotiatedValues(l2, (NegotiableCapabilitySet)negotiated.get(l));
        if (string.equals("operationname")) {
            renderedOp.setOperationName((String)object2);
        } else if (string.equals("parameterblock")) {
            ParameterBlock parameterBlock = (ParameterBlock)object2;
            Vector<Object> vector = parameterBlock.getSources();
            parameterBlock.removeSources();
            JAIRMIUtil.checkServerParameters(parameterBlock, nodes);
            Vector vector2 = JAIRMIUtil.replaceIdWithSources(vector, nodes, renderedOp.getOperationName(), renderedOp.getRenderingHints());
            parameterBlock.setSources(vector2);
            renderedOp.setParameterBlock(parameterBlock);
            Vector<Object> vector3 = parameterBlock.getSources();
            if (vector3 != null && vector3.size() > 0) {
                Iterator<Object> iterator = vector3.iterator();
                while (iterator.hasNext()) {
                    Object object3 = iterator.next();
                    if (object3 instanceof PlanarImage) {
                        ((PlanarImage)object3).removeSinks();
                        continue;
                    }
                    if (!(object3 instanceof CollectionImage)) continue;
                    ((CollectionImage)object3).removeSinks();
                }
            }
        } else if (string.equals("sources")) {
            Vector vector = JAIRMIUtil.replaceIdWithSources((Vector)object2, nodes, renderedOp.getOperationName(), renderedOp.getRenderingHints());
            renderedOp.setSources(vector);
            if (vector != null && vector.size() > 0) {
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof PlanarImage) {
                        ((PlanarImage)e).removeSinks();
                        continue;
                    }
                    if (!(e instanceof CollectionImage)) continue;
                    ((CollectionImage)e).removeSinks();
                }
            }
        } else if (string.equals("parameters")) {
            Vector vector = (Vector)object2;
            JAIRMIUtil.checkServerParameters(vector, nodes);
            renderedOp.setParameters(vector);
        } else if (string.equals("renderinghints")) {
            SerializableState serializableState = (SerializableState)object2;
            renderedOp.setRenderingHints((RenderingHints)serializableState.getObject());
        }
        return l2;
    }

    public synchronized Long handleEvent(Long l, int n, SerializableState serializableState, Object object) throws RemoteException {
        RenderedOp renderedOp = (RenderedOp)nodes.get(l);
        PlanarImage planarImage = renderedOp.getRendering();
        Long l2 = this.getRemoteID();
        nodes.put(l2, planarImage);
        this.setServerNegotiatedValues(l2, (NegotiableCapabilitySet)negotiated.get(l));
        PlanarImage planarImage2 = null;
        PlanarImage planarImage3 = null;
        String string = null;
        Object var11_11 = null;
        if (object instanceof String) {
            boolean bl;
            string = (String)object;
            int n2 = string.indexOf("::");
            boolean bl2 = bl = n2 != -1;
            planarImage2 = bl ? new RMIServerProxy(string, renderedOp.getOperationName(), renderedOp.getRenderingHints()) : ((var11_11 = nodes.get(Long.valueOf(string))) instanceof RenderedOp ? ((RenderedOp)var11_11).getRendering() : PlanarImage.wrapRenderedImage(var11_11));
        } else {
            planarImage2 = PlanarImage.wrapRenderedImage((RenderedImage)object);
        }
        PlanarImage planarImage4 = renderedOp.getSource(n);
        if (planarImage4 instanceof RenderedOp) {
            planarImage3 = ((RenderedOp)planarImage4).getRendering();
        } else if (planarImage4 instanceof RenderedImage) {
            planarImage3 = PlanarImage.wrapRenderedImage(planarImage4);
        }
        Shape shape = (Shape)serializableState.getObject();
        RenderingChangeEvent renderingChangeEvent = new RenderingChangeEvent((RenderedOp)renderedOp.getSource(n), planarImage2, planarImage3, shape);
        renderedOp.propertyChange(renderingChangeEvent);
        return l2;
    }

    public synchronized NegotiableCapabilitySet getServerCapabilities() {
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        String string = "tileEncoder";
        String[] stringArray = operationRegistry.getDescriptorNames(string);
        TileEncoderFactory tileEncoderFactory = null;
        NegotiableCapabilitySet negotiableCapabilitySet = new NegotiableCapabilitySet(false);
        for (int i = 0; i < stringArray.length; ++i) {
            Iterator iterator = operationRegistry.getFactoryIterator(string, stringArray[i]);
            while (iterator.hasNext()) {
                tileEncoderFactory = (TileEncoderFactory)iterator.next();
                negotiableCapabilitySet.add(tileEncoderFactory.getEncodeCapability());
            }
        }
        return negotiableCapabilitySet;
    }

    public void setServerNegotiatedValues(Long l, NegotiableCapabilitySet negotiableCapabilitySet) throws RemoteException {
        if (negotiableCapabilitySet != null) {
            negotiated.put(l, negotiableCapabilitySet);
        } else {
            negotiated.remove(l);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        Iterator iterator = Service.providers(class$com$sun$media$jai$remote$JAIServerConfigurationSpi == null ? (class$com$sun$media$jai$remote$JAIServerConfigurationSpi = JAIRMIImageServer.class$("com.sun.media.jai.remote.JAIServerConfigurationSpi")) : class$com$sun$media$jai$remote$JAIServerConfigurationSpi);
        JAI jAI = JAI.getDefaultInstance();
        while (iterator.hasNext()) {
            object2 = (JAIServerConfigurationSpi)iterator.next();
            object2.updateServer(jAI);
        }
        object2 = null;
        int n = 1099;
        int n2 = 0;
        if (stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n3;
                int n4;
                int n5;
                if (stringArray[i].equalsIgnoreCase("-help")) {
                    System.out.println("Usage: java -Djava.rmi.server.codebase=file:$JAI/lib/jai.jar \\");
                    System.out.println("-Djava.rmi.server.useCodebaseOnly=false \\");
                    System.out.println("-Djava.security.policy=file:`pwd`/policy \\");
                    System.out.println("com.sun.media.jai.rmi.JAIRMIImageServer \\");
                    System.out.println("\nwhere options are:");
                    System.out.println("\t-host <string> The server name or server IP address");
                    System.out.println("\t-port <integer> The port that rmiregistry is running on");
                    System.out.println("\t-rmiRegistryPort <integer> Same as -port option");
                    System.out.println("\t-serverPort <integer> The port that the server should listen on, for connections from clients");
                    System.out.println("\t-cacheMemCapacity <long> The memory capacity in bytes.");
                    System.out.println("\t-cacheMemThreshold <float> The memory threshold, which is the fractional amount of cache memory to retain during tile removal");
                    System.out.println("\t-disableDefaultCache Disable use of default tile cache. Tiles are not stored.");
                    System.out.println("\t-schedulerParallelism <integer> The degree of parallelism of the default TileScheduler");
                    System.out.println("\t-schedulerPrefetchParallelism <integer> The degree of parallelism of the default TileScheduler for tile prefetching");
                    System.out.println("\t-schedulerPriority <integer> The priority of tile scheduling for the default TileScheduler");
                    System.out.println("\t-schedulerPrefetchPriority <integer> The priority of tile prefetch scheduling for the default TileScheduler");
                    System.out.println("\t-defaultTileSize <integer>x<integer> The default tile dimensions in the form <xSize>x<ySize>");
                    System.out.println("\t-defaultRenderingSize <integer>x<integer> The default size to render a RenderableImage to, in the form <xSize>x<ySize>");
                    System.out.println("\t-serializeDeepCopy <boolean> Whether a deep copy of the image data should be used when serializing images");
                    System.out.println("\t-tileCodecFormat <string> The default format to be used for tile serialization via TileCodecs");
                    System.out.println("\t-retryInterval <integer> The retry interval value to be used for dealing with network errors during remote imaging");
                    System.out.println("\t-numRetries <integer> The number of retries to be used for dealing with network errors during remote imaging");
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-host")) {
                    object2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-port") || stringArray[i].equalsIgnoreCase("-rmiRegistryPort")) {
                    n = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-serverport")) {
                    n2 = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-cacheMemCapacity")) {
                    jAI.getTileCache().setMemoryCapacity(Long.parseLong(stringArray[++i]));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-cacheMemThreshold")) {
                    jAI.getTileCache().setMemoryThreshold(Float.parseFloat(stringArray[++i]));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-disableDefaultCache")) {
                    jAI.disableDefaultTileCache();
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-schedulerParallelism")) {
                    jAI.getTileScheduler().setParallelism(Integer.parseInt(stringArray[++i]));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-schedulerPrefetchParallelism")) {
                    jAI.getTileScheduler().setPrefetchParallelism(Integer.parseInt(stringArray[++i]));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-schedulerPriority")) {
                    jAI.getTileScheduler().setPriority(Integer.parseInt(stringArray[++i]));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-schedulerPrefetchPriority")) {
                    jAI.getTileScheduler().setPrefetchPriority(Integer.parseInt(stringArray[++i]));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-defaultTileSize")) {
                    object = stringArray[++i].toLowerCase();
                    n5 = ((String)object).indexOf("x");
                    n4 = Integer.parseInt(((String)object).substring(0, n5));
                    n3 = Integer.parseInt(((String)object).substring(n5 + 1));
                    JAI.setDefaultTileSize(new Dimension(n4, n3));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-defaultRenderingSize")) {
                    object = stringArray[++i].toLowerCase();
                    n5 = ((String)object).indexOf("x");
                    n4 = Integer.parseInt(((String)object).substring(0, n5));
                    n3 = Integer.parseInt(((String)object).substring(n5 + 1));
                    JAI.setDefaultRenderingSize(new Dimension(n4, n3));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-serializeDeepCopy")) {
                    jAI.setRenderingHint(JAI.KEY_SERIALIZE_DEEP_COPY, Boolean.valueOf(stringArray[++i]));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-tileCodecFormat")) {
                    jAI.setRenderingHint(JAI.KEY_TILE_CODEC_FORMAT, stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-retryInterval")) {
                    jAI.setRenderingHint(JAI.KEY_RETRY_INTERVAL, Integer.valueOf(stringArray[++i]));
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("-numRetries")) continue;
                jAI.setRenderingHint(JAI.KEY_NUM_RETRIES, Integer.valueOf(stringArray[++i]));
            }
        }
        if (object2 == null) {
            try {
                object2 = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                String string = JaiI18N.getString("RMIImageImpl1");
                JAIRMIImageServer.sendExceptionToListener(string, new RemoteImagingException(string, unknownHostException));
            }
        }
        System.out.println(JaiI18N.getString("RMIImageImpl3") + " " + (String)object2 + ":" + n);
        try {
            object = new JAIRMIImageServer(n2);
            String string = new String("rmi://" + (String)object2 + ":" + n + "/" + "JAIRMIRemoteServer1.1");
            System.out.println(JaiI18N.getString("RMIImageImpl4") + " \"" + string + "\".");
            Naming.rebind(string, (Remote)object);
            System.out.println(JaiI18N.getString("RMIImageImpl5"));
        }
        catch (Exception exception) {
            String string = JaiI18N.getString("RMIImageImpl1");
            JAIRMIImageServer.sendExceptionToListener(string, new RemoteImagingException(string, exception));
        }
    }

    private static void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
        imagingListener.errorOccurred(string, new RemoteImagingException(string, exception), class$com$sun$media$jai$rmi$JAIRMIImageServer == null ? (class$com$sun$media$jai$rmi$JAIRMIImageServer = JAIRMIImageServer.class$("com.sun.media.jai.rmi.JAIRMIImageServer")) : class$com$sun$media$jai$rmi$JAIRMIImageServer, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

