/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;

final class MlibBandCombineOpImage
extends PointOpImage {
    private double[] cmat = new double[9];
    private double[] offset = new double[3];
    private boolean isOffsetNonZero = false;

    public MlibBandCombineOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[][] dArray) {
        super(renderedImage, imageLayout, map, true);
        int n = dArray.length;
        if (this.getSampleModel().getNumBands() != n) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getDataType(), this.tileWidth, this.tileHeight, n);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)renderedImage.getSampleModel();
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = componentSampleModel.getBandOffsets();
        if (nArray[0] == nArray[1] && nArray[0] == nArray[2] && nArray2[0] > nArray2[2]) {
            for (int i = 0; i < 3; ++i) {
                int n2 = 8 - 3 * i;
                for (int j = 0; j < 3; ++j) {
                    this.cmat[n2--] = dArray[i][j];
                }
                this.offset[2 - i] = dArray[i][3];
                if (this.offset[i] == 0.0) continue;
                this.isOffsetNonZero = true;
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                int n3 = 3 * i;
                for (int j = 0; j < 3; ++j) {
                    this.cmat[n3++] = dArray[i][j];
                }
                this.offset[i] = dArray[i][3];
                if (this.offset[i] == 0.0) continue;
                this.isOffsetNonZero = true;
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                for (int i = 0; i < mediaLibImageArray2.length; ++i) {
                    if (this.isOffsetNonZero) {
                        Image.ColorConvert2((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.cmat, (double[])this.offset);
                        continue;
                    }
                    Image.ColorConvert1((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.cmat);
                }
                break;
            }
            case 4: 
            case 5: {
                for (int i = 0; i < mediaLibImageArray2.length; ++i) {
                    if (this.isOffsetNonZero) {
                        Image.ColorConvert2_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.cmat, (double[])this.offset);
                        continue;
                    }
                    Image.ColorConvert1_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.cmat);
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(string + JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

