/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibHistogramOpImage;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ROI;
import javax.media.jai.util.ImagingListener;

public class MlibHistogramRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        int n;
        int n2;
        int n3;
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock)) {
            return null;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        int n4 = renderedImage.getSampleModel().getDataType();
        if (n4 == 4 || n4 == 5) {
            return null;
        }
        ROI rOI = (ROI)parameterBlock.getObjectParameter(0);
        if (rOI != null && !rOI.equals(new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight()))) {
            return null;
        }
        int n5 = parameterBlock.getIntParameter(1);
        int n6 = parameterBlock.getIntParameter(2);
        int[] nArray = (int[])parameterBlock.getObjectParameter(3);
        double[] dArray = (double[])parameterBlock.getObjectParameter(4);
        double[] dArray2 = (double[])parameterBlock.getObjectParameter(5);
        switch (n4) {
            case 2: {
                n3 = Short.MIN_VALUE;
                n2 = Short.MAX_VALUE;
                break;
            }
            case 1: {
                n3 = 0;
                n2 = 65535;
                break;
            }
            case 3: {
                n3 = Integer.MIN_VALUE;
                n2 = Integer.MAX_VALUE;
                break;
            }
            default: {
                n3 = 0;
                n2 = 255;
            }
        }
        for (n = 0; n < dArray.length; ++n) {
            if (!(dArray[n] < (double)n3) && !(dArray[n] > (double)n2)) continue;
            return null;
        }
        for (n = 0; n < dArray2.length; ++n) {
            if (!(dArray2[n] <= (double)n3) && !(dArray2[n] > (double)(n2 + 1))) continue;
            return null;
        }
        MlibHistogramOpImage mlibHistogramOpImage = null;
        try {
            mlibHistogramOpImage = new MlibHistogramOpImage(renderedImage, n5, n6, nArray, dArray, dArray2);
        }
        catch (Exception exception) {
            ImagingListener imagingListener = ImageUtil.getImagingListener(renderingHints);
            String string = JaiI18N.getString("MlibHistogramRIF0");
            imagingListener.errorOccurred(string, exception, this, false);
        }
        return mlibHistogramOpImage;
    }
}

