/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;

final class MlibThresholdOpImage
extends PointOpImage {
    private double[] low;
    private int[] lowInt;
    private double[] high;
    private int[] highInt;
    private double[] constants;
    private int[] constantsInt;

    public MlibThresholdOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray, double[] dArray2, double[] dArray3) {
        super(renderedImage, imageLayout, map, true);
        int n = this.getSampleModel().getNumBands();
        this.low = new double[n];
        this.lowInt = new int[n];
        this.high = new double[n];
        this.highInt = new int[n];
        this.constants = new double[n];
        this.constantsInt = new int[n];
        for (int i = 0; i < n; ++i) {
            this.low[i] = dArray.length < n ? dArray[0] : dArray[i];
            this.lowInt[i] = ImageUtil.clampInt((int)Math.ceil(this.low[i]));
            this.high[i] = dArray2.length < n ? dArray2[0] : dArray2[i];
            this.highInt[i] = ImageUtil.clampInt((int)Math.floor(this.high[i]));
            this.constants[i] = dArray3.length < n ? dArray3[0] : dArray3[i];
            this.constantsInt[i] = ImageUtil.clampRoundInt(this.constants[i]);
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(rasterArray[0], rectangle, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                for (int i = 0; i < mediaLibImageArray2.length; ++i) {
                    int[] nArray = mediaLibAccessor2.getIntParameters(i, this.lowInt);
                    int[] nArray2 = mediaLibAccessor2.getIntParameters(i, this.highInt);
                    int[] nArray3 = mediaLibAccessor2.getIntParameters(i, this.constantsInt);
                    Image.Thresh5((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (int[])nArray2, (int[])nArray, (int[])nArray3);
                }
                break;
            }
            case 4: 
            case 5: {
                for (int i = 0; i < mediaLibImageArray2.length; ++i) {
                    double[] dArray = mediaLibAccessor2.getDoubleParameters(i, this.low);
                    double[] dArray2 = mediaLibAccessor2.getDoubleParameters(i, this.high);
                    double[] dArray3 = mediaLibAccessor2.getDoubleParameters(i, this.constants);
                    Image.Thresh5_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])dArray2, (double[])dArray, (double[])dArray3);
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

