/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class CompositeNoDestAlphaOpImage
extends PointOpImage {
    private RenderedImage alpha1;
    private RenderedImage alpha2;
    private boolean premultiplied;
    private RasterFormatTag[] tags;

    public CompositeNoDestAlphaOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout, RenderedImage renderedImage3, RenderedImage renderedImage4, boolean bl) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        this.alpha1 = renderedImage3;
        this.alpha2 = renderedImage4;
        this.premultiplied = bl;
        this.tags = this.getFormatTags();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterAccessor rasterAccessor;
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle, this.tags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(rasterArray[1], rectangle, this.tags[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor4 = new RasterAccessor(this.alpha1.getData(rectangle), rectangle, this.tags[2], this.alpha1.getColorModel());
        RasterAccessor rasterAccessor5 = null;
        if (this.alpha2 == null) {
            rasterAccessor = new RasterAccessor(writableRaster, rectangle, this.tags[3], this.getColorModel());
        } else {
            rasterAccessor5 = new RasterAccessor(this.alpha2.getData(rectangle), rectangle, this.tags[3], this.alpha2.getColorModel());
            rasterAccessor = new RasterAccessor(writableRaster, rectangle, this.tags[4], this.getColorModel());
        }
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5, rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        byte[] byArray3 = rasterAccessor3.getByteDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        byte[] byArray4 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            byArray4 = rasterAccessor4.getByteDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        byte[][] byArray5 = rasterAccessor5.getByteDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        float f = 0.003921569f;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            for (int i = 0; i < n14; ++i) {
                int n21 = n16;
                int n22 = n17;
                int n23 = n18 + n7;
                int n24 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f2 = 1.0f - (float)(byArray3[n23] & 0xFF) * f;
                    for (int k = 0; k < n15; ++k) {
                        byArray5[k][n24 + nArray3[k]] = (byte)((float)(byArray[k][n21 + nArray[k]] & 0xFF) + (float)(byArray2[k][n22 + nArray2[k]] & 0xFF) * f2);
                    }
                    n21 += n2;
                    n22 += n4;
                    n23 += n6;
                    n24 += n12;
                }
            }
        } else if (this.alpha2 == null) {
            for (int i = 0; i < n14; ++i) {
                int n25 = n16;
                int n26 = n17;
                int n27 = n18 + n7;
                int n28 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f3 = (float)(byArray3[n27] & 0xFF) * f;
                    float f4 = 1.0f - f3;
                    for (int k = 0; k < n15; ++k) {
                        byArray5[k][n28 + nArray3[k]] = (byte)((float)(byArray[k][n25 + nArray[k]] & 0xFF) * f3 + (float)(byArray2[k][n26 + nArray2[k]] & 0xFF) * f4);
                    }
                    n25 += n2;
                    n26 += n4;
                    n27 += n6;
                    n28 += n12;
                }
            }
        } else {
            for (int i = 0; i < n14; ++i) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n19 + n10;
                int n33 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f5;
                    float f6;
                    int n34 = byArray3[n31] & 0xFF;
                    float f7 = (float)(byArray4[n32] & 0xFF) * (1.0f - (float)n34 * f);
                    float f8 = (float)n34 + f7;
                    if (f8 == 0.0f) {
                        f6 = 0.0f;
                        f5 = 0.0f;
                    } else {
                        f6 = (float)n34 / f8;
                        f5 = f7 / f8;
                    }
                    for (int k = 0; k < n15; ++k) {
                        byArray5[k][n33 + nArray3[k]] = (byte)((float)(byArray[k][n29 + nArray[k]] & 0xFF) * f6 + (float)(byArray2[k][n30 + nArray2[k]] & 0xFF) * f5);
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n9;
                    n33 += n12;
                }
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        short[] sArray4 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            sArray4 = rasterAccessor4.getShortDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        float f = 1.5259022E-5f;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            for (int i = 0; i < n14; ++i) {
                int n21 = n16;
                int n22 = n17;
                int n23 = n18 + n7;
                int n24 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f2 = 1.0f - (float)(sArray3[n23] & 0xFFFF) * f;
                    for (int k = 0; k < n15; ++k) {
                        sArray5[k][n24 + nArray3[k]] = (short)((float)(sArray[k][n21 + nArray[k]] & 0xFFFF) + (float)(sArray2[k][n22 + nArray2[k]] & 0xFFFF) * f2);
                    }
                    n21 += n2;
                    n22 += n4;
                    n23 += n6;
                    n24 += n12;
                }
            }
        } else if (this.alpha2 == null) {
            for (int i = 0; i < n14; ++i) {
                int n25 = n16;
                int n26 = n17;
                int n27 = n18 + n7;
                int n28 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f3 = (float)(sArray3[n27] & 0xFFFF) * f;
                    float f4 = 1.0f - f3;
                    for (int k = 0; k < n15; ++k) {
                        sArray5[k][n28 + nArray3[k]] = (short)((float)(sArray[k][n25 + nArray[k]] & 0xFFFF) * f3 + (float)(sArray2[k][n26 + nArray2[k]] & 0xFFFF) * f4);
                    }
                    n25 += n2;
                    n26 += n4;
                    n27 += n6;
                    n28 += n12;
                }
            }
        } else {
            for (int i = 0; i < n14; ++i) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n19 + n10;
                int n33 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f5;
                    float f6;
                    int n34 = sArray3[n31] & 0xFFFF;
                    float f7 = (float)(sArray4[n32] & 0xFFFF) * (1.0f - (float)n34 * f);
                    float f8 = (float)n34 + f7;
                    if (f8 == 0.0f) {
                        f6 = 0.0f;
                        f5 = 0.0f;
                    } else {
                        f6 = (float)n34 / f8;
                        f5 = f7 / f8;
                    }
                    for (int k = 0; k < n15; ++k) {
                        sArray5[k][n33 + nArray3[k]] = (short)((float)(sArray[k][n29 + nArray[k]] & 0xFFFF) * f6 + (float)(sArray2[k][n30 + nArray2[k]] & 0xFFFF) * f5);
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n9;
                    n33 += n12;
                }
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        short[] sArray4 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            sArray4 = rasterAccessor4.getShortDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        float f = 3.051851E-5f;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            for (int i = 0; i < n14; ++i) {
                int n21 = n16;
                int n22 = n17;
                int n23 = n18 + n7;
                int n24 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f2 = 1.0f - (float)sArray3[n23] * f;
                    for (int k = 0; k < n15; ++k) {
                        sArray5[k][n24 + nArray3[k]] = (short)((float)sArray[k][n21 + nArray[k]] + (float)sArray2[k][n22 + nArray2[k]] * f2);
                    }
                    n21 += n2;
                    n22 += n4;
                    n23 += n6;
                    n24 += n12;
                }
            }
        } else if (this.alpha2 == null) {
            for (int i = 0; i < n14; ++i) {
                int n25 = n16;
                int n26 = n17;
                int n27 = n18 + n7;
                int n28 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f3 = (float)sArray3[n27] * f;
                    float f4 = 1.0f - f3;
                    for (int k = 0; k < n15; ++k) {
                        sArray5[k][n28 + nArray3[k]] = (short)((float)sArray[k][n25 + nArray[k]] * f3 + (float)sArray2[k][n26 + nArray2[k]] * f4);
                    }
                    n25 += n2;
                    n26 += n4;
                    n27 += n6;
                    n28 += n12;
                }
            }
        } else {
            for (int i = 0; i < n14; ++i) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n19 + n10;
                int n33 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f5;
                    float f6;
                    short s = sArray3[n31];
                    float f7 = (float)sArray4[n32] * (1.0f - (float)s * f);
                    float f8 = (float)s + f7;
                    if (f8 == 0.0f) {
                        f6 = 0.0f;
                        f5 = 0.0f;
                    } else {
                        f6 = (float)s / f8;
                        f5 = f7 / f8;
                    }
                    for (int k = 0; k < n15; ++k) {
                        sArray5[k][n33 + nArray3[k]] = (short)((float)sArray[k][n29 + nArray[k]] * f6 + (float)sArray2[k][n30 + nArray2[k]] * f5);
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n9;
                    n33 += n12;
                }
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        int[] nArray5 = rasterAccessor3.getIntDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int[] nArray6 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            nArray6 = rasterAccessor4.getIntDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray7 = rasterAccessor5.getBandOffsets();
        int[][] nArray8 = rasterAccessor5.getIntDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        float f = 4.656613E-10f;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            for (int i = 0; i < n14; ++i) {
                int n21 = n16;
                int n22 = n17;
                int n23 = n18 + n7;
                int n24 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f2 = 1.0f - (float)nArray5[n23] * f;
                    for (int k = 0; k < n15; ++k) {
                        nArray8[k][n24 + nArray7[k]] = (int)((float)nArray2[k][n21 + nArray[k]] + (float)nArray4[k][n22 + nArray3[k]] * f2);
                    }
                    n21 += n2;
                    n22 += n4;
                    n23 += n6;
                    n24 += n12;
                }
            }
        } else if (this.alpha2 == null) {
            for (int i = 0; i < n14; ++i) {
                int n25 = n16;
                int n26 = n17;
                int n27 = n18 + n7;
                int n28 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f3 = (float)nArray5[n27] * f;
                    float f4 = 1.0f - f3;
                    for (int k = 0; k < n15; ++k) {
                        nArray8[k][n28 + nArray7[k]] = (int)((float)nArray2[k][n25 + nArray[k]] * f3 + (float)nArray4[k][n26 + nArray3[k]] * f4);
                    }
                    n25 += n2;
                    n26 += n4;
                    n27 += n6;
                    n28 += n12;
                }
            }
        } else {
            for (int i = 0; i < n14; ++i) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n19 + n10;
                int n33 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f5;
                    float f6;
                    int n34 = nArray5[n31];
                    float f7 = (float)nArray6[n32] * (1.0f - (float)n34 * f);
                    float f8 = (float)n34 + f7;
                    if (f8 == 0.0f) {
                        f6 = 0.0f;
                        f5 = 0.0f;
                    } else {
                        f6 = (float)n34 / f8;
                        f5 = f7 / f8;
                    }
                    for (int k = 0; k < n15; ++k) {
                        nArray8[k][n33 + nArray7[k]] = (int)((float)nArray2[k][n29 + nArray[k]] * f6 + (float)nArray4[k][n30 + nArray3[k]] * f5);
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n9;
                    n33 += n12;
                }
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        float[] fArray3 = rasterAccessor3.getFloatDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        float[] fArray4 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            fArray4 = rasterAccessor4.getFloatDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        float[][] fArray5 = rasterAccessor5.getFloatDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            for (int i = 0; i < n14; ++i) {
                int n21 = n16;
                int n22 = n17;
                int n23 = n18 + n7;
                int n24 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f = 1.0f - fArray3[n23];
                    for (int k = 0; k < n15; ++k) {
                        fArray5[k][n24 + nArray3[k]] = fArray[k][n21 + nArray[k]] + fArray2[k][n22 + nArray2[k]] * f;
                    }
                    n21 += n2;
                    n22 += n4;
                    n23 += n6;
                    n24 += n12;
                }
            }
        } else if (this.alpha2 == null) {
            for (int i = 0; i < n14; ++i) {
                int n25 = n16;
                int n26 = n17;
                int n27 = n18 + n7;
                int n28 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f = fArray3[n27];
                    float f2 = 1.0f - f;
                    for (int k = 0; k < n15; ++k) {
                        fArray5[k][n28 + nArray3[k]] = fArray[k][n25 + nArray[k]] * f + fArray2[k][n26 + nArray2[k]] * f2;
                    }
                    n25 += n2;
                    n26 += n4;
                    n27 += n6;
                    n28 += n12;
                }
            }
        } else {
            for (int i = 0; i < n14; ++i) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n19 + n10;
                int n33 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    float f;
                    float f3;
                    float f4 = fArray3[n31];
                    float f5 = fArray4[n32] * (1.0f - f4);
                    float f6 = f4 + f5;
                    if (f6 == 0.0f) {
                        f3 = 0.0f;
                        f = 0.0f;
                    } else {
                        f3 = f4 / f6;
                        f = f5 / f6;
                    }
                    for (int k = 0; k < n15; ++k) {
                        fArray5[k][n33 + nArray3[k]] = fArray[k][n29 + nArray[k]] * f3 + fArray2[k][n30 + nArray2[k]] * f;
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n9;
                    n33 += n12;
                }
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int n7 = rasterAccessor3.getBandOffset(0);
        double[] dArray3 = rasterAccessor3.getDoubleDataArray(0);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double[] dArray4 = null;
        if (this.alpha2 != null) {
            n8 = rasterAccessor4.getScanlineStride();
            n9 = rasterAccessor4.getPixelStride();
            n10 = rasterAccessor4.getBandOffset(0);
            dArray4 = rasterAccessor4.getDoubleDataArray(0);
        }
        int n11 = rasterAccessor5.getScanlineStride();
        int n12 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        double[][] dArray5 = rasterAccessor5.getDoubleDataArrays();
        int n13 = rasterAccessor5.getWidth();
        int n14 = rasterAccessor5.getHeight();
        int n15 = rasterAccessor5.getNumBands();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.premultiplied) {
            for (int i = 0; i < n14; ++i) {
                int n21 = n16;
                int n22 = n17;
                int n23 = n18 + n7;
                int n24 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    double d = 1.0 - dArray3[n23];
                    for (int k = 0; k < n15; ++k) {
                        dArray5[k][n24 + nArray3[k]] = dArray[k][n21 + nArray[k]] + dArray2[k][n22 + nArray2[k]] * d;
                    }
                    n21 += n2;
                    n22 += n4;
                    n23 += n6;
                    n24 += n12;
                }
            }
        } else if (this.alpha2 == null) {
            for (int i = 0; i < n14; ++i) {
                int n25 = n16;
                int n26 = n17;
                int n27 = n18 + n7;
                int n28 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    double d = dArray3[n27];
                    double d2 = 1.0 - d;
                    for (int k = 0; k < n15; ++k) {
                        dArray5[k][n28 + nArray3[k]] = dArray[k][n25 + nArray[k]] * d + dArray2[k][n26 + nArray2[k]] * d2;
                    }
                    n25 += n2;
                    n26 += n4;
                    n27 += n6;
                    n28 += n12;
                }
            }
        } else {
            for (int i = 0; i < n14; ++i) {
                int n29 = n16;
                int n30 = n17;
                int n31 = n18 + n7;
                int n32 = n19 + n10;
                int n33 = n20;
                n16 += n;
                n17 += n3;
                n18 += n5;
                n19 += n8;
                n20 += n11;
                for (int j = 0; j < n13; ++j) {
                    double d;
                    double d3;
                    double d4 = dArray3[n31];
                    double d5 = dArray4[n32] * (1.0 - d4);
                    double d6 = d4 + d5;
                    if (d6 == 0.0) {
                        d3 = 0.0;
                        d = 0.0;
                    } else {
                        d3 = d4 / d6;
                        d = d5 / d6;
                    }
                    for (int k = 0; k < n15; ++k) {
                        dArray5[k][n33 + nArray3[k]] = dArray[k][n29 + nArray[k]] * d3 + dArray2[k][n30 + nArray2[k]] * d;
                    }
                    n29 += n2;
                    n30 += n4;
                    n31 += n6;
                    n32 += n9;
                    n33 += n12;
                }
            }
        }
    }

    protected synchronized RasterFormatTag[] getFormatTags() {
        RenderedImage[] renderedImageArray;
        if (this.alpha2 == null) {
            renderedImageArray = new RenderedImage[3];
        } else {
            renderedImageArray = new RenderedImage[4];
            renderedImageArray[3] = this.alpha2;
        }
        renderedImageArray[0] = this.getSourceImage(0);
        renderedImageArray[1] = this.getSourceImage(1);
        renderedImageArray[2] = this.alpha1;
        return RasterAccessor.findCompatibleTags(renderedImageArray, this);
    }
}

