/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public final class CopyOpImage
extends PointOpImage {
    public CopyOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        if (rasterAccessor2.isBinary()) {
            byte[] byArray = rasterAccessor.getBinaryDataArray();
            byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            rasterAccessor2.copyBinaryDataToRaster();
        } else {
            switch (rasterAccessor2.getDataType()) {
                case 0: {
                    this.byteLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 1: 
                case 2: {
                    this.shortLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 3: {
                    this.intLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 4: {
                    this.floatLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 5: {
                    this.doubleLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Convolve3x3OpImage1"));
                }
            }
            if (rasterAccessor2.isDataCopy()) {
                rasterAccessor2.clampDataArrays();
                rasterAccessor2.copyDataToRaster();
            }
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray2[i];
            int n9 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    byArray3[n11] = byArray4[n10];
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray2[i];
            int n9 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    sArray3[n11] = sArray4[n10];
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            int[] nArray5 = nArray[i];
            int[] nArray6 = nArray3[i];
            int n8 = nArray4[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    nArray5[n11] = nArray6[n10];
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n8 = nArray2[i];
            int n9 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    fArray3[n11] = fArray4[n10];
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n8 = nArray2[i];
            int n9 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    dArray3[n11] = dArray4[n10];
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }
}

