/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class DivideOpImage
extends PointOpImage {
    private byte[][] divideTableByte;
    private int s1bd = 1;
    private int s2bd = 1;

    public DivideOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        SampleModel sampleModel;
        int n;
        int n2 = renderedImage.getSampleModel().getNumBands();
        int n3 = renderedImage2.getSampleModel().getNumBands();
        if (imageLayout != null && imageLayout.isValid(256) && (n = (sampleModel = imageLayout.getSampleModel(null)).getNumBands()) > 1 && (n2 > 1 && n3 == 1 || n2 == 1 && n3 > 1)) {
            n = Math.min(Math.max(n2, n3), n);
            if (n != this.sampleModel.getNumBands()) {
                this.sampleModel = RasterFactory.createComponentSampleModel(sampleModel, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), n);
                if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                    this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
                }
            }
            this.s1bd = n2 == 1 ? 0 : 1;
            int n4 = this.s2bd = n3 == 1 ? 0 : 1;
        }
        if (this.sampleModel.getTransferType() == 0) {
            this.divideTableByte = new byte[256][256];
            for (int i = 0; i < 256; ++i) {
                byte[] byArray = this.divideTableByte[i];
                byArray[0] = i > 0 ? -1 : 0;
                for (int j = 1; j < 256; ++j) {
                    byArray[j] = ImageUtil.clampRoundByte((float)i / (float)j);
                }
            }
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        if (rasterAccessor3.isBinary()) {
            byte[] byArray = rasterAccessor3.getBinaryDataArray();
            System.arraycopy(rasterAccessor.getBinaryDataArray(), 0, byArray, 0, byArray.length);
            rasterAccessor3.copyBinaryDataToRaster();
            return;
        }
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor3.getNumBands();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.byteLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getByteDataArrays(), n3, n4, nArray2, rasterAccessor2.getByteDataArrays(), n8, n9, nArray3, rasterAccessor3.getByteDataArrays());
                break;
            }
            case 1: {
                this.ushortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays(), n8, n9, nArray3, rasterAccessor3.getShortDataArrays());
                break;
            }
            case 2: {
                this.shortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays(), n8, n9, nArray3, rasterAccessor3.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getIntDataArrays(), n3, n4, nArray2, rasterAccessor2.getIntDataArrays(), n8, n9, nArray3, rasterAccessor3.getIntDataArrays());
                break;
            }
            case 4: {
                this.floatLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getFloatDataArrays(), n3, n4, nArray2, rasterAccessor2.getFloatDataArrays(), n8, n9, nArray3, rasterAccessor3.getFloatDataArrays());
                break;
            }
            case 5: {
                this.doubleLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getDoubleDataArrays(), n3, n4, nArray2, rasterAccessor2.getDoubleDataArrays(), n8, n9, nArray3, rasterAccessor3.getDoubleDataArrays());
            }
        }
        if (rasterAccessor3.needsClamping()) {
            rasterAccessor3.clampDataArrays();
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void byteLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, byte[][] byArray, int n6, int n7, int[] nArray2, byte[][] byArray2, int n8, int n9, int[] nArray3, byte[][] byArray3) {
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n) {
            byte[] byArray4 = byArray[n11];
            byte[] byArray5 = byArray2[n12];
            byte[] byArray6 = byArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            for (int i = 0; i < n3; ++i) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                n13 += n4;
                n14 += n6;
                n15 += n8;
                for (int j = 0; j < n2; ++j) {
                    byArray6[n18] = this.divideTableByte[byArray4[n16] & 0xFF][byArray5[n17] & 0xFF];
                    n16 += n5;
                    n17 += n7;
                    n18 += n9;
                }
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void ushortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2, int n8, int n9, int[] nArray3, short[][] sArray3) {
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n12];
            short[] sArray6 = sArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            for (int i = 0; i < n3; ++i) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                n13 += n4;
                n14 += n6;
                n15 += n8;
                for (int j = 0; j < n2; ++j) {
                    float f = sArray4[n16] & 0xFFFF;
                    float f2 = sArray5[n17] & 0xFFFF;
                    sArray6[n18] = f == 0.0f ? 0 : (f2 == 0.0f ? -1 : ImageUtil.clampRoundUShort(f / f2));
                    n16 += n5;
                    n17 += n7;
                    n18 += n9;
                }
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void shortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2, int n8, int n9, int[] nArray3, short[][] sArray3) {
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n12];
            short[] sArray6 = sArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            for (int i = 0; i < n3; ++i) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                n13 += n4;
                n14 += n6;
                n15 += n8;
                for (int j = 0; j < n2; ++j) {
                    float f = sArray4[n16];
                    float f2 = sArray5[n17];
                    sArray6[n18] = f == 0.0f ? 0 : (f2 == 0.0f ? (f < 0.0f ? Short.MIN_VALUE : Short.MAX_VALUE) : ImageUtil.clampRoundShort(f / f2));
                    n16 += n5;
                    n17 += n7;
                    n18 += n9;
                }
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void intLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, int[][] nArray2, int n6, int n7, int[] nArray3, int[][] nArray4, int n8, int n9, int[] nArray5, int[][] nArray6) {
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                while (n10 < n) {
                    int[] nArray7 = nArray2[n11];
                    int[] nArray8 = nArray4[n12];
                    int[] nArray9 = nArray6[n10];
                    int n13 = nArray[n11];
                    int n14 = nArray3[n12];
                    int n15 = nArray5[n10];
                    for (int i = 0; i < n3; ++i) {
                        int n16 = n13;
                        int n17 = n14;
                        int n18 = n15;
                        n13 += n4;
                        n14 += n6;
                        n15 += n8;
                        for (int j = 0; j < n2; ++j) {
                            float f = nArray7[n16] & 0xFF;
                            float f2 = nArray8[n17] & 0xFF;
                            nArray9[n18] = f == 0.0f ? 0 : (f2 == 0.0f ? 255 : (int)ImageUtil.clampRoundByte(f / f2));
                            n16 += n5;
                            n17 += n7;
                            n18 += n9;
                        }
                    }
                    ++n10;
                    n11 += this.s1bd;
                    n12 += this.s2bd;
                }
                break;
            }
            case 1: {
                int n19 = 0;
                int n20 = 0;
                int n21 = 0;
                while (n19 < n) {
                    int[] nArray10 = nArray2[n20];
                    int[] nArray11 = nArray4[n21];
                    int[] nArray12 = nArray6[n19];
                    int n22 = nArray[n20];
                    int n23 = nArray3[n21];
                    int n24 = nArray5[n19];
                    for (int i = 0; i < n3; ++i) {
                        int n25 = n22;
                        int n26 = n23;
                        int n27 = n24;
                        n22 += n4;
                        n23 += n6;
                        n24 += n8;
                        for (int j = 0; j < n2; ++j) {
                            float f = nArray10[n25] & 0xFFFF;
                            float f3 = nArray11[n26] & 0xFFFF;
                            nArray12[n27] = f == 0.0f ? 0 : (f3 == 0.0f ? -1 : (int)ImageUtil.clampRoundUShort(f / f3));
                            n25 += n5;
                            n26 += n7;
                            n27 += n9;
                        }
                    }
                    ++n19;
                    n20 += this.s1bd;
                    n21 += this.s2bd;
                }
                break;
            }
            case 2: {
                int n28 = 0;
                int n29 = 0;
                int n30 = 0;
                while (n28 < n) {
                    int[] nArray13 = nArray2[n29];
                    int[] nArray14 = nArray4[n30];
                    int[] nArray15 = nArray6[n28];
                    int n31 = nArray[n29];
                    int n32 = nArray3[n30];
                    int n33 = nArray5[n28];
                    for (int i = 0; i < n3; ++i) {
                        int n34 = n31;
                        int n35 = n32;
                        int n36 = n33;
                        n31 += n4;
                        n32 += n6;
                        n33 += n8;
                        for (int j = 0; j < n2; ++j) {
                            float f = nArray13[n34];
                            float f4 = nArray14[n35];
                            nArray15[n36] = f == 0.0f ? 0 : (f4 == 0.0f ? (f < 0.0f ? Short.MIN_VALUE : Short.MAX_VALUE) : (int)ImageUtil.clampRoundShort(f / f4));
                            n34 += n5;
                            n35 += n7;
                            n36 += n9;
                        }
                    }
                    ++n28;
                    n29 += this.s1bd;
                    n30 += this.s2bd;
                }
                break;
            }
            case 3: {
                int n37 = 0;
                int n38 = 0;
                int n39 = 0;
                while (n37 < n) {
                    int[] nArray16 = nArray2[n38];
                    int[] nArray17 = nArray4[n39];
                    int[] nArray18 = nArray6[n37];
                    int n40 = nArray[n38];
                    int n41 = nArray3[n39];
                    int n42 = nArray5[n37];
                    for (int i = 0; i < n3; ++i) {
                        int n43 = n40;
                        int n44 = n41;
                        int n45 = n42;
                        n40 += n4;
                        n41 += n6;
                        n42 += n8;
                        for (int j = 0; j < n2; ++j) {
                            float f = nArray16[n43];
                            float f5 = nArray17[n44];
                            nArray18[n45] = f == 0.0f ? 0 : (f5 == 0.0f ? (f < 0.0f ? Integer.MIN_VALUE : Integer.MAX_VALUE) : ImageUtil.clampRoundInt(f / f5));
                            n43 += n5;
                            n44 += n7;
                            n45 += n9;
                        }
                    }
                    ++n37;
                    n38 += this.s1bd;
                    n39 += this.s2bd;
                }
                break;
            }
        }
    }

    private void floatLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, float[][] fArray, int n6, int n7, int[] nArray2, float[][] fArray2, int n8, int n9, int[] nArray3, float[][] fArray3) {
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n) {
            float[] fArray4 = fArray[n11];
            float[] fArray5 = fArray2[n12];
            float[] fArray6 = fArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            for (int i = 0; i < n3; ++i) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                n13 += n4;
                n14 += n6;
                n15 += n8;
                for (int j = 0; j < n2; ++j) {
                    fArray6[n18] = fArray4[n16] / fArray5[n17];
                    n16 += n5;
                    n17 += n7;
                    n18 += n9;
                }
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void doubleLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, double[][] dArray, int n6, int n7, int[] nArray2, double[][] dArray2, int n8, int n9, int[] nArray3, double[][] dArray3) {
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n) {
            double[] dArray4 = dArray[n11];
            double[] dArray5 = dArray2[n12];
            double[] dArray6 = dArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            for (int i = 0; i < n3; ++i) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                n13 += n4;
                n14 += n6;
                n15 += n8;
                for (int j = 0; j < n2; ++j) {
                    dArray6[n18] = dArray4[n16] / dArray5[n17];
                    n16 += n5;
                    n17 += n7;
                    n18 += n9;
                }
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }
}

