/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.ImageServer;
import com.sun.media.jai.rmi.JAIRMIImageServer;
import com.sun.media.jai.rmi.JAIRMIUtil;
import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.OperationNode;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.RenderingChangeEvent;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.PlanarImageServerProxy;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.RemoteRenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoderFactory;
import javax.media.jai.util.ImagingListener;

public class RMIServerProxy
extends PlanarImageServerProxy {
    private ImageServer remoteImage = null;
    private Long id;
    private Long renderingID = null;
    private boolean preferencesSet;
    private NegotiableCapabilitySet negPref;
    private static final Class NULL_PROPERTY_CLASS = JAIRMIImageServer.NULL_PROPERTY.getClass();
    private ImagingListener listener;
    static /* synthetic */ Class class$javax$media$jai$tilecodec$TileDecoderFactory;

    public RMIServerProxy(String string, String string2, RenderingHints renderingHints) {
        super(string, "jairmi", string2, null, renderingHints);
        boolean bl;
        int n = string.indexOf("::");
        boolean bl2 = bl = n != -1;
        if (!bl) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteImage1"));
        }
        if (bl) {
            this.id = Long.valueOf(string.substring(n + 2));
            this.serverName = string = string.substring(0, n);
        }
        this.listener = ImageUtil.getImagingListener(renderingHints);
        this.remoteImage = this.getImageServer(string);
        if (this.preferencesSet) {
            super.setNegotiationPreferences(this.negPref);
        }
        try {
            this.remoteImage.incrementRefCount(this.id);
        }
        catch (RemoteException remoteException) {
            System.err.println(JaiI18N.getString("RMIServerProxy2"));
        }
    }

    public RMIServerProxy(String string, ParameterBlock parameterBlock, String string2, RenderingHints renderingHints) {
        super(string, "jairmi", string2, parameterBlock, renderingHints);
        boolean bl;
        int n = string.indexOf("::");
        boolean bl2 = bl = n != -1;
        if (!bl) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteImage1"));
        }
        if (bl) {
            this.id = Long.valueOf(string.substring(n + 2));
            this.serverName = string = string.substring(0, n);
        }
        this.listener = ImageUtil.getImagingListener(renderingHints);
        this.remoteImage = this.getImageServer(string);
        if (this.preferencesSet) {
            super.setNegotiationPreferences(this.negPref);
        }
        try {
            this.remoteImage.incrementRefCount(this.id);
        }
        catch (RemoteException remoteException) {
            System.err.println(JaiI18N.getString("RMIServerProxy2"));
        }
    }

    public RMIServerProxy(String string, String string2, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        super(string, "jairmi", string2, parameterBlock, renderingHints);
        Object object;
        this.listener = ImageUtil.getImagingListener(renderingHints);
        this.remoteImage = this.getImageServer(string);
        this.getRMIID();
        if (this.preferencesSet) {
            super.setNegotiationPreferences(this.negPref);
        }
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        parameterBlock2.removeSources();
        JAIRMIUtil.checkClientParameters(parameterBlock2, string);
        try {
            object = SerializerFactory.getState(renderingHints, null);
            this.remoteImage.createRenderedOp(this.id, string2, parameterBlock2, (SerializableState)object);
        }
        catch (RemoteException remoteException) {
            String string3 = JaiI18N.getString("RMIServerProxy5");
            this.listener.errorOccurred(string3, new RemoteImagingException(string3, remoteException), this, false);
        }
        int n = this.getNumSources();
        for (int i = 0; i < n; ++i) {
            Object object2;
            PlanarImage planarImage;
            object = this.getSource(i);
            if (object instanceof RMIServerProxy) {
                try {
                    planarImage = (RMIServerProxy)object;
                    if (((RMIServerProxy)planarImage).serverName.equalsIgnoreCase(this.serverName)) {
                        this.remoteImage.setRenderedSource(this.id, ((RMIServerProxy)planarImage).getRMIID(), i);
                        continue;
                    }
                    this.remoteImage.setRenderedSource(this.id, ((RMIServerProxy)planarImage).getRMIID(), ((RMIServerProxy)planarImage).serverName, ((RMIServerProxy)planarImage).operationName, i);
                }
                catch (RemoteException remoteException) {
                    object2 = JaiI18N.getString("RMIServerProxy6");
                    this.listener.errorOccurred((String)object2, new RemoteImagingException(remoteException), this, false);
                }
                continue;
            }
            if (object instanceof RenderedOp) {
                planarImage = (RenderedOp)object;
                object2 = ((RenderedOp)planarImage).getRendering();
                if (!(object2 instanceof Serializable)) {
                    object2 = new SerializableRenderedImage((RenderedImage)object2);
                }
                try {
                    this.remoteImage.setRenderedSource(this.id, (RenderedImage)object2, i);
                }
                catch (RemoteException remoteException) {
                    String string4 = JaiI18N.getString("RMIServerProxy6");
                    this.listener.errorOccurred(string4, new RemoteImagingException(string4, remoteException), this, false);
                }
                continue;
            }
            if (!(object instanceof RenderedImage)) continue;
            try {
                if (object instanceof Serializable) {
                    this.remoteImage.setRenderedSource(this.id, (RenderedImage)object, i);
                    continue;
                }
                this.remoteImage.setRenderedSource(this.id, new SerializableRenderedImage((RenderedImage)object), i);
                continue;
            }
            catch (RemoteException remoteException) {
                object2 = JaiI18N.getString("RMIServerProxy6");
                this.listener.errorOccurred((String)object2, new RemoteImagingException((String)object2, remoteException), this, false);
            }
        }
        try {
            this.remoteImage.incrementRefCount(this.id);
        }
        catch (RemoteException remoteException) {
            System.err.println(JaiI18N.getString("RMIServerProxy2"));
        }
    }

    public RMIServerProxy(PlanarImageServerProxy planarImageServerProxy, OperationNode operationNode, String string) {
        this(string, operationNode.getOperationName(), operationNode.getParameterBlock(), operationNode.getRenderingHints());
    }

    public RMIServerProxy(PlanarImageServerProxy planarImageServerProxy, OperationNode operationNode, PropertyChangeEventJAI propertyChangeEventJAI) {
        super(((RemoteRenderedOp)operationNode).getServerName(), "jairmi", operationNode.getOperationName(), operationNode.getParameterBlock(), operationNode.getRenderingHints());
        this.listener = ImageUtil.getImagingListener(operationNode.getRenderingHints());
        this.remoteImage = this.getImageServer(this.serverName);
        RMIServerProxy rMIServerProxy = null;
        if (planarImageServerProxy instanceof RMIServerProxy) {
            rMIServerProxy = (RMIServerProxy)planarImageServerProxy;
        } else {
            System.err.println(JaiI18N.getString("RMIServerProxy3"));
        }
        Long l = rMIServerProxy.getRMIID();
        String string = propertyChangeEventJAI.getPropertyName();
        if (propertyChangeEventJAI instanceof RenderingChangeEvent) {
            Object object;
            RenderingChangeEvent renderingChangeEvent = (RenderingChangeEvent)propertyChangeEventJAI;
            int n = ((RenderedOp)operationNode).getSources().indexOf(renderingChangeEvent.getSource());
            PlanarImage planarImage = (PlanarImage)propertyChangeEventJAI.getOldValue();
            Object object2 = null;
            String string2 = null;
            if (planarImage instanceof RMIServerProxy) {
                object = (RMIServerProxy)planarImage;
                string2 = !((PlanarImageServerProxy)object).getServerName().equalsIgnoreCase(this.serverName) ? ((PlanarImageServerProxy)object).getServerName() + "::" + ((RMIServerProxy)object).getRMIID() : ((RMIServerProxy)object).getRMIID().toString();
                object2 = string2;
            } else {
                object2 = planarImage instanceof Serializable ? planarImage : new SerializableRenderedImage(planarImage);
            }
            object = renderingChangeEvent.getInvalidRegion();
            SerializableState serializableState = SerializerFactory.getState((Shape)object, null);
            Long l2 = null;
            try {
                l2 = this.remoteImage.handleEvent(l, n, serializableState, object2);
            }
            catch (RemoteException remoteException) {
                String string3 = JaiI18N.getString("RMIServerProxy7");
                this.listener.errorOccurred(string3, new RemoteImagingException(string3, remoteException), this, false);
            }
            rMIServerProxy.id = l2;
            this.id = l;
        } else {
            Object object;
            Cloneable cloneable;
            Object object3;
            Object object4 = null;
            Object object5 = null;
            if (string.equals("operationname")) {
                object4 = propertyChangeEventJAI.getOldValue();
                object5 = propertyChangeEventJAI.getNewValue();
            } else if (string.equals("parameterblock")) {
                object3 = (ParameterBlock)propertyChangeEventJAI.getOldValue();
                cloneable = ((ParameterBlock)object3).getSources();
                ((ParameterBlock)object3).removeSources();
                object = (ParameterBlock)propertyChangeEventJAI.getNewValue();
                Vector<Object> vector = ((ParameterBlock)object).getSources();
                ((ParameterBlock)object).removeSources();
                JAIRMIUtil.checkClientParameters((ParameterBlock)object3, this.serverName);
                JAIRMIUtil.checkClientParameters((ParameterBlock)object, this.serverName);
                ((ParameterBlock)object3).setSources(JAIRMIUtil.replaceSourcesWithId(cloneable, this.serverName));
                ((ParameterBlock)object).setSources(JAIRMIUtil.replaceSourcesWithId(vector, this.serverName));
                object4 = object3;
                object5 = object;
            } else if (string.equals("sources")) {
                object3 = (Vector)propertyChangeEventJAI.getOldValue();
                cloneable = (Vector)propertyChangeEventJAI.getNewValue();
                object4 = JAIRMIUtil.replaceSourcesWithId((Vector)object3, this.serverName);
                object5 = JAIRMIUtil.replaceSourcesWithId(cloneable, this.serverName);
            } else if (string.equals("parameters")) {
                object3 = (Vector)propertyChangeEventJAI.getOldValue();
                cloneable = (Vector)propertyChangeEventJAI.getNewValue();
                JAIRMIUtil.checkClientParameters((Vector)object3, this.serverName);
                JAIRMIUtil.checkClientParameters(cloneable, this.serverName);
                object4 = object3;
                object5 = cloneable;
            } else if (string.equals("renderinghints")) {
                object3 = (RenderingHints)propertyChangeEventJAI.getOldValue();
                cloneable = (RenderingHints)propertyChangeEventJAI.getNewValue();
                object4 = SerializerFactory.getState(object3, null);
                object5 = SerializerFactory.getState(cloneable, null);
            } else {
                throw new RemoteImagingException(JaiI18N.getString("RMIServerProxy4"));
            }
            object3 = null;
            try {
                object3 = this.remoteImage.handleEvent(l, string, object4, object5);
                this.remoteImage.incrementRefCount((Long)object3);
            }
            catch (RemoteException remoteException) {
                object = JaiI18N.getString("RMIServerProxy7");
                this.listener.errorOccurred((String)object, new RemoteImagingException((String)object, remoteException), this, false);
            }
            rMIServerProxy.id = object3;
            this.id = l;
        }
        if (this.preferencesSet) {
            super.setNegotiationPreferences(this.negPref);
        }
    }

    public RMIServerProxy(String string, String string2, ParameterBlock parameterBlock, RenderingHints renderingHints, Long l) {
        super(string, "jairmi", string2, parameterBlock, renderingHints);
        this.listener = ImageUtil.getImagingListener(renderingHints);
        this.remoteImage = this.getImageServer(string);
        this.id = l;
    }

    public RMIServerProxy(String string, String string2, ParameterBlock parameterBlock, RenderContext renderContext, boolean bl) {
        super(string, "jairmi", string2, parameterBlock, null);
        Vector<Object> vector;
        this.listener = ImageUtil.getImagingListener(renderContext.getRenderingHints());
        this.remoteImage = this.getImageServer(string);
        this.getRMIID();
        if (this.preferencesSet) {
            super.setNegotiationPreferences(this.negPref);
        }
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        parameterBlock2.removeSources();
        try {
            this.remoteImage.createRenderableOp(this.id, string2, parameterBlock2);
        }
        catch (RemoteException remoteException) {
            String string3 = JaiI18N.getString("RMIServerProxy8");
            this.listener.errorOccurred(string3, new RemoteImagingException(string3, remoteException), this, false);
        }
        int n = this.getNumSources();
        for (int i = 0; i < n; ++i) {
            String string4;
            vector = parameterBlock.getSources();
            Object object = vector.elementAt(i);
            if (object instanceof RMIServerProxy) {
                try {
                    RMIServerProxy rMIServerProxy = (RMIServerProxy)object;
                    if (rMIServerProxy.serverName.equals(this.serverName)) {
                        this.remoteImage.setRenderableSource(this.id, rMIServerProxy.getRMIID(), i);
                        continue;
                    }
                    this.remoteImage.setRenderableSource(this.id, rMIServerProxy.getRMIID(), rMIServerProxy.serverName, rMIServerProxy.operationName, i);
                }
                catch (RemoteException remoteException) {
                    string4 = JaiI18N.getString("RMIServerProxy6");
                    this.listener.errorOccurred(string4, new RemoteImagingException(string4, remoteException), this, false);
                }
                continue;
            }
            if (object instanceof RenderableOp) {
                try {
                    this.remoteImage.setRenderableSource(this.id, (RenderableOp)object, i);
                }
                catch (RemoteException remoteException) {
                    string4 = JaiI18N.getString("RMIServerProxy6");
                    this.listener.errorOccurred(string4, new RemoteImagingException(string4, remoteException), this, false);
                }
                continue;
            }
            if (!(object instanceof RenderedImage)) continue;
            try {
                this.remoteImage.setRenderableSource(this.id, new SerializableRenderedImage((RenderedImage)object), i);
                continue;
            }
            catch (RemoteException remoteException) {
                string4 = JaiI18N.getString("RMIServerProxy6");
                this.listener.errorOccurred(string4, new RemoteImagingException(string4, remoteException), this, false);
            }
        }
        try {
            this.remoteImage.incrementRefCount(this.id);
        }
        catch (RemoteException remoteException) {
            vector = JaiI18N.getString("RMIServerProxy9");
            this.listener.errorOccurred((String)((Object)vector), new RemoteImagingException((String)((Object)vector), remoteException), this, false);
        }
        if (bl) {
            try {
                this.renderingID = this.remoteImage.getRendering(this.id, SerializerFactory.getState(renderContext, null));
                this.remoteImage.incrementRefCount(this.renderingID);
            }
            catch (RemoteException remoteException) {
                vector = JaiI18N.getString("RMIServerProxy10");
                this.listener.errorOccurred((String)((Object)vector), new RemoteImagingException((String)((Object)vector), remoteException), this, false);
            }
        }
    }

    protected synchronized ImageServer getImageServer(String string) {
        if (this.remoteImage == null) {
            if (string == null) {
                try {
                    string = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception exception) {
                    String string2 = JaiI18N.getString("RMIServerProxy11");
                    this.listener.errorOccurred(string2, new RemoteImagingException(string2, exception), this, false);
                }
            }
            String string3 = new String("rmi://" + string + "/" + "JAIRMIRemoteServer1.1");
            this.remoteImage = null;
            try {
                this.remoteImage = (ImageServer)Naming.lookup(string3);
            }
            catch (Exception exception) {
                String string4 = JaiI18N.getString("RMIServerProxy12");
                this.listener.errorOccurred(string4, new RemoteImagingException(string4, exception), this, false);
            }
        }
        return this.remoteImage;
    }

    public synchronized Long getRMIID() {
        if (this.id != null) {
            return this.id;
        }
        try {
            this.id = this.remoteImage.getRemoteID();
            return this.id;
        }
        catch (Exception exception) {
            String string = JaiI18N.getString("RMIServerProxy13");
            this.listener.errorOccurred(string, new RemoteImagingException(string, exception), this, false);
            return this.id;
        }
    }

    public Long getRenderingID() {
        return this.renderingID;
    }

    public boolean canBeRendered() {
        boolean bl = true;
        this.getImageServer(this.serverName);
        try {
            bl = this.remoteImage.getRendering(this.getRMIID());
        }
        catch (RemoteException remoteException) {
            String string = JaiI18N.getString("RMIServerProxy10");
            this.listener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
        }
        return bl;
    }

    protected void finalize() {
        try {
            this.remoteImage.dispose(this.id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose();
    }

    public ImageLayout getImageLayout() throws RemoteImagingException {
        ImageLayout imageLayout = new ImageLayout();
        try {
            imageLayout.setMinX(this.remoteImage.getMinX(this.id));
            imageLayout.setMinY(this.remoteImage.getMinY(this.id));
            imageLayout.setWidth(this.remoteImage.getWidth(this.id));
            imageLayout.setHeight(this.remoteImage.getHeight(this.id));
            imageLayout.setTileWidth(this.remoteImage.getTileWidth(this.id));
            imageLayout.setTileHeight(this.remoteImage.getTileHeight(this.id));
            imageLayout.setTileGridXOffset(this.remoteImage.getTileGridXOffset(this.id));
            imageLayout.setTileGridYOffset(this.remoteImage.getTileGridYOffset(this.id));
            SerializableState serializableState = this.remoteImage.getSampleModel(this.id);
            imageLayout.setSampleModel((SampleModel)serializableState.getObject());
            SerializableState serializableState2 = this.remoteImage.getColorModel(this.id);
            imageLayout.setColorModel((ColorModel)serializableState2.getObject());
            return imageLayout;
        }
        catch (RemoteException remoteException) {
            String string = JaiI18N.getString("RMIServerProxy14");
            this.listener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Raster computeTile(int var1_1, int var2_2) throws RemoteImagingException {
        if (var1_1 < this.getMinTileX() || var1_1 > this.getMaxTileX() || var2_2 < this.getMinTileY() || var2_2 > this.getMaxTileY()) {
            return null;
        }
        var3_3 = this.getNegotiatedValue("tileCodec");
        var4_4 = null;
        var5_5 = null;
        if (var3_3 != null) {
            var6_6 = var3_3.getCategory();
            var7_8 = var3_3.getCapabilityName();
            var8_9 = var3_3.getGenerators();
            var10_10 = var8_9.iterator();
            while (var10_10.hasNext()) {
                var9_11 = (Class)var10_10.next();
                if (var4_4 != null || !(RMIServerProxy.class$javax$media$jai$tilecodec$TileDecoderFactory == null ? RMIServerProxy.class$("javax.media.jai.tilecodec.TileDecoderFactory") : RMIServerProxy.class$javax$media$jai$tilecodec$TileDecoderFactory).isAssignableFrom(var9_11)) continue;
                try {
                    var4_4 = (TileDecoderFactory)var9_11.newInstance();
                }
                catch (InstantiationException var11_13) {
                    throw new RemoteImagingException(ImageUtil.getStackTraceString(var11_13));
                }
                catch (IllegalAccessException var11_14) {
                    throw new RemoteImagingException(ImageUtil.getStackTraceString(var11_14));
                }
            }
            if (var4_4 == null) {
                throw new RemoteImagingException(JaiI18N.getString("RMIServerProxy0"));
            }
            var10_10 = (TileCodecDescriptor)this.registry.getDescriptor("tileDecoder", (String)var7_8);
            if (!var10_10.includesSampleModelInfo() || !var10_10.includesLocationInfo()) {
                throw new RemoteImagingException(JaiI18N.getString("RMIServerProxy1"));
            }
            var11_15 = var10_10.getParameterListDescriptor("tileDecoder");
            var5_5 = new TileCodecParameterList((String)var7_8, new String[]{"tileDecoder"}, var11_15);
            ** if (var11_15 == null || (var12_16 = var11_15.getParamNames()) == null) goto lbl39
            for (var15_17 = 0; var15_17 < var12_16.length; ++var15_17) {
                var13_18 = var12_16[var15_17];
                try {
                    var14_19 = var3_3.getNegotiatedValue(var13_18);
                }
                catch (IllegalArgumentException var16_20) {
                    continue;
                }
                var5_5.setParameter(var13_18, var14_19);
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl39:
        // 4 sources

        try {
            if (var3_3 != null) {
                var6_6 = this.remoteImage.getCompressedTile(this.id, var1_1, var2_2);
                var7_8 = new ByteArrayInputStream((byte[])var6_6);
                var8_9 = var4_4.createDecoder((InputStream)var7_8, var5_5);
                try {
                    return var8_9.decode();
                }
                catch (IOException var9_12) {
                    throw new RemoteImagingException(ImageUtil.getStackTraceString(var9_12));
                }
            }
            var6_6 = this.remoteImage.getTile(this.id, var1_1, var2_2);
            return (Raster)var6_6.getObject();
        }
        catch (RemoteException var6_7) {
            var7_8 = JaiI18N.getString("RMIServerProxy15");
            this.listener.errorOccurred((String)var7_8, new RemoteImagingException((String)var7_8, var6_7), this, false);
            return null;
        }
    }

    public Object getRemoteProperty(String string) throws RemoteImagingException {
        try {
            Object object = this.remoteImage.getProperty(this.id, string);
            if (NULL_PROPERTY_CLASS.isInstance(object)) {
                object = Image.UndefinedProperty;
            }
            return object;
        }
        catch (RemoteException remoteException) {
            String string2 = JaiI18N.getString("RMIServerProxy16");
            this.listener.errorOccurred(string2, new RemoteImagingException(string2, remoteException), this, false);
            return Image.UndefinedProperty;
        }
    }

    public String[] getRemotePropertyNames() throws RemoteImagingException {
        try {
            return this.remoteImage.getPropertyNames(this.id);
        }
        catch (RemoteException remoteException) {
            String string = JaiI18N.getString("RMIServerProxy17");
            this.listener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
            return null;
        }
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) throws RemoteImagingException {
        Rectangle rectangle2 = null;
        try {
            rectangle2 = this.remoteImage.mapSourceRect(this.id, rectangle, n);
        }
        catch (RemoteException remoteException) {
            String string = JaiI18N.getString("RMIServerProxy18");
            this.listener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
        }
        return rectangle2;
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) throws RemoteImagingException {
        Rectangle rectangle2 = null;
        try {
            rectangle2 = this.remoteImage.mapDestRect(this.id, rectangle, n);
        }
        catch (RemoteException remoteException) {
            String string = JaiI18N.getString("RMIServerProxy18");
            this.listener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
        }
        return rectangle2;
    }

    public void setNegotiationPreferences(NegotiableCapabilitySet negotiableCapabilitySet) {
        if (this.remoteImage == null) {
            this.negPref = negotiableCapabilitySet;
            this.preferencesSet = true;
        } else {
            super.setNegotiationPreferences(negotiableCapabilitySet);
        }
    }

    public synchronized void setServerNegotiatedValues(NegotiableCapabilitySet negotiableCapabilitySet) throws RemoteImagingException {
        try {
            this.remoteImage.setServerNegotiatedValues(this.id, negotiableCapabilitySet);
        }
        catch (RemoteException remoteException) {
            String string = JaiI18N.getString("RMIServerProxy19");
            this.listener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

