/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.tilecodec;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGQTable;
import com.sun.media.jai.tilecodec.JaiI18N;
import com.sun.media.jai.tilecodec.TileCodecUtils;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.RasterFactory;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoderImpl;
import javax.media.jai.util.ImagingListener;

public class JPEGTileDecoder
extends TileDecoderImpl {
    private TileCodecDescriptor tcd = TileCodecUtils.getTileCodecDescriptor("tileDecoder", "jpeg");

    public JPEGTileDecoder(InputStream inputStream, TileCodecParameterList tileCodecParameterList) {
        super("jpeg", inputStream, tileCodecParameterList);
    }

    public Raster decode() throws IOException {
        if (!this.tcd.includesLocationInfo()) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGTileDecoder0"));
        }
        return this.decode(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster decode(Point point) throws IOException {
        SampleModel sampleModel = null;
        byte[] byArray = null;
        ObjectInputStream objectInputStream = new ObjectInputStream(this.inputStream);
        try {
            this.paramList.setParameter("quality", objectInputStream.readFloat());
            this.paramList.setParameter("qualitySet", objectInputStream.readBoolean());
            sampleModel = TileCodecUtils.deserializeSampleModel(objectInputStream.readObject());
            point = (Point)objectInputStream.readObject();
            byArray = (byte[])objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
            imagingListener.errorOccurred(JaiI18N.getString("ClassNotFound"), classNotFoundException, this, false);
            Raster raster = null;
            return raster;
        }
        finally {
            objectInputStream.close();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
        Raster raster = jPEGImageDecoder.decodeAsRaster().createTranslatedChild(point.x, point.y);
        this.extractParameters(jPEGImageDecoder.getJPEGDecodeParam(), raster.getSampleModel().getNumBands());
        if (sampleModel != null) {
            int n = raster.getMinX();
            int n2 = raster.getMinY();
            int n3 = raster.getHeight();
            int n4 = raster.getWidth();
            double[] dArray = raster.getPixels(n, n2, n4, n3, (double[])null);
            raster = RasterFactory.createWritableRaster(sampleModel, new Point(n, n2));
            ((WritableRaster)raster).setPixels(n, n2, n4, n3, dArray);
        }
        return raster;
    }

    private void extractParameters(JPEGDecodeParam jPEGDecodeParam, int n) {
        int n2;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = jPEGDecodeParam.getHorizontalSubsampling(i);
        }
        this.paramList.setParameter("horizontalSubsampling", nArray);
        int[] nArray2 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray2[n2] = jPEGDecodeParam.getVerticalSubsampling(n2);
        }
        this.paramList.setParameter("verticalSubsampling", nArray2);
        if (!this.paramList.getBooleanParameter("qualitySet")) {
            for (n2 = 0; n2 < 4; ++n2) {
                JPEGQTable jPEGQTable = jPEGDecodeParam.getQTable(n2);
                this.paramList.setParameter("quantizationTable" + n2, jPEGQTable == null ? null : jPEGQTable.getTable());
            }
        } else {
            ParameterListDescriptor parameterListDescriptor = this.paramList.getParameterListDescriptor();
            for (int i = 0; i < 4; ++i) {
                this.paramList.setParameter("quantizationTable" + i, parameterListDescriptor.getParamDefaultValue("quantizationTable" + i));
            }
        }
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = jPEGDecodeParam.getQTableComponentMapping(i);
        }
        this.paramList.setParameter("quantizationTableMapping", nArray3);
        this.paramList.setParameter("writeTableInfo", jPEGDecodeParam.isTableInfoValid());
        this.paramList.setParameter("writeImageInfo", jPEGDecodeParam.isImageInfoValid());
        this.paramList.setParameter("restartInterval", jPEGDecodeParam.getRestartInterval());
        this.paramList.setParameter("writeJFIFHeader", jPEGDecodeParam.getMarker(224));
    }
}

