/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

public final class BorderExtenderReflect
extends BorderExtender {
    BorderExtenderReflect() {
    }

    private void flipX(WritableRaster writableRaster) {
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        int n5 = n + n4 - 1;
        int n6 = writableRaster.getNumBands();
        switch (writableRaster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = new int[n3 * n6];
                int[] nArray2 = new int[n3 * n6];
                for (int i = 0; i < n4 / 2; ++i) {
                    writableRaster.getPixels(n + i, n2, 1, n3, nArray);
                    writableRaster.getPixels(n5 - i, n2, 1, n3, nArray2);
                    writableRaster.setPixels(n + i, n2, 1, n3, nArray2);
                    writableRaster.setPixels(n5 - i, n2, 1, n3, nArray);
                }
                break;
            }
            case 4: {
                float[] fArray = new float[n3 * n6];
                float[] fArray2 = new float[n3 * n6];
                for (int i = 0; i < n4 / 2; ++i) {
                    writableRaster.getPixels(n + i, n2, 1, n3, fArray);
                    writableRaster.getPixels(n5 - i, n2, 1, n3, fArray2);
                    writableRaster.setPixels(n + i, n2, 1, n3, fArray2);
                    writableRaster.setPixels(n5 - i, n2, 1, n3, fArray);
                }
                break;
            }
            case 5: {
                double[] dArray = new double[n3 * n6];
                double[] dArray2 = new double[n3 * n6];
                for (int i = 0; i < n4 / 2; ++i) {
                    writableRaster.getPixels(n + i, n2, 1, n3, dArray);
                    writableRaster.getPixels(n5 - i, n2, 1, n3, dArray2);
                    writableRaster.setPixels(n + i, n2, 1, n3, dArray2);
                    writableRaster.setPixels(n5 - i, n2, 1, n3, dArray);
                }
                break;
            }
        }
    }

    private void flipY(WritableRaster writableRaster) {
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        int n5 = n2 + n3 - 1;
        int n6 = writableRaster.getNumBands();
        switch (writableRaster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = new int[n4 * n6];
                int[] nArray2 = new int[n4 * n6];
                for (int i = 0; i < n3 / 2; ++i) {
                    writableRaster.getPixels(n, n2 + i, n4, 1, nArray);
                    writableRaster.getPixels(n, n5 - i, n4, 1, nArray2);
                    writableRaster.setPixels(n, n2 + i, n4, 1, nArray2);
                    writableRaster.setPixels(n, n5 - i, n4, 1, nArray);
                }
                break;
            }
            case 4: {
                float[] fArray = new float[n4 * n6];
                float[] fArray2 = new float[n4 * n6];
                for (int i = 0; i < n3 / 2; ++i) {
                    writableRaster.getPixels(n, n2 + i, n4, 1, fArray);
                    writableRaster.getPixels(n, n5 - i, n4, 1, fArray2);
                    writableRaster.setPixels(n, n2 + i, n4, 1, fArray2);
                    writableRaster.setPixels(n, n5 - i, n4, 1, fArray);
                }
                break;
            }
            case 5: {
                double[] dArray = new double[n4 * n6];
                double[] dArray2 = new double[n4 * n6];
                for (int i = 0; i < n3 / 2; ++i) {
                    writableRaster.getPixels(n, n2 + i, n4, 1, dArray);
                    writableRaster.getPixels(n, n5 - i, n4, 1, dArray2);
                    writableRaster.setPixels(n, n2 + i, n4, 1, dArray2);
                    writableRaster.setPixels(n, n5 - i, n4, 1, dArray);
                }
                break;
            }
        }
    }

    public final void extend(WritableRaster writableRaster, PlanarImage planarImage) {
        if (writableRaster == null || planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getMinX();
        int n4 = n3 + n;
        int n5 = writableRaster.getMinY();
        int n6 = n5 + n2;
        int n7 = planarImage.getMinX();
        int n8 = planarImage.getMinY();
        int n9 = planarImage.getWidth();
        int n10 = planarImage.getHeight();
        int n11 = Math.max(n7, n3);
        int n12 = Math.min(n7 + n9, n4);
        int n13 = Math.max(n8, n5);
        int n14 = Math.min(n8 + n10, n6);
        if (n11 > n12 || n13 > n14) {
            if (n11 > n12) {
                if (n3 == n11) {
                    n3 = planarImage.getMaxX() - 1;
                } else {
                    n4 = planarImage.getMinX();
                }
            }
            if (n13 > n14) {
                if (n5 == n13) {
                    n5 = planarImage.getMaxY() - 1;
                } else {
                    n6 = planarImage.getMinY();
                }
            }
            WritableRaster writableRaster2 = writableRaster.createCompatibleWritableRaster(n3, n5, n4 - n3, n6 - n5);
            this.extend(writableRaster2, planarImage);
            Raster raster = writableRaster2.createChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), null);
            JDKWorkarounds.setRect(writableRaster, raster, 0, 0);
            return;
        }
        Rectangle rectangle = new Rectangle();
        int n15 = PlanarImage.XToTileX(n3, n7, n9);
        int n16 = PlanarImage.XToTileX(n4 - 1, n7, n9);
        int n17 = PlanarImage.YToTileY(n5, n8, n10);
        int n18 = PlanarImage.YToTileY(n6 - 1, n8, n10);
        for (int i = n17; i <= n18; ++i) {
            int n19 = i * n10 + n8;
            for (int j = n15; j <= n16; ++j) {
                int n20 = j * n9 + n7;
                if (j == 0 && i == 0) continue;
                boolean bl = Math.abs(j) % 2 == 1;
                boolean bl2 = Math.abs(i) % 2 == 1;
                rectangle.x = n20;
                rectangle.y = n19;
                rectangle.width = n9;
                rectangle.height = n10;
                int n21 = 0;
                if (rectangle.x < n3) {
                    n21 = n3 - rectangle.x;
                    rectangle.x = n3;
                    rectangle.width -= n21;
                }
                int n22 = 0;
                if (rectangle.y < n5) {
                    n22 = n5 - rectangle.y;
                    rectangle.y = n5;
                    rectangle.height -= n22;
                }
                if (rectangle.x + rectangle.width > n4) {
                    rectangle.width = n4 - rectangle.x;
                }
                if (rectangle.y + rectangle.height > n6) {
                    rectangle.height = n6 - rectangle.y;
                }
                int n23 = bl ? (n21 == 0 ? n7 + n9 - rectangle.width : n7) : n7 + n21;
                int n24 = bl2 ? (n22 == 0 ? n8 + n10 - rectangle.height : n8) : n8 + n22;
                WritableRaster writableRaster3 = RasterFactory.createWritableChild(writableRaster, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n23, n24, null);
                planarImage.copyData(writableRaster3);
                if (bl) {
                    this.flipX(writableRaster3);
                }
                if (!bl2) continue;
                this.flipY(writableRaster3);
            }
        }
    }
}

