/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.RegistryMode;
import javax.media.jai.util.CaselessStringKey;

class FactoryCache {
    final String modeName;
    final RegistryMode mode;
    final Class factoryClass;
    final Method factoryMethod;
    final boolean arePreferencesSupported;
    private Hashtable instances;
    private Hashtable instancesByName;
    private int count = 0;
    private Hashtable prefs;

    FactoryCache(String string) {
        this.modeName = string;
        this.mode = RegistryMode.getMode(string);
        this.factoryClass = this.mode.getFactoryClass();
        this.factoryMethod = this.mode.getFactoryMethod();
        this.arePreferencesSupported = this.mode.arePreferencesSupported();
        this.instances = new Hashtable();
        if (this.arePreferencesSupported) {
            this.instancesByName = new Hashtable();
            this.prefs = new Hashtable();
        }
    }

    Object invoke(Object object, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
        return this.factoryMethod.invoke(object, objectArray);
    }

    void addFactory(String string, String string2, Object object) {
        this.checkInstance(object);
        if (this.arePreferencesSupported) {
            if (string2 == null) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
            Vector<String> vector = new Vector<String>();
            vector.add(object.getClass().getName());
            vector.add(string2);
            vector.add(string);
            CaselessStringKey caselessStringKey = new CaselessStringKey(this.modeName + this.count);
            this.instancesByName.put(object, caselessStringKey);
            this.instances.put(caselessStringKey, vector);
            ++this.count;
        } else {
            this.instances.put(new CaselessStringKey(string), object);
        }
    }

    void removeFactory(String string, String string2, Object object) {
        this.checkInstance(object);
        this.checkRegistered(string, string2, object);
        if (this.arePreferencesSupported) {
            CaselessStringKey caselessStringKey = (CaselessStringKey)this.instancesByName.get(object);
            this.instancesByName.remove(object);
            this.instances.remove(caselessStringKey);
            --this.count;
        } else {
            this.instances.remove(new CaselessStringKey(string));
        }
    }

    void setPreference(String string, String string2, Object object, Object object2) {
        Vector<Object[]> vector;
        if (!this.arePreferencesSupported) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("FactoryCache1", new Object[]{this.modeName}));
        }
        if (object == null || object2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.checkRegistered(string, string2, object);
        this.checkRegistered(string, string2, object2);
        if (object == object2) {
            return;
        }
        this.checkInstance(object);
        this.checkInstance(object2);
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        CaselessStringKey caselessStringKey2 = new CaselessStringKey(string2);
        Hashtable<CaselessStringKey, Vector<Object[]>> hashtable = (Hashtable<CaselessStringKey, Vector<Object[]>>)this.prefs.get(caselessStringKey);
        if (hashtable == null) {
            hashtable = new Hashtable<CaselessStringKey, Vector<Object[]>>();
            this.prefs.put(caselessStringKey, hashtable);
        }
        if ((vector = (Vector<Object[]>)hashtable.get(caselessStringKey2)) == null) {
            vector = new Vector<Object[]>();
            hashtable.put(caselessStringKey2, vector);
        }
        vector.addElement(new Object[]{object, object2});
    }

    void unsetPreference(String string, String string2, Object object, Object object2) {
        Vector vector;
        if (!this.arePreferencesSupported) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("FactoryCache1", new Object[]{this.modeName}));
        }
        if (object == null || object2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.checkRegistered(string, string2, object);
        this.checkRegistered(string, string2, object2);
        if (object == object2) {
            return;
        }
        this.checkInstance(object);
        this.checkInstance(object2);
        Hashtable hashtable = (Hashtable)this.prefs.get(new CaselessStringKey(string));
        boolean bl = false;
        if (hashtable != null && (vector = (Vector)hashtable.get(new CaselessStringKey(string2))) != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                if (objectArray[0] != object || objectArray[1] != object2) continue;
                iterator.remove();
                bl = true;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("FactoryCache2", new Object[]{object.getClass().getName(), object2.getClass().getName(), this.modeName, string, string2}));
        }
    }

    Object[][] getPreferences(String string, String string2) {
        Vector vector;
        if (!this.arePreferencesSupported) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("FactoryCache1", new Object[]{this.modeName}));
        }
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Hashtable hashtable = (Hashtable)this.prefs.get(new CaselessStringKey(string));
        if (hashtable != null && (vector = (Vector)hashtable.get(new CaselessStringKey(string2))) != null) {
            return (Object[][])vector.toArray((T[])new Object[0][]);
        }
        return null;
    }

    void clearPreferences(String string, String string2) {
        if (!this.arePreferencesSupported) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("FactoryCache1", new Object[]{this.modeName}));
        }
        Hashtable hashtable = (Hashtable)this.prefs.get(new CaselessStringKey(string));
        if (hashtable != null) {
            hashtable.remove(new CaselessStringKey(string2));
        }
    }

    List getFactoryList(String string, String string2) {
        if (this.arePreferencesSupported) {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = this.instancesByName.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                CaselessStringKey caselessStringKey = (CaselessStringKey)this.instancesByName.get(k);
                Vector vector = (Vector)this.instances.get(caselessStringKey);
                String string3 = (String)vector.get(2);
                String string4 = (String)vector.get(1);
                if (!string.equalsIgnoreCase(string3) || !string2.equalsIgnoreCase(string4)) continue;
                arrayList.add(k);
            }
            return arrayList;
        }
        Object v = this.instances.get(new CaselessStringKey(string));
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(v);
        return arrayList;
    }

    String getLocalName(Object object) {
        CaselessStringKey caselessStringKey = (CaselessStringKey)this.instancesByName.get(object);
        if (caselessStringKey != null) {
            return caselessStringKey.getName();
        }
        return null;
    }

    private boolean checkInstance(Object object) {
        if (!this.factoryClass.isInstance(object)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("FactoryCache0", new Object[]{object.getClass().getName(), this.modeName, this.factoryClass.getName()}));
        }
        return true;
    }

    private void checkRegistered(String string, String string2, Object object) {
        if (this.arePreferencesSupported) {
            if (string2 == null) {
                throw new IllegalArgumentException("productName : " + JaiI18N.getString("Generic0"));
            }
            CaselessStringKey caselessStringKey = (CaselessStringKey)this.instancesByName.get(object);
            if (caselessStringKey != null) {
                Vector vector = (Vector)this.instances.get(caselessStringKey);
                String string3 = (String)vector.get(1);
                String string4 = (String)vector.get(2);
                if (string4 != null && string4.equalsIgnoreCase(string) && string3 != null && string3.equalsIgnoreCase(string2)) {
                    return;
                }
            }
            throw new IllegalArgumentException(JaiI18N.formatMsg("FactoryCache3", new Object[]{object.getClass().getName(), string, string2}));
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (object != this.instances.get(caselessStringKey)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("FactoryCache4", new Object[]{object.getClass().getName(), string}));
        }
    }
}

