/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.JaiI18N;
import javax.media.jai.RasterFormatTag;
import sun.awt.image.BytePackedRaster;

public class RasterAccessor {
    private static final int COPY_MASK_SHIFT = 7;
    private static final int COPY_MASK_SIZE = 2;
    public static final int COPY_MASK = 384;
    public static final int UNCOPIED = 0;
    public static final int COPIED = 128;
    private static final int EXPANSION_MASK_SHIFT = 9;
    private static final int EXPANSION_MASK_SIZE = 2;
    public static final int EXPANSION_MASK = 1536;
    public static final int DEFAULTEXPANSION = 0;
    public static final int EXPANDED = 512;
    public static final int UNEXPANDED = 1024;
    public static final int DATATYPE_MASK = 127;
    public static final int TAG_BYTE_UNCOPIED = 0;
    public static final int TAG_USHORT_UNCOPIED = 1;
    public static final int TAG_SHORT_UNCOPIED = 2;
    public static final int TAG_INT_UNCOPIED = 3;
    public static final int TAG_FLOAT_UNCOPIED = 4;
    public static final int TAG_DOUBLE_UNCOPIED = 5;
    public static final int TAG_INT_COPIED = 131;
    public static final int TAG_FLOAT_COPIED = 132;
    public static final int TAG_DOUBLE_COPIED = 133;
    public static final int TAG_BYTE_EXPANDED = 512;
    private static final int TAG_BINARY = 1152;
    protected Raster raster;
    protected int rectWidth;
    protected int rectHeight;
    protected int rectX;
    protected int rectY;
    protected int formatTagID;
    protected byte[] binaryDataArray;
    protected byte[][] byteDataArrays;
    protected short[][] shortDataArrays;
    protected int[][] intDataArrays;
    protected float[][] floatDataArrays;
    protected double[][] doubleDataArrays;
    protected int[] bandDataOffsets;
    protected int[] bandOffsets;
    protected int numBands;
    protected int scanlineStride;
    protected int pixelStride;

    public static RasterFormatTag[] findCompatibleTags(RenderedImage[] renderedImageArray, RenderedImage renderedImage) {
        int n;
        int n2;
        int n3;
        int[] nArray = renderedImageArray != null ? new int[renderedImageArray.length + 1] : new int[1];
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n4 = n3 = sampleModel.getTransferType();
        boolean bl = ImageUtil.isBinary(sampleModel);
        if (bl) {
            n4 = 0;
        } else if (n3 == 0 || n3 == 1 || n3 == 2) {
            n4 = 3;
        }
        if (renderedImageArray != null) {
            n2 = renderedImageArray.length;
            for (n = 0; n < n2; ++n) {
                SampleModel sampleModel2 = renderedImageArray[n].getSampleModel();
                int n5 = sampleModel2.getTransferType();
                if (bl && ImageUtil.isBinary(sampleModel2) || n5 <= n4) continue;
                n4 = n5;
            }
        }
        n2 = n4 | 0x80;
        if (sampleModel instanceof ComponentSampleModel) {
            if (renderedImageArray != null) {
                int n6;
                n = renderedImageArray.length;
                for (n6 = 0; n6 < n; ++n6) {
                    SampleModel sampleModel3 = renderedImageArray[n6].getSampleModel();
                    int n7 = sampleModel3.getTransferType();
                    if (!(sampleModel3 instanceof ComponentSampleModel) || n7 != n3) break;
                }
                if (n6 == n) {
                    n2 = n3 | 0;
                }
            } else {
                n2 = n3 | 0;
            }
        }
        RasterFormatTag[] rasterFormatTagArray = new RasterFormatTag[nArray.length];
        if (renderedImageArray != null) {
            int n8;
            for (n8 = 0; n8 < renderedImageArray.length; ++n8) {
                if (renderedImageArray[n8].getColorModel() instanceof IndexColorModel) {
                    if (renderedImage.getColorModel() instanceof IndexColorModel) {
                        nArray[n8] = n2 | 0x400;
                        continue;
                    }
                    nArray[n8] = n2 | 0x200;
                    continue;
                }
                nArray[n8] = renderedImageArray[n8].getColorModel() instanceof ComponentColorModel || bl && ImageUtil.isBinary(renderedImageArray[n8].getSampleModel()) ? n2 | 0x400 : n2 | 0;
            }
            nArray[renderedImageArray.length] = n2 | 0x400;
            for (n8 = 0; n8 < renderedImageArray.length; ++n8) {
                rasterFormatTagArray[n8] = new RasterFormatTag(renderedImageArray[n8].getSampleModel(), nArray[n8]);
            }
            rasterFormatTagArray[renderedImageArray.length] = new RasterFormatTag(sampleModel, nArray[renderedImageArray.length]);
        } else {
            rasterFormatTagArray[0] = new RasterFormatTag(sampleModel, n2 | 0x400);
        }
        return rasterFormatTagArray;
    }

    public static int findCompatibleTag(SampleModel[] sampleModelArray, SampleModel sampleModel) {
        int n = sampleModel.getTransferType();
        int n2 = n | 0x80;
        if (ImageUtil.isBinary(sampleModel)) {
            n2 = 128;
        } else if (n == 0 || n == 1 || n == 2) {
            n2 = 131;
        }
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModelArray != null) {
                int n3;
                int n4 = sampleModelArray.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    int n5 = sampleModelArray[n3].getTransferType();
                    if (!(sampleModelArray[n3] instanceof ComponentSampleModel) || n5 != n) break;
                }
                if (n3 == n4) {
                    n2 = n | 0;
                }
            } else {
                n2 = n | 0;
            }
        }
        return n2 | 0x400;
    }

    public RasterAccessor(Raster raster, Rectangle rectangle, RasterFormatTag rasterFormatTag, ColorModel colorModel) {
        block89: {
            block90: {
                block88: {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    this.binaryDataArray = null;
                    this.byteDataArrays = null;
                    this.shortDataArrays = null;
                    this.intDataArrays = null;
                    this.floatDataArrays = null;
                    this.doubleDataArrays = null;
                    if (raster == null || rectangle == null || rasterFormatTag == null) {
                        throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
                    }
                    if (!raster.getBounds().contains(rectangle)) {
                        throw new IllegalArgumentException(JaiI18N.getString("RasterAccessor2"));
                    }
                    this.raster = raster;
                    this.rectX = rectangle.x;
                    this.rectY = rectangle.y;
                    this.rectWidth = rectangle.width;
                    this.rectHeight = rectangle.height;
                    this.formatTagID = rasterFormatTag.getFormatTagID();
                    if ((this.formatTagID & 0x180) != 0) break block88;
                    this.numBands = rasterFormatTag.getNumBands();
                    this.pixelStride = rasterFormatTag.getPixelStride();
                    ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                    this.scanlineStride = componentSampleModel.getScanlineStride();
                    int[] nArray = null;
                    if (rasterFormatTag.isPixelSequential()) {
                        this.bandOffsets = rasterFormatTag.getBandOffsets();
                        nArray = rasterFormatTag.getBankIndices();
                    } else {
                        this.bandOffsets = componentSampleModel.getBandOffsets();
                        nArray = componentSampleModel.getBankIndices();
                    }
                    this.bandDataOffsets = new int[this.numBands];
                    int[] nArray2 = raster.getDataBuffer().getOffsets();
                    int n6 = (this.rectY - raster.getSampleModelTranslateY()) * this.scanlineStride + (this.rectX - raster.getSampleModelTranslateX()) * this.pixelStride;
                    if (nArray2.length == 1) {
                        n5 = nArray2[0];
                        for (n4 = 0; n4 < this.numBands; ++n4) {
                            this.bandDataOffsets[n4] = this.bandOffsets[n4] + n5 + n6;
                        }
                    } else if (nArray2.length == this.bandDataOffsets.length) {
                        for (n5 = 0; n5 < this.numBands; ++n5) {
                            this.bandDataOffsets[n5] = this.bandOffsets[n5] + nArray2[n5] + n6;
                        }
                    } else {
                        throw new RuntimeException(JaiI18N.getString("RasterAccessor0"));
                    }
                    switch (this.formatTagID & 0x7F) {
                        case 0: {
                            DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                            this.byteDataArrays = new byte[this.numBands][];
                            for (n4 = 0; n4 < this.numBands; ++n4) {
                                this.byteDataArrays[n4] = dataBufferByte.getData(nArray[n4]);
                            }
                            break;
                        }
                        case 1: {
                            DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
                            this.shortDataArrays = new short[this.numBands][];
                            for (n3 = 0; n3 < this.numBands; ++n3) {
                                this.shortDataArrays[n3] = dataBufferUShort.getData(nArray[n3]);
                            }
                            break;
                        }
                        case 2: {
                            DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
                            this.shortDataArrays = new short[this.numBands][];
                            for (int i = 0; i < this.numBands; ++i) {
                                this.shortDataArrays[i] = dataBufferShort.getData(nArray[i]);
                            }
                            break;
                        }
                        case 3: {
                            DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
                            this.intDataArrays = new int[this.numBands][];
                            for (n2 = 0; n2 < this.numBands; ++n2) {
                                this.intDataArrays[n2] = dataBufferInt.getData(nArray[n2]);
                            }
                            break;
                        }
                        case 4: {
                            DataBuffer dataBuffer = raster.getDataBuffer();
                            this.floatDataArrays = new float[this.numBands][];
                            for (n = 0; n < this.numBands; ++n) {
                                this.floatDataArrays[n] = DataBufferUtils.getDataFloat(dataBuffer, nArray[n]);
                            }
                            break;
                        }
                        case 5: {
                            DataBuffer dataBuffer = raster.getDataBuffer();
                            this.doubleDataArrays = new double[this.numBands][];
                            for (int i = 0; i < this.numBands; ++i) {
                                this.doubleDataArrays[i] = DataBufferUtils.getDataDouble(dataBuffer, nArray[i]);
                            }
                            break;
                        }
                    }
                    if ((this.formatTagID & 0x600) == 512 && colorModel instanceof IndexColorModel) {
                        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                        int n7 = indexColorModel.getNumComponents();
                        n3 = indexColorModel.getMapSize();
                        int[] nArray3 = new int[n7];
                        n2 = this.rectWidth * n7;
                        n = n7;
                        byte[][] byArray = new byte[n7][n3];
                        indexColorModel.getReds(byArray[0]);
                        indexColorModel.getGreens(byArray[1]);
                        indexColorModel.getBlues(byArray[2]);
                        byte[] byArray2 = byArray[0];
                        byte[] byArray3 = byArray[1];
                        byte[] byArray4 = byArray[2];
                        byte[] byArray5 = null;
                        if (n7 == 4) {
                            indexColorModel.getAlphas(byArray[3]);
                            byArray5 = byArray[3];
                        }
                        for (int i = 0; i < n7; ++i) {
                            nArray3[i] = i;
                        }
                        switch (this.formatTagID & 0x7F) {
                            case 0: {
                                int n8;
                                byte[] byArray6 = new byte[this.rectWidth * this.rectHeight * n7];
                                byte[] byArray7 = this.byteDataArrays[0];
                                int n9 = this.bandDataOffsets[0];
                                int n10 = 0;
                                for (n8 = 0; n8 < this.rectHeight; ++n8) {
                                    int n11 = n9;
                                    int n12 = n10;
                                    for (int i = 0; i < this.rectWidth; ++i) {
                                        int n13 = byArray7[n11] & 0xFF;
                                        for (int j = 0; j < n7; ++j) {
                                            byArray6[n12 + j] = byArray[j][n13];
                                        }
                                        n11 += this.pixelStride;
                                        n12 += n;
                                    }
                                    n9 += this.scanlineStride;
                                    n10 += n2;
                                }
                                this.byteDataArrays = new byte[n7][];
                                for (n8 = 0; n8 < n7; ++n8) {
                                    this.byteDataArrays[n8] = byArray6;
                                }
                                break;
                            }
                            case 1: {
                                int n14;
                                short[] sArray = new short[this.rectWidth * this.rectHeight * n7];
                                short[] sArray2 = this.shortDataArrays[0];
                                int n15 = this.bandDataOffsets[0];
                                int n16 = 0;
                                for (n14 = 0; n14 < this.rectHeight; ++n14) {
                                    int n17 = n15;
                                    int n18 = n16;
                                    for (int i = 0; i < this.rectWidth; ++i) {
                                        int n19 = sArray2[n17] & 0xFFFF;
                                        for (int j = 0; j < n7; ++j) {
                                            sArray[n18 + j] = (short)(byArray[j][n19] & 0xFF);
                                        }
                                        n17 += this.pixelStride;
                                        n18 += n;
                                    }
                                    n15 += this.scanlineStride;
                                    n16 += n2;
                                }
                                this.shortDataArrays = new short[n7][];
                                for (n14 = 0; n14 < n7; ++n14) {
                                    this.shortDataArrays[n14] = sArray;
                                }
                                break;
                            }
                            case 2: {
                                int n20;
                                short[] sArray = new short[this.rectWidth * this.rectHeight * n7];
                                short[] sArray3 = this.shortDataArrays[0];
                                int n21 = this.bandDataOffsets[0];
                                int n22 = 0;
                                for (n20 = 0; n20 < this.rectHeight; ++n20) {
                                    int n23 = n21;
                                    int n24 = n22;
                                    for (int i = 0; i < this.rectWidth; ++i) {
                                        short s = sArray3[n23];
                                        for (int j = 0; j < n7; ++j) {
                                            sArray[n24 + j] = (short)(byArray[j][s] & 0xFF);
                                        }
                                        n23 += this.pixelStride;
                                        n24 += n;
                                    }
                                    n21 += this.scanlineStride;
                                    n22 += n2;
                                }
                                this.shortDataArrays = new short[n7][];
                                for (n20 = 0; n20 < n7; ++n20) {
                                    this.shortDataArrays[n20] = sArray;
                                }
                                break;
                            }
                            case 3: {
                                int n25;
                                int[] nArray4 = new int[this.rectWidth * this.rectHeight * n7];
                                int[] nArray5 = this.intDataArrays[0];
                                int n26 = this.bandDataOffsets[0];
                                int n27 = 0;
                                for (n25 = 0; n25 < this.rectHeight; ++n25) {
                                    int n28 = n26;
                                    int n29 = n27;
                                    for (int i = 0; i < this.rectWidth; ++i) {
                                        int n30 = nArray5[n28];
                                        for (int j = 0; j < n7; ++j) {
                                            nArray4[n29 + j] = byArray[j][n30] & 0xFF;
                                        }
                                        n28 += this.pixelStride;
                                        n29 += n;
                                    }
                                    n26 += this.scanlineStride;
                                    n27 += n2;
                                }
                                this.intDataArrays = new int[n7][];
                                for (n25 = 0; n25 < n7; ++n25) {
                                    this.intDataArrays[n25] = nArray4;
                                }
                                break;
                            }
                            case 4: {
                                int n31;
                                float[] fArray = new float[this.rectWidth * this.rectHeight * n7];
                                float[] fArray2 = this.floatDataArrays[0];
                                int n32 = this.bandDataOffsets[0];
                                int n33 = 0;
                                for (n31 = 0; n31 < this.rectHeight; ++n31) {
                                    int n34 = n32;
                                    int n35 = n33;
                                    for (int i = 0; i < this.rectWidth; ++i) {
                                        int n36 = (int)fArray2[n34];
                                        for (int j = 0; j < n7; ++j) {
                                            fArray[n35 + j] = byArray[j][n36] & 0xFF;
                                        }
                                        n34 += this.pixelStride;
                                        n35 += n;
                                    }
                                    n32 += this.scanlineStride;
                                    n33 += n2;
                                }
                                this.floatDataArrays = new float[n7][];
                                for (n31 = 0; n31 < n7; ++n31) {
                                    this.floatDataArrays[n31] = fArray;
                                }
                                break;
                            }
                            case 5: {
                                int n37;
                                double[] dArray = new double[this.rectWidth * this.rectHeight * n7];
                                double[] dArray2 = this.doubleDataArrays[0];
                                int n38 = this.bandDataOffsets[0];
                                int n39 = 0;
                                for (n37 = 0; n37 < this.rectHeight; ++n37) {
                                    int n40 = n38;
                                    int n41 = n39;
                                    for (int i = 0; i < this.rectWidth; ++i) {
                                        int n42 = (int)dArray2[n40];
                                        for (int j = 0; j < n7; ++j) {
                                            dArray[n41 + j] = byArray[j][n42] & 0xFF;
                                        }
                                        n40 += this.pixelStride;
                                        n41 += n;
                                    }
                                    n38 += this.scanlineStride;
                                    n39 += n2;
                                }
                                this.doubleDataArrays = new double[n7][];
                                for (n37 = 0; n37 < n7; ++n37) {
                                    this.doubleDataArrays[n37] = dArray;
                                }
                                break;
                            }
                        }
                        this.numBands = n7;
                        this.pixelStride = n;
                        this.scanlineStride = n2;
                        this.bandDataOffsets = nArray3;
                        this.bandOffsets = nArray3;
                    }
                    break block89;
                }
                if ((this.formatTagID & 0x180) != 128 || (this.formatTagID & 0x600) == 1024 || colorModel == null) break block90;
                this.pixelStride = this.numBands = colorModel instanceof IndexColorModel ? colorModel.getNumComponents() : raster.getSampleModel().getNumBands();
                this.scanlineStride = this.rectWidth * this.numBands;
                this.bandOffsets = new int[this.numBands];
                for (int i = 0; i < this.numBands; ++i) {
                    this.bandOffsets[i] = i;
                }
                this.bandDataOffsets = this.bandOffsets;
                Object object = null;
                int n = 0;
                int[] nArray = new int[colorModel.getNumComponents()];
                switch (this.formatTagID & 0x7F) {
                    case 3: {
                        int[] nArray6 = new int[this.rectWidth * this.rectHeight * this.numBands];
                        this.intDataArrays = new int[this.numBands][];
                        for (int i = 0; i < this.numBands; ++i) {
                            this.intDataArrays[i] = nArray6;
                        }
                        object = raster.getDataElements(this.rectX, this.rectY, null);
                        n = 0;
                        byte[] byArray = null;
                        if (raster instanceof BytePackedRaster) {
                            byArray = (byte[])object;
                        }
                        for (int i = this.rectY; i < this.rectY + this.rectHeight; ++i) {
                            for (int j = this.rectX; j < this.rectX + this.rectWidth; ++j) {
                                if (byArray != null) {
                                    byArray[0] = (byte)raster.getSample(j, i, 0);
                                } else {
                                    raster.getDataElements(j, i, object);
                                }
                                colorModel.getComponents(object, nArray, 0);
                                nArray6[n] = nArray[0];
                                nArray6[n + 1] = nArray[1];
                                nArray6[n + 2] = nArray[2];
                                if (this.numBands > 3) {
                                    nArray6[n + 3] = nArray[3];
                                }
                                n += this.pixelStride;
                            }
                        }
                        break block89;
                    }
                    case 4: {
                        int n43;
                        float[] fArray = new float[this.rectWidth * this.rectHeight * this.numBands];
                        this.floatDataArrays = new float[this.numBands][];
                        for (n43 = 0; n43 < this.numBands; ++n43) {
                            this.floatDataArrays[n43] = fArray;
                        }
                        object = null;
                        n = 0;
                        for (n43 = this.rectY; n43 < this.rectY + this.rectHeight; ++n43) {
                            for (int i = this.rectX; i < this.rectX + this.rectWidth; ++i) {
                                object = raster.getDataElements(i, n43, object);
                                colorModel.getComponents(object, nArray, 0);
                                fArray[n] = nArray[0];
                                fArray[n + 1] = nArray[1];
                                fArray[n + 2] = nArray[2];
                                if (this.numBands > 3) {
                                    fArray[n + 3] = nArray[3];
                                }
                                n += this.pixelStride;
                            }
                        }
                        break block89;
                    }
                    case 5: {
                        int n44;
                        double[] dArray = new double[this.rectWidth * this.rectHeight * this.numBands];
                        this.doubleDataArrays = new double[this.numBands][];
                        for (n44 = 0; n44 < this.numBands; ++n44) {
                            this.doubleDataArrays[n44] = dArray;
                        }
                        object = null;
                        n = 0;
                        for (n44 = this.rectY; n44 < this.rectY + this.rectHeight; ++n44) {
                            for (int i = this.rectX; i < this.rectX + this.rectWidth; ++i) {
                                object = raster.getDataElements(i, n44, object);
                                colorModel.getComponents(object, nArray, 0);
                                dArray[n] = nArray[0];
                                dArray[n + 1] = nArray[1];
                                dArray[n + 2] = nArray[2];
                                if (this.numBands > 3) {
                                    dArray[n + 3] = nArray[3];
                                }
                                n += this.pixelStride;
                            }
                        }
                        break;
                    }
                }
                break block89;
            }
            this.pixelStride = this.numBands = rasterFormatTag.getNumBands();
            this.scanlineStride = this.rectWidth * this.numBands;
            this.bandDataOffsets = rasterFormatTag.getBandOffsets();
            this.bandOffsets = this.bandDataOffsets;
            switch (this.formatTagID & 0x7F) {
                case 3: {
                    int[] nArray = raster.getPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, (int[])null);
                    this.intDataArrays = new int[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        this.intDataArrays[i] = nArray;
                    }
                    break;
                }
                case 4: {
                    float[] fArray = raster.getPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, (float[])null);
                    this.floatDataArrays = new float[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        this.floatDataArrays[i] = fArray;
                    }
                    break;
                }
                case 5: {
                    double[] dArray = raster.getPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, (double[])null);
                    this.doubleDataArrays = new double[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        this.doubleDataArrays[i] = dArray;
                    }
                    break;
                }
            }
        }
    }

    public int getX() {
        return this.rectX;
    }

    public int getY() {
        return this.rectY;
    }

    public int getWidth() {
        return this.rectWidth;
    }

    public int getHeight() {
        return this.rectHeight;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public boolean isBinary() {
        return (this.formatTagID & 0x480) == 1152 && ImageUtil.isBinary(this.raster.getSampleModel());
    }

    public byte[] getBinaryDataArray() {
        if (this.binaryDataArray == null && this.isBinary()) {
            this.binaryDataArray = ImageUtil.getPackedBinaryData(this.raster, new Rectangle(this.rectX, this.rectY, this.rectWidth, this.rectHeight));
        }
        return this.binaryDataArray;
    }

    public byte[][] getByteDataArrays() {
        if (this.byteDataArrays == null && this.isBinary()) {
            byte[] byArray = ImageUtil.getUnpackedBinaryData(this.raster, new Rectangle(this.rectX, this.rectY, this.rectWidth, this.rectHeight));
            this.byteDataArrays = new byte[][]{byArray};
        }
        return this.byteDataArrays;
    }

    public byte[] getByteDataArray(int n) {
        byte[][] byArray = this.getByteDataArrays();
        return byArray == null ? null : byArray[n];
    }

    public short[][] getShortDataArrays() {
        return this.shortDataArrays;
    }

    public short[] getShortDataArray(int n) {
        return this.shortDataArrays == null ? null : this.shortDataArrays[n];
    }

    public int[][] getIntDataArrays() {
        return this.intDataArrays;
    }

    public int[] getIntDataArray(int n) {
        return this.intDataArrays == null ? null : this.intDataArrays[n];
    }

    public float[][] getFloatDataArrays() {
        return this.floatDataArrays;
    }

    public float[] getFloatDataArray(int n) {
        return this.floatDataArrays == null ? null : this.floatDataArrays[n];
    }

    public double[][] getDoubleDataArrays() {
        return this.doubleDataArrays;
    }

    public double[] getDoubleDataArray(int n) {
        return this.doubleDataArrays == null ? null : this.doubleDataArrays[n];
    }

    public Object getDataArray(int n) {
        Object[] objectArray = null;
        switch (this.getDataType()) {
            case 0: {
                objectArray = this.getByteDataArray(n);
                break;
            }
            case 1: 
            case 2: {
                objectArray = this.getShortDataArray(n);
                break;
            }
            case 3: {
                objectArray = this.getIntDataArray(n);
                break;
            }
            case 4: {
                objectArray = this.getFloatDataArray(n);
                break;
            }
            case 5: {
                objectArray = this.getDoubleDataArray(n);
                break;
            }
            default: {
                objectArray = null;
            }
        }
        return objectArray;
    }

    public int[] getBandOffsets() {
        return this.bandDataOffsets;
    }

    public int[] getOffsetsForBands() {
        return this.bandOffsets;
    }

    public int getBandOffset(int n) {
        return this.bandDataOffsets[n];
    }

    public int getOffsetForBand(int n) {
        return this.bandOffsets[n];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getDataType() {
        return this.formatTagID & 0x7F;
    }

    public boolean isDataCopy() {
        return (this.formatTagID & 0x180) == 128;
    }

    public void copyBinaryDataToRaster() {
        if (this.binaryDataArray == null || !this.isBinary()) {
            return;
        }
        ImageUtil.setPackedBinaryData(this.binaryDataArray, (WritableRaster)this.raster, new Rectangle(this.rectX, this.rectY, this.rectWidth, this.rectHeight));
    }

    public void copyDataToRaster() {
        if (this.isDataCopy()) {
            WritableRaster writableRaster = (WritableRaster)this.raster;
            switch (this.getDataType()) {
                case 0: {
                    if (!this.isBinary()) {
                        throw new RuntimeException(JaiI18N.getString("RasterAccessor1"));
                    }
                    ImageUtil.setUnpackedBinaryData(this.byteDataArrays[0], writableRaster, new Rectangle(this.rectX, this.rectY, this.rectWidth, this.rectHeight));
                    break;
                }
                case 3: {
                    writableRaster.setPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, this.intDataArrays[0]);
                    break;
                }
                case 4: {
                    writableRaster.setPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, this.floatDataArrays[0]);
                    break;
                }
                case 5: {
                    writableRaster.setPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, this.doubleDataArrays[0]);
                }
            }
        }
    }

    public boolean needsClamping() {
        int[] nArray = this.raster.getSampleModel().getSampleSize();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 32) continue;
            return true;
        }
        return false;
    }

    public void clampDataArrays() {
        int n;
        int[] nArray = this.raster.getSampleModel().getSampleSize();
        boolean bl = false;
        boolean bl2 = true;
        int n2 = nArray[0];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 32) {
                bl = true;
            }
            if (nArray[n] == n2) continue;
            bl2 = false;
        }
        if (!bl) {
            return;
        }
        n = this.raster.getDataBuffer().getDataType();
        double[] dArray = new double[nArray.length];
        double[] dArray2 = new double[nArray.length];
        if (n == 1 && bl2 && nArray[0] == 16) {
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = 65535.0;
                dArray2[i] = 0.0;
            }
        } else if (n == 2 && bl2 && nArray[0] == 16) {
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = 32767.0;
                dArray2[i] = -32768.0;
            }
        } else if (n == 3 && bl2 && nArray[0] == 32) {
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = 2.147483647E9;
                dArray2[i] = -2.147483648E9;
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = (1 << nArray[i]) - 1;
                dArray2[i] = 0.0;
            }
        }
        this.clampDataArray(dArray, dArray2);
    }

    private void clampDataArray(double[] dArray, double[] dArray2) {
        switch (this.getDataType()) {
            case 3: {
                this.clampIntArrays(this.toIntArray(dArray), this.toIntArray(dArray2));
                break;
            }
            case 4: {
                this.clampFloatArrays(this.toFloatArray(dArray), this.toFloatArray(dArray2));
                break;
            }
            case 5: {
                this.clampDoubleArrays(dArray, dArray2);
            }
        }
    }

    private int[] toIntArray(double[] dArray) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)dArray[i];
        }
        return nArray;
    }

    private float[] toFloatArray(double[] dArray) {
        float[] fArray = new float[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    private void clampIntArrays(int[] nArray, int[] nArray2) {
        int n = this.rectWidth;
        int n2 = this.rectHeight;
        for (int i = 0; i < this.numBands; ++i) {
            int[] nArray3 = this.intDataArrays[i];
            int n3 = this.bandDataOffsets[i];
            int n4 = nArray[i];
            int n5 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n6 = n3;
                for (int k = 0; k < n; ++k) {
                    int n7 = nArray3[n6];
                    if (n7 < n5) {
                        nArray3[n6] = n5;
                    } else if (n7 > n4) {
                        nArray3[n6] = n4;
                    }
                    n6 += this.pixelStride;
                }
                n3 += this.scanlineStride;
            }
        }
    }

    private void clampFloatArrays(float[] fArray, float[] fArray2) {
        int n = this.rectWidth;
        int n2 = this.rectHeight;
        for (int i = 0; i < this.numBands; ++i) {
            float[] fArray3 = this.floatDataArrays[i];
            int n3 = this.bandDataOffsets[i];
            float f = fArray[i];
            float f2 = fArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n4 = n3;
                for (int k = 0; k < n; ++k) {
                    float f3 = fArray3[n4];
                    if (f3 < f2) {
                        fArray3[n4] = f2;
                    } else if (f3 > f) {
                        fArray3[n4] = f;
                    }
                    n4 += this.pixelStride;
                }
                n3 += this.scanlineStride;
            }
        }
    }

    private void clampDoubleArrays(double[] dArray, double[] dArray2) {
        int n = this.rectWidth;
        int n2 = this.rectHeight;
        for (int i = 0; i < this.numBands; ++i) {
            double[] dArray3 = this.doubleDataArrays[i];
            int n3 = this.bandDataOffsets[i];
            double d = dArray[i];
            double d2 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n4 = n3;
                for (int k = 0; k < n; ++k) {
                    double d3 = dArray3[n4];
                    if (d3 < d2) {
                        dArray3[n4] = d2;
                    } else if (d3 > d) {
                        dArray3[n4] = d;
                    }
                    n4 += this.pixelStride;
                }
                n3 += this.scanlineStride;
            }
        }
    }
}

