/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;

public abstract class StatisticsOpImage
extends OpImage {
    protected ROI roi;
    protected int xStart;
    protected int yStart;
    protected int xPeriod;
    protected int yPeriod;
    private boolean checkForSkippedTiles;

    public StatisticsOpImage(RenderedImage renderedImage, ROI rOI, int n, int n2, int n3, int n4) {
        super(StatisticsOpImage.vectorize(renderedImage), new ImageLayout(renderedImage), null, false);
        this.roi = rOI == null ? new ROIShape(this.getSource(0).getBounds()) : rOI;
        this.xStart = n;
        this.yStart = n2;
        this.xPeriod = n3;
        this.yPeriod = n4;
        this.checkForSkippedTiles = n3 > this.tileWidth || n4 > this.tileHeight;
    }

    public boolean computesUniqueTiles() {
        return false;
    }

    public Raster getTile(int n, int n2) {
        return this.getSource(0).getTile(n, n2);
    }

    public Raster computeTile(int n, int n2) {
        return this.getSource(0).getTile(n, n2);
    }

    public Raster[] getTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.getSource(0).getTiles(pointArray);
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(rectangle);
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Object object = super.getProperty(string);
        if (object.equals(Image.UndefinedProperty)) {
            StatisticsOpImage statisticsOpImage = this;
            synchronized (statisticsOpImage) {
                object = this.createStatistics(string);
                if (!object.equals(Image.UndefinedProperty)) {
                    PlanarImage planarImage = this.getSource(0);
                    int n = planarImage.getMinTileX();
                    int n2 = planarImage.getMaxTileX();
                    int n3 = planarImage.getMinTileY();
                    int n4 = planarImage.getMaxTileY();
                    for (int i = n3; i <= n4; ++i) {
                        for (int j = n; j <= n2; ++j) {
                            Rectangle rectangle = this.getTileRect(j, i);
                            if (!this.roi.intersects(rectangle)) continue;
                            if (this.checkForSkippedTiles && rectangle.x >= this.xStart && rectangle.y >= this.yStart) {
                                int n5 = (this.xPeriod - (rectangle.x - this.xStart) % this.xPeriod) % this.xPeriod;
                                int n6 = (this.yPeriod - (rectangle.y - this.yStart) % this.yPeriod) % this.yPeriod;
                                if (n5 >= rectangle.width || n6 >= rectangle.height) continue;
                            }
                            this.accumulateStatistics(string, planarImage.getData(rectangle), object);
                        }
                    }
                    this.setProperty(string, object);
                }
            }
        }
        return object;
    }

    public String[] getPropertyNames() {
        String[] stringArray = this.getStatisticsNames();
        String[] stringArray2 = super.getPropertyNames();
        if (stringArray2 == null) {
            return stringArray;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray3 = PropertyUtil.getPropertyNames(stringArray2, string);
            if (stringArray3 == null) continue;
            for (int j = 0; j < stringArray3.length; ++j) {
                if (!stringArray3[j].equalsIgnoreCase(string)) continue;
                vector.add(string);
            }
        }
        if (vector.size() == 0) {
            return stringArray2;
        }
        String[] stringArray4 = new String[stringArray2.length + vector.size()];
        System.arraycopy(stringArray2, 0, stringArray4, 0, stringArray2.length);
        int n = stringArray2.length;
        for (int i = 0; i < vector.size(); ++i) {
            stringArray4[n++] = (String)vector.get(i);
        }
        return stringArray4;
    }

    protected abstract String[] getStatisticsNames();

    protected abstract Object createStatistics(String var1);

    protected abstract void accumulateStatistics(String var1, Raster var2, Object var3);
}

