/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.geom.Point2D;
import javax.media.jai.JaiI18N;
import javax.media.jai.Warp;

public final class WarpGrid
extends Warp {
    private int xStart;
    private int yStart;
    private int xEnd;
    private int yEnd;
    private int xStep;
    private int yStep;
    private int xNumCells;
    private int yNumCells;
    private float[] xWarpPos;
    private float[] yWarpPos;

    private void initialize(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.xStart = n;
        this.yStart = n4;
        this.xEnd = n + n2 * n3;
        this.yEnd = n4 + n5 * n6;
        this.xStep = n2;
        this.yStep = n5;
        this.xNumCells = n3;
        this.yNumCells = n6;
        int n7 = n3 + 1;
        int n8 = n6 + 1;
        int n9 = n8 * n7;
        this.xWarpPos = new float[n9];
        this.yWarpPos = new float[n9];
        int n10 = 0;
        for (int i = 0; i < n9; ++i) {
            this.xWarpPos[i] = fArray[n10++];
            this.yWarpPos[i] = fArray[n10++];
        }
    }

    public WarpGrid(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        if (fArray.length != 2 * (n3 + 1) * (n6 + 1)) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpGrid0"));
        }
        this.initialize(n, n2, n3, n4, n5, n6, fArray);
    }

    public WarpGrid(Warp warp, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 2 * (n3 + 1) * (n6 + 1);
        float[] fArray = new float[n7];
        fArray = warp.warpSparseRect(n, n4, n3 * n2 + 1, n6 * n5 + 1, n2, n5, fArray);
        this.initialize(n, n2, n3, n4, n5, n6, fArray);
    }

    public int getXStart() {
        return this.xStart;
    }

    public int getYStart() {
        return this.yStart;
    }

    public int getXStep() {
        return this.xStep;
    }

    public int getYStep() {
        return this.yStep;
    }

    public int getXNumCells() {
        return this.xNumCells;
    }

    public int getYNumCells() {
        return this.yNumCells;
    }

    public float[] getXWarpPos() {
        return this.xWarpPos;
    }

    public float[] getYWarpPos() {
        return this.yWarpPos;
    }

    private float[] noWarpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        for (int i = n3; i <= n4; i += n6) {
            int n9 = n7;
            n7 += n8;
            for (int j = n; j <= n2; j += n5) {
                fArray[n9++] = j;
                fArray[n9++] = i;
            }
        }
        return fArray;
    }

    public float[] warpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        int n7;
        int n8;
        int n9 = 2 * ((n3 + n5 - 1) / n5);
        if (fArray == null) {
            fArray = new float[n9 * ((n4 + n6 - 1) / n6)];
        }
        int n10 = n;
        int n11 = n + n3 - 1;
        int n12 = n2;
        int n13 = n2 + n4 - 1;
        if (n12 >= this.yEnd || n13 < this.yStart || n10 >= this.xEnd || n11 < this.xStart) {
            return this.noWarpSparseRect(n10, n11, n12, n13, n5, n6, 0, n9, fArray);
        }
        if (n12 < this.yStart) {
            n8 = (this.yStart - n12 + n6 - 1) / n6;
            this.noWarpSparseRect(n10, n11, n12, this.yStart - 1, n5, n6, 0, n9, fArray);
            n12 += n8 * n6;
        }
        if (n13 >= this.yEnd) {
            n8 = (this.yEnd - n2 + n6 - 1) / n6;
            this.noWarpSparseRect(n10, n11, n2 + n8 * n6, n13, n5, n6, n8 * n9, n9, fArray);
            n13 = n2 + (n8 - 1) * n6;
        }
        if (n10 < this.xStart) {
            n8 = (this.xStart - n10 + n5 - 1) / n5;
            this.noWarpSparseRect(n10, this.xStart - 1, n12, n13, n5, n6, (n12 - n2) / n6 * n9, n9, fArray);
            n10 += n8 * n5;
        }
        if (n11 >= this.xEnd) {
            n8 = (this.xEnd - n + n5 - 1) / n5;
            this.noWarpSparseRect(n + n8 * n5, n11, n12, n13, n5, n6, (n12 - n2) / n6 * n9 + n8 * 2, n9, fArray);
            n11 = n + (n8 - 1) * n5;
        }
        int[] nArray = new int[this.xNumCells];
        for (n7 = n10; n7 <= n11; n7 += n5) {
            int n14 = (n7 - this.xStart) / this.xStep;
            nArray[n14] = nArray[n14] + 1;
        }
        n7 = (n12 - n2) / n6 * n9 + (n10 - n) / n5 * 2;
        int n15 = this.xNumCells + 1;
        float f = (float)n5 / (float)this.xStep;
        for (int i = n12; i <= n13; i += n6) {
            int n16 = n7;
            n7 += n9;
            int n17 = (i - this.yStart) / this.yStep;
            int n18 = this.yStart + n17 * this.yStep;
            float f2 = ((float)i + 0.5f - (float)n18) / (float)this.yStep;
            float f3 = (1.0f - f2) * f;
            float f4 = f2 * f;
            int n19 = n10;
            while (n19 <= n11) {
                int n20 = (n19 - this.xStart) / this.xStep;
                int n21 = this.xStart + n20 * this.xStep;
                float f5 = ((float)n19 + 0.5f - (float)n21) / (float)this.xStep;
                int n22 = n17 * n15 + n20;
                float f6 = this.xWarpPos[n22];
                float f7 = this.yWarpPos[n22];
                float f8 = this.xWarpPos[++n22];
                float f9 = this.yWarpPos[n22];
                float f10 = this.xWarpPos[n22 += this.xNumCells];
                float f11 = this.yWarpPos[n22];
                float f12 = this.xWarpPos[++n22];
                float f13 = this.yWarpPos[n22];
                float f14 = f6 + (f8 - f6) * f5;
                float f15 = f7 + (f9 - f7) * f5;
                float f16 = f10 + (f12 - f10) * f5;
                float f17 = f11 + (f13 - f11) * f5;
                float f18 = f14 + (f16 - f14) * f2;
                float f19 = f15 + (f17 - f15) * f2;
                float f20 = (f8 - f6) * f3 + (f12 - f10) * f4;
                float f21 = (f9 - f7) * f3 + (f13 - f11) * f4;
                int n23 = nArray[n20];
                for (int j = 0; j < n23; ++j) {
                    fArray[n16++] = f18 - 0.5f;
                    fArray[n16++] = f19 - 0.5f;
                    f18 += f20;
                    f19 += f21;
                    n19 += n5;
                }
            }
        }
        return fArray;
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        float[] fArray = this.warpSparseRect((int)point2D.getX(), (int)point2D.getY(), 2, 2, 1, 1, null);
        double d = point2D.getX() - (double)((int)point2D.getX());
        double d2 = 1.0 - d;
        double d3 = point2D.getY() - (double)((int)point2D.getY());
        double d4 = 1.0 - d3;
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(((double)fArray[0] * d2 + (double)fArray[2] * d) * d4 + ((double)fArray[4] * d2 + (double)fArray[6] * d) * d3, ((double)fArray[1] * d2 + (double)fArray[3] * d) * d4 + ((double)fArray[5] * d2 + (double)fArray[7] * d) * d3);
        return point2D2;
    }
}

