/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.path;

import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.jpeg.JPEGSegment;
import com.twelvemonkeys.imageio.metadata.jpeg.JPEGSegmentUtil;
import com.twelvemonkeys.imageio.metadata.psd.PSDReader;
import com.twelvemonkeys.imageio.metadata.tiff.TIFFReader;
import com.twelvemonkeys.imageio.path.AdobePathBuilder;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.lang.Validate;
import java.awt.AlphaComposite;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public final class Paths {
    private Paths() {
    }

    public static Path2D readPath(ImageInputStream imageInputStream) throws IOException {
        CompoundDirectory compoundDirectory;
        Directory directory;
        Entry entry;
        Validate.notNull((Object)imageInputStream, (String)"stream");
        int n = Paths.readMagic(imageInputStream);
        if (n == 943868237) {
            return Paths.buildPathFromPhotoshopResources(imageInputStream);
        }
        if (n == 943870035) {
            imageInputStream.skipBytes(26);
            long l = imageInputStream.readUnsignedInt();
            imageInputStream.skipBytes(l);
            long l2 = imageInputStream.readUnsignedInt();
            return Paths.buildPathFromPhotoshopResources((ImageInputStream)new SubImageInputStream(imageInputStream, l2));
        }
        if (n >>> 16 == 65496 && (n & 0xFF00) == 65280) {
            LinkedHashMap<Integer, List<String>> linkedHashMap = new LinkedHashMap<Integer, List<String>>();
            linkedHashMap.put(65517, Collections.singletonList("Photoshop 3.0"));
            List list = JPEGSegmentUtil.readSegments((ImageInputStream)imageInputStream, linkedHashMap);
            if (!list.isEmpty()) {
                return Paths.buildPathFromPhotoshopResources(new MemoryCacheImageInputStream(((JPEGSegment)list.get(0)).data()));
            }
        } else if ((n >>> 16 == 19789 && (n & 0xFFFF) == 42 || n >>> 16 == 18761 && (n & 0xFFFF) == 10752) && (entry = (directory = (compoundDirectory = (CompoundDirectory)new TIFFReader().read(imageInputStream)).getDirectory(0)).getEntryById((Object)34377)) != null) {
            return Paths.buildPathFromPhotoshopResources((ImageInputStream)new ByteArrayImageInputStream((byte[])entry.getValue()));
        }
        return null;
    }

    private static int readMagic(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.mark();
        try {
            int n = imageInputStream.readInt();
            return n;
        }
        finally {
            imageInputStream.reset();
        }
    }

    private static Path2D buildPathFromPhotoshopResources(ImageInputStream imageInputStream) throws IOException {
        Entry entry;
        Directory directory = new PSDReader().read(imageInputStream);
        if (AdobePathBuilder.DEBUG) {
            System.out.println("resourceBlocks: " + directory);
        }
        if ((entry = directory.getEntryById((Object)2000)) != null) {
            return new AdobePathBuilder((byte[])entry.getValue()).path();
        }
        return null;
    }

    public static BufferedImage applyClippingPath(Shape shape, BufferedImage bufferedImage) {
        return Paths.applyClippingPath(shape, (BufferedImage)Validate.notNull((Object)bufferedImage, (String)"image"), new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage applyClippingPath(Shape shape, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Validate.notNull((Object)shape, (String)"clip");
        Validate.notNull((Object)bufferedImage, (String)"image");
        Validate.isTrue((bufferedImage2 != null && bufferedImage2 != bufferedImage ? 1 : 0) != 0, (String)"destination may not be null or same instance as image");
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale(bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fill(shape);
            graphics2D.setTransform(affineTransform);
            graphics2D.setComposite(AlphaComposite.SrcIn);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static BufferedImage readClipped(ImageInputStream imageInputStream) throws IOException {
        Path2D path2D = Paths.readPath(imageInputStream);
        imageInputStream.seek(0L);
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        if (path2D == null) {
            return bufferedImage;
        }
        return Paths.applyClippingPath(path2D, bufferedImage);
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        BufferedImage bufferedImage = Paths.readClipped(ImageIO.createImageInputStream(new File(stringArray[0])));
        File file = File.createTempFile("clipped-", ".png");
        file.deleteOnExit();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        Desktop.getDesktop().open(file);
        Thread.sleep(3000L);
        if (!file.delete()) {
            System.err.printf("%s not deleted\n", file);
        }
    }
}

