/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.settings;

import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.FileEventCursor;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.licensing.Licence;
import com.neptunelabs.fsiserver.framework.licensing.LicenceConsumer;
import com.neptunelabs.fsiserver.framework.licensing.LicenceManager;
import com.neptunelabs.fsiserver.framework.licensing.RawLicence;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.framework.settings.Section;
import com.neptunelabs.fsiserver.framework.systeminformation.SystemInformation;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.requestprocessor.effects.EffectsManager;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrSearcher;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.sourcemanager.DeleteDaemon;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.ServletUtils;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.StorageLockHandler;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import java.io.File;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ServletXMLSettings
implements LicenceConsumer {
    private static final int OO0000 = 1;
    private static final int oo0000 = 2;
    private static final int \u00d500000 = 4;
    private static final int return = 8;
    private static final int \u00d5O0000 = 16;
    private static final int thissuper = 32;
    private static final int \u00d4o0000 = 64;
    protected final ServletContext \u00d300000;
    private final long oO0000;
    private final Map<String, Boolean> \u00f500000 = new HashMap<String, Boolean>();
    private final Map<String, Boolean> while = new HashMap<String, Boolean>();
    private final DecimalFormat \u00f800000 = new DecimalFormat("00");
    private final Map<String, Section> \u00d400000 = new HashMap<String, Section>();
    private final List<Path> \u00f5O0000 = new ArrayList<Path>();
    private final Pattern \u00f400000 = Pattern.compile("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
    private final Map<String, Inet6Address> \u00d3o0000 = new HashMap<String, Inet6Address>(2);
    protected volatile boolean \u00d3O0000 = false;
    protected volatile Licence Oo0000 = new Licence();
    protected boolean \u00d800000 = false;
    private Path \u00f8O0000;
    private boolean o00000 = false;
    private boolean \u00f4O0000 = false;
    private Map<String, Section> \u00d8O0000 = new HashMap<String, Section>();
    private LicenceManager if;
    private Integer \u00d4O0000;
    private Integer nullsuper;
    private boolean Stringsuper = false;
    private boolean new = false;

    protected ServletXMLSettings(ServletContext servletContext, boolean bl) {
        this.\u00d300000 = servletContext;
        try {
            File file = File.createTempFile("sectest", "tmp");
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (SecurityException securityException) {
            this.o00000 = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.oO0000 = System.currentTimeMillis();
        if (servletContext != null && bl) {
            servletContext.setAttribute("FSIServletSettings", (Object)this);
        }
    }

    public static String parse4Env(String string) {
        String string2;
        Pattern pattern = Pattern.compile("(.*)\\{(.+)\\}(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string3 = matcher.group(2);
            Pattern pattern2 = Pattern.compile("(.+):(.+)");
            Matcher matcher2 = pattern2.matcher(string3);
            if (matcher2.matches()) {
                String string4;
                String string5 = matcher2.group(1);
                String string6 = matcher2.group(2);
                String string7 = string5.equalsIgnoreCase("ENV") ? System.getenv(string6) : (string5.equalsIgnoreCase("DOCKER_ENV") ? ((string4 = System.getenv(string6)) != null ? (string4.indexOf("tcp://") != -1 ? string4.substring(6) : string4) : null) : null);
                string2 = string7 != null ? matcher.replaceAll("$1" + string7 + "$3") : string;
            } else {
                string2 = string;
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    public ServletContext getServletContext() {
        return this.\u00d300000;
    }

    public Licence getLicence() {
        return this.Oo0000;
    }

    public String getLicenceContainerHash() {
        return this.if.getLicenceContainerHash();
    }

    public long getUptime() {
        return this.oO0000;
    }

    public void dispose() {
        if (this.if != null) {
            this.if.shutdown();
        }
    }

    public final void setLicenceFile(Path path, int n, int n2) {
        this.\u00d4O0000 = n;
        this.nullsuper = n2;
        this.if = new LicenceManager(this.getLogger(), path);
        this.if.setFileEventCursor(this.getFileEventCursor());
        this.updateLicenceFromLicenceManager();
        this.if.addConsumer(this);
    }

    public final LicenceManager getLicenceManager() {
        return this.if;
    }

    @Override
    public void updateLicenceFromLicenceManager() {
        this.Oo0000 = new Licence();
        if (this.if != null) {
            RawLicence rawLicence = this.if.getRawLicence(this.\u00d4O0000, this.nullsuper);
            if (rawLicence != null && rawLicence.\u00d500000 != null) {
                this.Stringsuper = this.Oo0000.decodeLicenceString(this.getLogger(), rawLicence.\u00d500000, SoftwareVersion.getKeyVersion(), this.\u00d4O0000, this.nullsuper, SoftwareVersion.readPublicKey(), rawLicence.\u00d300000);
                this.\u00d800000 = this.validateHardware();
                if (!this.\u00d800000) {
                    this.Stringsuper = false;
                }
            } else {
                this.new = this.if.hasRawLicences(this.\u00d4O0000);
                this.Stringsuper = false;
            }
        }
        this.logLicenceInfo();
    }

    protected boolean validateHardware() {
        SystemInformation systemInformation = this.getSystemInformation();
        UUID uUID = this.Oo0000.getSystemUUID();
        UUID uUID2 = systemInformation.getSystemUUID();
        if (uUID != null && uUID2 != null) {
            return uUID.equals(uUID2);
        }
        byte[][] byArray = this.Oo0000.getMacAddresses();
        byte[][] byArray2 = systemInformation.getMacs();
        if (byArray != null && byArray2 != null) {
            for (byte[] byArray3 : byArray2) {
                for (byte[] byArray4 : byArray) {
                    if (!Arrays.equals(byArray3, byArray4)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void logLicenceInfo() {
        FSILogger fSILogger = this.getLogger();
        if (fSILogger != null) {
            if (!this.hasValidLicence() && this.getLicenceErrorCode() > 0) {
                if (this.getLicenceErrorCode() == 4) {
                    fSILogger.log(7006, new Object[0]);
                } else {
                    fSILogger.log(7001, this.getLicenceErrorCode());
                }
            } else if (this.new) {
                fSILogger.log(7006, new Object[0]);
            } else if (!this.hasValidLicence() && this.getLicenceErrorCode() == 0) {
                fSILogger.log(7002, this.getLicenceErrorCode());
            } else if (this.hasValidLicence()) {
                fSILogger.log(7000, new Object[0]);
            }
        }
    }

    private boolean hasValidLicence() {
        return this.Stringsuper;
    }

    private int getLicenceErrorCode() {
        return this.Oo0000.getErrorCode();
    }

    public final boolean evalutateSettings() {
        boolean bl = true;
        Document document = FileOperations.getXMLFileContent(this.getLogger(), this.\u00f8O0000);
        this.\u00d400000.clear();
        if (document != null) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Object object2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String string = node.getNodeName().toLowerCase();
                boolean bl2 = true;
                Section.SectionTypes sectionTypes = null;
                if (node.hasAttributes()) {
                    Object object3;
                    object2 = node.getAttributes();
                    object = object2.getNamedItem("enabled");
                    if (object != null) {
                        object3 = object.getNodeValue();
                        bl2 = Boolean.valueOf((String)object3);
                    }
                    if ((object3 = object2.getNamedItem("type")) != null) {
                        try {
                            sectionTypes = Section.SectionTypes.valueOf(object3.getNodeValue());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.getLogger().log(1513, this.\u00f8O0000, string);
                        }
                    }
                }
                if (sectionTypes == null && this.\u00d8O0000 != null && (object2 = this.\u00d8O0000.get(node.getNodeName())) != null) {
                    sectionTypes = ((Section)object2).getType();
                }
                if (sectionTypes == null) {
                    sectionTypes = Section.SectionTypes.\u00d200000;
                }
                object2 = new Section(sectionTypes);
                ((Section)object2).enable(bl2);
                if (node.hasChildNodes()) {
                    object = node.getChildNodes();
                    block7: for (int j = 0; j < object.getLength(); ++j) {
                        Node node2 = object.item(j);
                        if (node2.getNodeType() != 1) continue;
                        String string2 = node2.getNodeName().toLowerCase();
                        if (sectionTypes == Section.SectionTypes.\u00d200000 && !this.isValidValueName(string, string2) && this.getLogger() != null) {
                            this.getLogger().log(1574, string2, string, this.\u00f8O0000);
                            continue;
                        }
                        switch (sectionTypes) {
                            case \u00d200000: {
                                String string3 = this.cleanValue(this.getNodeTextContent(node2.getChildNodes()));
                                if (string3 == null) continue block7;
                                ((Section)object2).put(string2, string3);
                                continue block7;
                            }
                            case o00000: {
                                String string4 = this.cleanValue(this.getNodeTextContent(node2.getChildNodes()));
                                if (string4 == null) continue block7;
                                ((Section)object2).put(string2, string4);
                                continue block7;
                            }
                            default: {
                                NamedNodeMap namedNodeMap = node2.getAttributes();
                                int n = namedNodeMap.getLength();
                                ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
                                for (int k = 0; k < n; ++k) {
                                    Node node3 = namedNodeMap.item(k);
                                    String string5 = node3.getNodeName();
                                    String string6 = this.cleanValue(node3.getNodeValue());
                                    if (string6 == null) continue;
                                    Pair<String, String> pair = new Pair<String, String>(string5, string6);
                                    arrayList.add(pair);
                                }
                                ((Section)object2).putAttribute(string2, arrayList);
                            }
                        }
                    }
                }
                this.\u00d400000.put(string, (Section)object2);
            }
        }
        this.\u00d3O0000 = true;
        return true;
    }

    public boolean hasSection(String string) {
        Section section = this.getSection(string);
        return section != null;
    }

    public boolean hasSectionEnabled(String string) {
        Section section = this.getSection(string);
        boolean bl = section != null ? section.getEnabled() : false;
        return bl;
    }

    public void enableSection(String string, String string2) {
        this.enableSection(string, Boolean.valueOf(string2));
    }

    private void enableSection(String string, boolean bl) {
        Section section = this.getSection(string);
        if (section != null) {
            section.enable(bl);
        } else {
            this.getLogger().log(1573, string);
        }
    }

    public String getPrefsString(String string, String string2) {
        String string3 = null;
        if ((string2 = string2.toLowerCase()).equals("datetime")) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.\u00f800000.format(gregorianCalendar.get(11)));
            stringBuilder.append(':');
            stringBuilder.append(this.\u00f800000.format(gregorianCalendar.get(12)));
            stringBuilder.append(':');
            stringBuilder.append(this.\u00f800000.format(gregorianCalendar.get(13)));
            string3 = stringBuilder.toString();
        } else if (string2.equals("vendor")) {
            string3 = "NeptuneLabs";
        } else if (this.isValidValueName(string, string2)) {
            String string4 = this.getDefaultValue(string, string2);
            string3 = this.getPrefs(string, string2, string4);
            string3 = ServletXMLSettings.parse4Env(string3);
        }
        return string3;
    }

    public boolean getPrefsBoolean(String string, String string2) {
        String string3;
        String string4;
        boolean bl = false;
        if (this.isValidValueName(string, string2 = string2.toLowerCase()) && (string4 = this.getPrefs(string, string2, string3 = this.getDefaultValue(string, string2))) != null) {
            String string5 = ServletXMLSettings.parse4Env(string4);
            bl = Boolean.valueOf(string5);
        }
        return bl;
    }

    public int getPrefsInt(String string, String string2) {
        String string3;
        String string4;
        int n = 0;
        if (this.isValidValueName(string, string2 = string2.toLowerCase()) && (string4 = this.getPrefs(string, string2, string3 = this.getDefaultValue(string, string2))) != null && !string4.equals("")) {
            String string5 = ServletXMLSettings.parse4Env(string4);
            try {
                n = Integer.valueOf(string5);
            }
            catch (NumberFormatException numberFormatException) {
                this.getLogger().log(1572, string, string2);
            }
        }
        return n;
    }

    public long getPrefsLong(String string, String string2) {
        String string3;
        String string4;
        long l = 0L;
        if (this.isValidValueName(string, string2 = string2.toLowerCase()) && (string4 = this.getPrefs(string, string2, string3 = this.getDefaultValue(string, string2))) != null) {
            String string5 = ServletXMLSettings.parse4Env(string4);
            try {
                l = Long.valueOf(string5);
            }
            catch (NumberFormatException numberFormatException) {
                this.getLogger().log(1572, string, string2);
            }
        }
        return l;
    }

    public List<String> getPrefsValues(String string, String string2) {
        string2 = string2.toLowerCase();
        Section section = this.getSection(string, Section.SectionTypes.o00000);
        return section.getValueList(string2);
    }

    public List<List<Pair<String, String>>> getPrefsAttributeList(String string, String string2) {
        string = string.toLowerCase();
        Section section = this.getSection(string, Section.SectionTypes.\u00d400000);
        return section.getAttrList(string2);
    }

    public int getTimeInDaySecs(String string, String string2) {
        int n = -1;
        String string3 = this.getPrefsString(string, string2 = string2.toLowerCase());
        if (string3 != null) {
            Pattern pattern = Pattern.compile("^\\s*(\\d{1,2}):(\\d{2})\\s*$");
            Pattern pattern2 = Pattern.compile("^\\s*(\\d{1,2}):(\\d{2}):(\\d{2})\\s*$");
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            try {
                Matcher matcher = pattern.matcher(string3);
                if (matcher.find()) {
                    String string4 = matcher.group(1);
                    String string5 = matcher.group(2);
                    n2 = Integer.valueOf(string4);
                    n3 = Integer.valueOf(string5);
                    n = n2 * 3600 + n3 * 60;
                } else {
                    Matcher matcher2 = pattern2.matcher(string3);
                    if (matcher2.find()) {
                        String string6 = matcher2.group(1);
                        String string7 = matcher2.group(2);
                        String string8 = matcher2.group(3);
                        n2 = Integer.valueOf(string6);
                        n3 = Integer.valueOf(string7);
                        n4 = Integer.valueOf(string8);
                        n = n2 * 3600 + n3 * 60 + n4;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    public int getPrefsWeekdaySet(String string, String string2) {
        int n = 0;
        String string3 = this.getPrefsString(string, string2 = string2.toLowerCase());
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";,");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().toLowerCase();
                if (string4.equals("mon") || string4.equals("monday")) {
                    n |= 1;
                    continue;
                }
                if (string4.equals("tue") || string4.equals("tuesday")) {
                    n |= 2;
                    continue;
                }
                if (string4.equals("wed") || string4.equals("wednesday")) {
                    n |= 4;
                    continue;
                }
                if (string4.equals("thu") || string4.equals("thursday")) {
                    n |= 8;
                    continue;
                }
                if (string4.equals("fri") || string4.equals("friday")) {
                    n |= 0x10;
                    continue;
                }
                if (string4.equals("sat") || string4.equals("saturday")) {
                    n |= 0x20;
                    continue;
                }
                if (!string4.equals("sun") && !string4.equals("sunday")) continue;
                n |= 0x40;
            }
        }
        return n;
    }

    protected long getHumanRAMBytes(String string) {
        long l = -1L;
        Pattern pattern = Pattern.compile("(\\d+)\\s*([etgmkbip]*)", 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            l = Long.parseLong(string2);
            if (string3 != null) {
                if ((string3 = string3.toLowerCase()).equals("k") || string3.equals("kb")) {
                    l *= 1000L;
                } else if (string3.equals("kib")) {
                    l *= 1024L;
                } else if (string3.equals("m") || string3.equals("mb")) {
                    l *= 1000000L;
                } else if (string3.equals("mib")) {
                    l *= 0x100000L;
                } else if (string3.equals("g") || string3.equals("gb")) {
                    l *= 1000000000L;
                } else if (string3.equals("gib")) {
                    l *= 0x40000000L;
                } else if (string3.equals("t") || string3.equals("tb")) {
                    l *= 1000000000000L;
                } else if (string3.equals("tib")) {
                    l *= 0x10000000000L;
                } else if (string3.equals("p") || string3.equals("pb")) {
                    l *= 1000000000000000L;
                } else if (string3.equals("pib")) {
                    l *= 0x4000000000000L;
                } else if (string3.equals("e") || string3.equals("eb")) {
                    l *= 1000000000000000000L;
                } else if (string3.equals("eib")) {
                    l *= 0x1000000000000000L;
                }
            }
        }
        return l;
    }

    public void setAttribute(String string, Section.SectionTypes sectionTypes, String string2, String string3) {
        Section section = this.getSection(string, sectionTypes);
        section.putAttribute(string2, string3);
    }

    public void setPrefs(String string, Section.SectionTypes sectionTypes, String string2, String string3) {
        this.setPrefs(string, sectionTypes, string2, string3, false);
    }

    public void setPrefs(String string, Section.SectionTypes sectionTypes, String string2, String string3, boolean bl) {
        if (!bl && !this.isValidValueName(string, string2)) {
            return;
        }
        Section section = this.getSection(string, sectionTypes);
        section.put(string2, string3);
    }

    public void removePrefs(String string, Section.SectionTypes sectionTypes, String string2, String string3) {
        Section section = this.getSection(string, sectionTypes);
        if (section != null) {
            section.remove(string2, string3);
        }
    }

    public void setDefaultSection(Map<String, Section> map) {
        this.\u00d8O0000 = map;
    }

    public boolean saveSettingsFile() {
        boolean bl = false;
        FSILogger fSILogger = this.getLogger();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            Document document = dOMImplementation.createDocument(null, "settings", null);
            Element element = document.getDocumentElement();
            for (String string : this.\u00d8O0000.keySet()) {
                Section section = this.getSection(string);
                Element element2 = document.createElement(string);
                element2.setAttribute("enabled", Boolean.toString(section.getEnabled()));
                Section.SectionTypes sectionTypes = section.getType();
                block7: for (String string2 : section.getKeys()) {
                    switch (sectionTypes) {
                        case \u00d200000: {
                            List<List<Pair<String, String>>> list = this.getDefaultValue(string, string2);
                            Object object3 = section.getValue(string2);
                            if (((String)object3).equalsIgnoreCase((String)((Object)list))) continue block7;
                            Element element3 = document.createElement(string2);
                            element3.setTextContent((String)object3);
                            element2.appendChild(element3);
                            break;
                        }
                        case o00000: {
                            element2.setAttribute("type", "valueList");
                            List<List<Pair<String, String>>> list = section.getValueList(string2);
                            for (String string3 : list) {
                                Object object = document.createElement(string2);
                                object.setTextContent(string3);
                                element2.appendChild((Node)object);
                            }
                            continue block7;
                        }
                        default: {
                            element2.setAttribute("type", "attrList");
                            List<List<Pair<String, String>>> list = section.getAttrList(string2);
                            Object object3 = document.createElement(string2);
                            for (Object object : list) {
                                Iterator iterator = object.iterator();
                                while (iterator.hasNext()) {
                                    Pair pair = (Pair)iterator.next();
                                    String string4 = (String)pair.getItem1();
                                    String string5 = (String)pair.getItem2();
                                    if (string5 == null) continue;
                                    object3.setAttribute(string4, string5);
                                }
                            }
                            element2.appendChild((Node)object3);
                        }
                    }
                }
                element.appendChild(element2);
            }
            bl = FileOperations.saveXMLFileContent(fSILogger, this.\u00f8O0000, document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            fSILogger.log(1517, this.\u00f8O0000, parserConfigurationException);
        }
        return bl;
    }

    public Path getSettingsFile() {
        return this.\u00f8O0000;
    }

    public final void setSettingsFile(Path path) {
        this.\u00f8O0000 = path;
    }

    public final boolean getSecured() {
        return this.o00000;
    }

    protected void log(String string) {
        if (this.\u00d300000 != null) {
            this.\u00d300000.log(string);
        }
    }

    private Section getSection(String string) {
        return this.getSection(string, Section.SectionTypes.\u00d200000);
    }

    private Section getSection(String string, Section.SectionTypes sectionTypes) {
        Section section;
        if (this.\u00d400000.containsKey(string = string.toLowerCase())) {
            section = this.\u00d400000.get(string);
        } else {
            section = new Section(sectionTypes);
            this.\u00d400000.put(string, section);
        }
        return section;
    }

    private String getPrefs(String string, String string2, String string3) {
        String string4;
        Section section = this.getSection(string);
        if (section.getType() == Section.SectionTypes.\u00d200000 && (string4 = section.getValue(string2)) != null) {
            string3 = string4;
        }
        return string3;
    }

    private String cleanValue(String string) {
        String string2 = null;
        if (string != null && !(string = string.trim()).equals("")) {
            string2 = string;
        }
        return string2;
    }

    private boolean isValidValueName(String string, String string2) {
        boolean bl = false;
        string2 = string2.toLowerCase();
        Section section = this.\u00d8O0000.get(string);
        FSILogger fSILogger = this.getLogger();
        if (section != null) {
            if (section.getType() == Section.SectionTypes.\u00d200000 && section.hasValueName(string2)) {
                bl = true;
            } else if (section.getType() == Section.SectionTypes.o00000 && section.hasValueList(string2)) {
                bl = true;
            } else if (section.getType() == Section.SectionTypes.\u00d400000 && section.hasAttributeList(string2)) {
                bl = true;
            }
        }
        if (!bl && fSILogger != null) {
            fSILogger.log(1572, string, string2);
        }
        return bl;
    }

    private String getDefaultValue(String string, String string2) {
        String string3 = null;
        Section section = this.\u00d8O0000.get(string);
        if (section != null) {
            string3 = section.getValue(string2);
        }
        return string3;
    }

    public Path getWebInfPath() {
        if (this.\u00d300000 != null) {
            return ServletUtils.getRealPath(this.\u00d300000, "PRIVATE");
        }
        return null;
    }

    private String getNodeTextContent(NodeList nodeList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            stringBuilder.append(node.getNodeValue());
        }
        return stringBuilder.toString().trim();
    }

    public boolean isLocalRange(String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase("localhost")) {
            bl = true;
        } else if (string.length() <= 15) {
            bl = this.isLocalIPv4Address(string);
        }
        if (!bl && string.startsWith("[") && string.endsWith("]")) {
            bl = this.isLocalIPv6Address(string);
        }
        return bl;
    }

    private boolean isLocalIPv6Address(String string) {
        String string2 = string.substring(1, string.length() - 1);
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            if (inetAddress instanceof Inet6Address) {
                byte[] byArray = inetAddress.getAddress();
                if ((byArray[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 128) {
                    return true;
                }
                if ((byArray[0] & 0xFF) == 252 || (byArray[0] & 0xFF) == 253) {
                    return true;
                }
                byte by = 0;
                for (int i = 0; i < 15; ++i) {
                    by = (byte)(by | byArray[i]);
                }
                return by == 0 && byArray[15] == 1;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    private boolean isLocalIPv4Address(String string) {
        boolean bl = false;
        Matcher matcher = this.\u00f400000.matcher(string);
        if (matcher.matches()) {
            long l = this.ipv4ToLong(string);
            if (l == 0L) {
                bl = true;
            } else if (l >= 0xA000000L && l <= 0xAFFFFFFL) {
                bl = true;
            } else if (l >= 2886729728L && l <= 2887778303L) {
                bl = true;
            } else if (l >= 3232235520L && l <= 3232301055L) {
                bl = true;
            } else if (l >= 2851995648L && l <= 2852061183L) {
                bl = true;
            } else if (l >= 0x7F000000L && l <= Integer.MAX_VALUE) {
                bl = true;
            }
        }
        return bl;
    }

    private long ipv4ToLong(String string) {
        String[] stringArray = string.split("\\.", 4);
        long l = 0L;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 3 - i;
            l = (long)((double)l + (double)(Integer.parseInt(stringArray[i]) % 256) * Math.pow(256.0, n));
        }
        return l;
    }

    protected Inet6Address getInet6Address(String string, boolean bl) {
        if (!this.\u00d3o0000.containsKey(string)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                if (inetAddress instanceof Inet6Address) {
                    if (bl) {
                        this.\u00d3o0000.put(string, (Inet6Address)inetAddress);
                    }
                    return (Inet6Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.\u00d3o0000.get(string);
    }

    public CacheManager getCacheManager() {
        return (CacheManager)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.CacheManager");
    }

    public FSILogger getLogger() {
        return (FSILogger)this.\u00d300000.getAttribute("logger.requestprocessor");
    }

    public SystemMonitor getSystemMonitor() {
        return (SystemMonitor)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.SystemMonitor");
    }

    public SystemInformation getSystemInformation() {
        return (SystemInformation)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.SystemInformation");
    }

    public FileEventCursor getFileEventCursor() {
        return (FileEventCursor)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.utils.FileEventCursor");
    }

    public StorageHelperV1002 getStorageHelper() {
        return (StorageHelperV1002)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.StorageHelper");
    }

    public EffectsManager getEffectsManager() {
        return (EffectsManager)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.EffectManager");
    }

    public UserAuthenticationInterface getUserAuthenticationInterface() {
        return (UserAuthenticationInterface)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.AuthenticationInterface");
    }

    public ScannerDaemon getScannerDaemon() {
        return (ScannerDaemon)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.ScannerDaemon");
    }

    public DeleteDaemon getDeleteDaemon() {
        return (DeleteDaemon)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.DeleteDaemon");
    }

    public SwapPool getSwapPool() {
        return (SwapPool)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.SwapPool");
    }

    public StorageManager getStorageManager() {
        return (StorageManager)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.StorageManager");
    }

    public StorageLockHandler getStorageLockHandler() {
        return (StorageLockHandler)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.utils.StorageLockHandler");
    }

    public SolrUpdater getSolrUpdater() {
        return (SolrUpdater)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.SolrUpdater");
    }

    public SolrSearcher getSolrSearcher() {
        return (SolrSearcher)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.SolrSearcher");
    }

    public SearchDatabaseSolr getSolr() {
        return (SearchDatabaseSolr)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.Solr");
    }

    public Map<String, String> getMimeTypes() {
        return (Map)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.MimeTypes");
    }

    public ImageBuilder getImageBuilder() {
        return (ImageBuilder)this.\u00d300000.getAttribute("com.neptunelabs.fsiserver.StandardImageBuilder");
    }
}

