/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.sort;

import java.util.Comparator;

public class FastQuickSort {
    private static void sort(Comparable[] comparableArray) {
        FastQuickSort.sort(comparableArray, 0, comparableArray.length - 1);
        FastQuickSort.insertSort(comparableArray, 0, comparableArray.length - 1);
    }

    public static void sort(Comparable[] comparableArray, Comparator<Comparable> comparator) {
        if (comparator != null) {
            FastQuickSort.sortComparator(comparableArray, 0, comparableArray.length - 1, comparator);
            FastQuickSort.insertSortComparator(comparableArray, 0, comparableArray.length - 1, comparator);
        } else {
            FastQuickSort.sort(comparableArray);
        }
    }

    private static void sort(Comparable[] comparableArray, int n, int n2) {
        int n3 = 4;
        if (n2 - n > 4) {
            int n4 = (n2 + n) / 2;
            if (comparableArray[n].compareTo(comparableArray[n4]) > 0) {
                FastQuickSort.swap(comparableArray, n, n4);
            }
            if (comparableArray[n].compareTo(comparableArray[n2]) > 0) {
                FastQuickSort.swap(comparableArray, n, n2);
            }
            if (comparableArray[n4].compareTo(comparableArray[n2]) > 0) {
                FastQuickSort.swap(comparableArray, n4, n2);
            }
            int n5 = n2 - 1;
            FastQuickSort.swap(comparableArray, n4, n5);
            n4 = n;
            Comparable comparable = comparableArray[n5];
            while (true) {
                if (comparableArray[++n4].compareTo(comparable) < 0) {
                    continue;
                }
                while (comparableArray[--n5].compareTo(comparable) > 0) {
                }
                if (n5 < n4) break;
                FastQuickSort.swap(comparableArray, n4, n5);
            }
            FastQuickSort.swap(comparableArray, n4, n2 - 1);
            FastQuickSort.sort(comparableArray, n, n5);
            FastQuickSort.sort(comparableArray, n4 + 1, n2);
        }
    }

    private static void insertSort(Comparable[] comparableArray, int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            Comparable comparable = comparableArray[i];
            for (int j = i; j > n && comparableArray[j - 1].compareTo(comparable) > 0; --j) {
                comparableArray[j] = comparableArray[j - 1];
            }
            comparableArray[j] = comparable;
        }
    }

    private static void sortComparator(Comparable[] comparableArray, int n, int n2, Comparator<Comparable> comparator) {
        int n3 = 4;
        if (n2 - n > 4) {
            int n4 = (n2 + n) / 2;
            if (comparator.compare(comparableArray[n], comparableArray[n4]) > 0) {
                FastQuickSort.swap(comparableArray, n, n4);
            }
            if (comparator.compare(comparableArray[n], comparableArray[n2]) > 0) {
                FastQuickSort.swap(comparableArray, n, n2);
            }
            if (comparator.compare(comparableArray[n4], comparableArray[n2]) > 0) {
                FastQuickSort.swap(comparableArray, n4, n2);
            }
            int n5 = n2 - 1;
            FastQuickSort.swap(comparableArray, n4, n5);
            n4 = n;
            Comparable comparable = comparableArray[n5];
            while (true) {
                if (comparator.compare(comparableArray[++n4], comparable) < 0) {
                    continue;
                }
                while (comparator.compare(comparableArray[--n5], comparable) > 0) {
                }
                if (n5 < n4) break;
                FastQuickSort.swap(comparableArray, n4, n5);
            }
            FastQuickSort.swap(comparableArray, n4, n2 - 1);
            FastQuickSort.sort(comparableArray, n, n5);
            FastQuickSort.sort(comparableArray, n4 + 1, n2);
        }
    }

    private static void insertSortComparator(Comparable[] comparableArray, int n, int n2, Comparator<Comparable> comparator) {
        for (int i = n + 1; i <= n2; ++i) {
            Comparable comparable = comparableArray[i];
            for (int j = i; j > n && comparator.compare(comparableArray[j - 1], comparable) > 0; --j) {
                comparableArray[j] = comparableArray[j - 1];
            }
            comparableArray[j] = comparable;
        }
    }

    private static void swap(Comparable[] comparableArray, int n, int n2) {
        Comparable comparable = comparableArray[n];
        comparableArray[n] = comparableArray[n2];
        comparableArray[n2] = comparable;
    }
}

