/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.area;

import com.neptunelabs.fsiserver.imagereader.converter.FastMath;

public class ConvolutionKernel1D {
    private float[] o00000;
    private float[][] \u00d300000;
    private int[] \u00d200000;

    private ConvolutionKernel1D() {
    }

    public float[] getSimpleMatrix() {
        return this.o00000;
    }

    public float[][] getShiftingMatrix() {
        return this.\u00d300000;
    }

    public int[] getStartShifting() {
        return this.\u00d200000;
    }

    public static ConvolutionKernel1D getKernel(float[] fArray) {
        ConvolutionKernel1D convolutionKernel1D = new ConvolutionKernel1D();
        convolutionKernel1D.o00000 = fArray;
        return convolutionKernel1D;
    }

    public static ConvolutionKernel1D getGaussianKernel(int n, double d) {
        int n2;
        int n3 = n * 2 + 1;
        float[] fArray = new float[n3];
        double d2 = 2.0 * d * d;
        double d3 = Math.sqrt(Math.PI * 2 * d);
        float f = n * n;
        float f2 = 0.0f;
        int n4 = 0;
        for (n2 = -n; n2 <= n; ++n2) {
            float f3 = n2 * n2;
            fArray[n4] = f3 > f ? 0.0f : (float)(FastMath.exp((double)(-f3) / d2) / d3);
            f2 += fArray[n4];
            ++n4;
        }
        n2 = 0;
        while (n2 < n3) {
            int n5 = n2++;
            fArray[n5] = fArray[n5] / f2;
        }
        ConvolutionKernel1D convolutionKernel1D = new ConvolutionKernel1D();
        convolutionKernel1D.o00000 = fArray;
        return convolutionKernel1D;
    }

    public static ConvolutionKernel1D buildLanczosKernel(int n, int n2, double d, double d2, double d3) {
        ConvolutionKernel1D convolutionKernel1D = new ConvolutionKernel1D();
        convolutionKernel1D.\u00d300000 = new float[n2][];
        convolutionKernel1D.\u00d200000 = new int[n2];
        double d4 = ((double)n2 - d2) / (double)n;
        double d5 = d3 / d4;
        if (d5 > (double)((float)n / 2.0f)) {
            d5 = (float)n / 2.0f;
        }
        if (d4 > 1.0) {
            d5 = d3;
            d = d4 > 5.0 ? (d -= 0.5) : (d -= d4 / 10.0);
        } else {
            d += d5 / (d3 * 2.0) - (double)n2 / (double)n;
        }
        for (int i = 0; i < n2; ++i) {
            double d6 = (double)i / d4 + d;
            int n3 = FastMath.floor(d6 - d5);
            int n4 = FastMath.floor(d6 + d5);
            int n5 = n4 - n3;
            double d7 = 0.0;
            double[] dArray = new double[n5];
            int n6 = n3;
            int n7 = 0;
            while (n6 < n4) {
                double d8;
                double d9 = (d6 - (double)n6) / (double)n5 * 2.0 * d3;
                dArray[n7] = d8 = ConvolutionKernel1D.lanczos(d9, d3);
                d7 += d8;
                ++n6;
                ++n7;
            }
            convolutionKernel1D.\u00d300000[i] = new float[n5 + 1];
            convolutionKernel1D.\u00d200000[i] = n3;
            for (n6 = 0; n6 < n5; ++n6) {
                convolutionKernel1D.\u00d300000[i][n6] = (float)(dArray[n6] / d7);
            }
        }
        return convolutionKernel1D;
    }

    private static double lanczos(double d, double d2) {
        return Math.abs(d) < d2 ? ConvolutionKernel1D.sinc(d) * ConvolutionKernel1D.sinc(d / d2) : 0.0;
    }

    private static double sinc(double d) {
        if (d != 0.0) {
            return Math.sin(d *= Math.PI) / d;
        }
        return 1.0;
    }
}

