/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.area;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import java.nio.BufferOverflowException;
import java.nio.IntBuffer;

public final class Crop {
    private Crop() {
    }

    public static FSIImage transform(FSIImage fSIImage, int n, int n2, int n3, int n4, int n5, CropPadPosition cropPadPosition, float f, float f2) throws ImageManipulatorException {
        return Crop.transform(fSIImage, n, n2, n3, n4, n5, cropPadPosition, f, f2, false);
    }

    public static FSIImage transform(FSIImage fSIImage, int n, int n2, int n3, int n4, int n5, CropPadPosition cropPadPosition, float f, float f2, boolean bl) throws ImageManipulatorException {
        if (fSIImage == null) {
            throw new ImageManipulatorException("Crop Input Image is null");
        }
        if (n3 <= 0 || n4 <= 0) {
            throw new ImageManipulatorException("New image size invalid: " + n3 + "x" + n4);
        }
        if (fSIImage instanceof FSIImageLimited) {
            return Crop.transformLimited((FSIImageLimited)fSIImage, n, n2, n3, n4, n5, cropPadPosition, f, f2, bl);
        }
        throw new IllegalArgumentException("Crop is currently only implemented for FSIImageLimited");
    }

    private static FSIImage transformLimited(FSIImageLimited fSIImageLimited, int n, int n2, int n3, int n4, int n5, CropPadPosition cropPadPosition, float f, float f2, boolean bl) throws ImageManipulatorException {
        FSIImageLimited fSIImageLimited2;
        int n6 = fSIImageLimited.getWidth();
        int n7 = fSIImageLimited.getHeight();
        if (n3 != n6 || n4 != n7) {
            fSIImageLimited2 = fSIImageLimited.createCompatibleImage(n3, n4);
            IntBuffer intBuffer = fSIImageLimited.getSamplesBuffer();
            IntBuffer intBuffer2 = fSIImageLimited2.getSamplesBuffer();
            int n8 = intBuffer2.capacity();
            int n9 = 0;
            int n10 = 0;
            int n11 = (n3 + n6) / 2 - n6;
            int n12 = (n4 + n7) / 2 - n7;
            if (cropPadPosition != null && (n3 > n6 || n4 > n7)) {
                Crop.fillAreaWithPadColor(intBuffer2, n5, n8);
                Pair<Integer, Integer> pair = Crop.calcPadOffset(cropPadPosition, f, f2, n11, n12, n6, n7, n3, n4);
                n9 = pair.getItem1();
                n10 = pair.getItem2();
            }
            int n13 = n6 > n3 ? n3 + n : n6;
            int n14 = n7 > n4 ? n4 + n2 : n7;
            int n15 = 0;
            int n16 = 0;
            try {
                n16 = n2;
                int n17 = n10;
                while (n16 < n14) {
                    n15 = n;
                    int n18 = n9;
                    while (n15 < n13) {
                        int n19 = intBuffer.get(n16 * n6 + n15);
                        if (n18 >= 0 && n18 < n3 && n17 >= 0 && n17 < n4) {
                            fSIImageLimited2.setSample(n18, n17, n19);
                        }
                        ++n15;
                        ++n18;
                    }
                    ++n16;
                    ++n17;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new ImageManipulatorException("Crop out of bounds (BO): " + n + "x" + n2 + ":" + n3 + "x" + n4 + " of " + n6 + "x" + n7);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ImageManipulatorException("Crop out of bounds (IO): " + n + "x" + n2 + ":" + n3 + "x" + n4 + " of " + n6 + "x" + n7 + " on position " + n15 + "x" + n16 + " " + n13 + ":" + n14);
            }
        } else {
            fSIImageLimited2 = fSIImageLimited.createCopy();
        }
        if (!bl) {
            fSIImageLimited.dispose();
        }
        return fSIImageLimited2;
    }

    private static Pair<Integer, Integer> calcPadOffset(CropPadPosition cropPadPosition, float f, float f2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        switch (cropPadPosition) {
            case \u00f400000: {
                n7 = (int)f;
                n8 = (int)f2;
                break;
            }
            case float: {
                n7 = (int)((float)n + f);
                n8 = (int)f2;
                break;
            }
            case Object: {
                n7 = (int)((float)(n5 - n3) + f);
                n8 = (int)f2;
                break;
            }
            case \u00d500000: {
                n7 = (int)f;
                n8 = (int)((float)n2 + f2);
                break;
            }
            case \u00d200000: {
                n7 = (int)((float)(n5 - n3) + f);
                n8 = (int)((float)n2 + f2);
                break;
            }
            case \u00f500000: {
                n7 = (int)f;
                n8 = (int)((float)(n6 - n4) + f2);
                break;
            }
            case o00000: {
                n7 = (int)((float)n + f);
                n8 = (int)((float)(n6 - n4) + f2);
                break;
            }
            case void: {
                n7 = (int)((float)(n5 - n3) + f);
                n8 = (int)((float)(n6 - n4) + f2);
                break;
            }
            case \u00d600000: {
                n7 = (int)((float)n5 * f / 100.0f);
                n8 = (int)((float)n6 * f2 / 100.0f);
                break;
            }
            default: {
                n7 = (int)((float)n + f);
                n8 = (int)((float)n2 + f2);
            }
        }
        return new Pair<Integer, Integer>(n7, n8);
    }

    private static void fillAreaWithPadColor(IntBuffer intBuffer, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            intBuffer.put(n);
        }
        intBuffer.position(0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum CropPadPosition {
        \u00f400000,
        float,
        Object,
        \u00d500000,
        \u00f600000,
        \u00d200000,
        \u00f500000,
        o00000,
        void,
        \u00d600000;

    }
}

