/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.area;

import com.neptunelabs.fsiserver.framework.helpers.ExecutorPool;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.color.AlphaMode;
import com.neptunelabs.fsiserver.imagemanipulator.color.BlendMode;
import com.neptunelabs.fsiserver.imagemanipulator.color.ColorOverlay2;
import com.neptunelabs.fsiserver.imagemanipulator.utils.EffectThreadAbstract;
import com.neptunelabs.fsiserver.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public final class LayerBlend
extends EffectUtils {
    public LayerBlend(FSILogger fSILogger) {
        super(fSILogger);
    }

    public FSIImage transform(FSIImage fSIImage, FSIImage fSIImage2, int n, int n2, BlendMode blendMode, float f, boolean bl) {
        return this.transform(fSIImage, fSIImage2, n, n2, blendMode, AlphaMode.String, f, bl);
    }

    public FSIImage transform(FSIImage fSIImage, FSIImage fSIImage2, int n, int n2, BlendMode blendMode, AlphaMode alphaMode, float f, boolean bl) {
        FSIImage fSIImage3 = fSIImage.createCopy();
        boolean bl2 = this.blend(fSIImage, fSIImage3, fSIImage2, n, n2, blendMode, alphaMode, f);
        if (!bl2) {
            LayerBlend.disposeImages(fSIImage3);
        }
        if (!bl) {
            LayerBlend.disposeImages(fSIImage, fSIImage2);
        }
        return fSIImage3;
    }

    public FSIImage transform(FSIImage fSIImage, FSIImage fSIImage2, BlendMode blendMode, AlphaMode alphaMode, boolean bl) throws ProcessingException {
        FSIImage fSIImage3 = fSIImage.createCompatibleImage();
        boolean bl2 = this.blend(fSIImage, fSIImage3, fSIImage2, blendMode, alphaMode);
        if (!bl2) {
            LayerBlend.disposeImages(fSIImage3);
        }
        if (!bl) {
            LayerBlend.disposeImages(fSIImage, fSIImage2);
        }
        return fSIImage3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean blend(FSIImage fSIImage, FSIImage fSIImage2, FSIImage fSIImage3, BlendMode blendMode, AlphaMode alphaMode) {
        int n;
        ColorOverlay2 colorOverlay2 = new ColorOverlay2(blendMode, alphaMode);
        int n2 = this.calcThreads(fSIImage3);
        ExecutorService executorService = ExecutorPool.createExecutorService("LayerBlend", n2);
        ArrayList<CompletableFuture<Void>> arrayList = new ArrayList<CompletableFuture<Void>>(n2);
        int[][] nArray = LayerBlend.calcThreadImageRanges(fSIImage3.getHeight(), n2);
        for (n = 0; n < n2; ++n) {
            int[] nArray2 = nArray[n];
            _o _o2 = new _o(nArray2[0], nArray2[1]);
            _o2.\u00f800000(fSIImage3, 0, 0, colorOverlay2);
            _o2.setAlphaSelection(this.new);
            _o2.setImages(fSIImage, fSIImage2);
            arrayList.add(CompletableFuture.supplyAsync(_o2, executorService));
        }
        n = 0;
        try {
            n = ExecutorPool.shutdownAndWait(executorService, arrayList, 60) ? 1 : 0;
            ExecutorPool.getAllVoid(arrayList);
            if (n != 0) return n != 0;
        }
        catch (ExecutionException executionException) {
            return 1 != 0;
        }
        catch (InterruptedException interruptedException) {
            if (n != 0) return n != 0;
            LayerBlend.disposeImages(fSIImage2);
            return n != 0;
            {
                catch (Throwable throwable) {
                    if (n != 0) throw throwable;
                    LayerBlend.disposeImages(fSIImage2);
                    throw throwable;
                }
            }
        }
        LayerBlend.disposeImages(fSIImage2);
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean blend(FSIImage fSIImage, FSIImage fSIImage2, FSIImage fSIImage3, int n, int n2, BlendMode blendMode, AlphaMode alphaMode, float f) {
        int n3;
        ColorOverlay2 colorOverlay2 = new ColorOverlay2(blendMode, alphaMode, f);
        int n4 = this.calcThreads(fSIImage3);
        ExecutorService executorService = ExecutorPool.createExecutorService("LayerBlend", n4);
        ArrayList<CompletableFuture<Void>> arrayList = new ArrayList<CompletableFuture<Void>>(n4);
        int n5 = fSIImage3.getHeight();
        if (fSIImage2.getHeight() - n2 < n5) {
            n5 = fSIImage2.getHeight() - n2;
        }
        int[][] nArray = LayerBlend.calcThreadImageRanges(n5, n4);
        for (n3 = 0; n3 < n4; ++n3) {
            int[] nArray2 = nArray[n3];
            _Oo _Oo2 = new _Oo(nArray2[0], nArray2[1]);
            _Oo2.oO0000(fSIImage3, n, n2, colorOverlay2);
            _Oo2.setImages(fSIImage, fSIImage2);
            arrayList.add(CompletableFuture.supplyAsync(_Oo2, executorService));
        }
        n3 = 0;
        try {
            n3 = ExecutorPool.shutdownAndWait(executorService, arrayList, 60) ? 1 : 0;
            ExecutorPool.getAllVoid(arrayList);
            if (n3 != 0) return n3 != 0;
        }
        catch (ExecutionException executionException) {
            n3 = 0;
            if (n3 != 0) return n3 != 0;
            LayerBlend.disposeImages(fSIImage2);
            return n3 != 0;
        }
        catch (InterruptedException interruptedException) {
            if (n3 != 0) return n3 != 0;
            LayerBlend.disposeImages(fSIImage2);
            return n3 != 0;
            {
                catch (Throwable throwable) {
                    if (n3 != 0) throw throwable;
                    LayerBlend.disposeImages(fSIImage2);
                    throw throwable;
                }
            }
        }
        LayerBlend.disposeImages(fSIImage2);
        return n3 != 0;
    }

    private final class _Oo
    extends EffectThreadAbstract {
        private FSIImage publicsuper;
        private int \u00f4o0000;
        private int \u00f8o0000;
        private ColorOverlay2 \u00f6o0000;

        _Oo(int n, int n2) {
            super(n, n2);
        }

        void oO0000(FSIImage fSIImage, int n, int n2, ColorOverlay2 colorOverlay2) {
            this.publicsuper = fSIImage;
            this.\u00f4o0000 = n;
            this.\u00f8o0000 = n2;
            this.\u00f6o0000 = colorOverlay2;
        }

        public Void OO0000() {
            int n = this.publicsuper.getWidth();
            int n2 = this.\u00d300000.getWidth();
            int n3 = this.\u00d300000.getHeight();
            int n4 = this.\u00d600000 * n;
            for (int i = this.\u00d600000; i <= this.class; ++i) {
                int n5 = i + this.\u00f8o0000;
                int n6 = 0;
                while (n6 < n) {
                    int n7 = n6 + this.\u00f4o0000;
                    if (n7 < n2 && n5 < n3 && n7 >= 0 && n5 >= 0) {
                        int n8 = this.\u00f6o0000.transform(this.\u00d300000.getSample(n7, n5), this.publicsuper.getSample(n6, i), n4);
                        this.\u00d400000.setSample(n7, n5, n8);
                    }
                    ++n6;
                    ++n4;
                }
            }
            return null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class _o
    extends EffectThreadAbstract {
        private FSIImage \u00d4o0000;
        private int \u00d3o0000;
        private int \u00d6o0000;
        private ColorOverlay2 floatsuper;

        _o(int n, int n2) {
            super(n, n2);
        }

        void \u00f800000(FSIImage fSIImage, int n, int n2, ColorOverlay2 colorOverlay2) {
            this.\u00d4o0000 = fSIImage;
            this.\u00d3o0000 = n;
            this.\u00d6o0000 = n2;
            this.floatsuper = colorOverlay2;
        }

        public Void if() {
            int n = this.\u00d4o0000.getWidth();
            int n2 = this.\u00d300000.getWidth();
            int n3 = this.\u00d300000.getHeight();
            int n4 = this.\u00d600000 * n;
            for (int i = this.\u00d600000; i <= this.class; ++i) {
                int n5 = i + this.\u00d6o0000;
                int n6 = 0;
                while (n6 < n) {
                    int n7 = n6 + this.\u00d3o0000;
                    if (n7 < n2 && n5 < n3 && n7 >= 0 && n5 >= 0) {
                        int n8 = i * n + n6;
                        float f = (float)(LayerBlend.this.new[n8] & 0xFF) / 255.0f;
                        int n9 = this.floatsuper.transform(this.\u00d300000.getSample(n7, n5), this.\u00d4o0000.getSample(n6, i), n4, f);
                        this.\u00d400000.setSample(n7, n5, n9);
                    }
                    ++n6;
                    ++n4;
                }
            }
            return null;
        }
    }
}

