/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.iptc;

import com.neptunelabs.fsiserver.framework.helpers.FloatingParser;
import com.neptunelabs.fsiserver.imagereader.iptc.Rational;
import com.neptunelabs.fsiserver.imagereader.iptc.Tag;
import com.neptunelabs.fsiserver.imagereader.iptc.TagDescriptor;
import com.neptunelabs.fsiserver.imagereader.iptc.exception.IptcDataException;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Directory {
    private final Map<Integer, Object> o00000 = new HashMap<Integer, Object>();
    private TagDescriptor Object;
    final List<Tag> \u00d200000 = new ArrayList<Tag>();
    private List<String> \u00d400000;

    public abstract String getName();

    protected abstract Map<Integer, String> getTagNameMap();

    Directory() {
    }

    public boolean containsTag(int n) {
        return this.o00000.containsKey(new Integer(n));
    }

    public Iterator<Tag> getTagIterator() {
        return this.\u00d200000.iterator();
    }

    public int getTagCount() {
        return this.\u00d200000.size();
    }

    void setDescriptor(TagDescriptor tagDescriptor) {
        if (tagDescriptor == null) {
            throw new NullPointerException("cannot set a null descriptor");
        }
        this.Object = tagDescriptor;
    }

    public void addError(String string) {
        if (this.\u00d400000 == null) {
            this.\u00d400000 = new ArrayList<String>();
        }
        this.\u00d400000.add(string);
    }

    public boolean hasErrors() {
        return this.\u00d400000 != null && this.\u00d400000.size() > 0;
    }

    public Iterator<String> getErrors() {
        return this.\u00d400000.iterator();
    }

    public int getErrorCount() {
        return this.\u00d400000.size();
    }

    public void setInt(int n, int n2) {
        this.setObject(n, new Integer(n2));
    }

    public void setDouble(int n, double d) {
        this.setObject(n, new Double(d));
    }

    public void setFloat(int n, float f) {
        this.setObject(n, new Float(f));
    }

    public void setString(int n, String string) {
        this.setObject(n, string);
    }

    public void setBoolean(int n, boolean bl) {
        this.setObject(n, bl);
    }

    public void setLong(int n, long l) {
        this.setObject(n, new Long(l));
    }

    public void setDate(int n, Date date) {
        this.setObject(n, date);
    }

    void setCalendar(int n, Calendar calendar) {
        this.setObject(n, calendar);
    }

    public void setRational(int n, Rational rational) {
        this.setObject(n, rational);
    }

    public void setRationalArray(int n, Rational[] rationalArray) {
        this.setObjectArray(n, rationalArray);
    }

    public void setIntArray(int n, int[] nArray) {
        this.setObjectArray(n, nArray);
    }

    public void setByteArray(int n, byte[] byArray) {
        this.setObjectArray(n, byArray);
    }

    public void setStringArray(int n, String[] stringArray) {
        this.setObjectArray(n, stringArray);
    }

    private void setObject(int n, Object object) {
        if (object == null) {
            throw new NullPointerException("cannot set a null object for tagType: " + n);
        }
        Integer n2 = new Integer(n);
        if (!this.o00000.containsKey(n2)) {
            this.\u00d200000.add(new Tag(n, this));
        }
        this.o00000.put(n2, object);
    }

    private void setObjectArray(int n, Object object) {
        this.setObject(n, object);
    }

    public int getInt(int n) throws IptcDataException {
        int[] nArray;
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = (String)object;
                byte[] byArray = string.getBytes();
                long l = 0L;
                for (byte by : byArray) {
                    l <<= 8;
                    l += (long)(by & 0xFF);
                }
                return (int)l;
            }
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            if (rationalArray.length == 1) {
                return rationalArray[0].intValue();
            }
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 1) {
                return byArray[0];
            }
        } else if (object instanceof int[] && (nArray = (int[])object).length == 1) {
            return nArray[0];
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to int.  It is of type '" + object.getClass() + "'.");
    }

    public String[] getStringArray(int n) throws IptcDataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            return Arrays.copyOf(stringArray, stringArray.length);
        }
        if (object instanceof String) {
            String[] stringArray = new String[]{(String)object};
            return stringArray;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            String[] stringArray = new String[nArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Integer.toString(nArray[i]);
            }
            return stringArray;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            String[] stringArray = new String[byArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Byte.toString(byArray[i]);
            }
            return stringArray;
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            String[] stringArray = new String[rationalArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = rationalArray[i].toSimpleString(false);
            }
            return stringArray;
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to an String array.  It is of type '" + object.getClass() + "'.");
    }

    public int[] getIntArray(int n) throws IptcDataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            int[] nArray = new int[rationalArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = rationalArray[i].intValue();
            }
            return nArray;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            return Arrays.copyOf(nArray, nArray.length);
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int[] nArray = new int[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                int n2;
                nArray[i] = n2 = byArray[i];
            }
            return nArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            int[] nArray = new int[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                nArray[i] = string.charAt(i);
            }
            return nArray;
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to an int array.  It is of type '" + object.getClass() + "'.");
    }

    public byte[] getByteArray(int n) throws IptcDataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            byte[] byArray = new byte[rationalArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = rationalArray[i].byteValue();
            }
            return byArray;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Arrays.copyOf(byArray, byArray.length);
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            byte[] byArray = new byte[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)nArray[i];
            }
            return byArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = new byte[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
            return byArray;
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to a byte array.  It is of type '" + object.getClass() + "'.");
    }

    public double getDouble(int n) throws IptcDataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return FloatingParser.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IptcDataException("unable to parse string " + object + " as a double", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to a double.  It is of type '" + object.getClass() + "'.");
    }

    public float getFloat(int n) throws IptcDataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return Float.parseFloat((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IptcDataException("unable to parse string " + object + " as a float", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to a float.  It is of type '" + object.getClass() + "'.");
    }

    public long getLong(int n) throws IptcDataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IptcDataException("unable to parse string " + object + " as a long", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to a long.  It is of type '" + object.getClass() + "'.");
    }

    public boolean getBoolean(int n) throws IptcDataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            try {
                return Boolean.getBoolean((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IptcDataException("unable to parse string " + object + " as a boolean", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to a boolean.  It is of type '" + object.getClass() + "'.");
    }

    Calendar getCalendar(int n) throws IptcDataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        if (object instanceof String) {
            String[] stringArray = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm"};
            String string = (String)object;
            SimpleDateFormat simpleDateFormat = null;
            for (String string2 : stringArray) {
                try {
                    simpleDateFormat = new SimpleDateFormat(string2);
                    simpleDateFormat.parse(string);
                    return simpleDateFormat.getCalendar();
                }
                catch (ParseException parseException) {
                }
            }
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to a java.util.Date.  It is of type '" + object.getClass() + "'.");
    }

    public Rational getRational(int n) throws IptcDataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational) {
            return (Rational)object;
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to a Rational.  It is of type '" + object.getClass() + "'.");
    }

    public Rational[] getRationalArray(int n) throws IptcDataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new IptcDataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational[]) {
            return (Rational[])object;
        }
        throw new IptcDataException("Tag '" + n + "' cannot be cast to a Rational array.  It is of type '" + object.getClass() + "'.");
    }

    public String getString(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Rational) {
            return ((Rational)object).toSimpleString(true);
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            boolean bl = object.getClass().toString().startsWith("class [L");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n2; ++i) {
                if (i != 0) {
                    stringBuilder.append(' ');
                }
                if (bl) {
                    stringBuilder.append(Array.get(object, i).toString());
                    continue;
                }
                stringBuilder.append(Array.getInt(object, i));
            }
            return stringBuilder.toString();
        }
        return object.toString();
    }

    public Object getObject(int n) {
        return this.o00000.get(new Integer(n));
    }

    public Object getObject(Integer n) {
        return this.o00000.get(n);
    }

    public String getTagName(int n) {
        Integer n2 = new Integer(n);
        Map<Integer, String> map = this.getTagNameMap();
        if (!map.containsKey(n2)) {
            String string = Integer.toHexString(n);
            while (string.length() < 4) {
                string = "0" + string;
            }
            return "Unknown tag (0x" + string + ")";
        }
        return map.get(n2);
    }

    public String getDescription(int n) throws IptcDataException {
        if (this.Object == null) {
            throw new IptcDataException("a descriptor must be set using setDescriptor(...) before descriptions can be provided");
        }
        return this.Object.getDescription(n);
    }
}

