/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.iptc;

import com.neptunelabs.fsiserver.imagereader.iptc.Directory;
import com.neptunelabs.fsiserver.imagereader.iptc.exception.IptcDataException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tag {
    private final int new;
    private final Directory o00000;

    public Tag(int n, Directory directory) {
        this.new = n;
        this.o00000 = directory;
    }

    public final int getTagType() {
        return this.new;
    }

    public final String getTagTypeHex() {
        return Tag.getTagTypeHex(this.new);
    }

    private static String getTagTypeHex(int n) {
        String string = Integer.toHexString(n);
        while (string.length() < 4) {
            string = "0" + string;
        }
        return "0x" + string;
    }

    private String getDescription() throws IptcDataException {
        return this.o00000.getDescription(this.new);
    }

    public final String getTagName() {
        String string = this.o00000.getTagName(this.new);
        return string != null ? string : Tag.getTagID(this.new);
    }

    public final String getDirectoryName() {
        return this.o00000.getName();
    }

    public final String toString() {
        String string;
        try {
            string = this.getDescription();
        }
        catch (IptcDataException iptcDataException) {
            string = this.o00000.getString(this.getTagType()) + " (unable to formulate description)";
        }
        return "[" + this.o00000.getName() + "]   " + this.getTagTypeHex() + "(" + (this.getTagType() >> 8) + ":" + (this.getTagType() & 0xFF) + ") \t" + String.format("%20s :: %s", this.getTagName(), string);
    }

    public static String getTagTypeInfo(int n) {
        return n + ":" + Tag.getTagTypeHex(n) + "(" + Tag.getTagID(n) + ")";
    }

    private static String getTagID(int n) {
        return String.format("%d:%03d", n >> 8, n & 0xFF);
    }
}

