/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.framework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.licensing.Licence;
import com.neptunelabs.fsiserver.framework.licensing.LicenceContainer;
import com.neptunelabs.fsiserver.framework.licensing.LicenceManager;
import com.neptunelabs.fsiserver.framework.licensing.RawLicence;
import com.neptunelabs.fsiserver.framework.security.DigestUtils;
import com.neptunelabs.fsiserver.service.B;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/licence")
public class LicenceService
extends B
implements Serializable {
    private static final long serialVersionUID = 2464871671251148919L;

    @PUT
    @Path(value="/test")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response decodeLicence(InputStream inputStream) {
        Response.ResponseBuilder responseBuilder;
        Object object;
        Object object2;
        HttpSession httpSession = this.\u00f800000(false);
        PermissionSet permissionSet = this.\u00d6O0000().getUserAuthenticationInterface().getPermissions((SourceConnectorReader)null, httpSession, true);
        if (permissionSet == null || !permissionSet.general.writeLicence.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        byte[] byArray = null;
        try {
            object2 = new ByteArrayOutputStreamFast();
            object = null;
            try {
                FileOperations.copy(inputStream, (OutputStream)object2);
                byArray = ((ByteArrayOutputStreamFast)object2).toByteArray();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((ByteArrayOutputStreamFast)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((ByteArrayOutputStreamFast)object2).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = DigestUtils.sha256(byArray);
        object = LicenceContainer.getInstance(System.currentTimeMillis(), byArray);
        List<RawLicence> list = ((LicenceContainer)object).getRawLicences();
        Licence licence = new Licence();
        boolean bl = false;
        boolean bl2 = false;
        for (RawLicence rawLicence : list) {
            if (rawLicence == null || rawLicence.\u00d500000 == null) continue;
            if (rawLicence.String == 22 && rawLicence.o00000 == 3) {
                licence.decodeLicenceString(this.\u00d800000(), rawLicence.\u00d500000, SoftwareVersion.getKeyVersion(), 22, 3, SoftwareVersion.readPublicKey(), rawLicence.\u00d300000);
                bl = true;
                continue;
            }
            if (rawLicence.String != 101 || rawLicence.o00000 != 6) continue;
            bl2 = true;
        }
        if (bl) {
            try {
                RawLicence rawLicence;
                rawLicence = this.o00000().getLicenceInfoAsJSON(licence, true, (String)object2);
                rawLicence.put("fsi_viewer", bl2);
                ObjectMapper objectMapper = new ObjectMapper();
                responseBuilder = Response.ok((Object)objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rawLicence), (MediaType)MediaType.APPLICATION_JSON_TYPE);
            }
            catch (IOException iOException) {
                responseBuilder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else {
            responseBuilder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        responseBuilder.cacheControl(new);
        return responseBuilder.build();
    }

    @PUT
    @Path(value="/install")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response installLicences(InputStream inputStream) {
        Response.ResponseBuilder responseBuilder;
        HttpSession httpSession = this.\u00f800000(false);
        PermissionSet permissionSet = this.\u00d6O0000().getUserAuthenticationInterface().getPermissions((SourceConnectorReader)null, httpSession, true);
        if (permissionSet == null || !permissionSet.general.writeLicence.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try (ByteArrayOutputStreamFast byteArrayOutputStreamFast = new ByteArrayOutputStreamFast();){
            FileOperations.copy(inputStream, byteArrayOutputStreamFast);
            LicenceManager licenceManager = this.o00000().getLicenceManager();
            licenceManager.replaceLicence(byteArrayOutputStreamFast.toByteArray(), System.currentTimeMillis(), true);
            responseBuilder = Response.status((Response.Status)Response.Status.OK);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            responseBuilder = Response.status((Response.Status)Response.Status.FORBIDDEN);
            responseBuilder.type("text/html");
            responseBuilder.entity((Object)"Could not save licence to file.");
        }
        responseBuilder.cacheControl(new);
        return responseBuilder.build();
    }
}

