/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletResponse;

public class AppRequestListener
implements AsyncListener {
    private static final Logger o00000 = Logger.getLogger("FSIServer");

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
    }

    public void onError(AsyncEvent asyncEvent) throws IOException {
        Throwable throwable = asyncEvent.getThrowable();
        String string = "Error in Processing @" + System.currentTimeMillis();
        if (throwable != null) {
            string = string + " - " + throwable.getMessage();
        }
        this.writeToResponse(asyncEvent, 500, string, throwable);
        if (!(throwable instanceof IOException)) {
            o00000.log(Level.INFO, string, throwable);
        }
    }

    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
    }

    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        Throwable throwable = asyncEvent.getThrowable();
        String string = "TimeOut Error in Processing @" + System.currentTimeMillis();
        this.writeToResponse(asyncEvent, 503, "TimeOut Error in Processing @" + System.currentTimeMillis(), throwable);
        o00000.log(Level.SEVERE, string, throwable);
        asyncEvent.getAsyncContext().complete();
    }

    private void writeToResponse(AsyncEvent asyncEvent, int n, String string, Throwable throwable) throws IOException {
        try {
            AsyncContext asyncContext = asyncEvent.getAsyncContext();
            HttpServletResponse httpServletResponse = (HttpServletResponse)asyncContext.getResponse();
            if (!httpServletResponse.isCommitted()) {
                httpServletResponse.setStatus(n);
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.write(string);
                if (throwable != null) {
                    printWriter.write(10);
                    printWriter.write(throwable.getMessage());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

