/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.histogram;

import com.neptunelabs.fsiserver.framework.io.ReaderAbstract;
import com.neptunelabs.fsiserver.framework.io.ReaderChannel;
import com.neptunelabs.fsiserver.imagereader.metrics.Histogram;
import com.neptunelabs.fsiserver.utils.SPXEnvironment;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

@Deprecated
public final class HistogramLoader {
    private HistogramLoader() {
    }

    public static Histogram load(Path path) throws IOException {
        Histogram histogram = null;
        if (path != null && Files.isReadable(path)) {
            try (ReaderChannel readerChannel = new ReaderChannel(path, StandardOpenOption.READ);){
                histogram = new Histogram();
                HistogramLoader.readAndCheckMagicNumber(readerChannel);
                ByteOrder byteOrder = ((ReaderAbstract)readerChannel).readByte() == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                readerChannel.setByteOrder(byteOrder);
                ((ReaderAbstract)readerChannel).readShort();
                int n = 0;
                boolean bl = false;
                while (!bl && n < 50) {
                    ++n;
                    short s = -1;
                    try {
                        s = ((ReaderAbstract)readerChannel).readShort();
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        bl = true;
                    }
                    if (bl) continue;
                    bl = HistogramLoader.handleTag(s, readerChannel, histogram);
                }
            }
        }
        return histogram;
    }

    private static boolean handleTag(short s, ReaderAbstract readerAbstract, Histogram histogram) throws IOException {
        boolean bl = false;
        int n = readerAbstract.readInt();
        switch (s) {
            case 101: {
                histogram.nullsuper = HistogramLoader.readFloats(readerAbstract, n);
                break;
            }
            case 102: {
                histogram.\u00d5o0000 = HistogramLoader.readFloats(readerAbstract, n);
                break;
            }
            case 103: {
                histogram.\u00d400000 = HistogramLoader.readFloats(readerAbstract, n);
                break;
            }
            case 105: {
                histogram.\u00f8O0000 = HistogramLoader.readFloats(readerAbstract, n);
                break;
            }
            case 106: {
                histogram.\u00f4O0000 = HistogramLoader.readFloats(readerAbstract, n);
                break;
            }
            case 107: {
                histogram.\u00d4o0000 = HistogramLoader.readFloats(readerAbstract, n);
                break;
            }
            case 121: {
                histogram.new = readerAbstract.readFloat();
                break;
            }
            case 122: {
                histogram.\u00d3o0000 = readerAbstract.readFloat();
                break;
            }
            case 123: {
                histogram.while = readerAbstract.readFloat();
                break;
            }
            case 131: {
                histogram.\u00f400000 = readerAbstract.readByte();
                break;
            }
            case 132: {
                histogram.\u00d300000 = readerAbstract.readByte();
                break;
            }
            case 133: {
                histogram.return = readerAbstract.readByte();
                break;
            }
            case 136: {
                histogram.\u00d800000 = readerAbstract.readByte();
                break;
            }
            case 137: {
                histogram.\u00d4O0000 = readerAbstract.readByte();
                break;
            }
            case 141: {
                histogram.OO0000 = readerAbstract.readByte();
                break;
            }
            case 142: {
                histogram.\u00d500000 = readerAbstract.readByte();
                break;
            }
            case 143: {
                histogram.if = readerAbstract.readByte();
                break;
            }
            case 146: {
                histogram.\u00f800000 = readerAbstract.readByte();
                break;
            }
            case 147: {
                histogram.\u00d8O0000 = readerAbstract.readByte();
                break;
            }
            case 3854: {
                bl = true;
                break;
            }
            default: {
                readerAbstract.skip(n);
            }
        }
        return bl;
    }

    private static float[] readFloats(ReaderAbstract readerAbstract, int n) throws IOException {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = readerAbstract.readFloat();
        }
        return fArray;
    }

    private static void readAndCheckMagicNumber(ReaderAbstract readerAbstract) throws IOException {
        byte[] byArray = new byte[8];
        readerAbstract.read(byArray);
        if (!Arrays.equals(byArray, SPXEnvironment.\u00d600000)) {
            throw new IOException("Invalid Histogram File");
        }
    }
}

