/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.stream;

import com.sun.media.imageio.stream.SectorStreamSegmentMapper;
import com.sun.media.imageio.stream.StreamSegment;
import com.sun.media.imageio.stream.StreamSegmentMapper;
import com.sun.media.imageio.stream.StreamSegmentMapperImpl;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class SegmentedImageInputStream
extends ImageInputStreamImpl {
    private ImageInputStream stream;
    private StreamSegmentMapper mapper;
    private StreamSegment streamSegment = new StreamSegment();

    public SegmentedImageInputStream(ImageInputStream imageInputStream, StreamSegmentMapper streamSegmentMapper) {
        this.stream = imageInputStream;
        this.mapper = streamSegmentMapper;
    }

    public SegmentedImageInputStream(ImageInputStream imageInputStream, long[] lArray, int[] nArray) {
        this(imageInputStream, new StreamSegmentMapperImpl(lArray, nArray));
    }

    public SegmentedImageInputStream(ImageInputStream imageInputStream, long[] lArray, int n, int n2) {
        this(imageInputStream, new SectorStreamSegmentMapper(lArray, n, n2));
    }

    @Override
    public int read() throws IOException {
        this.mapper.getStreamSegment(this.streamPos, 1, this.streamSegment);
        int n = this.streamSegment.getSegmentLength();
        if (n < 0) {
            return -1;
        }
        this.stream.seek(this.streamSegment.getStartPos());
        int n2 = this.stream.read();
        ++this.streamPos;
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        this.mapper.getStreamSegment(this.streamPos, n2, this.streamSegment);
        int n3 = this.streamSegment.getSegmentLength();
        if (n3 < 0) {
            return -1;
        }
        this.stream.seek(this.streamSegment.getStartPos());
        int n4 = this.stream.read(byArray, n, n3);
        this.streamPos += (long)n4;
        return n4;
    }

    @Override
    public long length() {
        long l;
        if (this.mapper instanceof StreamSegmentMapperImpl) {
            l = ((StreamSegmentMapperImpl)this.mapper).length();
        } else if (this.mapper instanceof SectorStreamSegmentMapper) {
            l = ((SectorStreamSegmentMapper)this.mapper).length();
        } else if (this.mapper != null) {
            l = 0L;
            long l2 = 0L;
            StreamSegment streamSegment = this.mapper.getStreamSegment(l2, Integer.MAX_VALUE);
            while ((l = (long)streamSegment.getSegmentLength()) > 0L) {
                streamSegment.setSegmentLength(0);
                this.mapper.getStreamSegment(l2 += l, Integer.MAX_VALUE, streamSegment);
            }
            l = l2;
        } else {
            l = super.length();
        }
        return l;
    }
}

